# Generated by Django 4.2.20 on 2025-08-20 15:43

from django.db import migrations


def create_all_members_group(apps, schema_editor):
    """Create the default 'All Members' group and add existing members to it."""
    MemberGroup = apps.get_model('unicom', 'MemberGroup')
    Member = apps.get_model('unicom', 'Member')
    
    # Create the All Members group
    all_members_group, created = MemberGroup.objects.get_or_create(
        name='All Members',
        defaults={
            'description': 'Default group containing all members. Used for category access control.'
        }
    )
    
    # Add all existing members to the group
    if created:
        all_members_group.members.set(Member.objects.all())


def reverse_all_members_group(apps, schema_editor):
    """Remove the 'All Members' group."""
    MemberGroup = apps.get_model('unicom', 'MemberGroup')
    MemberGroup.objects.filter(name='All Members').delete()


class Migration(migrations.Migration):

    dependencies = [
        ('unicom', '0007_message_imap_uid'),
    ]

    operations = [
        migrations.RunPython(
            create_all_members_group,
            reverse_all_members_group
        ),
    ]
