# Generated by Django 4.2.20 on 2025-09-26 20:32

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('unicom', '0009_add_tool_call_types'),
    ]

    operations = [
        migrations.AddField(
            model_name='request',
            name='initial_request',
            field=models.ForeignKey(blank=True, help_text='Root request that started this chain', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='descendant_requests', to='unicom.request'),
        ),
        migrations.AddField(
            model_name='request',
            name='llm_calls_count',
            field=models.PositiveIntegerField(default=0, help_text='Number of LLM calls made for this request'),
        ),
        migrations.AddField(
            model_name='request',
            name='llm_token_usage',
            field=models.PositiveIntegerField(default=0, help_text='Total tokens used by LLM for this request'),
        ),
        migrations.AddField(
            model_name='request',
            name='parent_request',
            field=models.ForeignKey(blank=True, help_text='Parent request that spawned this request', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='child_requests', to='unicom.request'),
        ),
        migrations.AddField(
            model_name='request',
            name='tool_call_count',
            field=models.PositiveIntegerField(default=0, help_text='Number of tool calls made from this request'),
        ),
        migrations.CreateModel(
            name='ToolCall',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('call_id', models.CharField(db_index=True, max_length=100, unique=True)),
                ('tool_name', models.CharField(db_index=True, max_length=100)),
                ('arguments', models.JSONField()),
                ('status', models.CharField(choices=[('PENDING', 'Pending'), ('IN_PROGRESS', 'In Progress'), ('COMPLETED', 'Completed'), ('ERROR', 'Error'), ('INTERRUPTED', 'Interrupted'), ('ACTIVE', 'Active')], db_index=True, default='PENDING', max_length=20)),
                ('error', models.TextField(blank=True, help_text='Error message if processing fails', null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('started_at', models.DateTimeField(blank=True, null=True)),
                ('completed_at', models.DateTimeField(blank=True, null=True)),
                ('request', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tool_calls', to='unicom.request')),
            ],
            options={
                'ordering': ['-created_at'],
                'indexes': [models.Index(fields=['status', 'created_at'], name='unicom_tool_status_ab7e95_idx'), models.Index(fields=['tool_name', 'status'], name='unicom_tool_tool_na_f6e5fe_idx')],
            },
        ),
    ]
