# Generated by Django 4.2.20 on 2025-09-26 22:11

from django.db import migrations, models
import django.db.models.deletion


def clear_toolcall_records(apps, schema_editor):
    """Clear all existing ToolCall records to allow for clean schema change"""
    ToolCall = apps.get_model('unicom', 'ToolCall')
    ToolCall.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('unicom', '0010_request_initial_request_request_llm_calls_count_and_more'),
    ]

    operations = [
        migrations.RunPython(
            clear_toolcall_records,
            reverse_code=migrations.RunPython.noop,
        ),
        migrations.AddField(
            model_name='toolcall',
            name='tool_call_message',
            field=models.ForeignKey(
                help_text='The tool_call message that this ToolCall object represents',
                on_delete=django.db.models.deletion.CASCADE,
                related_name='tool_call_record',
                to='unicom.message'
            ),
        ),
    ]
