# Generated by Django 4.2.20 on 2025-10-02 10:00

from django.db import migrations, models
import django.db.models.deletion
import json


def convert_callback_data_to_json(apps, schema_editor):
    """Convert existing string callback_data to JSON format"""
    CallbackExecution = apps.get_model('unicom', 'CallbackExecution')
    for execution in CallbackExecution.objects.all():
        # Try to parse as JSON, if it fails, wrap in quotes to make it valid JSON string
        try:
            json.loads(execution.callback_data)
            # Already valid JSON, keep as is
        except (json.JSONDecodeError, TypeError):
            # Not valid JSON, convert string to JSON string
            execution.callback_data = json.dumps(execution.callback_data)
            execution.save(update_fields=['callback_data'])


class Migration(migrations.Migration):

    dependencies = [
        ('unicom', '0014_rename_authorized_user_to_intended_account'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='callbackexecution',
            name='callback_id',
        ),
        migrations.RemoveField(
            model_name='callbackexecution',
            name='callback_message',
        ),
        migrations.RemoveField(
            model_name='callbackexecution',
            name='processed_at',
        ),
        migrations.AddField(
            model_name='callbackexecution',
            name='expires_at',
            field=models.DateTimeField(blank=True, help_text='Optional expiration time for this callback', null=True),
        ),
        # Convert existing data to valid JSON before changing field type
        migrations.RunPython(convert_callback_data_to_json, migrations.RunPython.noop),
        migrations.AlterField(
            model_name='callbackexecution',
            name='callback_data',
            field=models.JSONField(help_text='Button callback data (any JSON-serializable type)'),
        ),
        migrations.AlterField(
            model_name='callbackexecution',
            name='intended_account',
            field=models.ForeignKey(help_text='The account this button is intended for', on_delete=django.db.models.deletion.CASCADE, to='unicom.account'),
        ),
    ]
