//ϵͳ
#ifdef WIN32
#include "stdafx.h"
#endif

#include "vnxtp.h"
#include "pybind11/pybind11.h"
#include "xtp/xtp_quote_api.h"


using namespace pybind11;
using namespace XTP::API;


///-------------------------------------------------------------------------------------
///C++ SPIĻصʵ
///-------------------------------------------------------------------------------------

//APIļ̳ʵ
class MdApi : public QuoteSpi
{
private:
	QuoteApi* api = NULL;				//API
	bool active = false;		//״̬

public:
	MdApi()
	{
	};

	~MdApi()
	{
		if (this->active)
		{
			this->exit();
		}
	};

	//-------------------------------------------------------------------------------------
	//APIص
	//-------------------------------------------------------------------------------------

	///ͻ̨ͨӶϿʱ÷á
	///@param reason ԭӦ
	///@remark apiԶ߷ʱûѡڴ˺еLoginµ¼עûµ¼Ҫ¶
	virtual void OnDisconnected(int reason);


	///Ӧ
	///@param error_info ӦʱľĴʹϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@remark ˺ֻڷʱŻãһû
	virtual void OnError(XTPRI *error_info);

	///Ӧ𣬰ƱָȨ
	///@param ticker ϸĺԼ
	///@param error_info ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param is_last Ƿ˴ζĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	///@remark ÿĵĺԼӦһӦҪٷأϢʱᴥ
	virtual void OnSubMarketData(XTPST *ticker, XTPRI *error_info, bool is_last);

	///˶Ӧ𣬰ƱָȨ
	///@param ticker ϸĺԼȡ
	///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param is_last Ƿ˴ȡĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	///@remark ÿȡĵĺԼӦһȡӦҪٷأϢʱᴥ
	virtual void OnUnSubMarketData(XTPST *ticker, XTPRI *error_info, bool is_last);

	///֪ͨһһ
	///@param market_data 
	///@param bid1_qty һ
	///@param bid1_count һеЧίб
	///@param max_bid1_count һίб
	///@param ask1_qty һ
	///@param ask1_count һеЧίб
	///@param max_ask1_count һίб
	///@remark ҪٷأϢʱᴥ
	virtual void OnDepthMarketData(XTPMD *market_data, int64_t bid1_qty[], int32_t bid1_count, int32_t max_bid1_count, int64_t ask1_qty[], int32_t ask1_count, int32_t max_ask1_count);

	///鶩Ӧ𣬰ƱָȨ
	///@param ticker ϸĺԼ
	///@param error_info ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param is_last Ƿ˴ζĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	///@remark ÿĵĺԼӦһӦҪٷأϢʱᴥ
	virtual void OnSubOrderBook(XTPST *ticker, XTPRI *error_info, bool is_last);

	///˶鶩Ӧ𣬰ƱָȨ
	///@param ticker ϸĺԼȡ
	///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param is_last Ƿ˴ȡĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	///@remark ÿȡĵĺԼӦһȡӦҪٷأϢʱᴥ
	virtual void OnUnSubOrderBook(XTPST *ticker, XTPRI *error_info, bool is_last);

	///鶩֪ͨƱָȨ
	///@param order_book 鶩ݣҪٷأϢʱᴥ
	virtual void OnOrderBook(XTPOB *order_book);

	///Ӧ𣬰ƱָȨ
	///@param ticker ϸĺԼ
	///@param error_info ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param is_last Ƿ˴ζĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	///@remark ÿĵĺԼӦһӦҪٷأϢʱᴥ
	virtual void OnSubTickByTick(XTPST *ticker, XTPRI *error_info, bool is_last);

	///˶Ӧ𣬰ƱָȨ
	///@param ticker ϸĺԼȡ
	///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param is_last Ƿ˴ȡĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	///@remark ÿȡĵĺԼӦһȡӦҪٷأϢʱᴥ
	virtual void OnUnSubTickByTick(XTPST *ticker, XTPRI *error_info, bool is_last);

	///֪ͨƱָȨ
	///@param tbt_data ݣίкʳɽΪýṹ壬ҪtypeίлʳɽҪٷأϢʱᴥ
	virtual void OnTickByTick(XTPTBT *tbt_data);

	///ȫгĹƱӦ
	///@param exchange_id ʾǰȫĵгΪXTP_EXCHANGE_UNKNOWNʾȫгXTP_EXCHANGE_SHʾΪϺȫгXTP_EXCHANGE_SZʾΪȫг
	///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@remark Ҫٷ
	virtual void OnSubscribeAllMarketData(XTP_EXCHANGE_TYPE exchange_id, XTPRI *error_info);

	///˶ȫгĹƱӦ
	///@param exchange_id ʾǰ˶гΪXTP_EXCHANGE_UNKNOWNʾȫгXTP_EXCHANGE_SHʾΪϺȫгXTP_EXCHANGE_SZʾΪȫг
	///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@remark Ҫٷ
	virtual void OnUnSubscribeAllMarketData(XTP_EXCHANGE_TYPE exchange_id, XTPRI *error_info);

	///ȫгĹƱ鶩Ӧ
	///@param exchange_id ʾǰȫĵгΪXTP_EXCHANGE_UNKNOWNʾȫгXTP_EXCHANGE_SHʾΪϺȫгXTP_EXCHANGE_SZʾΪȫг
	///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@remark Ҫٷ
	virtual void OnSubscribeAllOrderBook(XTP_EXCHANGE_TYPE exchange_id, XTPRI *error_info);

	///˶ȫгĹƱ鶩Ӧ
	///@param exchange_id ʾǰ˶гΪXTP_EXCHANGE_UNKNOWNʾȫгXTP_EXCHANGE_SHʾΪϺȫгXTP_EXCHANGE_SZʾΪȫг
	///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@remark Ҫٷ
	virtual void OnUnSubscribeAllOrderBook(XTP_EXCHANGE_TYPE exchange_id, XTPRI *error_info);

	///ȫгĹƱӦ
	///@param exchange_id ʾǰȫĵгΪXTP_EXCHANGE_UNKNOWNʾȫгXTP_EXCHANGE_SHʾΪϺȫгXTP_EXCHANGE_SZʾΪȫг
	///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@remark Ҫٷ
	virtual void OnSubscribeAllTickByTick(XTP_EXCHANGE_TYPE exchange_id, XTPRI *error_info);

	///˶ȫгĹƱӦ
	///@param exchange_id ʾǰ˶гΪXTP_EXCHANGE_UNKNOWNʾȫгXTP_EXCHANGE_SHʾΪϺȫгXTP_EXCHANGE_SZʾΪȫг
	///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@remark Ҫٷ
	virtual void OnUnSubscribeAllTickByTick(XTP_EXCHANGE_TYPE exchange_id, XTPRI *error_info);


	///ѯԼ־̬ϢӦ
	///@param ticker_info Լ־̬Ϣ
	///@param error_info ѯԼ־̬ϢʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param is_last Ƿ˴βѯԼ־̬ϢһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	virtual void OnQueryAllTickers(XTPQSI* ticker_info, XTPRI *error_info, bool is_last);

	///ѯԼ¼۸ϢӦ
	///@param ticker_info Լ¼۸Ϣ
	///@param error_info ѯԼ¼۸ϢʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param is_last Ƿ˴βѯһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	virtual void OnQueryTickersPriceInfo(XTPTPI* ticker_info, XTPRI *error_info, bool is_last);

	///ȫгȨӦ
	///@param exchange_id ʾǰȫĵгΪXTP_EXCHANGE_UNKNOWNʾȫгXTP_EXCHANGE_SHʾΪϺȫгXTP_EXCHANGE_SZʾΪȫг
	///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@remark Ҫٷ
	virtual void OnSubscribeAllOptionMarketData(XTP_EXCHANGE_TYPE exchange_id, XTPRI *error_info);

	///˶ȫгȨӦ
	///@param exchange_id ʾǰ˶гΪXTP_EXCHANGE_UNKNOWNʾȫгXTP_EXCHANGE_SHʾΪϺȫгXTP_EXCHANGE_SZʾΪȫг
	///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@remark Ҫٷ
	virtual void OnUnSubscribeAllOptionMarketData(XTP_EXCHANGE_TYPE exchange_id, XTPRI *error_info);

	///ȫгȨ鶩Ӧ
	///@param exchange_id ʾǰȫĵгΪXTP_EXCHANGE_UNKNOWNʾȫгXTP_EXCHANGE_SHʾΪϺȫгXTP_EXCHANGE_SZʾΪȫг
	///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@remark Ҫٷ
	virtual void OnSubscribeAllOptionOrderBook(XTP_EXCHANGE_TYPE exchange_id, XTPRI *error_info);

	///˶ȫгȨ鶩Ӧ
	///@param exchange_id ʾǰ˶гΪXTP_EXCHANGE_UNKNOWNʾȫгXTP_EXCHANGE_SHʾΪϺȫгXTP_EXCHANGE_SZʾΪȫг
	///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@remark Ҫٷ
	virtual void OnUnSubscribeAllOptionOrderBook(XTP_EXCHANGE_TYPE exchange_id, XTPRI *error_info);

	///ȫгȨӦ
	///@param exchange_id ʾǰȫĵгΪXTP_EXCHANGE_UNKNOWNʾȫгXTP_EXCHANGE_SHʾΪϺȫгXTP_EXCHANGE_SZʾΪȫг
	///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@remark Ҫٷ
	virtual void OnSubscribeAllOptionTickByTick(XTP_EXCHANGE_TYPE exchange_id, XTPRI *error_info);

	///˶ȫгȨӦ
	///@param exchange_id ʾǰ˶гΪXTP_EXCHANGE_UNKNOWNʾȫгXTP_EXCHANGE_SHʾΪϺȫгXTP_EXCHANGE_SZʾΪȫг
	///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@remark Ҫٷ
	virtual void OnUnSubscribeAllOptionTickByTick(XTP_EXCHANGE_TYPE exchange_id, XTPRI *error_info);

	///ѯԼ̬ϢӦ
	///@param ticker_info Լ̬Ϣ
	///@param error_info ѯԼ̬ϢʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param is_last Ƿ˴βѯԼ̬ϢһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
	virtual void OnQueryAllTickersFullInfo(XTPQFI* ticker_info, XTPRI *error_info, bool is_last);

	//-------------------------------------------------------------------------------------
	//dataصֵ
	//errorصĴֵ
	//ԭ
	//-------------------------------------------------------------------------------------

	virtual void onDisconnected(int reason) {};

	virtual void onError(const dict &error) {};

	virtual void onSubMarketData(const dict &data, const dict &error, bool is_last) {};

	virtual void onUnSubMarketData(const dict &data, const dict &error, bool is_last) {};

	virtual void onDepthMarketData(const dict &data) {};

	virtual void onSubOrderBook(const dict &data, const dict &error, bool is_last) {};

	virtual void onUnSubOrderBook(const dict &data, const dict &error, bool is_last) {};

	virtual void onOrderBook(const dict &data) {};

	virtual void onSubTickByTick(const dict &data, const dict &error, bool is_last) {};

	virtual void onUnSubTickByTick(const dict &data, const dict &error, bool is_last) {};

	virtual void onTickByTick(const dict &data) {};

	virtual void onSubscribeAllMarketData(int exchange_id, const dict &error) {};

	virtual void onUnSubscribeAllMarketData(int exchange_id, const dict &error) {};

	virtual void onSubscribeAllOrderBook(int exchange_id, const dict &error) {};

	virtual void onUnSubscribeAllOrderBook(int exchange_id, const dict &error) {};

	virtual void onSubscribeAllTickByTick(int exchange_id, const dict &error) {};

	virtual void onUnSubscribeAllTickByTick(int exchange_id, const dict &error) {};

	virtual void onQueryAllTickers(const dict &data, const dict &error, bool is_last) {};

	virtual void onQueryTickersPriceInfo(const dict &data, const dict &error, bool is_last) {};

	virtual void onSubscribeAllOptionMarketData(int exchange_id, const dict &error) {};

	virtual void onUnSubscribeAllOptionMarketData(int exchange_id, const dict &error) {};

	virtual void onSubscribeAllOptionOrderBook(int exchange_id, const dict &error) {};

	virtual void onUnSubscribeAllOptionOrderBook(int exchange_id, const dict &error) {};

	virtual void onSubscribeAllOptionTickByTick(int exchange_id, const dict &error) {};

	virtual void onUnSubscribeAllOptionTickByTick(int exchange_id, const dict &error) {};

	virtual void onQueryAllTickersFullInfo(const dict &data, const dict &error, bool is_last) {};

	//-------------------------------------------------------------------------------------
	//req:ֵ
	//-------------------------------------------------------------------------------------

	void createQuoteApi(int client_id, string save_file_path, int log_level);

	void release();

	void init();

	int exit();

	string getTradingDay();

	string getApiVersion();

	dict getApiLastError();

	void setUDPBufferSize(int buff_size);

	void setHeartBeatInterval(int interval);

	int subscribeMarketData(string ticker, int count, int exchange_id);

	int unSubscribeMarketData(string ticker, int count, int exchange_id);

	int subscribeOrderBook(string ticker, int count, int exchange_id);

	int unSubscribeOrderBook(string ticker, int count, int exchange_id);

	int subscribeTickByTick(string ticker, int count, int exchange_id);

	int unSubscribeTickByTick(string ticker, int count, int exchange_id);

	int subscribeAllMarketData(int exchange_id);

	int unSubscribeAllMarketData(int exchange_id);

	int subscribeAllOrderBook(int exchange_id);

	int unSubscribeAllOrderBook(int exchange_id);

	int subscribeAllTickByTick(int exchange_id);

	int unSubscribeAllTickByTick(int exchange_id);

	int login(string ip, int port, string user, string password, int sock_type, string local_ip);

	int logout();

	int queryAllTickers(int exchange_id);

	int queryTickersPriceInfo(string ticker, int count, int exchange_id);

	int queryAllTickersPriceInfo();

	int queryAllTickersFullInfo(int exchange_id);
};
