# 打谱么
本项目用于将线性乐谱转换为 MIDI 文件。

&emsp;&emsp;线性乐谱是本项目创制的一种 ASCII 字符书写简单乐谱的方式。下面将详细介绍线性乐谱。

## 线性乐谱
&emsp;&emsp;线性乐谱的行分为参数行和乐谱行。参数行用于修改演奏参数，乐谱行用于描述音符。

## 参数行
&emsp;&emsp;参数行可以修改演奏参数，下一行起将使用新参数进行演奏。所有参数**大小写敏感**。

| 参数 | 格式 | 示例 |
| :--: | :-- | :--: |
| 谱号 | 以 `1=` 开头，后接 `CDEFGAB` 其一，然后可以选择接 `#b.,` 或其组合来表示半音和八度。| `1=C` |
| BPM | 以数字开头并以 `bpm` 结尾。| `120bpm` |

- **不同参数间使用空格连接**。参数无顺序。
- 若首行未指定参数，则默认为 `1=C 120bpm`。
- 若参数行未指定某一参数，则继承该行以前的该项参数值。

一些正确的参数行示例：
- `1=G 100bpm` 表示 G 大调，100 bpm
- `1=Bb. 70bpm` 表示低八度 Bb 大调，70 bpm
- `1=A` 表示 A 大调，bpm 继承上一个参数行。若前面没有其它参数行，则保持默认值 120 bpm

## 音符行
&emsp;&emsp;与简谱相同，线性乐谱用 1 至 7 七个数字代表七个音符。音符后可以接后缀表示音高和时值。下面是所有允许的后缀：

| 音高后缀 | 含义 | 时值后缀 | 含义 | 时值后缀 | 含义 |
| :--: | :--: | :--: | :--: | :--: | :--: |
| `#` | 高半音 | `-` | 1 拍 | `*` | 0.5 拍 |
| `b` | 低半音 | `~` | 1.5 拍 | `^` | 1/4 拍 |
| `.` | 高八度 | `=` | 2 拍 | `'` | 1/8 拍 |
| `,` | 低八度 | `+` | 4 拍 |

- **若音符无时值后缀，则默认为 0.5 拍。**
- 后缀**可以叠加**且无顺序。可以用时值后缀组合出不同的拍数，比如 3 拍使用 `~~` 或 `=-` 后缀。

一些正确的音符示例：
- `1` 表示 0.5 拍 do
- `5-` 表示 1 拍 sol
- `1.-` 表示 1 拍高八度 do
- `1=*` 表示 2.5 拍 do

## 多轨演奏
&emsp;&emsp;在音符之后使用圆括号 `()` 内写其它音符，表示多轨同时演奏。多轨时值与主轨右对齐，例如在 `1-3-(5-)` 中，`3-` 和 `5-` 同时演奏。若两条以上轨道同时演奏，请以 `1-(3-)(5-)` 格式书写。

## 和弦演奏
&emsp;&emsp;请在音符行写入方括号 `[]`，然后在其中写入和弦记号，此处将会自动演奏和弦并持续到下一个和弦的位置。和弦记号由级数、类型、后缀、转位和八度组成。

### 级数
&emsp;&emsp;本项目支持以下和弦级数：
| 一级 | 二级 | 三级 | 四级 | 五级 | 六级 | 七级 |
| :--: | :--: | :--: | :--: | :--: | :--: | :--: |
| 1 | 2 | 3 | 4 | 5 | 6 | 7 |
| 1# | 2# | 3# | 4# | 5# | 6# | 7# |
| 1b | 2b | 3b | 4b | 5b | 6b | 7b |

### 类型
&emsp;&emsp;本项目支持以下和弦类型：
| 和弦家族 | 三和弦 | 七和弦 | 九和弦 | 十一和弦 | 十三和弦 | 三音、五音、七音 |
| :--: | :--: | :--: | :--: | :--: | :--: | :--: |
| 大和弦 | (无后缀) | M7 | M9 | M11 | M13 | 大三、纯五、大七 |
| 小和弦 | m | m7 | m9 | m11 | m13 | 小三、纯五、小七 |
| 减和弦 | dim | dim7 | dim9 | dim11 | dim13 | 小三、减五、减七 |
| 增和弦 | aug | aug7 | aug9 | aug11 | aug13 | 大三、增五、小七 |
| 属和弦 | | 7 | 9 | 11 | 13 | 大三、纯五、小七 |
| 小大和弦 | | mM7 | mM9 | mM11 | mM13 | 小三、纯五、大七 |
| 增大和弦 | | augM7 | augM9 | augM11 | augM13 | 大三、增五、大七 |

*注：对于半减七和弦，请使用 `m7b5`（见下文“后缀”一节）。*

### 后缀
&emsp;&emsp;和弦支持以下后缀：
| 后缀 | 功能 |
| :-- | :-- |
| add\[9,11,13\] | 加入某音。此处加入的是纯音程或大音程。 |
| omit\[3,5,7,9,11,13\] | 省略某音。 |
| sus、sus2 | 将三音更换为增三度音或减三度音。 |
| #\[3,5,7,9,11,13\] | 升高某音，若该音不存在则先加入再升高。 |
| b\[3,5,7,9,11,13\] | 降低某音，若该音不存在则先加入再降低。 |
| /\[#b2-13\] | 切换根音。 |

### 转位
&emsp;&emsp;可以在和弦最后加入斜杠 `/`，然后追加一个和弦级数。若追加的级数为和弦内音，则所有低于该级数的音将移高八度；若追加的级数为和弦外音，则先将该音加入和弦，然后将所有低于该级数的音将移高八度。

### 八度
&emsp;&emsp;和弦的末尾可以添加若干个 `,` 或者 `.` 来调整演奏的八度，以便构建低音线条。请注意，和弦默认是低八度演奏的。例如 `[5/7,]` 表示低两个八度演奏；`[1.]` 表示以中央八度演奏。

一些正确的和弦记号举例：
- 4：四级大三和弦
- 57：五级属七和弦
- 7bsus：降七级大三挂四和弦
- 4#m7b5：升四级半减七和弦
- 1add6add9：一级六九和弦
- 511omit3omit5：五级属十一和弦，省略三音和五音
- 1/5：一级大三和弦第二转位，即 `5(1.)(3.)`
- 4/5：四级大三和弦下加 5，即 `5(6)(1.)(4.)`

*注：请注意升降记号可能引起的歧义。在 `1` 至 `7` 七个大三和弦后，若要直接添加升降音后缀，请先加入空格。例如六级大三降十三和弦为 `6 b13` 而不是 `6b13`（降六级属十三和弦）。*

## 乐谱示例
卡农主旋律
```
1=D
5-345-34(1+(3+(5+)))
55,6,7,1234(7,+(2+(5+)))
3-123-3,4,(6,+(1+(3+)))
5,6,5,4,5,3,4,5,(5,+(7,+(3+)))
4,-6,5,4,-3,2,(4,+(6,+(1+)))
3,2,1,2,3,4,5,6,(3,+(5,+(1+)))
4,-6,5,6,-7,1(4,+(6,+(1+)))
5,6,7,12345(5,+(7,+(2+)))
```
更多乐谱示例位于 [templates](./templates) 文件夹下

| 文件名 | 乐曲 | 艺术家 | 备注 |
| :-- | :-- | :-- | :-- |
| `tori_no_uta.txt` | 鸟之诗 | Lia | 仅旋律，用于测试单轨演奏 |
| `flower_dance.txt` | 花之舞 | DJ Okawari | 用于测试简单多轨演奏 |
| `canon.txt` | 卡农 | Johann Pachelbel | 用于测试复杂多轨演奏和紧凑式写法 |
| `orchid_pavilion.txt` | 兰亭序 | 周杰伦 | 仅副歌，用于测试和弦演奏 |
