# SnakeScan
![PyPI version](https://badge.fury.io/py/SnakeScan.svg)
![Requires-python](https://img.shields.io/badge/requires--python-3.7+-red)
![License](https://img.shields.io/badge/License-MIT-blue.svg)
 ```
import SnakeScan
SnakeScan.run()
```
## Help
- -l  need internet to view public ip you device
- -t threading port search
- -s single search ports
- -i information about host
- -help in host /-help port in host
- -check [host] scan subnet in ip
- exit in host or port off script
## Added class Watcher:
 ```
 from SnakeScan import Watcher
 Watcher = Watcher(host="localhost",port="80",timeout=1)
 Watcher.start()
 ```
 ## Watcher commands
 ```
 Watcher.start() - Starts checking ports
 Watcher.stop() - Stops port checking
 ## Added multiple use Watcher:
 ```
 from SnakeScan import Watcher
 ports=[53,80,100,160]
 Watchers=[]
 for i in range(len(ports)):
 Watchers.append(Watcher("127.0.0.1",ports[i]))
 Watchers[i].start()
 ```
## Added CLI command line use snake or Snake
```
usage: snake [-h] [-sp] [-v] [-i] [-p PORTS] [-t] [-ch]
             [-l]
             [host]

Snake - It's a command line module SnakeScan. Use him for
more fast starting

positional arguments:
  host

options:
  -h, --help         show this help message and exit
  -sp, --speed       speed scan
  -v, --version      version
  -i, --info         ip info
  -p, --ports PORTS  range ports to scan host
  -t, --thread       fast scan
  -ch, --check       scan subnet
  -l, --local        view you public ip - need internet
```
## Attributes snake-Snake
```
-p:snake -p 80,443,3437,20-1000
-p:[20]-1000 will start from [21]-[1000]
-h:snake -h [snake usage]
-sp:snake -sp [use processpoolexecutir to scan host]
-v:snake -v [Build_version]
-t:snake -t [use thread pool to scan]
-ch:snake -ch [scan subnet in host]
-l:snake -l [view you public ip and to view need on internet]
-i:snake www.google.com -i [info ip of host]
All:snake -p 100,200,79-443 www.google.com -i -l -t -ch -sp
```
## Added Info about ipv6
```
snake 2001:db8:: -i or snake [2001:4860:4860::8888] -i
```