# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OciLinkAccountArgs', 'OciLinkAccount']

@pulumi.input_type
class OciLinkAccountArgs:
    def __init__(__self__, *,
                 compartment_ocid: pulumi.Input[_builtins.str],
                 oci_client_id: pulumi.Input[_builtins.str],
                 oci_client_secret: pulumi.Input[_builtins.str],
                 oci_domain_url: pulumi.Input[_builtins.str],
                 oci_home_region: pulumi.Input[_builtins.str],
                 tenant_id: pulumi.Input[_builtins.str],
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingest_vault_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 instrumentation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_stack_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_stack_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_region: Optional[pulumi.Input[_builtins.str]] = None,
                 user_vault_ocid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OciLinkAccount resource.
        :param pulumi.Input[_builtins.str] compartment_ocid: OCI compartment OCID representing (or containing) the monitored resources/newrelic compartment.
        :param pulumi.Input[_builtins.str] oci_client_id: OCI Identity Domain (IDCS) OAuth2 client ID used for workload identity federation.
        :param pulumi.Input[_builtins.str] oci_client_secret: OAuth2 client secret. Not displayed in plans or state outputs.
        :param pulumi.Input[_builtins.str] oci_domain_url: Base URL of the OCI Identity Domain (e.g. `https://idcs-<hash>.identity.oraclecloud.com`).
        :param pulumi.Input[_builtins.str] oci_home_region: Home region of the tenancy (e.g. `us-ashburn-1`).
        :param pulumi.Input[_builtins.str] tenant_id: OCI tenancy OCID (root tenancy). Changing forces a new linked account.
        :param pulumi.Input[_builtins.str] account_id: New Relic account to operate on. Overrides the provider-level `account_id`. If omitted, use the provider default or `NEW_RELIC_ACCOUNT_ID`.
        :param pulumi.Input[_builtins.str] ingest_vault_ocid: Vault secret OCID containing an ingest secret.
        :param pulumi.Input[_builtins.str] instrumentation_type: Specifies the type of integration, such as metrics, logs, or a combination of logs and metrics (e.g., `METRICS`, `LOGS`, `METRICS,LOGS`).
        :param pulumi.Input[_builtins.str] logging_stack_ocid: The Logging stack identifier for the OCI account.
        :param pulumi.Input[_builtins.str] metric_stack_ocid: Metric stack OCID (ignored on create, applied on update).
        :param pulumi.Input[_builtins.str] name: Display name for the linked account.
        :param pulumi.Input[_builtins.str] oci_region: OCI region for the linkage (ignored on create, applied on update).
        :param pulumi.Input[_builtins.str] user_vault_ocid: Vault secret OCID containing a user or auxiliary secret.
        """
        pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        pulumi.set(__self__, "oci_client_id", oci_client_id)
        pulumi.set(__self__, "oci_client_secret", oci_client_secret)
        pulumi.set(__self__, "oci_domain_url", oci_domain_url)
        pulumi.set(__self__, "oci_home_region", oci_home_region)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if ingest_vault_ocid is not None:
            pulumi.set(__self__, "ingest_vault_ocid", ingest_vault_ocid)
        if instrumentation_type is not None:
            pulumi.set(__self__, "instrumentation_type", instrumentation_type)
        if logging_stack_ocid is not None:
            pulumi.set(__self__, "logging_stack_ocid", logging_stack_ocid)
        if metric_stack_ocid is not None:
            pulumi.set(__self__, "metric_stack_ocid", metric_stack_ocid)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oci_region is not None:
            pulumi.set(__self__, "oci_region", oci_region)
        if user_vault_ocid is not None:
            pulumi.set(__self__, "user_vault_ocid", user_vault_ocid)

    @_builtins.property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Input[_builtins.str]:
        """
        OCI compartment OCID representing (or containing) the monitored resources/newrelic compartment.
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_ocid", value)

    @_builtins.property
    @pulumi.getter(name="ociClientId")
    def oci_client_id(self) -> pulumi.Input[_builtins.str]:
        """
        OCI Identity Domain (IDCS) OAuth2 client ID used for workload identity federation.
        """
        return pulumi.get(self, "oci_client_id")

    @oci_client_id.setter
    def oci_client_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "oci_client_id", value)

    @_builtins.property
    @pulumi.getter(name="ociClientSecret")
    def oci_client_secret(self) -> pulumi.Input[_builtins.str]:
        """
        OAuth2 client secret. Not displayed in plans or state outputs.
        """
        return pulumi.get(self, "oci_client_secret")

    @oci_client_secret.setter
    def oci_client_secret(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "oci_client_secret", value)

    @_builtins.property
    @pulumi.getter(name="ociDomainUrl")
    def oci_domain_url(self) -> pulumi.Input[_builtins.str]:
        """
        Base URL of the OCI Identity Domain (e.g. `https://idcs-<hash>.identity.oraclecloud.com`).
        """
        return pulumi.get(self, "oci_domain_url")

    @oci_domain_url.setter
    def oci_domain_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "oci_domain_url", value)

    @_builtins.property
    @pulumi.getter(name="ociHomeRegion")
    def oci_home_region(self) -> pulumi.Input[_builtins.str]:
        """
        Home region of the tenancy (e.g. `us-ashburn-1`).
        """
        return pulumi.get(self, "oci_home_region")

    @oci_home_region.setter
    def oci_home_region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "oci_home_region", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[_builtins.str]:
        """
        OCI tenancy OCID (root tenancy). Changing forces a new linked account.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        New Relic account to operate on. Overrides the provider-level `account_id`. If omitted, use the provider default or `NEW_RELIC_ACCOUNT_ID`.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="ingestVaultOcid")
    def ingest_vault_ocid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vault secret OCID containing an ingest secret.
        """
        return pulumi.get(self, "ingest_vault_ocid")

    @ingest_vault_ocid.setter
    def ingest_vault_ocid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingest_vault_ocid", value)

    @_builtins.property
    @pulumi.getter(name="instrumentationType")
    def instrumentation_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of integration, such as metrics, logs, or a combination of logs and metrics (e.g., `METRICS`, `LOGS`, `METRICS,LOGS`).
        """
        return pulumi.get(self, "instrumentation_type")

    @instrumentation_type.setter
    def instrumentation_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instrumentation_type", value)

    @_builtins.property
    @pulumi.getter(name="loggingStackOcid")
    def logging_stack_ocid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Logging stack identifier for the OCI account.
        """
        return pulumi.get(self, "logging_stack_ocid")

    @logging_stack_ocid.setter
    def logging_stack_ocid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logging_stack_ocid", value)

    @_builtins.property
    @pulumi.getter(name="metricStackOcid")
    def metric_stack_ocid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Metric stack OCID (ignored on create, applied on update).
        """
        return pulumi.get(self, "metric_stack_ocid")

    @metric_stack_ocid.setter
    def metric_stack_ocid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_stack_ocid", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name for the linked account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ociRegion")
    def oci_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCI region for the linkage (ignored on create, applied on update).
        """
        return pulumi.get(self, "oci_region")

    @oci_region.setter
    def oci_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_region", value)

    @_builtins.property
    @pulumi.getter(name="userVaultOcid")
    def user_vault_ocid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vault secret OCID containing a user or auxiliary secret.
        """
        return pulumi.get(self, "user_vault_ocid")

    @user_vault_ocid.setter
    def user_vault_ocid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_vault_ocid", value)


@pulumi.input_type
class _OciLinkAccountState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 ingest_vault_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 instrumentation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_stack_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_stack_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_domain_url: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_home_region: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_vault_ocid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OciLinkAccount resources.
        :param pulumi.Input[_builtins.str] account_id: New Relic account to operate on. Overrides the provider-level `account_id`. If omitted, use the provider default or `NEW_RELIC_ACCOUNT_ID`.
        :param pulumi.Input[_builtins.str] compartment_ocid: OCI compartment OCID representing (or containing) the monitored resources/newrelic compartment.
        :param pulumi.Input[_builtins.str] ingest_vault_ocid: Vault secret OCID containing an ingest secret.
        :param pulumi.Input[_builtins.str] instrumentation_type: Specifies the type of integration, such as metrics, logs, or a combination of logs and metrics (e.g., `METRICS`, `LOGS`, `METRICS,LOGS`).
        :param pulumi.Input[_builtins.str] logging_stack_ocid: The Logging stack identifier for the OCI account.
        :param pulumi.Input[_builtins.str] metric_stack_ocid: Metric stack OCID (ignored on create, applied on update).
        :param pulumi.Input[_builtins.str] name: Display name for the linked account.
        :param pulumi.Input[_builtins.str] oci_client_id: OCI Identity Domain (IDCS) OAuth2 client ID used for workload identity federation.
        :param pulumi.Input[_builtins.str] oci_client_secret: OAuth2 client secret. Not displayed in plans or state outputs.
        :param pulumi.Input[_builtins.str] oci_domain_url: Base URL of the OCI Identity Domain (e.g. `https://idcs-<hash>.identity.oraclecloud.com`).
        :param pulumi.Input[_builtins.str] oci_home_region: Home region of the tenancy (e.g. `us-ashburn-1`).
        :param pulumi.Input[_builtins.str] oci_region: OCI region for the linkage (ignored on create, applied on update).
        :param pulumi.Input[_builtins.str] tenant_id: OCI tenancy OCID (root tenancy). Changing forces a new linked account.
        :param pulumi.Input[_builtins.str] user_vault_ocid: Vault secret OCID containing a user or auxiliary secret.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if compartment_ocid is not None:
            pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if ingest_vault_ocid is not None:
            pulumi.set(__self__, "ingest_vault_ocid", ingest_vault_ocid)
        if instrumentation_type is not None:
            pulumi.set(__self__, "instrumentation_type", instrumentation_type)
        if logging_stack_ocid is not None:
            pulumi.set(__self__, "logging_stack_ocid", logging_stack_ocid)
        if metric_stack_ocid is not None:
            pulumi.set(__self__, "metric_stack_ocid", metric_stack_ocid)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oci_client_id is not None:
            pulumi.set(__self__, "oci_client_id", oci_client_id)
        if oci_client_secret is not None:
            pulumi.set(__self__, "oci_client_secret", oci_client_secret)
        if oci_domain_url is not None:
            pulumi.set(__self__, "oci_domain_url", oci_domain_url)
        if oci_home_region is not None:
            pulumi.set(__self__, "oci_home_region", oci_home_region)
        if oci_region is not None:
            pulumi.set(__self__, "oci_region", oci_region)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if user_vault_ocid is not None:
            pulumi.set(__self__, "user_vault_ocid", user_vault_ocid)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        New Relic account to operate on. Overrides the provider-level `account_id`. If omitted, use the provider default or `NEW_RELIC_ACCOUNT_ID`.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCI compartment OCID representing (or containing) the monitored resources/newrelic compartment.
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_ocid", value)

    @_builtins.property
    @pulumi.getter(name="ingestVaultOcid")
    def ingest_vault_ocid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vault secret OCID containing an ingest secret.
        """
        return pulumi.get(self, "ingest_vault_ocid")

    @ingest_vault_ocid.setter
    def ingest_vault_ocid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingest_vault_ocid", value)

    @_builtins.property
    @pulumi.getter(name="instrumentationType")
    def instrumentation_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of integration, such as metrics, logs, or a combination of logs and metrics (e.g., `METRICS`, `LOGS`, `METRICS,LOGS`).
        """
        return pulumi.get(self, "instrumentation_type")

    @instrumentation_type.setter
    def instrumentation_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instrumentation_type", value)

    @_builtins.property
    @pulumi.getter(name="loggingStackOcid")
    def logging_stack_ocid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Logging stack identifier for the OCI account.
        """
        return pulumi.get(self, "logging_stack_ocid")

    @logging_stack_ocid.setter
    def logging_stack_ocid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logging_stack_ocid", value)

    @_builtins.property
    @pulumi.getter(name="metricStackOcid")
    def metric_stack_ocid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Metric stack OCID (ignored on create, applied on update).
        """
        return pulumi.get(self, "metric_stack_ocid")

    @metric_stack_ocid.setter
    def metric_stack_ocid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_stack_ocid", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name for the linked account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ociClientId")
    def oci_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCI Identity Domain (IDCS) OAuth2 client ID used for workload identity federation.
        """
        return pulumi.get(self, "oci_client_id")

    @oci_client_id.setter
    def oci_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_client_id", value)

    @_builtins.property
    @pulumi.getter(name="ociClientSecret")
    def oci_client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OAuth2 client secret. Not displayed in plans or state outputs.
        """
        return pulumi.get(self, "oci_client_secret")

    @oci_client_secret.setter
    def oci_client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_client_secret", value)

    @_builtins.property
    @pulumi.getter(name="ociDomainUrl")
    def oci_domain_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base URL of the OCI Identity Domain (e.g. `https://idcs-<hash>.identity.oraclecloud.com`).
        """
        return pulumi.get(self, "oci_domain_url")

    @oci_domain_url.setter
    def oci_domain_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_domain_url", value)

    @_builtins.property
    @pulumi.getter(name="ociHomeRegion")
    def oci_home_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Home region of the tenancy (e.g. `us-ashburn-1`).
        """
        return pulumi.get(self, "oci_home_region")

    @oci_home_region.setter
    def oci_home_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_home_region", value)

    @_builtins.property
    @pulumi.getter(name="ociRegion")
    def oci_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCI region for the linkage (ignored on create, applied on update).
        """
        return pulumi.get(self, "oci_region")

    @oci_region.setter
    def oci_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_region", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCI tenancy OCID (root tenancy). Changing forces a new linked account.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="userVaultOcid")
    def user_vault_ocid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vault secret OCID containing a user or auxiliary secret.
        """
        return pulumi.get(self, "user_vault_ocid")

    @user_vault_ocid.setter
    def user_vault_ocid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_vault_ocid", value)


@pulumi.type_token("newrelic:cloud/ociLinkAccount:OciLinkAccount")
class OciLinkAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 ingest_vault_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 instrumentation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_stack_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_stack_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_domain_url: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_home_region: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_vault_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Use this resource to link an Oracle Cloud Infrastructure (OCI) account to New Relic.

        This setup is used to create a provider account with OCI credentials, establishing a relationship between Oracle and New Relic. Additionally, as part of this integration, we store WIF (Workload Identity Federation) credentials which are further used for fetching data and validations, and vault OCIDs corresponding to the vault resource where the New Relic ingest and user keys are stored in the OCI console.

        ## Prerequisites

        For the `cloud.OciLinkAccount` resource to work properly, you need an OCI tenancy with IAM permissions to create and manage the identity artifacts (client/application, secrets, compartments, and service user) referenced below. OCI provides enterprise-grade cloud services across multiple global regions.

        > NOTE: Before using this resource, ensure the New Relic provider is configured with valid credentials.\\
        See Getting Started: New Relic provider guide

        If you encounter issues or bugs, please open an issue in the GitHub repository.

        ### Workload Identity Federation (WIF) Attributes

        The following arguments rely on an OCI Identity Domain OAuth2 client set up for workload identity federation (identity propagation): `oci_client_id`, `oci_client_secret` and `oci_domain_url`.

        To create and retrieve these values, follow Oracle's guidance for configuring identity propagation / JWT token exchange:

        [Oracle documentation: Create an identity propagation trust (JWT token exchange)](https://docs.oracle.com/en-us/iaas/Content/Identity/api-getstarted/json_web_token_exchange.htm#jwt_token_exchange__create-identity-propagation-trust)

        WIF configuration steps:
        1. Create (or identify) an Identity Domain and register an OAuth2 confidential application (client) to represent New Relic ingestion.
        2. Generate / record the client ID (`oci_client_id`) and client secret (`oci_client_secret`). Store the secret securely (e.g., in OCI Vault; reference its OCID via `ingest_vault_ocid` / `user_vault_ocid` if desired).
        3. Use the Identity Domain base URL as `oci_domain_url` (format: `https://idcs-<hash>.identity.oraclecloud.com`).
        4. Ensure the client has the required scopes and the tenancy policies allow the token exchange.

        > TIP: Rotating the OAuth2 client secret only requires updating `oci_client_secret`; it does not force resource replacement.

        ## Example Usage

        Minimal example (required arguments for creation):

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        example = newrelic.cloud.OciLinkAccount("example",
            account_id="1234567",
            tenant_id="ocid1.tenancy.oc1..aaaaaaaaexample",
            name="my-oci-link",
            compartment_ocid="ocid1.compartment.oc1..bbbbbbbbexample",
            oci_client_id="aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee",
            oci_client_secret=oci_client_secret,
            oci_domain_url="https://idcs-1234567890abcdef.identity.oraclecloud.com",
            oci_home_region="us-ashburn-1")
        ```

        Example including optional secret references and update-only fields:

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        full = newrelic.cloud.OciLinkAccount("full",
            name="my-oci-link-full",
            tenant_id="ocid1.tenancy.oc1..aaaaaaaaexample",
            compartment_ocid="ocid1.compartment.oc1..bbbbbbbbexample",
            oci_client_id="aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee",
            oci_client_secret=oci_client_secret,
            oci_domain_url="https://idcs-1234567890abcdef.identity.oraclecloud.com",
            oci_home_region="us-ashburn-1",
            ingest_vault_ocid="ocid1.vaultsecret.oc1..ccccccccexample",
            user_vault_ocid="ocid1.vaultsecret.oc1..ddddddddexample",
            instrumentation_type="METRICS,LOGS",
            oci_region="us-phoenix-1",
            metric_stack_ocid="ocid1.stack.oc1..eeeeeeeeexample",
            logging_stack_ocid="ocid1.stack.oc1..ffffffloggingstack")
        ```

        ## Import

        Linked OCI accounts can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import newrelic:cloud/ociLinkAccount:OciLinkAccount foo <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: New Relic account to operate on. Overrides the provider-level `account_id`. If omitted, use the provider default or `NEW_RELIC_ACCOUNT_ID`.
        :param pulumi.Input[_builtins.str] compartment_ocid: OCI compartment OCID representing (or containing) the monitored resources/newrelic compartment.
        :param pulumi.Input[_builtins.str] ingest_vault_ocid: Vault secret OCID containing an ingest secret.
        :param pulumi.Input[_builtins.str] instrumentation_type: Specifies the type of integration, such as metrics, logs, or a combination of logs and metrics (e.g., `METRICS`, `LOGS`, `METRICS,LOGS`).
        :param pulumi.Input[_builtins.str] logging_stack_ocid: The Logging stack identifier for the OCI account.
        :param pulumi.Input[_builtins.str] metric_stack_ocid: Metric stack OCID (ignored on create, applied on update).
        :param pulumi.Input[_builtins.str] name: Display name for the linked account.
        :param pulumi.Input[_builtins.str] oci_client_id: OCI Identity Domain (IDCS) OAuth2 client ID used for workload identity federation.
        :param pulumi.Input[_builtins.str] oci_client_secret: OAuth2 client secret. Not displayed in plans or state outputs.
        :param pulumi.Input[_builtins.str] oci_domain_url: Base URL of the OCI Identity Domain (e.g. `https://idcs-<hash>.identity.oraclecloud.com`).
        :param pulumi.Input[_builtins.str] oci_home_region: Home region of the tenancy (e.g. `us-ashburn-1`).
        :param pulumi.Input[_builtins.str] oci_region: OCI region for the linkage (ignored on create, applied on update).
        :param pulumi.Input[_builtins.str] tenant_id: OCI tenancy OCID (root tenancy). Changing forces a new linked account.
        :param pulumi.Input[_builtins.str] user_vault_ocid: Vault secret OCID containing a user or auxiliary secret.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OciLinkAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to link an Oracle Cloud Infrastructure (OCI) account to New Relic.

        This setup is used to create a provider account with OCI credentials, establishing a relationship between Oracle and New Relic. Additionally, as part of this integration, we store WIF (Workload Identity Federation) credentials which are further used for fetching data and validations, and vault OCIDs corresponding to the vault resource where the New Relic ingest and user keys are stored in the OCI console.

        ## Prerequisites

        For the `cloud.OciLinkAccount` resource to work properly, you need an OCI tenancy with IAM permissions to create and manage the identity artifacts (client/application, secrets, compartments, and service user) referenced below. OCI provides enterprise-grade cloud services across multiple global regions.

        > NOTE: Before using this resource, ensure the New Relic provider is configured with valid credentials.\\
        See Getting Started: New Relic provider guide

        If you encounter issues or bugs, please open an issue in the GitHub repository.

        ### Workload Identity Federation (WIF) Attributes

        The following arguments rely on an OCI Identity Domain OAuth2 client set up for workload identity federation (identity propagation): `oci_client_id`, `oci_client_secret` and `oci_domain_url`.

        To create and retrieve these values, follow Oracle's guidance for configuring identity propagation / JWT token exchange:

        [Oracle documentation: Create an identity propagation trust (JWT token exchange)](https://docs.oracle.com/en-us/iaas/Content/Identity/api-getstarted/json_web_token_exchange.htm#jwt_token_exchange__create-identity-propagation-trust)

        WIF configuration steps:
        1. Create (or identify) an Identity Domain and register an OAuth2 confidential application (client) to represent New Relic ingestion.
        2. Generate / record the client ID (`oci_client_id`) and client secret (`oci_client_secret`). Store the secret securely (e.g., in OCI Vault; reference its OCID via `ingest_vault_ocid` / `user_vault_ocid` if desired).
        3. Use the Identity Domain base URL as `oci_domain_url` (format: `https://idcs-<hash>.identity.oraclecloud.com`).
        4. Ensure the client has the required scopes and the tenancy policies allow the token exchange.

        > TIP: Rotating the OAuth2 client secret only requires updating `oci_client_secret`; it does not force resource replacement.

        ## Example Usage

        Minimal example (required arguments for creation):

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        example = newrelic.cloud.OciLinkAccount("example",
            account_id="1234567",
            tenant_id="ocid1.tenancy.oc1..aaaaaaaaexample",
            name="my-oci-link",
            compartment_ocid="ocid1.compartment.oc1..bbbbbbbbexample",
            oci_client_id="aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee",
            oci_client_secret=oci_client_secret,
            oci_domain_url="https://idcs-1234567890abcdef.identity.oraclecloud.com",
            oci_home_region="us-ashburn-1")
        ```

        Example including optional secret references and update-only fields:

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        full = newrelic.cloud.OciLinkAccount("full",
            name="my-oci-link-full",
            tenant_id="ocid1.tenancy.oc1..aaaaaaaaexample",
            compartment_ocid="ocid1.compartment.oc1..bbbbbbbbexample",
            oci_client_id="aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee",
            oci_client_secret=oci_client_secret,
            oci_domain_url="https://idcs-1234567890abcdef.identity.oraclecloud.com",
            oci_home_region="us-ashburn-1",
            ingest_vault_ocid="ocid1.vaultsecret.oc1..ccccccccexample",
            user_vault_ocid="ocid1.vaultsecret.oc1..ddddddddexample",
            instrumentation_type="METRICS,LOGS",
            oci_region="us-phoenix-1",
            metric_stack_ocid="ocid1.stack.oc1..eeeeeeeeexample",
            logging_stack_ocid="ocid1.stack.oc1..ffffffloggingstack")
        ```

        ## Import

        Linked OCI accounts can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import newrelic:cloud/ociLinkAccount:OciLinkAccount foo <id>
        ```

        :param str resource_name: The name of the resource.
        :param OciLinkAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OciLinkAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 ingest_vault_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 instrumentation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_stack_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_stack_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_domain_url: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_home_region: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_vault_ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OciLinkAccountArgs.__new__(OciLinkAccountArgs)

            __props__.__dict__["account_id"] = account_id
            if compartment_ocid is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_ocid'")
            __props__.__dict__["compartment_ocid"] = compartment_ocid
            __props__.__dict__["ingest_vault_ocid"] = ingest_vault_ocid
            __props__.__dict__["instrumentation_type"] = instrumentation_type
            __props__.__dict__["logging_stack_ocid"] = logging_stack_ocid
            __props__.__dict__["metric_stack_ocid"] = metric_stack_ocid
            __props__.__dict__["name"] = name
            if oci_client_id is None and not opts.urn:
                raise TypeError("Missing required property 'oci_client_id'")
            __props__.__dict__["oci_client_id"] = oci_client_id
            if oci_client_secret is None and not opts.urn:
                raise TypeError("Missing required property 'oci_client_secret'")
            __props__.__dict__["oci_client_secret"] = None if oci_client_secret is None else pulumi.Output.secret(oci_client_secret)
            if oci_domain_url is None and not opts.urn:
                raise TypeError("Missing required property 'oci_domain_url'")
            __props__.__dict__["oci_domain_url"] = oci_domain_url
            if oci_home_region is None and not opts.urn:
                raise TypeError("Missing required property 'oci_home_region'")
            __props__.__dict__["oci_home_region"] = oci_home_region
            __props__.__dict__["oci_region"] = oci_region
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["user_vault_ocid"] = user_vault_ocid
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["ociClientSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(OciLinkAccount, __self__).__init__(
            'newrelic:cloud/ociLinkAccount:OciLinkAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_ocid: Optional[pulumi.Input[_builtins.str]] = None,
            ingest_vault_ocid: Optional[pulumi.Input[_builtins.str]] = None,
            instrumentation_type: Optional[pulumi.Input[_builtins.str]] = None,
            logging_stack_ocid: Optional[pulumi.Input[_builtins.str]] = None,
            metric_stack_ocid: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            oci_client_id: Optional[pulumi.Input[_builtins.str]] = None,
            oci_client_secret: Optional[pulumi.Input[_builtins.str]] = None,
            oci_domain_url: Optional[pulumi.Input[_builtins.str]] = None,
            oci_home_region: Optional[pulumi.Input[_builtins.str]] = None,
            oci_region: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_vault_ocid: Optional[pulumi.Input[_builtins.str]] = None) -> 'OciLinkAccount':
        """
        Get an existing OciLinkAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: New Relic account to operate on. Overrides the provider-level `account_id`. If omitted, use the provider default or `NEW_RELIC_ACCOUNT_ID`.
        :param pulumi.Input[_builtins.str] compartment_ocid: OCI compartment OCID representing (or containing) the monitored resources/newrelic compartment.
        :param pulumi.Input[_builtins.str] ingest_vault_ocid: Vault secret OCID containing an ingest secret.
        :param pulumi.Input[_builtins.str] instrumentation_type: Specifies the type of integration, such as metrics, logs, or a combination of logs and metrics (e.g., `METRICS`, `LOGS`, `METRICS,LOGS`).
        :param pulumi.Input[_builtins.str] logging_stack_ocid: The Logging stack identifier for the OCI account.
        :param pulumi.Input[_builtins.str] metric_stack_ocid: Metric stack OCID (ignored on create, applied on update).
        :param pulumi.Input[_builtins.str] name: Display name for the linked account.
        :param pulumi.Input[_builtins.str] oci_client_id: OCI Identity Domain (IDCS) OAuth2 client ID used for workload identity federation.
        :param pulumi.Input[_builtins.str] oci_client_secret: OAuth2 client secret. Not displayed in plans or state outputs.
        :param pulumi.Input[_builtins.str] oci_domain_url: Base URL of the OCI Identity Domain (e.g. `https://idcs-<hash>.identity.oraclecloud.com`).
        :param pulumi.Input[_builtins.str] oci_home_region: Home region of the tenancy (e.g. `us-ashburn-1`).
        :param pulumi.Input[_builtins.str] oci_region: OCI region for the linkage (ignored on create, applied on update).
        :param pulumi.Input[_builtins.str] tenant_id: OCI tenancy OCID (root tenancy). Changing forces a new linked account.
        :param pulumi.Input[_builtins.str] user_vault_ocid: Vault secret OCID containing a user or auxiliary secret.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OciLinkAccountState.__new__(_OciLinkAccountState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["ingest_vault_ocid"] = ingest_vault_ocid
        __props__.__dict__["instrumentation_type"] = instrumentation_type
        __props__.__dict__["logging_stack_ocid"] = logging_stack_ocid
        __props__.__dict__["metric_stack_ocid"] = metric_stack_ocid
        __props__.__dict__["name"] = name
        __props__.__dict__["oci_client_id"] = oci_client_id
        __props__.__dict__["oci_client_secret"] = oci_client_secret
        __props__.__dict__["oci_domain_url"] = oci_domain_url
        __props__.__dict__["oci_home_region"] = oci_home_region
        __props__.__dict__["oci_region"] = oci_region
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["user_vault_ocid"] = user_vault_ocid
        return OciLinkAccount(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        New Relic account to operate on. Overrides the provider-level `account_id`. If omitted, use the provider default or `NEW_RELIC_ACCOUNT_ID`.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[_builtins.str]:
        """
        OCI compartment OCID representing (or containing) the monitored resources/newrelic compartment.
        """
        return pulumi.get(self, "compartment_ocid")

    @_builtins.property
    @pulumi.getter(name="ingestVaultOcid")
    def ingest_vault_ocid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Vault secret OCID containing an ingest secret.
        """
        return pulumi.get(self, "ingest_vault_ocid")

    @_builtins.property
    @pulumi.getter(name="instrumentationType")
    def instrumentation_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the type of integration, such as metrics, logs, or a combination of logs and metrics (e.g., `METRICS`, `LOGS`, `METRICS,LOGS`).
        """
        return pulumi.get(self, "instrumentation_type")

    @_builtins.property
    @pulumi.getter(name="loggingStackOcid")
    def logging_stack_ocid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Logging stack identifier for the OCI account.
        """
        return pulumi.get(self, "logging_stack_ocid")

    @_builtins.property
    @pulumi.getter(name="metricStackOcid")
    def metric_stack_ocid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Metric stack OCID (ignored on create, applied on update).
        """
        return pulumi.get(self, "metric_stack_ocid")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Display name for the linked account.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ociClientId")
    def oci_client_id(self) -> pulumi.Output[_builtins.str]:
        """
        OCI Identity Domain (IDCS) OAuth2 client ID used for workload identity federation.
        """
        return pulumi.get(self, "oci_client_id")

    @_builtins.property
    @pulumi.getter(name="ociClientSecret")
    def oci_client_secret(self) -> pulumi.Output[_builtins.str]:
        """
        OAuth2 client secret. Not displayed in plans or state outputs.
        """
        return pulumi.get(self, "oci_client_secret")

    @_builtins.property
    @pulumi.getter(name="ociDomainUrl")
    def oci_domain_url(self) -> pulumi.Output[_builtins.str]:
        """
        Base URL of the OCI Identity Domain (e.g. `https://idcs-<hash>.identity.oraclecloud.com`).
        """
        return pulumi.get(self, "oci_domain_url")

    @_builtins.property
    @pulumi.getter(name="ociHomeRegion")
    def oci_home_region(self) -> pulumi.Output[_builtins.str]:
        """
        Home region of the tenancy (e.g. `us-ashburn-1`).
        """
        return pulumi.get(self, "oci_home_region")

    @_builtins.property
    @pulumi.getter(name="ociRegion")
    def oci_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        OCI region for the linkage (ignored on create, applied on update).
        """
        return pulumi.get(self, "oci_region")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        OCI tenancy OCID (root tenancy). Changing forces a new linked account.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="userVaultOcid")
    def user_vault_ocid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Vault secret OCID containing a user or auxiliary secret.
        """
        return pulumi.get(self, "user_vault_ocid")

