# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EventArgs', 'Event']

@pulumi.input_type
class EventArgs:
    def __init__(__self__, *,
                 events: pulumi.Input[Sequence[pulumi.Input['EventEventArgs']]]):
        """
        The set of arguments for constructing a Event resource.
        :param pulumi.Input[Sequence[pulumi.Input['EventEventArgs']]] events: An event to insert into Insights. Multiple event blocks can be defined. See Events below for details.
        """
        pulumi.set(__self__, "events", events)

    @_builtins.property
    @pulumi.getter
    def events(self) -> pulumi.Input[Sequence[pulumi.Input['EventEventArgs']]]:
        """
        An event to insert into Insights. Multiple event blocks can be defined. See Events below for details.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: pulumi.Input[Sequence[pulumi.Input['EventEventArgs']]]):
        pulumi.set(self, "events", value)


@pulumi.input_type
class _EventState:
    def __init__(__self__, *,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input['EventEventArgs']]]] = None):
        """
        Input properties used for looking up and filtering Event resources.
        :param pulumi.Input[Sequence[pulumi.Input['EventEventArgs']]] events: An event to insert into Insights. Multiple event blocks can be defined. See Events below for details.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)

    @_builtins.property
    @pulumi.getter
    def events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventEventArgs']]]]:
        """
        An event to insert into Insights. Multiple event blocks can be defined. See Events below for details.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventEventArgs']]]]):
        pulumi.set(self, "events", value)


@pulumi.type_token("newrelic:insights/event:Event")
class Event(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventEventArgs', 'EventEventArgsDict']]]]] = None,
                 __props__=None):
        """
        Use this resource to create one or more Insights events.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.insights.Event("foo", events=[{
            "type": "MyEvent",
            "timestamp": 1232471100,
            "attributes": [
                {
                    "key": "a_string_attribute",
                    "value": "a string",
                },
                {
                    "key": "an_integer_attribute",
                    "value": "42",
                    "type": "int",
                },
                {
                    "key": "a_float_attribute",
                    "value": "101.1",
                    "type": "float",
                },
            ],
        }])
        ```

        ## Events

        The `event` mapping supports the following arguments:

          * `type` - (Required) The event's name. Can be a combination of alphanumeric characters, underscores, and colons.
          * `timestamp` - (Optional) Must be a Unix epoch timestamp. You can define timestamps either in seconds or in milliseconds.
          * `attribute` - (Required) An attribute to include in your event payload. Multiple attribute blocks can be defined for an event. See Attributes below for details.

        ### Attributes

        The `attribute` mapping supports the following arguments:

          * `key` - (Required) The name of the attribute.
          * `value` - (Required) The value of the attribute.
          * `type` - (Optional) Specify the type for the attribute value. This is useful when passing integer or float values to Insights. Allowed values are `string`, `int`, or `float`. Defaults to `string`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EventEventArgs', 'EventEventArgsDict']]]] events: An event to insert into Insights. Multiple event blocks can be defined. See Events below for details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to create one or more Insights events.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.insights.Event("foo", events=[{
            "type": "MyEvent",
            "timestamp": 1232471100,
            "attributes": [
                {
                    "key": "a_string_attribute",
                    "value": "a string",
                },
                {
                    "key": "an_integer_attribute",
                    "value": "42",
                    "type": "int",
                },
                {
                    "key": "a_float_attribute",
                    "value": "101.1",
                    "type": "float",
                },
            ],
        }])
        ```

        ## Events

        The `event` mapping supports the following arguments:

          * `type` - (Required) The event's name. Can be a combination of alphanumeric characters, underscores, and colons.
          * `timestamp` - (Optional) Must be a Unix epoch timestamp. You can define timestamps either in seconds or in milliseconds.
          * `attribute` - (Required) An attribute to include in your event payload. Multiple attribute blocks can be defined for an event. See Attributes below for details.

        ### Attributes

        The `attribute` mapping supports the following arguments:

          * `key` - (Required) The name of the attribute.
          * `value` - (Required) The value of the attribute.
          * `type` - (Optional) Specify the type for the attribute value. This is useful when passing integer or float values to Insights. Allowed values are `string`, `int`, or `float`. Defaults to `string`.

        :param str resource_name: The name of the resource.
        :param EventArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventEventArgs', 'EventEventArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventArgs.__new__(EventArgs)

            if events is None and not opts.urn:
                raise TypeError("Missing required property 'events'")
            __props__.__dict__["events"] = events
        super(Event, __self__).__init__(
            'newrelic:insights/event:Event',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            events: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventEventArgs', 'EventEventArgsDict']]]]] = None) -> 'Event':
        """
        Get an existing Event resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EventEventArgs', 'EventEventArgsDict']]]] events: An event to insert into Insights. Multiple event blocks can be defined. See Events below for details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventState.__new__(_EventState)

        __props__.__dict__["events"] = events
        return Event(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def events(self) -> pulumi.Output[Sequence['outputs.EventEvent']]:
        """
        An event to insert into Insights. Multiple event blocks can be defined. See Events below for details.
        """
        return pulumi.get(self, "events")

