# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NrqlAlertConditionArgs', 'NrqlAlertCondition']

@pulumi.input_type
class NrqlAlertConditionArgs:
    def __init__(__self__, *,
                 nrql: pulumi.Input['NrqlAlertConditionNrqlArgs'],
                 policy_id: pulumi.Input[_builtins.str],
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregation_delay: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregation_method: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregation_timer: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 baseline_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 close_violations_on_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 critical: Optional[pulumi.Input['NrqlAlertConditionCriticalArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 evaluation_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 expiration_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 fill_option: Optional[pulumi.Input[_builtins.str]] = None,
                 fill_value: Optional[pulumi.Input[_builtins.float]] = None,
                 ignore_on_expected_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 open_violation_on_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 runbook_url: Optional[pulumi.Input[_builtins.str]] = None,
                 signal_seasonality: Optional[pulumi.Input[_builtins.str]] = None,
                 slide_by: Optional[pulumi.Input[_builtins.int]] = None,
                 target_entity: Optional[pulumi.Input[_builtins.str]] = None,
                 terms: Optional[pulumi.Input[Sequence[pulumi.Input['NrqlAlertConditionTermArgs']]]] = None,
                 title_template: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_time_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_time_limit_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 warning: Optional[pulumi.Input['NrqlAlertConditionWarningArgs']] = None):
        """
        The set of arguments for constructing a NrqlAlertCondition resource.
        :param pulumi.Input['NrqlAlertConditionNrqlArgs'] nrql: A NRQL query. See NRQL below for details.
        :param pulumi.Input[_builtins.str] policy_id: The ID of the policy where this condition should be used.
        :param pulumi.Input[_builtins.str] account_id: The New Relic account ID of the account you wish to create the condition. Defaults to the account ID set in your environment variable `NEW_RELIC_ACCOUNT_ID`.
        :param pulumi.Input[_builtins.str] aggregation_delay: How long we wait for data that belongs in each aggregation window. Depending on your data, a longer delay may increase accuracy but delay notifications. Use `aggregation_delay` with the `event_flow` and `cadence` methods. The maximum delay is 1200 seconds (20 minutes) when using `event_flow` and 3600 seconds (60 minutes) when using `cadence`. In both cases, the minimum delay is 0 seconds and the default is 120 seconds. `aggregation_delay` cannot be set with `nrql.evaluation_offset`.
        :param pulumi.Input[_builtins.str] aggregation_method: Determines when we consider an aggregation window to be complete so that we can evaluate the signal for incidents. Possible values are `cadence`, `event_flow` or `event_timer`. Default is `event_flow`. `aggregation_method` cannot be set with `nrql.evaluation_offset`.
        :param pulumi.Input[_builtins.str] aggregation_timer: How long we wait after each data point arrives to make sure we've processed the whole batch. Use `aggregation_timer` with the `event_timer` method. The timer value can range from 0 seconds to 1200 seconds (20 minutes); the default is 60 seconds. `aggregation_timer` cannot be set with `nrql.evaluation_offset`.
        :param pulumi.Input[_builtins.int] aggregation_window: The duration of the time window used to evaluate the NRQL query, in seconds. The value must be at least 30 seconds, and no more than 21600 seconds (6 hours). Default is 60 seconds.
        :param pulumi.Input[_builtins.str] baseline_direction: The baseline direction of a _baseline_ NRQL alert condition. Valid values are: `lower_only`, `upper_and_lower`, `upper_only` (case insensitive).
        :param pulumi.Input[_builtins.bool] close_violations_on_expiration: Whether to close all open incidents when the signal expires.
        :param pulumi.Input['NrqlAlertConditionCriticalArgs'] critical: A list containing the `critical` threshold values. At least one `critical` or `warning` threshold must be defined. See Terms below for details.
        :param pulumi.Input[_builtins.str] description: The description of the NRQL alert condition.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable the alert condition. Valid values are `true` and `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.int] evaluation_delay: How long we wait until the signal starts evaluating. The maximum delay is 7200 seconds (120 minutes).
        :param pulumi.Input[_builtins.int] expiration_duration: The amount of time (in seconds) to wait before considering the signal expired. The value must be at least 30 seconds, and no more than 172800 seconds (48 hours).
        :param pulumi.Input[_builtins.str] fill_option: Which strategy to use when filling gaps in the signal. Possible values are `none`, `last_value` or `static`. If `static`, the `fill_value` field will be used for filling gaps in the signal.
        :param pulumi.Input[_builtins.float] fill_value: This value will be used for filling gaps in the signal.
        :param pulumi.Input[_builtins.bool] ignore_on_expected_termination: Whether an alert condition should ignore expected termination of a signal when considering whether to create a loss of signal incident. Defaults to false.
        :param pulumi.Input[_builtins.str] name: The title of the condition.
        :param pulumi.Input[_builtins.bool] open_violation_on_expiration: Whether to create a new incident to capture that the signal expired.
        :param pulumi.Input[_builtins.str] runbook_url: Runbook URL to display in notifications.
        :param pulumi.Input[_builtins.str] signal_seasonality: Seasonality under which a condition's signal(s) are evaluated. Only available for baseline conditions. Valid values are: `NEW_RELIC_CALCULATION`, `HOURLY`, `DAILY`, `WEEKLY`, or `NONE`. To have New Relic calculate seasonality automatically, set to `NEW_RELIC_CALCULATION`. To turn off seasonality completely, set to `NONE`.
        :param pulumi.Input[_builtins.int] slide_by: Gathers data in overlapping time windows to smooth the chart line, making it easier to spot trends. The `slide_by` value is specified in seconds and must be smaller than and a factor of the `aggregation_window`.
        :param pulumi.Input[_builtins.str] target_entity: BETA PREVIEW: The GUID of the entity explicitly targeted by the condition. Issues triggered by this condition will affect the health status of this entity instead of having the affected entity detected automatically. The entity's account ID must be either `account_id` or `nrql.data_account_id`.
        :param pulumi.Input[Sequence[pulumi.Input['NrqlAlertConditionTermArgs']]] terms: **DEPRECATED** Use `critical`, and `warning` instead. A list of terms for this condition. See Terms below for details.
        :param pulumi.Input[_builtins.str] title_template: The custom title to be used when incidents are opened by the condition. Setting this field will override the default title. Must be [Handlebars](https://handlebarsjs.com/) format.
        :param pulumi.Input[_builtins.str] type: The type of the condition. Valid values are `static` or `baseline`. Defaults to `static`.
        :param pulumi.Input[_builtins.str] violation_time_limit: **DEPRECATED:** Use `violation_time_limit_seconds` instead. Sets a time limit, in hours, that will automatically force-close a long-lasting incident after the time limit you select. Possible values are `ONE_HOUR`, `TWO_HOURS`, `FOUR_HOURS`, `EIGHT_HOURS`, `TWELVE_HOURS`, `TWENTY_FOUR_HOURS`, `THIRTY_DAYS` (case insensitive).<br>
               <small>\\***Note**: One of `violation_time_limit` _or_ `violation_time_limit_seconds` must be set, but not both.</small>
        :param pulumi.Input[_builtins.int] violation_time_limit_seconds: Sets a time limit, in seconds, that will automatically force-close a long-lasting incident after the time limit you select. The value must be between 300 seconds (5 minutes) to 2592000 seconds (30 days) (inclusive). <br>
               <small>\\***Note**: One of `violation_time_limit` _or_ `violation_time_limit_seconds` must be set, but not both.</small>
        :param pulumi.Input['NrqlAlertConditionWarningArgs'] warning: A list containing the `warning` threshold values. At least one `critical` or `warning` threshold must be defined. See Terms below for details.
        """
        pulumi.set(__self__, "nrql", nrql)
        pulumi.set(__self__, "policy_id", policy_id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if aggregation_delay is not None:
            pulumi.set(__self__, "aggregation_delay", aggregation_delay)
        if aggregation_method is not None:
            pulumi.set(__self__, "aggregation_method", aggregation_method)
        if aggregation_timer is not None:
            pulumi.set(__self__, "aggregation_timer", aggregation_timer)
        if aggregation_window is not None:
            pulumi.set(__self__, "aggregation_window", aggregation_window)
        if baseline_direction is not None:
            pulumi.set(__self__, "baseline_direction", baseline_direction)
        if close_violations_on_expiration is not None:
            pulumi.set(__self__, "close_violations_on_expiration", close_violations_on_expiration)
        if critical is not None:
            pulumi.set(__self__, "critical", critical)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if evaluation_delay is not None:
            pulumi.set(__self__, "evaluation_delay", evaluation_delay)
        if expiration_duration is not None:
            pulumi.set(__self__, "expiration_duration", expiration_duration)
        if fill_option is not None:
            pulumi.set(__self__, "fill_option", fill_option)
        if fill_value is not None:
            pulumi.set(__self__, "fill_value", fill_value)
        if ignore_on_expected_termination is not None:
            pulumi.set(__self__, "ignore_on_expected_termination", ignore_on_expected_termination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if open_violation_on_expiration is not None:
            pulumi.set(__self__, "open_violation_on_expiration", open_violation_on_expiration)
        if runbook_url is not None:
            pulumi.set(__self__, "runbook_url", runbook_url)
        if signal_seasonality is not None:
            pulumi.set(__self__, "signal_seasonality", signal_seasonality)
        if slide_by is not None:
            pulumi.set(__self__, "slide_by", slide_by)
        if target_entity is not None:
            pulumi.set(__self__, "target_entity", target_entity)
        if terms is not None:
            warnings.warn("""use `critical` and `warning` attributes instead""", DeprecationWarning)
            pulumi.log.warn("""terms is deprecated: use `critical` and `warning` attributes instead""")
        if terms is not None:
            pulumi.set(__self__, "terms", terms)
        if title_template is not None:
            pulumi.set(__self__, "title_template", title_template)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if violation_time_limit is not None:
            warnings.warn("""use `violation_time_limit_seconds` attribute instead""", DeprecationWarning)
            pulumi.log.warn("""violation_time_limit is deprecated: use `violation_time_limit_seconds` attribute instead""")
        if violation_time_limit is not None:
            pulumi.set(__self__, "violation_time_limit", violation_time_limit)
        if violation_time_limit_seconds is not None:
            pulumi.set(__self__, "violation_time_limit_seconds", violation_time_limit_seconds)
        if warning is not None:
            pulumi.set(__self__, "warning", warning)

    @_builtins.property
    @pulumi.getter
    def nrql(self) -> pulumi.Input['NrqlAlertConditionNrqlArgs']:
        """
        A NRQL query. See NRQL below for details.
        """
        return pulumi.get(self, "nrql")

    @nrql.setter
    def nrql(self, value: pulumi.Input['NrqlAlertConditionNrqlArgs']):
        pulumi.set(self, "nrql", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the policy where this condition should be used.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The New Relic account ID of the account you wish to create the condition. Defaults to the account ID set in your environment variable `NEW_RELIC_ACCOUNT_ID`.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="aggregationDelay")
    def aggregation_delay(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How long we wait for data that belongs in each aggregation window. Depending on your data, a longer delay may increase accuracy but delay notifications. Use `aggregation_delay` with the `event_flow` and `cadence` methods. The maximum delay is 1200 seconds (20 minutes) when using `event_flow` and 3600 seconds (60 minutes) when using `cadence`. In both cases, the minimum delay is 0 seconds and the default is 120 seconds. `aggregation_delay` cannot be set with `nrql.evaluation_offset`.
        """
        return pulumi.get(self, "aggregation_delay")

    @aggregation_delay.setter
    def aggregation_delay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aggregation_delay", value)

    @_builtins.property
    @pulumi.getter(name="aggregationMethod")
    def aggregation_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines when we consider an aggregation window to be complete so that we can evaluate the signal for incidents. Possible values are `cadence`, `event_flow` or `event_timer`. Default is `event_flow`. `aggregation_method` cannot be set with `nrql.evaluation_offset`.
        """
        return pulumi.get(self, "aggregation_method")

    @aggregation_method.setter
    def aggregation_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aggregation_method", value)

    @_builtins.property
    @pulumi.getter(name="aggregationTimer")
    def aggregation_timer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How long we wait after each data point arrives to make sure we've processed the whole batch. Use `aggregation_timer` with the `event_timer` method. The timer value can range from 0 seconds to 1200 seconds (20 minutes); the default is 60 seconds. `aggregation_timer` cannot be set with `nrql.evaluation_offset`.
        """
        return pulumi.get(self, "aggregation_timer")

    @aggregation_timer.setter
    def aggregation_timer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aggregation_timer", value)

    @_builtins.property
    @pulumi.getter(name="aggregationWindow")
    def aggregation_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration of the time window used to evaluate the NRQL query, in seconds. The value must be at least 30 seconds, and no more than 21600 seconds (6 hours). Default is 60 seconds.
        """
        return pulumi.get(self, "aggregation_window")

    @aggregation_window.setter
    def aggregation_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "aggregation_window", value)

    @_builtins.property
    @pulumi.getter(name="baselineDirection")
    def baseline_direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The baseline direction of a _baseline_ NRQL alert condition. Valid values are: `lower_only`, `upper_and_lower`, `upper_only` (case insensitive).
        """
        return pulumi.get(self, "baseline_direction")

    @baseline_direction.setter
    def baseline_direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "baseline_direction", value)

    @_builtins.property
    @pulumi.getter(name="closeViolationsOnExpiration")
    def close_violations_on_expiration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to close all open incidents when the signal expires.
        """
        return pulumi.get(self, "close_violations_on_expiration")

    @close_violations_on_expiration.setter
    def close_violations_on_expiration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "close_violations_on_expiration", value)

    @_builtins.property
    @pulumi.getter
    def critical(self) -> Optional[pulumi.Input['NrqlAlertConditionCriticalArgs']]:
        """
        A list containing the `critical` threshold values. At least one `critical` or `warning` threshold must be defined. See Terms below for details.
        """
        return pulumi.get(self, "critical")

    @critical.setter
    def critical(self, value: Optional[pulumi.Input['NrqlAlertConditionCriticalArgs']]):
        pulumi.set(self, "critical", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the NRQL alert condition.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the alert condition. Valid values are `true` and `false`. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="evaluationDelay")
    def evaluation_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long we wait until the signal starts evaluating. The maximum delay is 7200 seconds (120 minutes).
        """
        return pulumi.get(self, "evaluation_delay")

    @evaluation_delay.setter
    def evaluation_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "evaluation_delay", value)

    @_builtins.property
    @pulumi.getter(name="expirationDuration")
    def expiration_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time (in seconds) to wait before considering the signal expired. The value must be at least 30 seconds, and no more than 172800 seconds (48 hours).
        """
        return pulumi.get(self, "expiration_duration")

    @expiration_duration.setter
    def expiration_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration_duration", value)

    @_builtins.property
    @pulumi.getter(name="fillOption")
    def fill_option(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Which strategy to use when filling gaps in the signal. Possible values are `none`, `last_value` or `static`. If `static`, the `fill_value` field will be used for filling gaps in the signal.
        """
        return pulumi.get(self, "fill_option")

    @fill_option.setter
    def fill_option(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fill_option", value)

    @_builtins.property
    @pulumi.getter(name="fillValue")
    def fill_value(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        This value will be used for filling gaps in the signal.
        """
        return pulumi.get(self, "fill_value")

    @fill_value.setter
    def fill_value(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "fill_value", value)

    @_builtins.property
    @pulumi.getter(name="ignoreOnExpectedTermination")
    def ignore_on_expected_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether an alert condition should ignore expected termination of a signal when considering whether to create a loss of signal incident. Defaults to false.
        """
        return pulumi.get(self, "ignore_on_expected_termination")

    @ignore_on_expected_termination.setter
    def ignore_on_expected_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_on_expected_termination", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The title of the condition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="openViolationOnExpiration")
    def open_violation_on_expiration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create a new incident to capture that the signal expired.
        """
        return pulumi.get(self, "open_violation_on_expiration")

    @open_violation_on_expiration.setter
    def open_violation_on_expiration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "open_violation_on_expiration", value)

    @_builtins.property
    @pulumi.getter(name="runbookUrl")
    def runbook_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Runbook URL to display in notifications.
        """
        return pulumi.get(self, "runbook_url")

    @runbook_url.setter
    def runbook_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runbook_url", value)

    @_builtins.property
    @pulumi.getter(name="signalSeasonality")
    def signal_seasonality(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Seasonality under which a condition's signal(s) are evaluated. Only available for baseline conditions. Valid values are: `NEW_RELIC_CALCULATION`, `HOURLY`, `DAILY`, `WEEKLY`, or `NONE`. To have New Relic calculate seasonality automatically, set to `NEW_RELIC_CALCULATION`. To turn off seasonality completely, set to `NONE`.
        """
        return pulumi.get(self, "signal_seasonality")

    @signal_seasonality.setter
    def signal_seasonality(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signal_seasonality", value)

    @_builtins.property
    @pulumi.getter(name="slideBy")
    def slide_by(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Gathers data in overlapping time windows to smooth the chart line, making it easier to spot trends. The `slide_by` value is specified in seconds and must be smaller than and a factor of the `aggregation_window`.
        """
        return pulumi.get(self, "slide_by")

    @slide_by.setter
    def slide_by(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slide_by", value)

    @_builtins.property
    @pulumi.getter(name="targetEntity")
    def target_entity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        BETA PREVIEW: The GUID of the entity explicitly targeted by the condition. Issues triggered by this condition will affect the health status of this entity instead of having the affected entity detected automatically. The entity's account ID must be either `account_id` or `nrql.data_account_id`.
        """
        return pulumi.get(self, "target_entity")

    @target_entity.setter
    def target_entity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_entity", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""use `critical` and `warning` attributes instead""")
    def terms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NrqlAlertConditionTermArgs']]]]:
        """
        **DEPRECATED** Use `critical`, and `warning` instead. A list of terms for this condition. See Terms below for details.
        """
        return pulumi.get(self, "terms")

    @terms.setter
    def terms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NrqlAlertConditionTermArgs']]]]):
        pulumi.set(self, "terms", value)

    @_builtins.property
    @pulumi.getter(name="titleTemplate")
    def title_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The custom title to be used when incidents are opened by the condition. Setting this field will override the default title. Must be [Handlebars](https://handlebarsjs.com/) format.
        """
        return pulumi.get(self, "title_template")

    @title_template.setter
    def title_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title_template", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the condition. Valid values are `static` or `baseline`. Defaults to `static`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="violationTimeLimit")
    @_utilities.deprecated("""use `violation_time_limit_seconds` attribute instead""")
    def violation_time_limit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **DEPRECATED:** Use `violation_time_limit_seconds` instead. Sets a time limit, in hours, that will automatically force-close a long-lasting incident after the time limit you select. Possible values are `ONE_HOUR`, `TWO_HOURS`, `FOUR_HOURS`, `EIGHT_HOURS`, `TWELVE_HOURS`, `TWENTY_FOUR_HOURS`, `THIRTY_DAYS` (case insensitive).<br>
        <small>\\***Note**: One of `violation_time_limit` _or_ `violation_time_limit_seconds` must be set, but not both.</small>
        """
        return pulumi.get(self, "violation_time_limit")

    @violation_time_limit.setter
    def violation_time_limit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "violation_time_limit", value)

    @_builtins.property
    @pulumi.getter(name="violationTimeLimitSeconds")
    def violation_time_limit_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets a time limit, in seconds, that will automatically force-close a long-lasting incident after the time limit you select. The value must be between 300 seconds (5 minutes) to 2592000 seconds (30 days) (inclusive). <br>
        <small>\\***Note**: One of `violation_time_limit` _or_ `violation_time_limit_seconds` must be set, but not both.</small>
        """
        return pulumi.get(self, "violation_time_limit_seconds")

    @violation_time_limit_seconds.setter
    def violation_time_limit_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "violation_time_limit_seconds", value)

    @_builtins.property
    @pulumi.getter
    def warning(self) -> Optional[pulumi.Input['NrqlAlertConditionWarningArgs']]:
        """
        A list containing the `warning` threshold values. At least one `critical` or `warning` threshold must be defined. See Terms below for details.
        """
        return pulumi.get(self, "warning")

    @warning.setter
    def warning(self, value: Optional[pulumi.Input['NrqlAlertConditionWarningArgs']]):
        pulumi.set(self, "warning", value)


@pulumi.input_type
class _NrqlAlertConditionState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregation_delay: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregation_method: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregation_timer: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 baseline_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 close_violations_on_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 critical: Optional[pulumi.Input['NrqlAlertConditionCriticalArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 evaluation_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 expiration_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 fill_option: Optional[pulumi.Input[_builtins.str]] = None,
                 fill_value: Optional[pulumi.Input[_builtins.float]] = None,
                 ignore_on_expected_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nrql: Optional[pulumi.Input['NrqlAlertConditionNrqlArgs']] = None,
                 open_violation_on_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 runbook_url: Optional[pulumi.Input[_builtins.str]] = None,
                 signal_seasonality: Optional[pulumi.Input[_builtins.str]] = None,
                 slide_by: Optional[pulumi.Input[_builtins.int]] = None,
                 target_entity: Optional[pulumi.Input[_builtins.str]] = None,
                 terms: Optional[pulumi.Input[Sequence[pulumi.Input['NrqlAlertConditionTermArgs']]]] = None,
                 title_template: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_time_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_time_limit_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 warning: Optional[pulumi.Input['NrqlAlertConditionWarningArgs']] = None):
        """
        Input properties used for looking up and filtering NrqlAlertCondition resources.
        :param pulumi.Input[_builtins.str] account_id: The New Relic account ID of the account you wish to create the condition. Defaults to the account ID set in your environment variable `NEW_RELIC_ACCOUNT_ID`.
        :param pulumi.Input[_builtins.str] aggregation_delay: How long we wait for data that belongs in each aggregation window. Depending on your data, a longer delay may increase accuracy but delay notifications. Use `aggregation_delay` with the `event_flow` and `cadence` methods. The maximum delay is 1200 seconds (20 minutes) when using `event_flow` and 3600 seconds (60 minutes) when using `cadence`. In both cases, the minimum delay is 0 seconds and the default is 120 seconds. `aggregation_delay` cannot be set with `nrql.evaluation_offset`.
        :param pulumi.Input[_builtins.str] aggregation_method: Determines when we consider an aggregation window to be complete so that we can evaluate the signal for incidents. Possible values are `cadence`, `event_flow` or `event_timer`. Default is `event_flow`. `aggregation_method` cannot be set with `nrql.evaluation_offset`.
        :param pulumi.Input[_builtins.str] aggregation_timer: How long we wait after each data point arrives to make sure we've processed the whole batch. Use `aggregation_timer` with the `event_timer` method. The timer value can range from 0 seconds to 1200 seconds (20 minutes); the default is 60 seconds. `aggregation_timer` cannot be set with `nrql.evaluation_offset`.
        :param pulumi.Input[_builtins.int] aggregation_window: The duration of the time window used to evaluate the NRQL query, in seconds. The value must be at least 30 seconds, and no more than 21600 seconds (6 hours). Default is 60 seconds.
        :param pulumi.Input[_builtins.str] baseline_direction: The baseline direction of a _baseline_ NRQL alert condition. Valid values are: `lower_only`, `upper_and_lower`, `upper_only` (case insensitive).
        :param pulumi.Input[_builtins.bool] close_violations_on_expiration: Whether to close all open incidents when the signal expires.
        :param pulumi.Input['NrqlAlertConditionCriticalArgs'] critical: A list containing the `critical` threshold values. At least one `critical` or `warning` threshold must be defined. See Terms below for details.
        :param pulumi.Input[_builtins.str] description: The description of the NRQL alert condition.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable the alert condition. Valid values are `true` and `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] entity_guid: The unique entity identifier of the NRQL Condition in New Relic.
        :param pulumi.Input[_builtins.int] evaluation_delay: How long we wait until the signal starts evaluating. The maximum delay is 7200 seconds (120 minutes).
        :param pulumi.Input[_builtins.int] expiration_duration: The amount of time (in seconds) to wait before considering the signal expired. The value must be at least 30 seconds, and no more than 172800 seconds (48 hours).
        :param pulumi.Input[_builtins.str] fill_option: Which strategy to use when filling gaps in the signal. Possible values are `none`, `last_value` or `static`. If `static`, the `fill_value` field will be used for filling gaps in the signal.
        :param pulumi.Input[_builtins.float] fill_value: This value will be used for filling gaps in the signal.
        :param pulumi.Input[_builtins.bool] ignore_on_expected_termination: Whether an alert condition should ignore expected termination of a signal when considering whether to create a loss of signal incident. Defaults to false.
        :param pulumi.Input[_builtins.str] name: The title of the condition.
        :param pulumi.Input['NrqlAlertConditionNrqlArgs'] nrql: A NRQL query. See NRQL below for details.
        :param pulumi.Input[_builtins.bool] open_violation_on_expiration: Whether to create a new incident to capture that the signal expired.
        :param pulumi.Input[_builtins.str] policy_id: The ID of the policy where this condition should be used.
        :param pulumi.Input[_builtins.str] runbook_url: Runbook URL to display in notifications.
        :param pulumi.Input[_builtins.str] signal_seasonality: Seasonality under which a condition's signal(s) are evaluated. Only available for baseline conditions. Valid values are: `NEW_RELIC_CALCULATION`, `HOURLY`, `DAILY`, `WEEKLY`, or `NONE`. To have New Relic calculate seasonality automatically, set to `NEW_RELIC_CALCULATION`. To turn off seasonality completely, set to `NONE`.
        :param pulumi.Input[_builtins.int] slide_by: Gathers data in overlapping time windows to smooth the chart line, making it easier to spot trends. The `slide_by` value is specified in seconds and must be smaller than and a factor of the `aggregation_window`.
        :param pulumi.Input[_builtins.str] target_entity: BETA PREVIEW: The GUID of the entity explicitly targeted by the condition. Issues triggered by this condition will affect the health status of this entity instead of having the affected entity detected automatically. The entity's account ID must be either `account_id` or `nrql.data_account_id`.
        :param pulumi.Input[Sequence[pulumi.Input['NrqlAlertConditionTermArgs']]] terms: **DEPRECATED** Use `critical`, and `warning` instead. A list of terms for this condition. See Terms below for details.
        :param pulumi.Input[_builtins.str] title_template: The custom title to be used when incidents are opened by the condition. Setting this field will override the default title. Must be [Handlebars](https://handlebarsjs.com/) format.
        :param pulumi.Input[_builtins.str] type: The type of the condition. Valid values are `static` or `baseline`. Defaults to `static`.
        :param pulumi.Input[_builtins.str] violation_time_limit: **DEPRECATED:** Use `violation_time_limit_seconds` instead. Sets a time limit, in hours, that will automatically force-close a long-lasting incident after the time limit you select. Possible values are `ONE_HOUR`, `TWO_HOURS`, `FOUR_HOURS`, `EIGHT_HOURS`, `TWELVE_HOURS`, `TWENTY_FOUR_HOURS`, `THIRTY_DAYS` (case insensitive).<br>
               <small>\\***Note**: One of `violation_time_limit` _or_ `violation_time_limit_seconds` must be set, but not both.</small>
        :param pulumi.Input[_builtins.int] violation_time_limit_seconds: Sets a time limit, in seconds, that will automatically force-close a long-lasting incident after the time limit you select. The value must be between 300 seconds (5 minutes) to 2592000 seconds (30 days) (inclusive). <br>
               <small>\\***Note**: One of `violation_time_limit` _or_ `violation_time_limit_seconds` must be set, but not both.</small>
        :param pulumi.Input['NrqlAlertConditionWarningArgs'] warning: A list containing the `warning` threshold values. At least one `critical` or `warning` threshold must be defined. See Terms below for details.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if aggregation_delay is not None:
            pulumi.set(__self__, "aggregation_delay", aggregation_delay)
        if aggregation_method is not None:
            pulumi.set(__self__, "aggregation_method", aggregation_method)
        if aggregation_timer is not None:
            pulumi.set(__self__, "aggregation_timer", aggregation_timer)
        if aggregation_window is not None:
            pulumi.set(__self__, "aggregation_window", aggregation_window)
        if baseline_direction is not None:
            pulumi.set(__self__, "baseline_direction", baseline_direction)
        if close_violations_on_expiration is not None:
            pulumi.set(__self__, "close_violations_on_expiration", close_violations_on_expiration)
        if critical is not None:
            pulumi.set(__self__, "critical", critical)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if entity_guid is not None:
            pulumi.set(__self__, "entity_guid", entity_guid)
        if evaluation_delay is not None:
            pulumi.set(__self__, "evaluation_delay", evaluation_delay)
        if expiration_duration is not None:
            pulumi.set(__self__, "expiration_duration", expiration_duration)
        if fill_option is not None:
            pulumi.set(__self__, "fill_option", fill_option)
        if fill_value is not None:
            pulumi.set(__self__, "fill_value", fill_value)
        if ignore_on_expected_termination is not None:
            pulumi.set(__self__, "ignore_on_expected_termination", ignore_on_expected_termination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nrql is not None:
            pulumi.set(__self__, "nrql", nrql)
        if open_violation_on_expiration is not None:
            pulumi.set(__self__, "open_violation_on_expiration", open_violation_on_expiration)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if runbook_url is not None:
            pulumi.set(__self__, "runbook_url", runbook_url)
        if signal_seasonality is not None:
            pulumi.set(__self__, "signal_seasonality", signal_seasonality)
        if slide_by is not None:
            pulumi.set(__self__, "slide_by", slide_by)
        if target_entity is not None:
            pulumi.set(__self__, "target_entity", target_entity)
        if terms is not None:
            warnings.warn("""use `critical` and `warning` attributes instead""", DeprecationWarning)
            pulumi.log.warn("""terms is deprecated: use `critical` and `warning` attributes instead""")
        if terms is not None:
            pulumi.set(__self__, "terms", terms)
        if title_template is not None:
            pulumi.set(__self__, "title_template", title_template)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if violation_time_limit is not None:
            warnings.warn("""use `violation_time_limit_seconds` attribute instead""", DeprecationWarning)
            pulumi.log.warn("""violation_time_limit is deprecated: use `violation_time_limit_seconds` attribute instead""")
        if violation_time_limit is not None:
            pulumi.set(__self__, "violation_time_limit", violation_time_limit)
        if violation_time_limit_seconds is not None:
            pulumi.set(__self__, "violation_time_limit_seconds", violation_time_limit_seconds)
        if warning is not None:
            pulumi.set(__self__, "warning", warning)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The New Relic account ID of the account you wish to create the condition. Defaults to the account ID set in your environment variable `NEW_RELIC_ACCOUNT_ID`.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="aggregationDelay")
    def aggregation_delay(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How long we wait for data that belongs in each aggregation window. Depending on your data, a longer delay may increase accuracy but delay notifications. Use `aggregation_delay` with the `event_flow` and `cadence` methods. The maximum delay is 1200 seconds (20 minutes) when using `event_flow` and 3600 seconds (60 minutes) when using `cadence`. In both cases, the minimum delay is 0 seconds and the default is 120 seconds. `aggregation_delay` cannot be set with `nrql.evaluation_offset`.
        """
        return pulumi.get(self, "aggregation_delay")

    @aggregation_delay.setter
    def aggregation_delay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aggregation_delay", value)

    @_builtins.property
    @pulumi.getter(name="aggregationMethod")
    def aggregation_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines when we consider an aggregation window to be complete so that we can evaluate the signal for incidents. Possible values are `cadence`, `event_flow` or `event_timer`. Default is `event_flow`. `aggregation_method` cannot be set with `nrql.evaluation_offset`.
        """
        return pulumi.get(self, "aggregation_method")

    @aggregation_method.setter
    def aggregation_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aggregation_method", value)

    @_builtins.property
    @pulumi.getter(name="aggregationTimer")
    def aggregation_timer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How long we wait after each data point arrives to make sure we've processed the whole batch. Use `aggregation_timer` with the `event_timer` method. The timer value can range from 0 seconds to 1200 seconds (20 minutes); the default is 60 seconds. `aggregation_timer` cannot be set with `nrql.evaluation_offset`.
        """
        return pulumi.get(self, "aggregation_timer")

    @aggregation_timer.setter
    def aggregation_timer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aggregation_timer", value)

    @_builtins.property
    @pulumi.getter(name="aggregationWindow")
    def aggregation_window(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration of the time window used to evaluate the NRQL query, in seconds. The value must be at least 30 seconds, and no more than 21600 seconds (6 hours). Default is 60 seconds.
        """
        return pulumi.get(self, "aggregation_window")

    @aggregation_window.setter
    def aggregation_window(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "aggregation_window", value)

    @_builtins.property
    @pulumi.getter(name="baselineDirection")
    def baseline_direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The baseline direction of a _baseline_ NRQL alert condition. Valid values are: `lower_only`, `upper_and_lower`, `upper_only` (case insensitive).
        """
        return pulumi.get(self, "baseline_direction")

    @baseline_direction.setter
    def baseline_direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "baseline_direction", value)

    @_builtins.property
    @pulumi.getter(name="closeViolationsOnExpiration")
    def close_violations_on_expiration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to close all open incidents when the signal expires.
        """
        return pulumi.get(self, "close_violations_on_expiration")

    @close_violations_on_expiration.setter
    def close_violations_on_expiration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "close_violations_on_expiration", value)

    @_builtins.property
    @pulumi.getter
    def critical(self) -> Optional[pulumi.Input['NrqlAlertConditionCriticalArgs']]:
        """
        A list containing the `critical` threshold values. At least one `critical` or `warning` threshold must be defined. See Terms below for details.
        """
        return pulumi.get(self, "critical")

    @critical.setter
    def critical(self, value: Optional[pulumi.Input['NrqlAlertConditionCriticalArgs']]):
        pulumi.set(self, "critical", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the NRQL alert condition.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the alert condition. Valid values are `true` and `false`. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="entityGuid")
    def entity_guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique entity identifier of the NRQL Condition in New Relic.
        """
        return pulumi.get(self, "entity_guid")

    @entity_guid.setter
    def entity_guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_guid", value)

    @_builtins.property
    @pulumi.getter(name="evaluationDelay")
    def evaluation_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long we wait until the signal starts evaluating. The maximum delay is 7200 seconds (120 minutes).
        """
        return pulumi.get(self, "evaluation_delay")

    @evaluation_delay.setter
    def evaluation_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "evaluation_delay", value)

    @_builtins.property
    @pulumi.getter(name="expirationDuration")
    def expiration_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time (in seconds) to wait before considering the signal expired. The value must be at least 30 seconds, and no more than 172800 seconds (48 hours).
        """
        return pulumi.get(self, "expiration_duration")

    @expiration_duration.setter
    def expiration_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration_duration", value)

    @_builtins.property
    @pulumi.getter(name="fillOption")
    def fill_option(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Which strategy to use when filling gaps in the signal. Possible values are `none`, `last_value` or `static`. If `static`, the `fill_value` field will be used for filling gaps in the signal.
        """
        return pulumi.get(self, "fill_option")

    @fill_option.setter
    def fill_option(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fill_option", value)

    @_builtins.property
    @pulumi.getter(name="fillValue")
    def fill_value(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        This value will be used for filling gaps in the signal.
        """
        return pulumi.get(self, "fill_value")

    @fill_value.setter
    def fill_value(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "fill_value", value)

    @_builtins.property
    @pulumi.getter(name="ignoreOnExpectedTermination")
    def ignore_on_expected_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether an alert condition should ignore expected termination of a signal when considering whether to create a loss of signal incident. Defaults to false.
        """
        return pulumi.get(self, "ignore_on_expected_termination")

    @ignore_on_expected_termination.setter
    def ignore_on_expected_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_on_expected_termination", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The title of the condition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def nrql(self) -> Optional[pulumi.Input['NrqlAlertConditionNrqlArgs']]:
        """
        A NRQL query. See NRQL below for details.
        """
        return pulumi.get(self, "nrql")

    @nrql.setter
    def nrql(self, value: Optional[pulumi.Input['NrqlAlertConditionNrqlArgs']]):
        pulumi.set(self, "nrql", value)

    @_builtins.property
    @pulumi.getter(name="openViolationOnExpiration")
    def open_violation_on_expiration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create a new incident to capture that the signal expired.
        """
        return pulumi.get(self, "open_violation_on_expiration")

    @open_violation_on_expiration.setter
    def open_violation_on_expiration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "open_violation_on_expiration", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the policy where this condition should be used.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter(name="runbookUrl")
    def runbook_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Runbook URL to display in notifications.
        """
        return pulumi.get(self, "runbook_url")

    @runbook_url.setter
    def runbook_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runbook_url", value)

    @_builtins.property
    @pulumi.getter(name="signalSeasonality")
    def signal_seasonality(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Seasonality under which a condition's signal(s) are evaluated. Only available for baseline conditions. Valid values are: `NEW_RELIC_CALCULATION`, `HOURLY`, `DAILY`, `WEEKLY`, or `NONE`. To have New Relic calculate seasonality automatically, set to `NEW_RELIC_CALCULATION`. To turn off seasonality completely, set to `NONE`.
        """
        return pulumi.get(self, "signal_seasonality")

    @signal_seasonality.setter
    def signal_seasonality(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signal_seasonality", value)

    @_builtins.property
    @pulumi.getter(name="slideBy")
    def slide_by(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Gathers data in overlapping time windows to smooth the chart line, making it easier to spot trends. The `slide_by` value is specified in seconds and must be smaller than and a factor of the `aggregation_window`.
        """
        return pulumi.get(self, "slide_by")

    @slide_by.setter
    def slide_by(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slide_by", value)

    @_builtins.property
    @pulumi.getter(name="targetEntity")
    def target_entity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        BETA PREVIEW: The GUID of the entity explicitly targeted by the condition. Issues triggered by this condition will affect the health status of this entity instead of having the affected entity detected automatically. The entity's account ID must be either `account_id` or `nrql.data_account_id`.
        """
        return pulumi.get(self, "target_entity")

    @target_entity.setter
    def target_entity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_entity", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""use `critical` and `warning` attributes instead""")
    def terms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NrqlAlertConditionTermArgs']]]]:
        """
        **DEPRECATED** Use `critical`, and `warning` instead. A list of terms for this condition. See Terms below for details.
        """
        return pulumi.get(self, "terms")

    @terms.setter
    def terms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NrqlAlertConditionTermArgs']]]]):
        pulumi.set(self, "terms", value)

    @_builtins.property
    @pulumi.getter(name="titleTemplate")
    def title_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The custom title to be used when incidents are opened by the condition. Setting this field will override the default title. Must be [Handlebars](https://handlebarsjs.com/) format.
        """
        return pulumi.get(self, "title_template")

    @title_template.setter
    def title_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title_template", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the condition. Valid values are `static` or `baseline`. Defaults to `static`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="violationTimeLimit")
    @_utilities.deprecated("""use `violation_time_limit_seconds` attribute instead""")
    def violation_time_limit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        **DEPRECATED:** Use `violation_time_limit_seconds` instead. Sets a time limit, in hours, that will automatically force-close a long-lasting incident after the time limit you select. Possible values are `ONE_HOUR`, `TWO_HOURS`, `FOUR_HOURS`, `EIGHT_HOURS`, `TWELVE_HOURS`, `TWENTY_FOUR_HOURS`, `THIRTY_DAYS` (case insensitive).<br>
        <small>\\***Note**: One of `violation_time_limit` _or_ `violation_time_limit_seconds` must be set, but not both.</small>
        """
        return pulumi.get(self, "violation_time_limit")

    @violation_time_limit.setter
    def violation_time_limit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "violation_time_limit", value)

    @_builtins.property
    @pulumi.getter(name="violationTimeLimitSeconds")
    def violation_time_limit_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets a time limit, in seconds, that will automatically force-close a long-lasting incident after the time limit you select. The value must be between 300 seconds (5 minutes) to 2592000 seconds (30 days) (inclusive). <br>
        <small>\\***Note**: One of `violation_time_limit` _or_ `violation_time_limit_seconds` must be set, but not both.</small>
        """
        return pulumi.get(self, "violation_time_limit_seconds")

    @violation_time_limit_seconds.setter
    def violation_time_limit_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "violation_time_limit_seconds", value)

    @_builtins.property
    @pulumi.getter
    def warning(self) -> Optional[pulumi.Input['NrqlAlertConditionWarningArgs']]:
        """
        A list containing the `warning` threshold values. At least one `critical` or `warning` threshold must be defined. See Terms below for details.
        """
        return pulumi.get(self, "warning")

    @warning.setter
    def warning(self, value: Optional[pulumi.Input['NrqlAlertConditionWarningArgs']]):
        pulumi.set(self, "warning", value)


@pulumi.type_token("newrelic:index/nrqlAlertCondition:NrqlAlertCondition")
class NrqlAlertCondition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregation_delay: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregation_method: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregation_timer: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 baseline_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 close_violations_on_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 critical: Optional[pulumi.Input[Union['NrqlAlertConditionCriticalArgs', 'NrqlAlertConditionCriticalArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 evaluation_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 expiration_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 fill_option: Optional[pulumi.Input[_builtins.str]] = None,
                 fill_value: Optional[pulumi.Input[_builtins.float]] = None,
                 ignore_on_expected_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nrql: Optional[pulumi.Input[Union['NrqlAlertConditionNrqlArgs', 'NrqlAlertConditionNrqlArgsDict']]] = None,
                 open_violation_on_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 runbook_url: Optional[pulumi.Input[_builtins.str]] = None,
                 signal_seasonality: Optional[pulumi.Input[_builtins.str]] = None,
                 slide_by: Optional[pulumi.Input[_builtins.int]] = None,
                 target_entity: Optional[pulumi.Input[_builtins.str]] = None,
                 terms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NrqlAlertConditionTermArgs', 'NrqlAlertConditionTermArgsDict']]]]] = None,
                 title_template: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_time_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_time_limit_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 warning: Optional[pulumi.Input[Union['NrqlAlertConditionWarningArgs', 'NrqlAlertConditionWarningArgsDict']]] = None,
                 __props__=None):
        """
        Use this resource to create and manage NRQL alert conditions in New Relic.

        ## Example Usage

        ### Type: `static` (default)

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.AlertPolicy("foo", name="foo")
        foo_nrql_alert_condition = newrelic.NrqlAlertCondition("foo",
            account_id="12345678",
            policy_id=foo.id,
            type="static",
            name="foo",
            description="Alert when transactions are taking too long",
            title_template="Issue in environment: {{ tags.environment }}",
            target_entity="MXxBUE18QVBQTElDQVRJT058MQ",
            runbook_url="https://www.example.com",
            enabled=True,
            violation_time_limit_seconds=3600,
            fill_option="static",
            fill_value=1,
            aggregation_window=60,
            aggregation_method="event_flow",
            aggregation_delay="120",
            expiration_duration=120,
            open_violation_on_expiration=True,
            close_violations_on_expiration=True,
            ignore_on_expected_termination=True,
            slide_by=30,
            nrql={
                "query": "SELECT average(duration) FROM Transaction where appName = 'Your App'",
            },
            critical={
                "operator": "above",
                "threshold": 5.5,
                "threshold_duration": 300,
                "threshold_occurrences": "ALL",
            },
            warning={
                "operator": "above",
                "threshold": 3.5,
                "threshold_duration": 600,
                "threshold_occurrences": "ALL",
            })
        ```

        ## NRQL

        The `nrql` block supports the following arguments:

        - `query` - (Required) The NRQL query to execute for the condition.
        - `data_account_id` - (Optional) The account ID to use for the alert condition's query as specified in the the `query` field. If `data_account_id` is not specified, then the condition's query will be evaluated against the `account_id`. Note that the `account_id` must have read privileges for the `data_account_id` or else the condition will be invalid.
        - `evaluation_offset` - (Optional) **DEPRECATED:** Use `aggregation_method` instead. Represented in minutes and must be within 1-20 minutes (inclusive). NRQL queries are evaluated based on their `aggregation_window` size. The start time depends on this value. It's recommended to set this to 3 windows. An offset of less than 3 windows will trigger incidents sooner, but you may see more false positives and negatives due to data latency. With `evaluation_offset` set to 3 windows and an `aggregation_window` of 60 seconds, the NRQL time window applied to your query will be: `SINCE 3 minutes ago UNTIL 2 minutes ago`. `evaluation_offset` cannot be set with `aggregation_method`, `aggregation_delay`, or `aggregation_timer`.<br>
        - `since_value` - (Optional)  **DEPRECATED:** Use `aggregation_method` instead. The value to be used in the `SINCE <X> minutes ago` clause for the NRQL query. Must be between 1-20 (inclusive). <br>

        ## Terms

        > **NOTE:** The direct use of the `term` has been deprecated, and users should use `critical` and `warning` instead.  What follows now applies to the named priority attributes for `critical` and `warning`, but for those attributes the priority is not allowed. At least one `critical` or `warning` term must be defined.

        NRQL alert conditions support up to two terms. At least one `term` must have `priority` set to `critical` and the second optional `term` must have `priority` set to `warning`.

        The `term` block supports the following arguments:

        - `operator` - (Optional) Valid values are `above`, `above_or_equals`, `below`, `below_or_equals`, `equals`, or `not_equals` (case insensitive). Defaults to `equals`. Note that when using a `type` of `baseline`, the only valid option here is `above`.
        - `priority` - (Optional) `critical` or `warning`. Defaults to `critical`.
        - `threshold` - (Required) The value which will trigger an incident.
        <br>For _baseline_ NRQL alert conditions, the value must be in the range [1, 1000]. The value is the number of standard deviations from the baseline that the metric must exceed in order to create an incident.
        - `threshold_duration` - (Optional) The duration, in seconds, that the threshold must violate in order to create an incident. Value must be a multiple of the `aggregation_window` (which has a default of 60 seconds).
        <br>For _baseline_ NRQL alert conditions, the value must be within 120-86400 seconds (inclusive).
        <br>For _static_ NRQL alert conditions, the value must be within 60-86400 seconds (inclusive).

        - `threshold_occurrences` - (Optional) The criteria for how many data points must be in violation for the specified threshold duration. Valid values are: `all` or `at_least_once` (case insensitive).
        - `duration` - (Optional) **DEPRECATED:** Use `threshold_duration` instead. The duration of time, in _minutes_, that the threshold must violate for in order to create an incident. Must be within 1-120 (inclusive).
        - `time_function` - (Optional) **DEPRECATED:** Use `threshold_occurrences` instead. The criteria for how many data points must be in violation for the specified threshold duration. Valid values are: `all` or `any`.
        - `prediction` - (Optional) **BETA PREVIEW: the `prediction` field is in limited release and only enabled for preview on a per-account basis.** Use `prediction` to open alerts when your static threshold is predicted to be reached in the future. The `prediction` field is only available for _static_ NRQL alert conditions. See Prediction below for details.
        - `disable_health_status_reporting` - (Optional) `true` or `false`. Defaults to `false` when field not included in TF config. Violations will not change system health status for this term.

        > **NOTE:** When a `critical` or `warning` block is added to this resource, using either `duration` or `threshold_duration` (one of the two) is mandatory. Both of these should not be specified.

        > **NOTE:** When a `critical` or `warning` block is added to this resource, using either `time_function` or `threshold_occurrences` (one of the two) is mandatory. Both of these should not be specified.

        ### Prediction

        > **BETA PREVIEW:** The `prediction` block is in limited release and only enabled for preview on a per-account basis.

        > **NOTE:** The `prediction` block is only available for _static_ NRQL alert conditions.

        The `prediction` block supports the following arguments:

        - `predict_by` - (Optional) The duration, in seconds, that the prediction should look into the future. Default is 3600 seconds (1 hour).
        - `prefer_prediction_violation` - (Optional) If a prediction incident is open when a term's static threshold is breached by the actual signal, default behavior is to close the prediction incident and open a static incident. Setting `prefer_prediction_violation` to `true` overrides this behavior leaving the prediction incident open and preventing a static incident from opening. Default is false.

        ## Additional Examples

        ##### Type: `baseline`

        [Baseline NRQL alert conditions](https://docs.newrelic.com/docs/alerts/new-relic-alerts/defining-conditions/create-baseline-alert-conditions) are dynamic in nature and adjust to the behavior of your data. The example below demonstrates a baseline NRQL alert condition for alerting when transaction durations are above a specified threshold and dynamically adjusts based on data trends.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.AlertPolicy("foo", name="foo")
        foo_nrql_alert_condition = newrelic.NrqlAlertCondition("foo",
            account_id="your_account_id",
            policy_id=foo.id,
            type="static",
            name="foo",
            description="Alert when transactions are taking too long",
            runbook_url="https://www.example.com",
            enabled=True,
            violation_time_limit_seconds=3600,
            fill_option="static",
            fill_value=1,
            aggregation_window=60,
            aggregation_method="event_flow",
            aggregation_delay="120",
            expiration_duration=120,
            open_violation_on_expiration=True,
            close_violations_on_expiration=True,
            slide_by=30,
            nrql={
                "query": "SELECT average(duration) FROM Transaction where appName = 'Your App'",
            },
            critical={
                "operator": "above",
                "threshold": 5.5,
                "threshold_duration": 300,
                "threshold_occurrences": "ALL",
            },
            warning={
                "operator": "above",
                "threshold": 3.5,
                "threshold_duration": 600,
                "threshold_occurrences": "ALL",
            })
        ```

        ## Tags

        Manage NRQL alert condition tags with `EntityTags`. For up-to-date documentation about the tagging resource, please check `EntityTags`.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.AlertPolicy("foo", name="foo")
        foo_nrql_alert_condition = newrelic.NrqlAlertCondition("foo",
            account_id="12345678",
            policy_id=foo.id,
            type="static",
            name="foo",
            description="Alert when transactions are taking too long",
            runbook_url="https://www.example.com",
            enabled=True,
            violation_time_limit_seconds=3600,
            fill_option="static",
            fill_value=1,
            aggregation_window=60,
            aggregation_method="event_flow",
            aggregation_delay="120",
            expiration_duration=120,
            open_violation_on_expiration=True,
            close_violations_on_expiration=True,
            slide_by=30,
            nrql={
                "query": "SELECT average(duration) FROM Transaction where appName = 'Your App'",
            },
            critical={
                "operator": "above",
                "threshold": 5.5,
                "threshold_duration": 300,
                "threshold_occurrences": "ALL",
            },
            warning={
                "operator": "above",
                "threshold": 3.5,
                "threshold_duration": 600,
                "threshold_occurrences": "ALL",
            })
        my_condition_entity_tags = newrelic.EntityTags("my_condition_entity_tags",
            guid=foo_nrql_alert_condition.entity_guid,
            tags=[
                {
                    "key": "my-key",
                    "values": [
                        "my-value",
                        "my-other-value",
                    ],
                },
                {
                    "key": "my-key-2",
                    "values": ["my-value-2"],
                },
            ])
        ```

        <small>alerts.newrelic.com/accounts/**\\<account_id\\>**/policies/**\\<policy_id\\>**/conditions/**\\<condition_id\\>**/edit</small>

        ## Upgrade from 1.x to 2.x

        There have been several deprecations in the `NrqlAlertCondition`
        resource. Users will need to make some updates in order to have a smooth
        upgrade.

        An example resource from 1.x might look like the following.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        z = newrelic.NrqlAlertCondition("z",
            policy_id=z_newrelic_alert_policy["id"],
            name="zleslie-test",
            type="static",
            runbook_url="https://localhost",
            enabled=True,
            violation_time_limit="TWENTY_FOUR_HOURS",
            critical={
                "operator": "above",
                "threshold_duration": 120,
                "threshold": 3,
                "threshold_occurrences": "AT_LEAST_ONCE",
            },
            nrql={
                "query": "SELECT count(*) FROM TransactionError WHERE appName like '%Dummy App%' FACET appName",
            })
        ```

        After making the appropriate adjustments mentioned in the deprecation warnings,
        the resource now looks like the following.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        z = newrelic.NrqlAlertCondition("z",
            policy_id=z_newrelic_alert_policy["id"],
            name="zleslie-test",
            type="static",
            runbook_url="https://localhost",
            enabled=True,
            violation_time_limit_seconds=86400,
            terms=[{
                "priority": "critical",
                "operator": "above",
                "threshold": 3,
                "duration": 5,
                "time_function": "any",
            }],
            nrql={
                "query": "SELECT count(*) FROM TransactionError WHERE appName like '%Dummy App%' FACET appName",
            })
        ```

        ## Import

        NRQL alert conditions can be imported using a composite ID of `<policy_id>:<condition_id>:<conditionType>`, e.g.

        // For `baseline` conditions

        ```sh
        $ pulumi import newrelic:index/nrqlAlertCondition:NrqlAlertCondition foo 538291:6789035:baseline
        ```

        // For `static` conditions

        ```sh
        $ pulumi import newrelic:index/nrqlAlertCondition:NrqlAlertCondition foo 538291:6789035:static
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The New Relic account ID of the account you wish to create the condition. Defaults to the account ID set in your environment variable `NEW_RELIC_ACCOUNT_ID`.
        :param pulumi.Input[_builtins.str] aggregation_delay: How long we wait for data that belongs in each aggregation window. Depending on your data, a longer delay may increase accuracy but delay notifications. Use `aggregation_delay` with the `event_flow` and `cadence` methods. The maximum delay is 1200 seconds (20 minutes) when using `event_flow` and 3600 seconds (60 minutes) when using `cadence`. In both cases, the minimum delay is 0 seconds and the default is 120 seconds. `aggregation_delay` cannot be set with `nrql.evaluation_offset`.
        :param pulumi.Input[_builtins.str] aggregation_method: Determines when we consider an aggregation window to be complete so that we can evaluate the signal for incidents. Possible values are `cadence`, `event_flow` or `event_timer`. Default is `event_flow`. `aggregation_method` cannot be set with `nrql.evaluation_offset`.
        :param pulumi.Input[_builtins.str] aggregation_timer: How long we wait after each data point arrives to make sure we've processed the whole batch. Use `aggregation_timer` with the `event_timer` method. The timer value can range from 0 seconds to 1200 seconds (20 minutes); the default is 60 seconds. `aggregation_timer` cannot be set with `nrql.evaluation_offset`.
        :param pulumi.Input[_builtins.int] aggregation_window: The duration of the time window used to evaluate the NRQL query, in seconds. The value must be at least 30 seconds, and no more than 21600 seconds (6 hours). Default is 60 seconds.
        :param pulumi.Input[_builtins.str] baseline_direction: The baseline direction of a _baseline_ NRQL alert condition. Valid values are: `lower_only`, `upper_and_lower`, `upper_only` (case insensitive).
        :param pulumi.Input[_builtins.bool] close_violations_on_expiration: Whether to close all open incidents when the signal expires.
        :param pulumi.Input[Union['NrqlAlertConditionCriticalArgs', 'NrqlAlertConditionCriticalArgsDict']] critical: A list containing the `critical` threshold values. At least one `critical` or `warning` threshold must be defined. See Terms below for details.
        :param pulumi.Input[_builtins.str] description: The description of the NRQL alert condition.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable the alert condition. Valid values are `true` and `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.int] evaluation_delay: How long we wait until the signal starts evaluating. The maximum delay is 7200 seconds (120 minutes).
        :param pulumi.Input[_builtins.int] expiration_duration: The amount of time (in seconds) to wait before considering the signal expired. The value must be at least 30 seconds, and no more than 172800 seconds (48 hours).
        :param pulumi.Input[_builtins.str] fill_option: Which strategy to use when filling gaps in the signal. Possible values are `none`, `last_value` or `static`. If `static`, the `fill_value` field will be used for filling gaps in the signal.
        :param pulumi.Input[_builtins.float] fill_value: This value will be used for filling gaps in the signal.
        :param pulumi.Input[_builtins.bool] ignore_on_expected_termination: Whether an alert condition should ignore expected termination of a signal when considering whether to create a loss of signal incident. Defaults to false.
        :param pulumi.Input[_builtins.str] name: The title of the condition.
        :param pulumi.Input[Union['NrqlAlertConditionNrqlArgs', 'NrqlAlertConditionNrqlArgsDict']] nrql: A NRQL query. See NRQL below for details.
        :param pulumi.Input[_builtins.bool] open_violation_on_expiration: Whether to create a new incident to capture that the signal expired.
        :param pulumi.Input[_builtins.str] policy_id: The ID of the policy where this condition should be used.
        :param pulumi.Input[_builtins.str] runbook_url: Runbook URL to display in notifications.
        :param pulumi.Input[_builtins.str] signal_seasonality: Seasonality under which a condition's signal(s) are evaluated. Only available for baseline conditions. Valid values are: `NEW_RELIC_CALCULATION`, `HOURLY`, `DAILY`, `WEEKLY`, or `NONE`. To have New Relic calculate seasonality automatically, set to `NEW_RELIC_CALCULATION`. To turn off seasonality completely, set to `NONE`.
        :param pulumi.Input[_builtins.int] slide_by: Gathers data in overlapping time windows to smooth the chart line, making it easier to spot trends. The `slide_by` value is specified in seconds and must be smaller than and a factor of the `aggregation_window`.
        :param pulumi.Input[_builtins.str] target_entity: BETA PREVIEW: The GUID of the entity explicitly targeted by the condition. Issues triggered by this condition will affect the health status of this entity instead of having the affected entity detected automatically. The entity's account ID must be either `account_id` or `nrql.data_account_id`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NrqlAlertConditionTermArgs', 'NrqlAlertConditionTermArgsDict']]]] terms: **DEPRECATED** Use `critical`, and `warning` instead. A list of terms for this condition. See Terms below for details.
        :param pulumi.Input[_builtins.str] title_template: The custom title to be used when incidents are opened by the condition. Setting this field will override the default title. Must be [Handlebars](https://handlebarsjs.com/) format.
        :param pulumi.Input[_builtins.str] type: The type of the condition. Valid values are `static` or `baseline`. Defaults to `static`.
        :param pulumi.Input[_builtins.str] violation_time_limit: **DEPRECATED:** Use `violation_time_limit_seconds` instead. Sets a time limit, in hours, that will automatically force-close a long-lasting incident after the time limit you select. Possible values are `ONE_HOUR`, `TWO_HOURS`, `FOUR_HOURS`, `EIGHT_HOURS`, `TWELVE_HOURS`, `TWENTY_FOUR_HOURS`, `THIRTY_DAYS` (case insensitive).<br>
               <small>\\***Note**: One of `violation_time_limit` _or_ `violation_time_limit_seconds` must be set, but not both.</small>
        :param pulumi.Input[_builtins.int] violation_time_limit_seconds: Sets a time limit, in seconds, that will automatically force-close a long-lasting incident after the time limit you select. The value must be between 300 seconds (5 minutes) to 2592000 seconds (30 days) (inclusive). <br>
               <small>\\***Note**: One of `violation_time_limit` _or_ `violation_time_limit_seconds` must be set, but not both.</small>
        :param pulumi.Input[Union['NrqlAlertConditionWarningArgs', 'NrqlAlertConditionWarningArgsDict']] warning: A list containing the `warning` threshold values. At least one `critical` or `warning` threshold must be defined. See Terms below for details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NrqlAlertConditionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to create and manage NRQL alert conditions in New Relic.

        ## Example Usage

        ### Type: `static` (default)

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.AlertPolicy("foo", name="foo")
        foo_nrql_alert_condition = newrelic.NrqlAlertCondition("foo",
            account_id="12345678",
            policy_id=foo.id,
            type="static",
            name="foo",
            description="Alert when transactions are taking too long",
            title_template="Issue in environment: {{ tags.environment }}",
            target_entity="MXxBUE18QVBQTElDQVRJT058MQ",
            runbook_url="https://www.example.com",
            enabled=True,
            violation_time_limit_seconds=3600,
            fill_option="static",
            fill_value=1,
            aggregation_window=60,
            aggregation_method="event_flow",
            aggregation_delay="120",
            expiration_duration=120,
            open_violation_on_expiration=True,
            close_violations_on_expiration=True,
            ignore_on_expected_termination=True,
            slide_by=30,
            nrql={
                "query": "SELECT average(duration) FROM Transaction where appName = 'Your App'",
            },
            critical={
                "operator": "above",
                "threshold": 5.5,
                "threshold_duration": 300,
                "threshold_occurrences": "ALL",
            },
            warning={
                "operator": "above",
                "threshold": 3.5,
                "threshold_duration": 600,
                "threshold_occurrences": "ALL",
            })
        ```

        ## NRQL

        The `nrql` block supports the following arguments:

        - `query` - (Required) The NRQL query to execute for the condition.
        - `data_account_id` - (Optional) The account ID to use for the alert condition's query as specified in the the `query` field. If `data_account_id` is not specified, then the condition's query will be evaluated against the `account_id`. Note that the `account_id` must have read privileges for the `data_account_id` or else the condition will be invalid.
        - `evaluation_offset` - (Optional) **DEPRECATED:** Use `aggregation_method` instead. Represented in minutes and must be within 1-20 minutes (inclusive). NRQL queries are evaluated based on their `aggregation_window` size. The start time depends on this value. It's recommended to set this to 3 windows. An offset of less than 3 windows will trigger incidents sooner, but you may see more false positives and negatives due to data latency. With `evaluation_offset` set to 3 windows and an `aggregation_window` of 60 seconds, the NRQL time window applied to your query will be: `SINCE 3 minutes ago UNTIL 2 minutes ago`. `evaluation_offset` cannot be set with `aggregation_method`, `aggregation_delay`, or `aggregation_timer`.<br>
        - `since_value` - (Optional)  **DEPRECATED:** Use `aggregation_method` instead. The value to be used in the `SINCE <X> minutes ago` clause for the NRQL query. Must be between 1-20 (inclusive). <br>

        ## Terms

        > **NOTE:** The direct use of the `term` has been deprecated, and users should use `critical` and `warning` instead.  What follows now applies to the named priority attributes for `critical` and `warning`, but for those attributes the priority is not allowed. At least one `critical` or `warning` term must be defined.

        NRQL alert conditions support up to two terms. At least one `term` must have `priority` set to `critical` and the second optional `term` must have `priority` set to `warning`.

        The `term` block supports the following arguments:

        - `operator` - (Optional) Valid values are `above`, `above_or_equals`, `below`, `below_or_equals`, `equals`, or `not_equals` (case insensitive). Defaults to `equals`. Note that when using a `type` of `baseline`, the only valid option here is `above`.
        - `priority` - (Optional) `critical` or `warning`. Defaults to `critical`.
        - `threshold` - (Required) The value which will trigger an incident.
        <br>For _baseline_ NRQL alert conditions, the value must be in the range [1, 1000]. The value is the number of standard deviations from the baseline that the metric must exceed in order to create an incident.
        - `threshold_duration` - (Optional) The duration, in seconds, that the threshold must violate in order to create an incident. Value must be a multiple of the `aggregation_window` (which has a default of 60 seconds).
        <br>For _baseline_ NRQL alert conditions, the value must be within 120-86400 seconds (inclusive).
        <br>For _static_ NRQL alert conditions, the value must be within 60-86400 seconds (inclusive).

        - `threshold_occurrences` - (Optional) The criteria for how many data points must be in violation for the specified threshold duration. Valid values are: `all` or `at_least_once` (case insensitive).
        - `duration` - (Optional) **DEPRECATED:** Use `threshold_duration` instead. The duration of time, in _minutes_, that the threshold must violate for in order to create an incident. Must be within 1-120 (inclusive).
        - `time_function` - (Optional) **DEPRECATED:** Use `threshold_occurrences` instead. The criteria for how many data points must be in violation for the specified threshold duration. Valid values are: `all` or `any`.
        - `prediction` - (Optional) **BETA PREVIEW: the `prediction` field is in limited release and only enabled for preview on a per-account basis.** Use `prediction` to open alerts when your static threshold is predicted to be reached in the future. The `prediction` field is only available for _static_ NRQL alert conditions. See Prediction below for details.
        - `disable_health_status_reporting` - (Optional) `true` or `false`. Defaults to `false` when field not included in TF config. Violations will not change system health status for this term.

        > **NOTE:** When a `critical` or `warning` block is added to this resource, using either `duration` or `threshold_duration` (one of the two) is mandatory. Both of these should not be specified.

        > **NOTE:** When a `critical` or `warning` block is added to this resource, using either `time_function` or `threshold_occurrences` (one of the two) is mandatory. Both of these should not be specified.

        ### Prediction

        > **BETA PREVIEW:** The `prediction` block is in limited release and only enabled for preview on a per-account basis.

        > **NOTE:** The `prediction` block is only available for _static_ NRQL alert conditions.

        The `prediction` block supports the following arguments:

        - `predict_by` - (Optional) The duration, in seconds, that the prediction should look into the future. Default is 3600 seconds (1 hour).
        - `prefer_prediction_violation` - (Optional) If a prediction incident is open when a term's static threshold is breached by the actual signal, default behavior is to close the prediction incident and open a static incident. Setting `prefer_prediction_violation` to `true` overrides this behavior leaving the prediction incident open and preventing a static incident from opening. Default is false.

        ## Additional Examples

        ##### Type: `baseline`

        [Baseline NRQL alert conditions](https://docs.newrelic.com/docs/alerts/new-relic-alerts/defining-conditions/create-baseline-alert-conditions) are dynamic in nature and adjust to the behavior of your data. The example below demonstrates a baseline NRQL alert condition for alerting when transaction durations are above a specified threshold and dynamically adjusts based on data trends.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.AlertPolicy("foo", name="foo")
        foo_nrql_alert_condition = newrelic.NrqlAlertCondition("foo",
            account_id="your_account_id",
            policy_id=foo.id,
            type="static",
            name="foo",
            description="Alert when transactions are taking too long",
            runbook_url="https://www.example.com",
            enabled=True,
            violation_time_limit_seconds=3600,
            fill_option="static",
            fill_value=1,
            aggregation_window=60,
            aggregation_method="event_flow",
            aggregation_delay="120",
            expiration_duration=120,
            open_violation_on_expiration=True,
            close_violations_on_expiration=True,
            slide_by=30,
            nrql={
                "query": "SELECT average(duration) FROM Transaction where appName = 'Your App'",
            },
            critical={
                "operator": "above",
                "threshold": 5.5,
                "threshold_duration": 300,
                "threshold_occurrences": "ALL",
            },
            warning={
                "operator": "above",
                "threshold": 3.5,
                "threshold_duration": 600,
                "threshold_occurrences": "ALL",
            })
        ```

        ## Tags

        Manage NRQL alert condition tags with `EntityTags`. For up-to-date documentation about the tagging resource, please check `EntityTags`.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.AlertPolicy("foo", name="foo")
        foo_nrql_alert_condition = newrelic.NrqlAlertCondition("foo",
            account_id="12345678",
            policy_id=foo.id,
            type="static",
            name="foo",
            description="Alert when transactions are taking too long",
            runbook_url="https://www.example.com",
            enabled=True,
            violation_time_limit_seconds=3600,
            fill_option="static",
            fill_value=1,
            aggregation_window=60,
            aggregation_method="event_flow",
            aggregation_delay="120",
            expiration_duration=120,
            open_violation_on_expiration=True,
            close_violations_on_expiration=True,
            slide_by=30,
            nrql={
                "query": "SELECT average(duration) FROM Transaction where appName = 'Your App'",
            },
            critical={
                "operator": "above",
                "threshold": 5.5,
                "threshold_duration": 300,
                "threshold_occurrences": "ALL",
            },
            warning={
                "operator": "above",
                "threshold": 3.5,
                "threshold_duration": 600,
                "threshold_occurrences": "ALL",
            })
        my_condition_entity_tags = newrelic.EntityTags("my_condition_entity_tags",
            guid=foo_nrql_alert_condition.entity_guid,
            tags=[
                {
                    "key": "my-key",
                    "values": [
                        "my-value",
                        "my-other-value",
                    ],
                },
                {
                    "key": "my-key-2",
                    "values": ["my-value-2"],
                },
            ])
        ```

        <small>alerts.newrelic.com/accounts/**\\<account_id\\>**/policies/**\\<policy_id\\>**/conditions/**\\<condition_id\\>**/edit</small>

        ## Upgrade from 1.x to 2.x

        There have been several deprecations in the `NrqlAlertCondition`
        resource. Users will need to make some updates in order to have a smooth
        upgrade.

        An example resource from 1.x might look like the following.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        z = newrelic.NrqlAlertCondition("z",
            policy_id=z_newrelic_alert_policy["id"],
            name="zleslie-test",
            type="static",
            runbook_url="https://localhost",
            enabled=True,
            violation_time_limit="TWENTY_FOUR_HOURS",
            critical={
                "operator": "above",
                "threshold_duration": 120,
                "threshold": 3,
                "threshold_occurrences": "AT_LEAST_ONCE",
            },
            nrql={
                "query": "SELECT count(*) FROM TransactionError WHERE appName like '%Dummy App%' FACET appName",
            })
        ```

        After making the appropriate adjustments mentioned in the deprecation warnings,
        the resource now looks like the following.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        z = newrelic.NrqlAlertCondition("z",
            policy_id=z_newrelic_alert_policy["id"],
            name="zleslie-test",
            type="static",
            runbook_url="https://localhost",
            enabled=True,
            violation_time_limit_seconds=86400,
            terms=[{
                "priority": "critical",
                "operator": "above",
                "threshold": 3,
                "duration": 5,
                "time_function": "any",
            }],
            nrql={
                "query": "SELECT count(*) FROM TransactionError WHERE appName like '%Dummy App%' FACET appName",
            })
        ```

        ## Import

        NRQL alert conditions can be imported using a composite ID of `<policy_id>:<condition_id>:<conditionType>`, e.g.

        // For `baseline` conditions

        ```sh
        $ pulumi import newrelic:index/nrqlAlertCondition:NrqlAlertCondition foo 538291:6789035:baseline
        ```

        // For `static` conditions

        ```sh
        $ pulumi import newrelic:index/nrqlAlertCondition:NrqlAlertCondition foo 538291:6789035:static
        ```

        :param str resource_name: The name of the resource.
        :param NrqlAlertConditionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NrqlAlertConditionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregation_delay: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregation_method: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregation_timer: Optional[pulumi.Input[_builtins.str]] = None,
                 aggregation_window: Optional[pulumi.Input[_builtins.int]] = None,
                 baseline_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 close_violations_on_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 critical: Optional[pulumi.Input[Union['NrqlAlertConditionCriticalArgs', 'NrqlAlertConditionCriticalArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 evaluation_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 expiration_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 fill_option: Optional[pulumi.Input[_builtins.str]] = None,
                 fill_value: Optional[pulumi.Input[_builtins.float]] = None,
                 ignore_on_expected_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nrql: Optional[pulumi.Input[Union['NrqlAlertConditionNrqlArgs', 'NrqlAlertConditionNrqlArgsDict']]] = None,
                 open_violation_on_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 runbook_url: Optional[pulumi.Input[_builtins.str]] = None,
                 signal_seasonality: Optional[pulumi.Input[_builtins.str]] = None,
                 slide_by: Optional[pulumi.Input[_builtins.int]] = None,
                 target_entity: Optional[pulumi.Input[_builtins.str]] = None,
                 terms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NrqlAlertConditionTermArgs', 'NrqlAlertConditionTermArgsDict']]]]] = None,
                 title_template: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_time_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 violation_time_limit_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 warning: Optional[pulumi.Input[Union['NrqlAlertConditionWarningArgs', 'NrqlAlertConditionWarningArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NrqlAlertConditionArgs.__new__(NrqlAlertConditionArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["aggregation_delay"] = aggregation_delay
            __props__.__dict__["aggregation_method"] = aggregation_method
            __props__.__dict__["aggregation_timer"] = aggregation_timer
            __props__.__dict__["aggregation_window"] = aggregation_window
            __props__.__dict__["baseline_direction"] = baseline_direction
            __props__.__dict__["close_violations_on_expiration"] = close_violations_on_expiration
            __props__.__dict__["critical"] = critical
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["evaluation_delay"] = evaluation_delay
            __props__.__dict__["expiration_duration"] = expiration_duration
            __props__.__dict__["fill_option"] = fill_option
            __props__.__dict__["fill_value"] = fill_value
            __props__.__dict__["ignore_on_expected_termination"] = ignore_on_expected_termination
            __props__.__dict__["name"] = name
            if nrql is None and not opts.urn:
                raise TypeError("Missing required property 'nrql'")
            __props__.__dict__["nrql"] = nrql
            __props__.__dict__["open_violation_on_expiration"] = open_violation_on_expiration
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["runbook_url"] = runbook_url
            __props__.__dict__["signal_seasonality"] = signal_seasonality
            __props__.__dict__["slide_by"] = slide_by
            __props__.__dict__["target_entity"] = target_entity
            __props__.__dict__["terms"] = terms
            __props__.__dict__["title_template"] = title_template
            __props__.__dict__["type"] = type
            __props__.__dict__["violation_time_limit"] = violation_time_limit
            __props__.__dict__["violation_time_limit_seconds"] = violation_time_limit_seconds
            __props__.__dict__["warning"] = warning
            __props__.__dict__["entity_guid"] = None
        super(NrqlAlertCondition, __self__).__init__(
            'newrelic:index/nrqlAlertCondition:NrqlAlertCondition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            aggregation_delay: Optional[pulumi.Input[_builtins.str]] = None,
            aggregation_method: Optional[pulumi.Input[_builtins.str]] = None,
            aggregation_timer: Optional[pulumi.Input[_builtins.str]] = None,
            aggregation_window: Optional[pulumi.Input[_builtins.int]] = None,
            baseline_direction: Optional[pulumi.Input[_builtins.str]] = None,
            close_violations_on_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
            critical: Optional[pulumi.Input[Union['NrqlAlertConditionCriticalArgs', 'NrqlAlertConditionCriticalArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            entity_guid: Optional[pulumi.Input[_builtins.str]] = None,
            evaluation_delay: Optional[pulumi.Input[_builtins.int]] = None,
            expiration_duration: Optional[pulumi.Input[_builtins.int]] = None,
            fill_option: Optional[pulumi.Input[_builtins.str]] = None,
            fill_value: Optional[pulumi.Input[_builtins.float]] = None,
            ignore_on_expected_termination: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nrql: Optional[pulumi.Input[Union['NrqlAlertConditionNrqlArgs', 'NrqlAlertConditionNrqlArgsDict']]] = None,
            open_violation_on_expiration: Optional[pulumi.Input[_builtins.bool]] = None,
            policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            runbook_url: Optional[pulumi.Input[_builtins.str]] = None,
            signal_seasonality: Optional[pulumi.Input[_builtins.str]] = None,
            slide_by: Optional[pulumi.Input[_builtins.int]] = None,
            target_entity: Optional[pulumi.Input[_builtins.str]] = None,
            terms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NrqlAlertConditionTermArgs', 'NrqlAlertConditionTermArgsDict']]]]] = None,
            title_template: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            violation_time_limit: Optional[pulumi.Input[_builtins.str]] = None,
            violation_time_limit_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            warning: Optional[pulumi.Input[Union['NrqlAlertConditionWarningArgs', 'NrqlAlertConditionWarningArgsDict']]] = None) -> 'NrqlAlertCondition':
        """
        Get an existing NrqlAlertCondition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The New Relic account ID of the account you wish to create the condition. Defaults to the account ID set in your environment variable `NEW_RELIC_ACCOUNT_ID`.
        :param pulumi.Input[_builtins.str] aggregation_delay: How long we wait for data that belongs in each aggregation window. Depending on your data, a longer delay may increase accuracy but delay notifications. Use `aggregation_delay` with the `event_flow` and `cadence` methods. The maximum delay is 1200 seconds (20 minutes) when using `event_flow` and 3600 seconds (60 minutes) when using `cadence`. In both cases, the minimum delay is 0 seconds and the default is 120 seconds. `aggregation_delay` cannot be set with `nrql.evaluation_offset`.
        :param pulumi.Input[_builtins.str] aggregation_method: Determines when we consider an aggregation window to be complete so that we can evaluate the signal for incidents. Possible values are `cadence`, `event_flow` or `event_timer`. Default is `event_flow`. `aggregation_method` cannot be set with `nrql.evaluation_offset`.
        :param pulumi.Input[_builtins.str] aggregation_timer: How long we wait after each data point arrives to make sure we've processed the whole batch. Use `aggregation_timer` with the `event_timer` method. The timer value can range from 0 seconds to 1200 seconds (20 minutes); the default is 60 seconds. `aggregation_timer` cannot be set with `nrql.evaluation_offset`.
        :param pulumi.Input[_builtins.int] aggregation_window: The duration of the time window used to evaluate the NRQL query, in seconds. The value must be at least 30 seconds, and no more than 21600 seconds (6 hours). Default is 60 seconds.
        :param pulumi.Input[_builtins.str] baseline_direction: The baseline direction of a _baseline_ NRQL alert condition. Valid values are: `lower_only`, `upper_and_lower`, `upper_only` (case insensitive).
        :param pulumi.Input[_builtins.bool] close_violations_on_expiration: Whether to close all open incidents when the signal expires.
        :param pulumi.Input[Union['NrqlAlertConditionCriticalArgs', 'NrqlAlertConditionCriticalArgsDict']] critical: A list containing the `critical` threshold values. At least one `critical` or `warning` threshold must be defined. See Terms below for details.
        :param pulumi.Input[_builtins.str] description: The description of the NRQL alert condition.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable the alert condition. Valid values are `true` and `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] entity_guid: The unique entity identifier of the NRQL Condition in New Relic.
        :param pulumi.Input[_builtins.int] evaluation_delay: How long we wait until the signal starts evaluating. The maximum delay is 7200 seconds (120 minutes).
        :param pulumi.Input[_builtins.int] expiration_duration: The amount of time (in seconds) to wait before considering the signal expired. The value must be at least 30 seconds, and no more than 172800 seconds (48 hours).
        :param pulumi.Input[_builtins.str] fill_option: Which strategy to use when filling gaps in the signal. Possible values are `none`, `last_value` or `static`. If `static`, the `fill_value` field will be used for filling gaps in the signal.
        :param pulumi.Input[_builtins.float] fill_value: This value will be used for filling gaps in the signal.
        :param pulumi.Input[_builtins.bool] ignore_on_expected_termination: Whether an alert condition should ignore expected termination of a signal when considering whether to create a loss of signal incident. Defaults to false.
        :param pulumi.Input[_builtins.str] name: The title of the condition.
        :param pulumi.Input[Union['NrqlAlertConditionNrqlArgs', 'NrqlAlertConditionNrqlArgsDict']] nrql: A NRQL query. See NRQL below for details.
        :param pulumi.Input[_builtins.bool] open_violation_on_expiration: Whether to create a new incident to capture that the signal expired.
        :param pulumi.Input[_builtins.str] policy_id: The ID of the policy where this condition should be used.
        :param pulumi.Input[_builtins.str] runbook_url: Runbook URL to display in notifications.
        :param pulumi.Input[_builtins.str] signal_seasonality: Seasonality under which a condition's signal(s) are evaluated. Only available for baseline conditions. Valid values are: `NEW_RELIC_CALCULATION`, `HOURLY`, `DAILY`, `WEEKLY`, or `NONE`. To have New Relic calculate seasonality automatically, set to `NEW_RELIC_CALCULATION`. To turn off seasonality completely, set to `NONE`.
        :param pulumi.Input[_builtins.int] slide_by: Gathers data in overlapping time windows to smooth the chart line, making it easier to spot trends. The `slide_by` value is specified in seconds and must be smaller than and a factor of the `aggregation_window`.
        :param pulumi.Input[_builtins.str] target_entity: BETA PREVIEW: The GUID of the entity explicitly targeted by the condition. Issues triggered by this condition will affect the health status of this entity instead of having the affected entity detected automatically. The entity's account ID must be either `account_id` or `nrql.data_account_id`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NrqlAlertConditionTermArgs', 'NrqlAlertConditionTermArgsDict']]]] terms: **DEPRECATED** Use `critical`, and `warning` instead. A list of terms for this condition. See Terms below for details.
        :param pulumi.Input[_builtins.str] title_template: The custom title to be used when incidents are opened by the condition. Setting this field will override the default title. Must be [Handlebars](https://handlebarsjs.com/) format.
        :param pulumi.Input[_builtins.str] type: The type of the condition. Valid values are `static` or `baseline`. Defaults to `static`.
        :param pulumi.Input[_builtins.str] violation_time_limit: **DEPRECATED:** Use `violation_time_limit_seconds` instead. Sets a time limit, in hours, that will automatically force-close a long-lasting incident after the time limit you select. Possible values are `ONE_HOUR`, `TWO_HOURS`, `FOUR_HOURS`, `EIGHT_HOURS`, `TWELVE_HOURS`, `TWENTY_FOUR_HOURS`, `THIRTY_DAYS` (case insensitive).<br>
               <small>\\***Note**: One of `violation_time_limit` _or_ `violation_time_limit_seconds` must be set, but not both.</small>
        :param pulumi.Input[_builtins.int] violation_time_limit_seconds: Sets a time limit, in seconds, that will automatically force-close a long-lasting incident after the time limit you select. The value must be between 300 seconds (5 minutes) to 2592000 seconds (30 days) (inclusive). <br>
               <small>\\***Note**: One of `violation_time_limit` _or_ `violation_time_limit_seconds` must be set, but not both.</small>
        :param pulumi.Input[Union['NrqlAlertConditionWarningArgs', 'NrqlAlertConditionWarningArgsDict']] warning: A list containing the `warning` threshold values. At least one `critical` or `warning` threshold must be defined. See Terms below for details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NrqlAlertConditionState.__new__(_NrqlAlertConditionState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["aggregation_delay"] = aggregation_delay
        __props__.__dict__["aggregation_method"] = aggregation_method
        __props__.__dict__["aggregation_timer"] = aggregation_timer
        __props__.__dict__["aggregation_window"] = aggregation_window
        __props__.__dict__["baseline_direction"] = baseline_direction
        __props__.__dict__["close_violations_on_expiration"] = close_violations_on_expiration
        __props__.__dict__["critical"] = critical
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["entity_guid"] = entity_guid
        __props__.__dict__["evaluation_delay"] = evaluation_delay
        __props__.__dict__["expiration_duration"] = expiration_duration
        __props__.__dict__["fill_option"] = fill_option
        __props__.__dict__["fill_value"] = fill_value
        __props__.__dict__["ignore_on_expected_termination"] = ignore_on_expected_termination
        __props__.__dict__["name"] = name
        __props__.__dict__["nrql"] = nrql
        __props__.__dict__["open_violation_on_expiration"] = open_violation_on_expiration
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["runbook_url"] = runbook_url
        __props__.__dict__["signal_seasonality"] = signal_seasonality
        __props__.__dict__["slide_by"] = slide_by
        __props__.__dict__["target_entity"] = target_entity
        __props__.__dict__["terms"] = terms
        __props__.__dict__["title_template"] = title_template
        __props__.__dict__["type"] = type
        __props__.__dict__["violation_time_limit"] = violation_time_limit
        __props__.__dict__["violation_time_limit_seconds"] = violation_time_limit_seconds
        __props__.__dict__["warning"] = warning
        return NrqlAlertCondition(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The New Relic account ID of the account you wish to create the condition. Defaults to the account ID set in your environment variable `NEW_RELIC_ACCOUNT_ID`.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="aggregationDelay")
    def aggregation_delay(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        How long we wait for data that belongs in each aggregation window. Depending on your data, a longer delay may increase accuracy but delay notifications. Use `aggregation_delay` with the `event_flow` and `cadence` methods. The maximum delay is 1200 seconds (20 minutes) when using `event_flow` and 3600 seconds (60 minutes) when using `cadence`. In both cases, the minimum delay is 0 seconds and the default is 120 seconds. `aggregation_delay` cannot be set with `nrql.evaluation_offset`.
        """
        return pulumi.get(self, "aggregation_delay")

    @_builtins.property
    @pulumi.getter(name="aggregationMethod")
    def aggregation_method(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Determines when we consider an aggregation window to be complete so that we can evaluate the signal for incidents. Possible values are `cadence`, `event_flow` or `event_timer`. Default is `event_flow`. `aggregation_method` cannot be set with `nrql.evaluation_offset`.
        """
        return pulumi.get(self, "aggregation_method")

    @_builtins.property
    @pulumi.getter(name="aggregationTimer")
    def aggregation_timer(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        How long we wait after each data point arrives to make sure we've processed the whole batch. Use `aggregation_timer` with the `event_timer` method. The timer value can range from 0 seconds to 1200 seconds (20 minutes); the default is 60 seconds. `aggregation_timer` cannot be set with `nrql.evaluation_offset`.
        """
        return pulumi.get(self, "aggregation_timer")

    @_builtins.property
    @pulumi.getter(name="aggregationWindow")
    def aggregation_window(self) -> pulumi.Output[_builtins.int]:
        """
        The duration of the time window used to evaluate the NRQL query, in seconds. The value must be at least 30 seconds, and no more than 21600 seconds (6 hours). Default is 60 seconds.
        """
        return pulumi.get(self, "aggregation_window")

    @_builtins.property
    @pulumi.getter(name="baselineDirection")
    def baseline_direction(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The baseline direction of a _baseline_ NRQL alert condition. Valid values are: `lower_only`, `upper_and_lower`, `upper_only` (case insensitive).
        """
        return pulumi.get(self, "baseline_direction")

    @_builtins.property
    @pulumi.getter(name="closeViolationsOnExpiration")
    def close_violations_on_expiration(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to close all open incidents when the signal expires.
        """
        return pulumi.get(self, "close_violations_on_expiration")

    @_builtins.property
    @pulumi.getter
    def critical(self) -> pulumi.Output[Optional['outputs.NrqlAlertConditionCritical']]:
        """
        A list containing the `critical` threshold values. At least one `critical` or `warning` threshold must be defined. See Terms below for details.
        """
        return pulumi.get(self, "critical")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the NRQL alert condition.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable the alert condition. Valid values are `true` and `false`. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="entityGuid")
    def entity_guid(self) -> pulumi.Output[_builtins.str]:
        """
        The unique entity identifier of the NRQL Condition in New Relic.
        """
        return pulumi.get(self, "entity_guid")

    @_builtins.property
    @pulumi.getter(name="evaluationDelay")
    def evaluation_delay(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        How long we wait until the signal starts evaluating. The maximum delay is 7200 seconds (120 minutes).
        """
        return pulumi.get(self, "evaluation_delay")

    @_builtins.property
    @pulumi.getter(name="expirationDuration")
    def expiration_duration(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time (in seconds) to wait before considering the signal expired. The value must be at least 30 seconds, and no more than 172800 seconds (48 hours).
        """
        return pulumi.get(self, "expiration_duration")

    @_builtins.property
    @pulumi.getter(name="fillOption")
    def fill_option(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Which strategy to use when filling gaps in the signal. Possible values are `none`, `last_value` or `static`. If `static`, the `fill_value` field will be used for filling gaps in the signal.
        """
        return pulumi.get(self, "fill_option")

    @_builtins.property
    @pulumi.getter(name="fillValue")
    def fill_value(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        This value will be used for filling gaps in the signal.
        """
        return pulumi.get(self, "fill_value")

    @_builtins.property
    @pulumi.getter(name="ignoreOnExpectedTermination")
    def ignore_on_expected_termination(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether an alert condition should ignore expected termination of a signal when considering whether to create a loss of signal incident. Defaults to false.
        """
        return pulumi.get(self, "ignore_on_expected_termination")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The title of the condition.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def nrql(self) -> pulumi.Output['outputs.NrqlAlertConditionNrql']:
        """
        A NRQL query. See NRQL below for details.
        """
        return pulumi.get(self, "nrql")

    @_builtins.property
    @pulumi.getter(name="openViolationOnExpiration")
    def open_violation_on_expiration(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to create a new incident to capture that the signal expired.
        """
        return pulumi.get(self, "open_violation_on_expiration")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the policy where this condition should be used.
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter(name="runbookUrl")
    def runbook_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Runbook URL to display in notifications.
        """
        return pulumi.get(self, "runbook_url")

    @_builtins.property
    @pulumi.getter(name="signalSeasonality")
    def signal_seasonality(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Seasonality under which a condition's signal(s) are evaluated. Only available for baseline conditions. Valid values are: `NEW_RELIC_CALCULATION`, `HOURLY`, `DAILY`, `WEEKLY`, or `NONE`. To have New Relic calculate seasonality automatically, set to `NEW_RELIC_CALCULATION`. To turn off seasonality completely, set to `NONE`.
        """
        return pulumi.get(self, "signal_seasonality")

    @_builtins.property
    @pulumi.getter(name="slideBy")
    def slide_by(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Gathers data in overlapping time windows to smooth the chart line, making it easier to spot trends. The `slide_by` value is specified in seconds and must be smaller than and a factor of the `aggregation_window`.
        """
        return pulumi.get(self, "slide_by")

    @_builtins.property
    @pulumi.getter(name="targetEntity")
    def target_entity(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        BETA PREVIEW: The GUID of the entity explicitly targeted by the condition. Issues triggered by this condition will affect the health status of this entity instead of having the affected entity detected automatically. The entity's account ID must be either `account_id` or `nrql.data_account_id`.
        """
        return pulumi.get(self, "target_entity")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""use `critical` and `warning` attributes instead""")
    def terms(self) -> pulumi.Output[Optional[Sequence['outputs.NrqlAlertConditionTerm']]]:
        """
        **DEPRECATED** Use `critical`, and `warning` instead. A list of terms for this condition. See Terms below for details.
        """
        return pulumi.get(self, "terms")

    @_builtins.property
    @pulumi.getter(name="titleTemplate")
    def title_template(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The custom title to be used when incidents are opened by the condition. Setting this field will override the default title. Must be [Handlebars](https://handlebarsjs.com/) format.
        """
        return pulumi.get(self, "title_template")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the condition. Valid values are `static` or `baseline`. Defaults to `static`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="violationTimeLimit")
    @_utilities.deprecated("""use `violation_time_limit_seconds` attribute instead""")
    def violation_time_limit(self) -> pulumi.Output[_builtins.str]:
        """
        **DEPRECATED:** Use `violation_time_limit_seconds` instead. Sets a time limit, in hours, that will automatically force-close a long-lasting incident after the time limit you select. Possible values are `ONE_HOUR`, `TWO_HOURS`, `FOUR_HOURS`, `EIGHT_HOURS`, `TWELVE_HOURS`, `TWENTY_FOUR_HOURS`, `THIRTY_DAYS` (case insensitive).<br>
        <small>\\***Note**: One of `violation_time_limit` _or_ `violation_time_limit_seconds` must be set, but not both.</small>
        """
        return pulumi.get(self, "violation_time_limit")

    @_builtins.property
    @pulumi.getter(name="violationTimeLimitSeconds")
    def violation_time_limit_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Sets a time limit, in seconds, that will automatically force-close a long-lasting incident after the time limit you select. The value must be between 300 seconds (5 minutes) to 2592000 seconds (30 days) (inclusive). <br>
        <small>\\***Note**: One of `violation_time_limit` _or_ `violation_time_limit_seconds` must be set, but not both.</small>
        """
        return pulumi.get(self, "violation_time_limit_seconds")

    @_builtins.property
    @pulumi.getter
    def warning(self) -> pulumi.Output[Optional['outputs.NrqlAlertConditionWarning']]:
        """
        A list containing the `warning` threshold values. At least one `critical` or `warning` threshold must be defined. See Terms below for details.
        """
        return pulumi.get(self, "warning")

