# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OneDashboardRawArgs', 'OneDashboardRaw']

@pulumi.input_type
class OneDashboardRawArgs:
    def __init__(__self__, *,
                 pages: pulumi.Input[Sequence[pulumi.Input['OneDashboardRawPageArgs']]],
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OneDashboardRaw resource.
        :param pulumi.Input[Sequence[pulumi.Input['OneDashboardRawPageArgs']]] pages: A nested block that describes a page. See Nested page blocks below for details.
        :param pulumi.Input[_builtins.str] account_id: Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        :param pulumi.Input[_builtins.str] description: Brief text describing the dashboard.
        :param pulumi.Input[_builtins.str] name: The title of the dashboard.
        :param pulumi.Input[_builtins.str] permissions: Determines who can see the dashboard in an account. Valid values are `private`, `public_read_only`, or `public_read_write`. Defaults to `public_read_only`.
        """
        pulumi.set(__self__, "pages", pages)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @_builtins.property
    @pulumi.getter
    def pages(self) -> pulumi.Input[Sequence[pulumi.Input['OneDashboardRawPageArgs']]]:
        """
        A nested block that describes a page. See Nested page blocks below for details.
        """
        return pulumi.get(self, "pages")

    @pages.setter
    def pages(self, value: pulumi.Input[Sequence[pulumi.Input['OneDashboardRawPageArgs']]]):
        pulumi.set(self, "pages", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Brief text describing the dashboard.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The title of the dashboard.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines who can see the dashboard in an account. Valid values are `private`, `public_read_only`, or `public_read_write`. Defaults to `public_read_only`.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class _OneDashboardRawState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 guid: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pages: Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardRawPageArgs']]]] = None,
                 permalink: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OneDashboardRaw resources.
        :param pulumi.Input[_builtins.str] account_id: Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        :param pulumi.Input[_builtins.str] description: Brief text describing the dashboard.
        :param pulumi.Input[_builtins.str] guid: The unique entity identifier of the dashboard page in New Relic.
        :param pulumi.Input[_builtins.str] name: The title of the dashboard.
        :param pulumi.Input[Sequence[pulumi.Input['OneDashboardRawPageArgs']]] pages: A nested block that describes a page. See Nested page blocks below for details.
        :param pulumi.Input[_builtins.str] permalink: The URL for viewing the dashboard.
        :param pulumi.Input[_builtins.str] permissions: Determines who can see the dashboard in an account. Valid values are `private`, `public_read_only`, or `public_read_write`. Defaults to `public_read_only`.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if guid is not None:
            pulumi.set(__self__, "guid", guid)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pages is not None:
            pulumi.set(__self__, "pages", pages)
        if permalink is not None:
            pulumi.set(__self__, "permalink", permalink)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Brief text describing the dashboard.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique entity identifier of the dashboard page in New Relic.
        """
        return pulumi.get(self, "guid")

    @guid.setter
    def guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guid", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The title of the dashboard.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def pages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardRawPageArgs']]]]:
        """
        A nested block that describes a page. See Nested page blocks below for details.
        """
        return pulumi.get(self, "pages")

    @pages.setter
    def pages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OneDashboardRawPageArgs']]]]):
        pulumi.set(self, "pages", value)

    @_builtins.property
    @pulumi.getter
    def permalink(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL for viewing the dashboard.
        """
        return pulumi.get(self, "permalink")

    @permalink.setter
    def permalink(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permalink", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines who can see the dashboard in an account. Valid values are `private`, `public_read_only`, or `public_read_write`. Defaults to `public_read_only`.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permissions", value)


@pulumi.type_token("newrelic:index/oneDashboardRaw:OneDashboardRaw")
class OneDashboardRaw(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OneDashboardRawPageArgs', 'OneDashboardRawPageArgsDict']]]]] = None,
                 permissions: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        > **NOTE:** The OneDashboardJson resource is preferred for configuring dashboards in New Relic. This resource does not support the latest dashboard features and will receive less investment compared to newrelic_one_dashboard_json.

        ## Example Usage

        ### Create A New Relic One Dashboard With RawConfiguration

        ```python
        import pulumi
        import json
        import pulumi_newrelic as newrelic

        exampledash = newrelic.OneDashboardRaw("exampledash",
            name="New Relic Terraform Example",
            pages=[{
                "name": "Page Name",
                "widgets": [
                    {
                        "title": "Custom widget",
                        "row": 1,
                        "column": 1,
                        "width": 1,
                        "height": 1,
                        "visualization_id": "viz.custom",
                        "configuration": \"\"\"      {
                \\"legend\\": {
                  \\"enabled\\": false
                },
                \\"nrqlQueries\\": [
                  {
                    \\"accountId\\": ` + accountID + `,
                    \\"query\\": \\"SELECT average(loadAverageOneMinute), average(loadAverageFiveMinute), average(loadAverageFifteenMinute) from SystemSample SINCE 60 minutes ago    TIMESERIES\\"
                  }
                ],
                \\"yAxisLeft\\": {
                  \\"max\\": 100,
                  \\"min\\": 50,
                  \\"zero\\": false
                }
              }
        \"\"\",
                    },
                    {
                        "title": "Server CPU",
                        "row": 1,
                        "column": 2,
                        "width": 1,
                        "height": 1,
                        "visualization_id": "viz.testing",
                        "configuration": \"\"\"      {
                \\"nrqlQueries\\": [
                  {
                    \\"accountId\\": ` + accountID + `,
                    \\"query\\": \\"SELECT average(cpuPercent) FROM SystemSample since 3 hours ago facet hostname limit 400\\"
                  }
                ]
              }
        \"\"\",
                    },
                    {
                        "title": "Docker Server CPU",
                        "row": 1,
                        "column": 3,
                        "height": 1,
                        "width": 1,
                        "visualization_id": "viz.bar",
                        "configuration": json.dumps({
                            "facet": {
                                "showOtherSeries": False,
                            },
                            "nrqlQueries": [{
                                "accountId": account_id,
                                "query": "SELECT average(cpuPercent) FROM SystemSample since 3 hours ago facet hostname limit 400",
                            }],
                        }),
                        "linked_entity_guids": ["MzI5ODAxNnxWSVp8REFTSEJPQVJEfDI2MTcxNDc"],
                    },
                ],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        :param pulumi.Input[_builtins.str] description: Brief text describing the dashboard.
        :param pulumi.Input[_builtins.str] name: The title of the dashboard.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OneDashboardRawPageArgs', 'OneDashboardRawPageArgsDict']]]] pages: A nested block that describes a page. See Nested page blocks below for details.
        :param pulumi.Input[_builtins.str] permissions: Determines who can see the dashboard in an account. Valid values are `private`, `public_read_only`, or `public_read_write`. Defaults to `public_read_only`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OneDashboardRawArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **NOTE:** The OneDashboardJson resource is preferred for configuring dashboards in New Relic. This resource does not support the latest dashboard features and will receive less investment compared to newrelic_one_dashboard_json.

        ## Example Usage

        ### Create A New Relic One Dashboard With RawConfiguration

        ```python
        import pulumi
        import json
        import pulumi_newrelic as newrelic

        exampledash = newrelic.OneDashboardRaw("exampledash",
            name="New Relic Terraform Example",
            pages=[{
                "name": "Page Name",
                "widgets": [
                    {
                        "title": "Custom widget",
                        "row": 1,
                        "column": 1,
                        "width": 1,
                        "height": 1,
                        "visualization_id": "viz.custom",
                        "configuration": \"\"\"      {
                \\"legend\\": {
                  \\"enabled\\": false
                },
                \\"nrqlQueries\\": [
                  {
                    \\"accountId\\": ` + accountID + `,
                    \\"query\\": \\"SELECT average(loadAverageOneMinute), average(loadAverageFiveMinute), average(loadAverageFifteenMinute) from SystemSample SINCE 60 minutes ago    TIMESERIES\\"
                  }
                ],
                \\"yAxisLeft\\": {
                  \\"max\\": 100,
                  \\"min\\": 50,
                  \\"zero\\": false
                }
              }
        \"\"\",
                    },
                    {
                        "title": "Server CPU",
                        "row": 1,
                        "column": 2,
                        "width": 1,
                        "height": 1,
                        "visualization_id": "viz.testing",
                        "configuration": \"\"\"      {
                \\"nrqlQueries\\": [
                  {
                    \\"accountId\\": ` + accountID + `,
                    \\"query\\": \\"SELECT average(cpuPercent) FROM SystemSample since 3 hours ago facet hostname limit 400\\"
                  }
                ]
              }
        \"\"\",
                    },
                    {
                        "title": "Docker Server CPU",
                        "row": 1,
                        "column": 3,
                        "height": 1,
                        "width": 1,
                        "visualization_id": "viz.bar",
                        "configuration": json.dumps({
                            "facet": {
                                "showOtherSeries": False,
                            },
                            "nrqlQueries": [{
                                "accountId": account_id,
                                "query": "SELECT average(cpuPercent) FROM SystemSample since 3 hours ago facet hostname limit 400",
                            }],
                        }),
                        "linked_entity_guids": ["MzI5ODAxNnxWSVp8REFTSEJPQVJEfDI2MTcxNDc"],
                    },
                ],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param OneDashboardRawArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OneDashboardRawArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OneDashboardRawPageArgs', 'OneDashboardRawPageArgsDict']]]]] = None,
                 permissions: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OneDashboardRawArgs.__new__(OneDashboardRawArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if pages is None and not opts.urn:
                raise TypeError("Missing required property 'pages'")
            __props__.__dict__["pages"] = pages
            __props__.__dict__["permissions"] = permissions
            __props__.__dict__["guid"] = None
            __props__.__dict__["permalink"] = None
        super(OneDashboardRaw, __self__).__init__(
            'newrelic:index/oneDashboardRaw:OneDashboardRaw',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            guid: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            pages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OneDashboardRawPageArgs', 'OneDashboardRawPageArgsDict']]]]] = None,
            permalink: Optional[pulumi.Input[_builtins.str]] = None,
            permissions: Optional[pulumi.Input[_builtins.str]] = None) -> 'OneDashboardRaw':
        """
        Get an existing OneDashboardRaw resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        :param pulumi.Input[_builtins.str] description: Brief text describing the dashboard.
        :param pulumi.Input[_builtins.str] guid: The unique entity identifier of the dashboard page in New Relic.
        :param pulumi.Input[_builtins.str] name: The title of the dashboard.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OneDashboardRawPageArgs', 'OneDashboardRawPageArgsDict']]]] pages: A nested block that describes a page. See Nested page blocks below for details.
        :param pulumi.Input[_builtins.str] permalink: The URL for viewing the dashboard.
        :param pulumi.Input[_builtins.str] permissions: Determines who can see the dashboard in an account. Valid values are `private`, `public_read_only`, or `public_read_write`. Defaults to `public_read_only`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OneDashboardRawState.__new__(_OneDashboardRawState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["description"] = description
        __props__.__dict__["guid"] = guid
        __props__.__dict__["name"] = name
        __props__.__dict__["pages"] = pages
        __props__.__dict__["permalink"] = permalink
        __props__.__dict__["permissions"] = permissions
        return OneDashboardRaw(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Determines the New Relic account where the dashboard will be created. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Brief text describing the dashboard.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def guid(self) -> pulumi.Output[_builtins.str]:
        """
        The unique entity identifier of the dashboard page in New Relic.
        """
        return pulumi.get(self, "guid")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The title of the dashboard.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def pages(self) -> pulumi.Output[Sequence['outputs.OneDashboardRawPage']]:
        """
        A nested block that describes a page. See Nested page blocks below for details.
        """
        return pulumi.get(self, "pages")

    @_builtins.property
    @pulumi.getter
    def permalink(self) -> pulumi.Output[_builtins.str]:
        """
        The URL for viewing the dashboard.
        """
        return pulumi.get(self, "permalink")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Determines who can see the dashboard in an account. Valid values are `private`, `public_read_only`, or `public_read_write`. Defaults to `public_read_only`.
        """
        return pulumi.get(self, "permissions")

