# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationSettingsArgs', 'ApplicationSettings']

@pulumi.input_type
class ApplicationSettingsArgs:
    def __init__(__self__, *,
                 app_apdex_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 enable_real_user_monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_slow_sql: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_thread_profiler: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_user_apdex_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 error_collectors: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSettingsErrorCollectorArgs']]]] = None,
                 guid: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tracer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 transaction_tracers: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSettingsTransactionTracerArgs']]]] = None,
                 use_server_side_config: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ApplicationSettings resource.
        :param pulumi.Input[_builtins.float] app_apdex_threshold: The acceptable response time limit (Apdex threshold) for the application.
        :param pulumi.Input[_builtins.bool] enable_real_user_monitoring: Dummy field to support backward compatibility of previous version.should be removed with next major version.
        :param pulumi.Input[_builtins.bool] enable_slow_sql: Enable or disable the collection of slowest database queries in your traces.
        :param pulumi.Input[_builtins.bool] enable_thread_profiler: Enable or disable the collection of thread profiling data.
        :param pulumi.Input[_builtins.float] end_user_apdex_threshold: Dummy field to support backward compatibility of previous version.should be removed with next major version.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationSettingsErrorCollectorArgs']]] error_collectors: Configuration block for error collection. Including this block enables the error collector. The following arguments are supported:
        :param pulumi.Input[_builtins.str] guid: The GUID of the application in New Relic APM.
               
               > **NOTE:** While the attribute `guid` is not mandatory at a schema level, it is recommended to use `guid` over `name`, as support for using `name` with this resource shall eventually be discontinued. Please see the note under `name` for more details.
        :param pulumi.Input[_builtins.str] name: The name of the application in New Relic.
        :param pulumi.Input[_builtins.str] tracer_type: Configures the type of tracer used. Valid values are `CROSS_APPLICATION_TRACER`, `DISTRIBUTED_TRACING`, `NONE`, `OPT_OUT`.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationSettingsTransactionTracerArgs']]] transaction_tracers: Configuration block for transaction tracer. Providing this block enables transaction tracing. The following arguments are supported:
        :param pulumi.Input[_builtins.bool] use_server_side_config: Enable or disable server side monitoring for the New Relic application.
        """
        if app_apdex_threshold is not None:
            pulumi.set(__self__, "app_apdex_threshold", app_apdex_threshold)
        if enable_real_user_monitoring is not None:
            pulumi.set(__self__, "enable_real_user_monitoring", enable_real_user_monitoring)
        if enable_slow_sql is not None:
            pulumi.set(__self__, "enable_slow_sql", enable_slow_sql)
        if enable_thread_profiler is not None:
            pulumi.set(__self__, "enable_thread_profiler", enable_thread_profiler)
        if end_user_apdex_threshold is not None:
            pulumi.set(__self__, "end_user_apdex_threshold", end_user_apdex_threshold)
        if error_collectors is not None:
            pulumi.set(__self__, "error_collectors", error_collectors)
        if guid is not None:
            pulumi.set(__self__, "guid", guid)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tracer_type is not None:
            pulumi.set(__self__, "tracer_type", tracer_type)
        if transaction_tracers is not None:
            pulumi.set(__self__, "transaction_tracers", transaction_tracers)
        if use_server_side_config is not None:
            pulumi.set(__self__, "use_server_side_config", use_server_side_config)

    @_builtins.property
    @pulumi.getter(name="appApdexThreshold")
    def app_apdex_threshold(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The acceptable response time limit (Apdex threshold) for the application.
        """
        return pulumi.get(self, "app_apdex_threshold")

    @app_apdex_threshold.setter
    def app_apdex_threshold(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "app_apdex_threshold", value)

    @_builtins.property
    @pulumi.getter(name="enableRealUserMonitoring")
    def enable_real_user_monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Dummy field to support backward compatibility of previous version.should be removed with next major version.
        """
        return pulumi.get(self, "enable_real_user_monitoring")

    @enable_real_user_monitoring.setter
    def enable_real_user_monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_real_user_monitoring", value)

    @_builtins.property
    @pulumi.getter(name="enableSlowSql")
    def enable_slow_sql(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or disable the collection of slowest database queries in your traces.
        """
        return pulumi.get(self, "enable_slow_sql")

    @enable_slow_sql.setter
    def enable_slow_sql(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_slow_sql", value)

    @_builtins.property
    @pulumi.getter(name="enableThreadProfiler")
    def enable_thread_profiler(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or disable the collection of thread profiling data.
        """
        return pulumi.get(self, "enable_thread_profiler")

    @enable_thread_profiler.setter
    def enable_thread_profiler(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_thread_profiler", value)

    @_builtins.property
    @pulumi.getter(name="endUserApdexThreshold")
    def end_user_apdex_threshold(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Dummy field to support backward compatibility of previous version.should be removed with next major version.
        """
        return pulumi.get(self, "end_user_apdex_threshold")

    @end_user_apdex_threshold.setter
    def end_user_apdex_threshold(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "end_user_apdex_threshold", value)

    @_builtins.property
    @pulumi.getter(name="errorCollectors")
    def error_collectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSettingsErrorCollectorArgs']]]]:
        """
        Configuration block for error collection. Including this block enables the error collector. The following arguments are supported:
        """
        return pulumi.get(self, "error_collectors")

    @error_collectors.setter
    def error_collectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSettingsErrorCollectorArgs']]]]):
        pulumi.set(self, "error_collectors", value)

    @_builtins.property
    @pulumi.getter
    def guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GUID of the application in New Relic APM.

        > **NOTE:** While the attribute `guid` is not mandatory at a schema level, it is recommended to use `guid` over `name`, as support for using `name` with this resource shall eventually be discontinued. Please see the note under `name` for more details.
        """
        return pulumi.get(self, "guid")

    @guid.setter
    def guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guid", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the application in New Relic.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="tracerType")
    def tracer_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configures the type of tracer used. Valid values are `CROSS_APPLICATION_TRACER`, `DISTRIBUTED_TRACING`, `NONE`, `OPT_OUT`.
        """
        return pulumi.get(self, "tracer_type")

    @tracer_type.setter
    def tracer_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tracer_type", value)

    @_builtins.property
    @pulumi.getter(name="transactionTracers")
    def transaction_tracers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSettingsTransactionTracerArgs']]]]:
        """
        Configuration block for transaction tracer. Providing this block enables transaction tracing. The following arguments are supported:
        """
        return pulumi.get(self, "transaction_tracers")

    @transaction_tracers.setter
    def transaction_tracers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSettingsTransactionTracerArgs']]]]):
        pulumi.set(self, "transaction_tracers", value)

    @_builtins.property
    @pulumi.getter(name="useServerSideConfig")
    def use_server_side_config(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or disable server side monitoring for the New Relic application.
        """
        return pulumi.get(self, "use_server_side_config")

    @use_server_side_config.setter
    def use_server_side_config(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_server_side_config", value)


@pulumi.input_type
class _ApplicationSettingsState:
    def __init__(__self__, *,
                 app_apdex_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 enable_real_user_monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_slow_sql: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_thread_profiler: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_user_apdex_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 error_collectors: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSettingsErrorCollectorArgs']]]] = None,
                 guid: Optional[pulumi.Input[_builtins.str]] = None,
                 is_imported: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tracer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 transaction_tracers: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSettingsTransactionTracerArgs']]]] = None,
                 use_server_side_config: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ApplicationSettings resources.
        :param pulumi.Input[_builtins.float] app_apdex_threshold: The acceptable response time limit (Apdex threshold) for the application.
        :param pulumi.Input[_builtins.bool] enable_real_user_monitoring: Dummy field to support backward compatibility of previous version.should be removed with next major version.
        :param pulumi.Input[_builtins.bool] enable_slow_sql: Enable or disable the collection of slowest database queries in your traces.
        :param pulumi.Input[_builtins.bool] enable_thread_profiler: Enable or disable the collection of thread profiling data.
        :param pulumi.Input[_builtins.float] end_user_apdex_threshold: Dummy field to support backward compatibility of previous version.should be removed with next major version.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationSettingsErrorCollectorArgs']]] error_collectors: Configuration block for error collection. Including this block enables the error collector. The following arguments are supported:
        :param pulumi.Input[_builtins.str] guid: The GUID of the application in New Relic APM.
               
               > **NOTE:** While the attribute `guid` is not mandatory at a schema level, it is recommended to use `guid` over `name`, as support for using `name` with this resource shall eventually be discontinued. Please see the note under `name` for more details.
        :param pulumi.Input[_builtins.str] name: The name of the application in New Relic.
        :param pulumi.Input[_builtins.str] tracer_type: Configures the type of tracer used. Valid values are `CROSS_APPLICATION_TRACER`, `DISTRIBUTED_TRACING`, `NONE`, `OPT_OUT`.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationSettingsTransactionTracerArgs']]] transaction_tracers: Configuration block for transaction tracer. Providing this block enables transaction tracing. The following arguments are supported:
        :param pulumi.Input[_builtins.bool] use_server_side_config: Enable or disable server side monitoring for the New Relic application.
        """
        if app_apdex_threshold is not None:
            pulumi.set(__self__, "app_apdex_threshold", app_apdex_threshold)
        if enable_real_user_monitoring is not None:
            pulumi.set(__self__, "enable_real_user_monitoring", enable_real_user_monitoring)
        if enable_slow_sql is not None:
            pulumi.set(__self__, "enable_slow_sql", enable_slow_sql)
        if enable_thread_profiler is not None:
            pulumi.set(__self__, "enable_thread_profiler", enable_thread_profiler)
        if end_user_apdex_threshold is not None:
            pulumi.set(__self__, "end_user_apdex_threshold", end_user_apdex_threshold)
        if error_collectors is not None:
            pulumi.set(__self__, "error_collectors", error_collectors)
        if guid is not None:
            pulumi.set(__self__, "guid", guid)
        if is_imported is not None:
            pulumi.set(__self__, "is_imported", is_imported)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tracer_type is not None:
            pulumi.set(__self__, "tracer_type", tracer_type)
        if transaction_tracers is not None:
            pulumi.set(__self__, "transaction_tracers", transaction_tracers)
        if use_server_side_config is not None:
            pulumi.set(__self__, "use_server_side_config", use_server_side_config)

    @_builtins.property
    @pulumi.getter(name="appApdexThreshold")
    def app_apdex_threshold(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The acceptable response time limit (Apdex threshold) for the application.
        """
        return pulumi.get(self, "app_apdex_threshold")

    @app_apdex_threshold.setter
    def app_apdex_threshold(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "app_apdex_threshold", value)

    @_builtins.property
    @pulumi.getter(name="enableRealUserMonitoring")
    def enable_real_user_monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Dummy field to support backward compatibility of previous version.should be removed with next major version.
        """
        return pulumi.get(self, "enable_real_user_monitoring")

    @enable_real_user_monitoring.setter
    def enable_real_user_monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_real_user_monitoring", value)

    @_builtins.property
    @pulumi.getter(name="enableSlowSql")
    def enable_slow_sql(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or disable the collection of slowest database queries in your traces.
        """
        return pulumi.get(self, "enable_slow_sql")

    @enable_slow_sql.setter
    def enable_slow_sql(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_slow_sql", value)

    @_builtins.property
    @pulumi.getter(name="enableThreadProfiler")
    def enable_thread_profiler(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or disable the collection of thread profiling data.
        """
        return pulumi.get(self, "enable_thread_profiler")

    @enable_thread_profiler.setter
    def enable_thread_profiler(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_thread_profiler", value)

    @_builtins.property
    @pulumi.getter(name="endUserApdexThreshold")
    def end_user_apdex_threshold(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Dummy field to support backward compatibility of previous version.should be removed with next major version.
        """
        return pulumi.get(self, "end_user_apdex_threshold")

    @end_user_apdex_threshold.setter
    def end_user_apdex_threshold(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "end_user_apdex_threshold", value)

    @_builtins.property
    @pulumi.getter(name="errorCollectors")
    def error_collectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSettingsErrorCollectorArgs']]]]:
        """
        Configuration block for error collection. Including this block enables the error collector. The following arguments are supported:
        """
        return pulumi.get(self, "error_collectors")

    @error_collectors.setter
    def error_collectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSettingsErrorCollectorArgs']]]]):
        pulumi.set(self, "error_collectors", value)

    @_builtins.property
    @pulumi.getter
    def guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GUID of the application in New Relic APM.

        > **NOTE:** While the attribute `guid` is not mandatory at a schema level, it is recommended to use `guid` over `name`, as support for using `name` with this resource shall eventually be discontinued. Please see the note under `name` for more details.
        """
        return pulumi.get(self, "guid")

    @guid.setter
    def guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guid", value)

    @_builtins.property
    @pulumi.getter(name="isImported")
    def is_imported(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_imported")

    @is_imported.setter
    def is_imported(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_imported", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the application in New Relic.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="tracerType")
    def tracer_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configures the type of tracer used. Valid values are `CROSS_APPLICATION_TRACER`, `DISTRIBUTED_TRACING`, `NONE`, `OPT_OUT`.
        """
        return pulumi.get(self, "tracer_type")

    @tracer_type.setter
    def tracer_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tracer_type", value)

    @_builtins.property
    @pulumi.getter(name="transactionTracers")
    def transaction_tracers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSettingsTransactionTracerArgs']]]]:
        """
        Configuration block for transaction tracer. Providing this block enables transaction tracing. The following arguments are supported:
        """
        return pulumi.get(self, "transaction_tracers")

    @transaction_tracers.setter
    def transaction_tracers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationSettingsTransactionTracerArgs']]]]):
        pulumi.set(self, "transaction_tracers", value)

    @_builtins.property
    @pulumi.getter(name="useServerSideConfig")
    def use_server_side_config(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable or disable server side monitoring for the New Relic application.
        """
        return pulumi.get(self, "use_server_side_config")

    @use_server_side_config.setter
    def use_server_side_config(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_server_side_config", value)


@pulumi.type_token("newrelic:plugins/applicationSettings:ApplicationSettings")
class ApplicationSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_apdex_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 enable_real_user_monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_slow_sql: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_thread_profiler: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_user_apdex_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 error_collectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationSettingsErrorCollectorArgs', 'ApplicationSettingsErrorCollectorArgsDict']]]]] = None,
                 guid: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tracer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 transaction_tracers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationSettingsTransactionTracerArgs', 'ApplicationSettingsTransactionTracerArgsDict']]]]] = None,
                 use_server_side_config: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Import

        Applications can be imported using notation `application_guid`, e.g.

        ```sh
        $ pulumi import newrelic:plugins/applicationSettings:ApplicationSettings main Mzk1NzUyNHQVRJNTxBUE18QVBQTElDc4ODU1MzYx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.float] app_apdex_threshold: The acceptable response time limit (Apdex threshold) for the application.
        :param pulumi.Input[_builtins.bool] enable_real_user_monitoring: Dummy field to support backward compatibility of previous version.should be removed with next major version.
        :param pulumi.Input[_builtins.bool] enable_slow_sql: Enable or disable the collection of slowest database queries in your traces.
        :param pulumi.Input[_builtins.bool] enable_thread_profiler: Enable or disable the collection of thread profiling data.
        :param pulumi.Input[_builtins.float] end_user_apdex_threshold: Dummy field to support backward compatibility of previous version.should be removed with next major version.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationSettingsErrorCollectorArgs', 'ApplicationSettingsErrorCollectorArgsDict']]]] error_collectors: Configuration block for error collection. Including this block enables the error collector. The following arguments are supported:
        :param pulumi.Input[_builtins.str] guid: The GUID of the application in New Relic APM.
               
               > **NOTE:** While the attribute `guid` is not mandatory at a schema level, it is recommended to use `guid` over `name`, as support for using `name` with this resource shall eventually be discontinued. Please see the note under `name` for more details.
        :param pulumi.Input[_builtins.str] name: The name of the application in New Relic.
        :param pulumi.Input[_builtins.str] tracer_type: Configures the type of tracer used. Valid values are `CROSS_APPLICATION_TRACER`, `DISTRIBUTED_TRACING`, `NONE`, `OPT_OUT`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationSettingsTransactionTracerArgs', 'ApplicationSettingsTransactionTracerArgsDict']]]] transaction_tracers: Configuration block for transaction tracer. Providing this block enables transaction tracing. The following arguments are supported:
        :param pulumi.Input[_builtins.bool] use_server_side_config: Enable or disable server side monitoring for the New Relic application.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ApplicationSettingsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Applications can be imported using notation `application_guid`, e.g.

        ```sh
        $ pulumi import newrelic:plugins/applicationSettings:ApplicationSettings main Mzk1NzUyNHQVRJNTxBUE18QVBQTElDc4ODU1MzYx
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_apdex_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 enable_real_user_monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_slow_sql: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_thread_profiler: Optional[pulumi.Input[_builtins.bool]] = None,
                 end_user_apdex_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 error_collectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationSettingsErrorCollectorArgs', 'ApplicationSettingsErrorCollectorArgsDict']]]]] = None,
                 guid: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tracer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 transaction_tracers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationSettingsTransactionTracerArgs', 'ApplicationSettingsTransactionTracerArgsDict']]]]] = None,
                 use_server_side_config: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationSettingsArgs.__new__(ApplicationSettingsArgs)

            __props__.__dict__["app_apdex_threshold"] = app_apdex_threshold
            __props__.__dict__["enable_real_user_monitoring"] = enable_real_user_monitoring
            __props__.__dict__["enable_slow_sql"] = enable_slow_sql
            __props__.__dict__["enable_thread_profiler"] = enable_thread_profiler
            __props__.__dict__["end_user_apdex_threshold"] = end_user_apdex_threshold
            __props__.__dict__["error_collectors"] = error_collectors
            __props__.__dict__["guid"] = guid
            __props__.__dict__["name"] = name
            __props__.__dict__["tracer_type"] = tracer_type
            __props__.__dict__["transaction_tracers"] = transaction_tracers
            __props__.__dict__["use_server_side_config"] = use_server_side_config
            __props__.__dict__["is_imported"] = None
        super(ApplicationSettings, __self__).__init__(
            'newrelic:plugins/applicationSettings:ApplicationSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_apdex_threshold: Optional[pulumi.Input[_builtins.float]] = None,
            enable_real_user_monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_slow_sql: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_thread_profiler: Optional[pulumi.Input[_builtins.bool]] = None,
            end_user_apdex_threshold: Optional[pulumi.Input[_builtins.float]] = None,
            error_collectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationSettingsErrorCollectorArgs', 'ApplicationSettingsErrorCollectorArgsDict']]]]] = None,
            guid: Optional[pulumi.Input[_builtins.str]] = None,
            is_imported: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            tracer_type: Optional[pulumi.Input[_builtins.str]] = None,
            transaction_tracers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationSettingsTransactionTracerArgs', 'ApplicationSettingsTransactionTracerArgsDict']]]]] = None,
            use_server_side_config: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ApplicationSettings':
        """
        Get an existing ApplicationSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.float] app_apdex_threshold: The acceptable response time limit (Apdex threshold) for the application.
        :param pulumi.Input[_builtins.bool] enable_real_user_monitoring: Dummy field to support backward compatibility of previous version.should be removed with next major version.
        :param pulumi.Input[_builtins.bool] enable_slow_sql: Enable or disable the collection of slowest database queries in your traces.
        :param pulumi.Input[_builtins.bool] enable_thread_profiler: Enable or disable the collection of thread profiling data.
        :param pulumi.Input[_builtins.float] end_user_apdex_threshold: Dummy field to support backward compatibility of previous version.should be removed with next major version.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationSettingsErrorCollectorArgs', 'ApplicationSettingsErrorCollectorArgsDict']]]] error_collectors: Configuration block for error collection. Including this block enables the error collector. The following arguments are supported:
        :param pulumi.Input[_builtins.str] guid: The GUID of the application in New Relic APM.
               
               > **NOTE:** While the attribute `guid` is not mandatory at a schema level, it is recommended to use `guid` over `name`, as support for using `name` with this resource shall eventually be discontinued. Please see the note under `name` for more details.
        :param pulumi.Input[_builtins.str] name: The name of the application in New Relic.
        :param pulumi.Input[_builtins.str] tracer_type: Configures the type of tracer used. Valid values are `CROSS_APPLICATION_TRACER`, `DISTRIBUTED_TRACING`, `NONE`, `OPT_OUT`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationSettingsTransactionTracerArgs', 'ApplicationSettingsTransactionTracerArgsDict']]]] transaction_tracers: Configuration block for transaction tracer. Providing this block enables transaction tracing. The following arguments are supported:
        :param pulumi.Input[_builtins.bool] use_server_side_config: Enable or disable server side monitoring for the New Relic application.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationSettingsState.__new__(_ApplicationSettingsState)

        __props__.__dict__["app_apdex_threshold"] = app_apdex_threshold
        __props__.__dict__["enable_real_user_monitoring"] = enable_real_user_monitoring
        __props__.__dict__["enable_slow_sql"] = enable_slow_sql
        __props__.__dict__["enable_thread_profiler"] = enable_thread_profiler
        __props__.__dict__["end_user_apdex_threshold"] = end_user_apdex_threshold
        __props__.__dict__["error_collectors"] = error_collectors
        __props__.__dict__["guid"] = guid
        __props__.__dict__["is_imported"] = is_imported
        __props__.__dict__["name"] = name
        __props__.__dict__["tracer_type"] = tracer_type
        __props__.__dict__["transaction_tracers"] = transaction_tracers
        __props__.__dict__["use_server_side_config"] = use_server_side_config
        return ApplicationSettings(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appApdexThreshold")
    def app_apdex_threshold(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        The acceptable response time limit (Apdex threshold) for the application.
        """
        return pulumi.get(self, "app_apdex_threshold")

    @_builtins.property
    @pulumi.getter(name="enableRealUserMonitoring")
    def enable_real_user_monitoring(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Dummy field to support backward compatibility of previous version.should be removed with next major version.
        """
        return pulumi.get(self, "enable_real_user_monitoring")

    @_builtins.property
    @pulumi.getter(name="enableSlowSql")
    def enable_slow_sql(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable or disable the collection of slowest database queries in your traces.
        """
        return pulumi.get(self, "enable_slow_sql")

    @_builtins.property
    @pulumi.getter(name="enableThreadProfiler")
    def enable_thread_profiler(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable or disable the collection of thread profiling data.
        """
        return pulumi.get(self, "enable_thread_profiler")

    @_builtins.property
    @pulumi.getter(name="endUserApdexThreshold")
    def end_user_apdex_threshold(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        Dummy field to support backward compatibility of previous version.should be removed with next major version.
        """
        return pulumi.get(self, "end_user_apdex_threshold")

    @_builtins.property
    @pulumi.getter(name="errorCollectors")
    def error_collectors(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationSettingsErrorCollector']]]:
        """
        Configuration block for error collection. Including this block enables the error collector. The following arguments are supported:
        """
        return pulumi.get(self, "error_collectors")

    @_builtins.property
    @pulumi.getter
    def guid(self) -> pulumi.Output[_builtins.str]:
        """
        The GUID of the application in New Relic APM.

        > **NOTE:** While the attribute `guid` is not mandatory at a schema level, it is recommended to use `guid` over `name`, as support for using `name` with this resource shall eventually be discontinued. Please see the note under `name` for more details.
        """
        return pulumi.get(self, "guid")

    @_builtins.property
    @pulumi.getter(name="isImported")
    def is_imported(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "is_imported")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the application in New Relic.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="tracerType")
    def tracer_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Configures the type of tracer used. Valid values are `CROSS_APPLICATION_TRACER`, `DISTRIBUTED_TRACING`, `NONE`, `OPT_OUT`.
        """
        return pulumi.get(self, "tracer_type")

    @_builtins.property
    @pulumi.getter(name="transactionTracers")
    def transaction_tracers(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationSettingsTransactionTracer']]]:
        """
        Configuration block for transaction tracer. Providing this block enables transaction tracing. The following arguments are supported:
        """
        return pulumi.get(self, "transaction_tracers")

    @_builtins.property
    @pulumi.getter(name="useServerSideConfig")
    def use_server_side_config(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable or disable server side monitoring for the New Relic application.
        """
        return pulumi.get(self, "use_server_side_config")

