from typing import Any, Dict, List, Optional

# 设置动作抖动值（像素，随屏幕 scale 适配）
def set_jitter_value(value: int) -> bool: ...

# 点击
# 参数：x/y 坐标；duration 持续时间（ms）；jitter 是否启用抖动
def click(x: int, y: int, duration: int, jitter: bool) -> bool: ...

# 随机点击指定矩形区域
def click_random(x1: int, y1: int, x2: int, y2: int, duration: int) -> bool: ...

# 双击
# 参数：duration 持续时间；interval 间隔时间（ms）；jitter 是否抖动
def double_click(x: int, y: int, duration: int, interval: int, jitter: bool) -> bool: ...

# 随机双击指定区域
def double_click_random(x1: int, y1: int, x2: int, y2: int, duration: int, interval: int) -> bool: ...

# 直线滑动
# 参数：起点 x/y；终点 ex/ey；duration 总时长；jitter 抖动；steps 轨迹点数
def swipe(startX: int, startY: int, endX: int, endY: int, duration: int, jitter: bool, steps: int) -> bool: ...

# 长按并滑动
# 参数：touch_* 三段时长（ms）；steps 步数
def press_and_swipe(startX: int, startY: int, endX: int, endY: int, touch_down_duration: int, touch_move_duration: int, touch_up_duration: int, jitter: bool, steps: int) -> bool: ...

# 3点曲线滑动（先快后慢）
def swipe_curve(startX: int, startY: int, midX: int, midY: int, endX: int, endY: int, duration: int) -> bool: ...

# 输入英文文本（不支持中文）
def input(text: str) -> bool: ...

# 删除文本（count 默认 1）
def backspace(count: int) -> bool: ...

# 回车
def enter() -> bool: ...

# 回到主屏幕
def home_screen() -> bool: ...

# 按按钮（home/volumeup/volumedown 等）
def press_button(button: str) -> bool: ...

# 按 HID 按钮（power/snapshot 等），可指定时长
def press_hid_button(button: str, duration: int) -> bool: ...

# 链式 ActionBuilder
class Pointer:
    def move_to(self, x: int, y: int, duration: int) -> "Pointer": ...
    def down(self) -> "Pointer": ...
    def up(self) -> "Pointer": ...
    def stay(self, duration: int) -> "Pointer": ...
    def tap(self, x: int, y: int, duration: int) -> "Pointer": ...
    def done(self) -> "ActionBuilder": ...

class ActionBuilder:
    def add_pointer(self, id: int) -> Pointer: ...
    def single_tap(self, x: int, y: int, duration: int) -> "ActionBuilder": ...
    def multi_tap(self, points: List[Dict[str, int]], duration: int) -> "ActionBuilder": ...
    def execute(self) -> bool: ...

def create_builder() -> ActionBuilder: ...