from typing import Any, Dict, List, Optional

# OCR 识别（Apple Vision）
# 参数：
# - input: 输入源（imageId、URL字符串、文件路径或 "screen"）
# - x: 边界框左上角 x 坐标
# - y: 边界框左上角 y 坐标
# - ex: 边界框右下角 x 坐标
# - ey: 边界框右下角 y 坐标
# - languages: 识别语言数组，例如 ["zh-Hans", "en-US"]
# 返回：包含文本、置信度与位置信息的字典列表
def recognize(input: str, x: int, y: int, ex: int, ey: int, languages: Optional[List[str]] = ...) -> List[Dict[str, Any]]: ...

# 纯数字 OCR 识别
# 参数：同上，过滤非数字，仅保留 0-9 . , - +
# 返回：数字文本结果列表（含位置信息）
def recognize_numbers(input: str, x: int, y: int, ex: int, ey: int) -> List[Dict[str, Any]]: ...

# 查找包含目标文本的位置
# 参数：
# - input: 输入源（imageId、URL字符串、文件路径或 "screen"）
# - targetTexts: 要查找的目标文本数组
# - x/y/ex/ey: 搜索区域边界框
# - languages: 识别语言数组（可选）
# 返回：匹配到的文本位置信息列表
def find_text(input: str, targetTexts: List[str], x: int, y: int, ex: int, ey: int, languages: Optional[List[str]] = ...) -> List[Dict[str, Any]]: ...