from typing import Dict

class ScreenSize:
    width: float
    height: float
    def __init__(self, *, width: float, height: float) -> None: ...

class BatteryInfo:
    level: int
    isCharging: bool
    def __init__(self, *, level: int, isCharging: bool) -> None: ...

# 获取电池信息
# 返回：{"level": 百分比int, "isCharging": 是否充电bool}
def get_battery_info() -> BatteryInfo: ...

# 获取设备ID（Vendor ID）
def get_device_id() -> str: ...

# 获取服务器设备ID（自定义）
def get_server_device_id() -> str: ...

# 获取设备名称
def get_device_name() -> str: ...

# 获取设备型号（硬件型号）
def get_device_model() -> str: ...

# 获取屏幕逻辑尺寸
# 返回：{"width": float, "height": float}
def get_screen_size() -> ScreenSize: ...

# 获取屏幕实际尺寸
# 返回：{"width": float, "height": float}
def get_screen_real_size() -> ScreenSize: ...

# 获取屏幕缩放比例
def get_screen_scale() -> float: ...

# 获取屏幕方向
def get_orientation() -> str: ...

# 获取系统版本
def get_os_version() -> str: ...

# 获取局域网IP
def get_lan_ip() -> str: ...

# 震动
# 参数：duration 毫秒；intensity 0.0-1.0
def vibrate(duration: int, intensity: float) -> bool: ...