from typing import List, Optional

# 获取内部目录
# 参数：type = documents | library | temp | libraryCaches
def get_internal_dir(type: str) -> str: ...

# 获取数据目录
def get_data_dir() -> str: ...

# 获取数据文件路径
# 参数：file = 文件名
def get_data_file(file: str) -> str: ...

# 创建文件
def create(path: str) -> bool: ...

# 递归创建目录
def mkdirs(path: str) -> bool: ...

# 删除文件或目录（谨慎）
def delete_all_file(path: str) -> bool: ...

# 读取文件内容（UTF-8）
def read_file(path: str) -> Optional[str]: ...

# 读取资源文件内容（UTF-8）
def read_res_file(fileName: str) -> Optional[str]: ...

# 删除指定行或包含关键字的行
# 参数：line >=0 删除行号；line <0 且 contains 指定关键字
def delete_line(path: str, line: int, contains: str) -> bool: ...

# 列出目录文件
# 参数：recursion 是否递归
def list_dir(path: str, recursion: bool) -> List[str]: ...

# 写入文件（覆盖，UTF-8）
def write_file(path: str, data: str) -> bool: ...

# 追加一行（UTF-8）
def append_line(path: str, data: str) -> bool: ...

# 读取指定行（0 基）
def read_line(path: str, lineNo: int) -> Optional[str]: ...

# 读取所有行
def read_all_lines(path: str) -> Optional[List[str]]: ...

# 文件是否存在
def exists(path: str) -> bool: ...

# 复制文件
def copy(src: str, dest: str) -> bool: ...

# 计算文件 MD5（十六进制字符串）
def file_md5(path: str) -> Optional[str]: ...