from typing import Any, Dict, List, Optional

# 设置动作抖动值（像素，随屏幕 scale 适配）
def set_jitter_value(value: int) -> None: ...

# 重置坐标系方向（如 "portrait" | "landscape"）
def reset_position(orientation: str) -> None: ...

# 点击
# 参数：x/y 坐标；duration 持续时间（ms）；jitter 是否启用抖动
def click(x: int, y: int, duration: int, jitter: bool) -> bool: ...

# 随机点击指定矩形区域
def click_random(x1: int, y1: int, x2: int, y2: int, duration: int) -> bool: ...

# 双击
# 参数：duration 持续时间；interval 间隔时间（ms）；jitter 是否抖动
def double_click(x: int, y: int, duration: int, interval: int, jitter: bool) -> bool: ...

# 随机双击指定区域
def double_click_random(x1: int, y1: int, x2: int, y2: int, duration: int, interval: int) -> bool: ...

# 直线滑动
# 参数：起点 x/y；终点 ex/ey；jitter 抖动；steps 轨迹点数
def swipe(x: int, y: int, ex: int, ey: int, jitter: bool, steps: int) -> bool: ...

# 3 点曲线滑动（先快后慢）
def swipe_curve(startX: int, startY: int, midX: int, midY: int, endX: int, endY: int) -> bool: ...

# 回主页（Command+H）
def home_screen() -> bool: ...

# 输入简单键盘数据（仅英文与可输入键；不支持中文）
def input_simple(data: str) -> bool: ...

# 空格/删除/回车
def space() -> bool: ...
def backspace() -> bool: ...
def enter() -> bool: ...

# 发送组合按键（支持 Int 或字符）
def send_key(keys: List[Any]) -> bool: ...

# 复制/粘贴/返回/最近应用/锁屏/解锁
def copy_text() -> bool: ...
def paste_text() -> bool: ...
def back() -> bool: ...
def recent() -> bool: ...
def lock() -> bool: ...
def unlock() -> bool: ...

# 打开 URL / App；切到前台
def open_url(url: str) -> bool: ...
def open_app(name: str) -> bool: ...
def take_me_to_front() -> bool: ...

# 当前应用信息（仅 IOS18+）
def current_app_info() -> Optional[Dict[str, str]]: ...

# 剪切板读写
def set_clipboard(text: str) -> bool: ...
def get_clipboard() -> str: ...

# 执行自定义按钮（1-11）
def custom_button(button: int) -> bool: ...