from typing import Any, Dict, List, Optional

# 截取全屏并返回图片ID
def capture_full_screen() -> Optional[str]: ...

# 截取屏幕区域并返回图片ID
# 参数：x/y 左上角；ex/ey 右下角
def capture_rect(x: int, y: int, ex: int, ey: int) -> Optional[str]: ...

# 读取图片文件为图片ID
def read_image(path: str) -> Optional[str]: ...

# 裁剪图片并返回新的图片ID
def clip(id: str, x: int, y: int, ex: int, ey: int) -> Optional[str]: ...

# 获取图片尺寸信息 {width,height}
def get_size(id: str) -> Optional[Dict[str, int]]: ...

# 图片转 base64（format: jpg|png；q: 质量1-100，仅jpg）
def to_base64_format(id: str, format: str, q: int) -> Optional[str]: ...

# base64 转图片ID
def base64_to_image(base64data: str) -> Optional[str]: ...

# 图片是否被释放
def is_release(id: str) -> bool: ...

# 释放图片/全部图片
def release(id: str) -> None: ...
def release_all() -> None: ...

# 保存图片到路径
def save_to(id: str, path: str) -> bool: ...

# 旋转图片（degree: 90 | -90 | 180）返回新ID
def rotate_image(id: str, degree: int) -> Optional[str]: ...

# 多点比色（points: "x|y|主色-偏色,..."；threshold: 0.0-1.0；区域 x/y/ex/ey）
def cmp_color(id: str, points: str, threshold: float, x: int, y: int, ex: int, ey: int) -> bool: ...

# 单点找色（返回点坐标列表）
def find_color(id: str, color: str, threshold: float, x: int, y: int, ex: int, ey: int, limit: int, orz: int) -> List[Dict[str, Any]]: ...

# 多点找色（返回点坐标列表）
def find_multi_color(id: str, firstColor: str, threshold: float, points: str, x: int, y: int, ex: int, ey: int, limit: int, orz: int) -> List[Dict[str, Any]]: ...

# 找图（返回矩形列表）
def find_image(id: str, templateImageId: str, x: int, y: int, ex: int, ey: int, threshold: float, limit: int, method: int, rgb: bool) -> List[Dict[str, Any]]: ...

# 获取像素颜色（返回整数RGB）
def pixel(id: str, x: int, y: int) -> int: ...

# 颜色值转16进制字符串（#RRGGBB）
def argb(color: int) -> str: ...

# 二值化/灰度化图片（返回新ID）
def binaryzation(id: str, threshold: float) -> Optional[str]: ...
def gray(id: str) -> Optional[str]: ...

# 扫描条码/二维码（返回识别文本）
def scan_code(id: str) -> Optional[str]: ...

# 在图片上绘制矩形（直接修改原图）
def draw_rect(id: str, x: int, y: int, ex: int, ey: int, color: str, thickness: int) -> bool: ...