from typing import Any, Dict, List, Optional

class Selector:
    # 释放并移除选择器
    def release(self) -> bool: ...

    # 清空所有选择条件（链式返回 self）
    def clear_selector(self) -> "Selector": ...

    # 加载节点数据（timeout 毫秒，默认 5000，链式返回 self）
    def load_node(self, timeout: int = 5000) -> "Selector": ...

    # 获取 XML 文本（timeout 毫秒）
    def xml(self, timeout: int = 5000) -> Optional[str]: ...

    # 获取所有/一个节点信息
    def get_node_info(self, timeout: int = 5000) -> List[Dict[str, Any]]: ...
    def get_one_node_info(self, timeout: int = 5000) -> Optional[Dict[str, Any]]: ...

    # 条件构建（均链式返回 self）
    def xpath(self, path: str) -> "Selector": ...
    def label(self, label: str) -> "Selector": ...
    def label_match(self, match: str) -> "Selector": ...
    def name(self, name: str) -> "Selector": ...
    def name_match(self, match: str) -> "Selector": ...
    def type(self, type_name: str) -> "Selector": ...
    def type_match(self, match: str) -> "Selector": ...
    def value(self, value: str) -> "Selector": ...
    def value_match(self, match: str) -> "Selector": ...
    def enable(self, flag: bool) -> "Selector": ...
    def accessible(self, flag: bool) -> "Selector": ...
    def visible(self, flag: bool) -> "Selector": ...
    def selected(self, flag: bool) -> "Selector": ...
    def index(self, idx: int) -> "Selector": ...
    def depth(self, d: int) -> "Selector": ...
    def child_count(self, expr: str) -> "Selector": ...
    def bounds(self, x: int, y: int, width: int, height: int) -> "Selector": ...

# 创建节点选择器（返回链式 Selector）
# 参数：visibleFilter/labelFilter/boundsFilter/maxDepth/maxChildCount/excludedAttributes
def create_selector(params: Dict[str, Any]) -> Selector: ...

class NodeBounds:
    x: int
    y: int
    width: int
    height: int
    centerX: int
    centerY: int

class NodeInfo:
    id: str
    label: str
    type: str
    value: str
    name: str
    visible: bool
    enabled: bool
    accessible: bool
    selected: bool
    bounds: NodeBounds
    depth: int
    index: int
    parentId: str
    childCount: int

    def clickCenter(self) -> bool: ...
    def clickRandom(self) -> bool: ...
    def parent(self) -> Optional["NodeInfo"]: ...
    def child(self, index: int) -> Optional["NodeInfo"]: ...
    def allChildren(self) -> List["NodeInfo"]: ...
    def siblings(self) -> List["NodeInfo"]: ...
    def previousSiblings(self) -> List["NodeInfo"]: ...
    def nextSiblings(self) -> List["NodeInfo"]: ...
    def toJSON(self) -> Dict[str, Any]: ...