from typing import Any, Dict, List, Optional

# 启动应用
# 参数：
# - bundle_id: 应用的 Bundle ID，例如 "com.example.app"
# - args: 启动参数列表，例如 ["--flag", "--debug"]
# - env: 环境变量映射，例如 {"ENV": "1"}
def start_app(bundle_id: str, args: List[str], env: Dict[str, str]) -> bool: ...

# 停止应用
# 参数：
# - bundle_id: 应用的 Bundle ID
def stop_app(bundle_id: str) -> bool: ...

# 激活应用到前台
# 参数：
# - bundle_id: 应用的 Bundle ID
def activate_app(bundle_id: str) -> bool: ...

# 使用系统浏览器打开 URL
# 参数：
# - url: 例如 "https://example.com"
def open_url(url: str) -> bool: ...

# 发送系统通知（后台生效）
# 参数：
# - msg: 通知内容
# - title: 通知标题，空或 "undefined" 时使用应用名称
# - id: 通知 ID，相同 ID 会覆盖
def notify(msg: str, title: str, id: str) -> bool: ...

# 设置剪贴板文本（仅前台有效）
# 参数：
# - text: 要写入剪贴板的文本
def set_clipboard(text: str) -> bool: ...

# 获取剪贴板文本（仅前台有效）
def get_clipboard() -> str: ...

# 是否锁屏
def is_locked() -> bool: ...

# 锁屏
def lock() -> bool: ...

# 解锁
def unlock() -> bool: ...

# 获取内存使用信息（单位：MB）
# 返回键：
# - used: 已使用内存
# - available: 可用内存
# - total: 系统总内存
# - usagePercentage: 使用率（0-100）
class MemoryInfo:
    used: int
    available: int
    total: int
    usagePercentage: int
    def __init__(self, *, used: int, available: int, total: int, usagePercentage: int) -> None: ...

def get_memory_info() -> MemoryInfo: ...

# 获取已使用内存（MB）
def get_used_memory() -> int: ...

# 获取可用内存（MB）
def get_available_memory() -> int: ...

# 获取系统总内存（MB）
def get_total_memory() -> int: ...

# 启动 WDA 服务
def start_wda() -> bool: ...

# 获取 WDA 状态（是否可用）
def get_wda_status() -> bool: ...

# 设置 WDA 参数
# 参数：
# - params: 支持的键：
#   - mjpegServerScreenshotQuality: int 截图质量（MJPEG）
#   - mjpegServerFramerate: int MJPEG 帧率
#   - screenshotQuality: int 普通截图质量
def set_wda_settings(params: Dict[str, Any]) -> bool: ...

# 获取当前运行的应用信息（可能为 None）
class ActivateAppInfo:
    name: str
    pid: int
    bundleId: str
    processArguments: "ProcessArguments"
    def __init__(self, *, name: str, pid: int, bundleId: str, processArguments: "ProcessArguments") -> None: ...

class ProcessArguments:
    env: Dict[str, str]
    args: List[str]
    def __init__(self, *, env: Dict[str, str], args: List[str]) -> None: ...

def activate_app_info() -> Optional[ActivateAppInfo]: ...