# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['ClusterAlertRule']


class ClusterAlertRule(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 event_rule: Optional[pulumi.Input[pulumi.InputType['ClusterAlertRuleEventRuleArgs']]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 group_interval_seconds: Optional[pulumi.Input[float]] = None,
                 group_wait_seconds: Optional[pulumi.Input[float]] = None,
                 inherited: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 metric_rule: Optional[pulumi.Input[pulumi.InputType['ClusterAlertRuleMetricRuleArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_rule: Optional[pulumi.Input[pulumi.InputType['ClusterAlertRuleNodeRuleArgs']]] = None,
                 repeat_interval_seconds: Optional[pulumi.Input[float]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 system_service_rule: Optional[pulumi.Input[pulumi.InputType['ClusterAlertRuleSystemServiceRuleArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a Rancher v2 Cluster Alert Rule resource. This can be used to create Cluster Alert Rule for Rancher v2 environments and retrieve their information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new Rancher2 Cluster Alert Group
        foo_cluster_alert_group = rancher2.ClusterAlertGroup("fooClusterAlertGroup",
            cluster_id="<cluster_id>",
            description="Terraform cluster alert group",
            group_interval_seconds=300,
            repeat_interval_seconds=3600)
        # Create a new Rancher2 Cluster Alert Rule
        foo_cluster_alert_rule = rancher2.ClusterAlertRule("fooClusterAlertRule",
            cluster_id=foo_cluster_alert_group.cluster_id,
            group_id=foo_cluster_alert_group.id,
            group_interval_seconds=600,
            repeat_interval_seconds=6000)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] annotations: The cluster alert rule annotations (map)
        :param pulumi.Input[str] cluster_id: The cluster id where create cluster alert rule (string)
        :param pulumi.Input[pulumi.InputType['ClusterAlertRuleEventRuleArgs']] event_rule: The cluster alert rule event rule. ConflictsWith: `"metric_rule", "node_rule", "system_service_rule"`` (list Maxitems:1)
        :param pulumi.Input[str] group_id: The cluster alert rule alert group ID (string)
        :param pulumi.Input[float] group_interval_seconds: The cluster alert rule group interval seconds. Default: `180` (int)
        :param pulumi.Input[float] group_wait_seconds: The cluster alert rule group wait seconds. Default: `180` (int)
        :param pulumi.Input[bool] inherited: The cluster alert rule inherited. Default: `true` (bool)
        :param pulumi.Input[Mapping[str, Any]] labels: The cluster alert rule labels (map)
        :param pulumi.Input[pulumi.InputType['ClusterAlertRuleMetricRuleArgs']] metric_rule: The cluster alert rule metric rule. ConflictsWith: `"event_rule", "node_rule", "system_service_rule"`` (list Maxitems:1)
        :param pulumi.Input[str] name: The cluster alert rule name (string)
        :param pulumi.Input[pulumi.InputType['ClusterAlertRuleNodeRuleArgs']] node_rule: The cluster alert rule node rule. ConflictsWith: `"event_rule", "metric_rule", "system_service_rule"`` (list Maxitems:1)
        :param pulumi.Input[float] repeat_interval_seconds: The cluster alert rule wait seconds. Default: `3600` (int)
        :param pulumi.Input[str] severity: The cluster alert rule severity. Supported values : `"critical" | "info" | "warning"`. Default: `critical` (string)
        :param pulumi.Input[pulumi.InputType['ClusterAlertRuleSystemServiceRuleArgs']] system_service_rule: The cluster alert rule system service rule. ConflictsWith: `"event_rule", "metric_rule", "node_rule"` (list Maxitems:1)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['annotations'] = annotations
            if cluster_id is None:
                raise TypeError("Missing required property 'cluster_id'")
            __props__['cluster_id'] = cluster_id
            __props__['event_rule'] = event_rule
            if group_id is None:
                raise TypeError("Missing required property 'group_id'")
            __props__['group_id'] = group_id
            __props__['group_interval_seconds'] = group_interval_seconds
            __props__['group_wait_seconds'] = group_wait_seconds
            __props__['inherited'] = inherited
            __props__['labels'] = labels
            __props__['metric_rule'] = metric_rule
            __props__['name'] = name
            __props__['node_rule'] = node_rule
            __props__['repeat_interval_seconds'] = repeat_interval_seconds
            __props__['severity'] = severity
            __props__['system_service_rule'] = system_service_rule
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="rancher2:index/clusterAlterRule:ClusterAlterRule")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ClusterAlertRule, __self__).__init__(
            'rancher2:index/clusterAlertRule:ClusterAlertRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            event_rule: Optional[pulumi.Input[pulumi.InputType['ClusterAlertRuleEventRuleArgs']]] = None,
            group_id: Optional[pulumi.Input[str]] = None,
            group_interval_seconds: Optional[pulumi.Input[float]] = None,
            group_wait_seconds: Optional[pulumi.Input[float]] = None,
            inherited: Optional[pulumi.Input[bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            metric_rule: Optional[pulumi.Input[pulumi.InputType['ClusterAlertRuleMetricRuleArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_rule: Optional[pulumi.Input[pulumi.InputType['ClusterAlertRuleNodeRuleArgs']]] = None,
            repeat_interval_seconds: Optional[pulumi.Input[float]] = None,
            severity: Optional[pulumi.Input[str]] = None,
            system_service_rule: Optional[pulumi.Input[pulumi.InputType['ClusterAlertRuleSystemServiceRuleArgs']]] = None) -> 'ClusterAlertRule':
        """
        Get an existing ClusterAlertRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] annotations: The cluster alert rule annotations (map)
        :param pulumi.Input[str] cluster_id: The cluster id where create cluster alert rule (string)
        :param pulumi.Input[pulumi.InputType['ClusterAlertRuleEventRuleArgs']] event_rule: The cluster alert rule event rule. ConflictsWith: `"metric_rule", "node_rule", "system_service_rule"`` (list Maxitems:1)
        :param pulumi.Input[str] group_id: The cluster alert rule alert group ID (string)
        :param pulumi.Input[float] group_interval_seconds: The cluster alert rule group interval seconds. Default: `180` (int)
        :param pulumi.Input[float] group_wait_seconds: The cluster alert rule group wait seconds. Default: `180` (int)
        :param pulumi.Input[bool] inherited: The cluster alert rule inherited. Default: `true` (bool)
        :param pulumi.Input[Mapping[str, Any]] labels: The cluster alert rule labels (map)
        :param pulumi.Input[pulumi.InputType['ClusterAlertRuleMetricRuleArgs']] metric_rule: The cluster alert rule metric rule. ConflictsWith: `"event_rule", "node_rule", "system_service_rule"`` (list Maxitems:1)
        :param pulumi.Input[str] name: The cluster alert rule name (string)
        :param pulumi.Input[pulumi.InputType['ClusterAlertRuleNodeRuleArgs']] node_rule: The cluster alert rule node rule. ConflictsWith: `"event_rule", "metric_rule", "system_service_rule"`` (list Maxitems:1)
        :param pulumi.Input[float] repeat_interval_seconds: The cluster alert rule wait seconds. Default: `3600` (int)
        :param pulumi.Input[str] severity: The cluster alert rule severity. Supported values : `"critical" | "info" | "warning"`. Default: `critical` (string)
        :param pulumi.Input[pulumi.InputType['ClusterAlertRuleSystemServiceRuleArgs']] system_service_rule: The cluster alert rule system service rule. ConflictsWith: `"event_rule", "metric_rule", "node_rule"` (list Maxitems:1)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["annotations"] = annotations
        __props__["cluster_id"] = cluster_id
        __props__["event_rule"] = event_rule
        __props__["group_id"] = group_id
        __props__["group_interval_seconds"] = group_interval_seconds
        __props__["group_wait_seconds"] = group_wait_seconds
        __props__["inherited"] = inherited
        __props__["labels"] = labels
        __props__["metric_rule"] = metric_rule
        __props__["name"] = name
        __props__["node_rule"] = node_rule
        __props__["repeat_interval_seconds"] = repeat_interval_seconds
        __props__["severity"] = severity
        __props__["system_service_rule"] = system_service_rule
        return ClusterAlertRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        The cluster alert rule annotations (map)
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The cluster id where create cluster alert rule (string)
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="eventRule")
    def event_rule(self) -> pulumi.Output[Optional['outputs.ClusterAlertRuleEventRule']]:
        """
        The cluster alert rule event rule. ConflictsWith: `"metric_rule", "node_rule", "system_service_rule"`` (list Maxitems:1)
        """
        return pulumi.get(self, "event_rule")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[str]:
        """
        The cluster alert rule alert group ID (string)
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupIntervalSeconds")
    def group_interval_seconds(self) -> pulumi.Output[Optional[float]]:
        """
        The cluster alert rule group interval seconds. Default: `180` (int)
        """
        return pulumi.get(self, "group_interval_seconds")

    @property
    @pulumi.getter(name="groupWaitSeconds")
    def group_wait_seconds(self) -> pulumi.Output[Optional[float]]:
        """
        The cluster alert rule group wait seconds. Default: `180` (int)
        """
        return pulumi.get(self, "group_wait_seconds")

    @property
    @pulumi.getter
    def inherited(self) -> pulumi.Output[Optional[bool]]:
        """
        The cluster alert rule inherited. Default: `true` (bool)
        """
        return pulumi.get(self, "inherited")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        The cluster alert rule labels (map)
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="metricRule")
    def metric_rule(self) -> pulumi.Output[Optional['outputs.ClusterAlertRuleMetricRule']]:
        """
        The cluster alert rule metric rule. ConflictsWith: `"event_rule", "node_rule", "system_service_rule"`` (list Maxitems:1)
        """
        return pulumi.get(self, "metric_rule")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The cluster alert rule name (string)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeRule")
    def node_rule(self) -> pulumi.Output[Optional['outputs.ClusterAlertRuleNodeRule']]:
        """
        The cluster alert rule node rule. ConflictsWith: `"event_rule", "metric_rule", "system_service_rule"`` (list Maxitems:1)
        """
        return pulumi.get(self, "node_rule")

    @property
    @pulumi.getter(name="repeatIntervalSeconds")
    def repeat_interval_seconds(self) -> pulumi.Output[Optional[float]]:
        """
        The cluster alert rule wait seconds. Default: `3600` (int)
        """
        return pulumi.get(self, "repeat_interval_seconds")

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Output[Optional[str]]:
        """
        The cluster alert rule severity. Supported values : `"critical" | "info" | "warning"`. Default: `critical` (string)
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter(name="systemServiceRule")
    def system_service_rule(self) -> pulumi.Output[Optional['outputs.ClusterAlertRuleSystemServiceRule']]:
        """
        The cluster alert rule system service rule. ConflictsWith: `"event_rule", "metric_rule", "node_rule"` (list Maxitems:1)
        """
        return pulumi.get(self, "system_service_rule")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

