# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['ClusterTemplate']


class ClusterTemplate(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 members: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['ClusterTemplateMemberArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 template_revisions: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['ClusterTemplateTemplateRevisionArgs']]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a Rancher v2 Cluster Template resource. This can be used to create Cluster Templates for Rancher v2 RKE clusters and retrieve their information.

        Cluster Templates are available from Rancher v2.3.x and above.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Cluster Template
        foo = rancher2.ClusterTemplate("foo",
            description="Terraform cluster template foo",
            members=[rancher2.ClusterTemplateMemberArgs(
                access_type="owner",
                user_principal_id="local://user-XXXXX",
            )],
            template_revisions=[rancher2.ClusterTemplateTemplateRevisionArgs(
                cluster_config=rancher2.ClusterTemplateTemplateRevisionClusterConfigArgs(
                    rke_config={
                        "network": {
                            "plugin": "canal",
                        },
                        "services": {
                            "etcd": {
                                "creation": "6h",
                                "retention": "24h",
                            },
                        },
                    },
                ),
                default=True,
                name="V1",
            )])
        ```

        Creating Rancher v2 RKE cluster template with upgrade strategy. For Rancher v2.4.x or above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Cluster Template
        foo = rancher2.ClusterTemplate("foo",
            description="Terraform cluster template foo",
            members=[rancher2.ClusterTemplateMemberArgs(
                access_type="owner",
                user_principal_id="local://user-XXXXX",
            )],
            template_revisions=[rancher2.ClusterTemplateTemplateRevisionArgs(
                cluster_config=rancher2.ClusterTemplateTemplateRevisionClusterConfigArgs(
                    rke_config={
                        "network": {
                            "plugin": "canal",
                        },
                        "services": {
                            "etcd": {
                                "creation": "6h",
                                "retention": "24h",
                            },
                        },
                        "upgrade_strategy": {
                            "drain": True,
                            "maxUnavailableWorker": "20%",
                        },
                    },
                ),
                default=True,
                name="V1",
            )])
        ```

        Creating Rancher v2 RKE cluster template with scheduled cluster scan. For Rancher v2.4.x or above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Cluster Template
        foo = rancher2.ClusterTemplate("foo",
            description="Terraform cluster template foo",
            members=[rancher2.ClusterTemplateMemberArgs(
                access_type="owner",
                user_principal_id="local://user-XXXXX",
            )],
            template_revisions=[rancher2.ClusterTemplateTemplateRevisionArgs(
                cluster_config=rancher2.ClusterTemplateTemplateRevisionClusterConfigArgs(
                    rke_config={
                        "network": {
                            "plugin": "canal",
                        },
                        "services": {
                            "etcd": {
                                "creation": "6h",
                                "retention": "24h",
                            },
                        },
                    },
                    scheduled_cluster_scan={
                        "enabled": True,
                        "scanConfig": {
                            "cisScanConfig": {
                                "debugMaster": True,
                                "debugWorker": True,
                            },
                        },
                        "scheduleConfig": {
                            "cronSchedule": "30 * * * *",
                            "retention": 5,
                        },
                    },
                ),
                default=True,
                name="V1",
            )])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] annotations: Annotations for the cluster template revision (map)
        :param pulumi.Input[str] description: Cluster template description
        :param pulumi.Input[Mapping[str, Any]] labels: Labels for the cluster template revision (map)
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['ClusterTemplateMemberArgs']]]] members: Cluster template members (list)
        :param pulumi.Input[str] name: The cluster template revision name (string)
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['ClusterTemplateTemplateRevisionArgs']]]] template_revisions: Cluster template revisions (list)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['annotations'] = annotations
            __props__['description'] = description
            __props__['labels'] = labels
            __props__['members'] = members
            __props__['name'] = name
            __props__['template_revisions'] = template_revisions
            __props__['default_revision_id'] = None
        super(ClusterTemplate, __self__).__init__(
            'rancher2:index/clusterTemplate:ClusterTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            default_revision_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            members: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['ClusterTemplateMemberArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            template_revisions: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['ClusterTemplateTemplateRevisionArgs']]]]] = None) -> 'ClusterTemplate':
        """
        Get an existing ClusterTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] annotations: Annotations for the cluster template revision (map)
        :param pulumi.Input[str] default_revision_id: (Computed) Default cluster template revision ID (string)
        :param pulumi.Input[str] description: Cluster template description
        :param pulumi.Input[Mapping[str, Any]] labels: Labels for the cluster template revision (map)
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['ClusterTemplateMemberArgs']]]] members: Cluster template members (list)
        :param pulumi.Input[str] name: The cluster template revision name (string)
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['ClusterTemplateTemplateRevisionArgs']]]] template_revisions: Cluster template revisions (list)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["annotations"] = annotations
        __props__["default_revision_id"] = default_revision_id
        __props__["description"] = description
        __props__["labels"] = labels
        __props__["members"] = members
        __props__["name"] = name
        __props__["template_revisions"] = template_revisions
        return ClusterTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Annotations for the cluster template revision (map)
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="defaultRevisionId")
    def default_revision_id(self) -> pulumi.Output[str]:
        """
        (Computed) Default cluster template revision ID (string)
        """
        return pulumi.get(self, "default_revision_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Cluster template description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Labels for the cluster template revision (map)
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def members(self) -> pulumi.Output[Optional[List['outputs.ClusterTemplateMember']]]:
        """
        Cluster template members (list)
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The cluster template revision name (string)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="templateRevisions")
    def template_revisions(self) -> pulumi.Output[List['outputs.ClusterTemplateTemplateRevision']]:
        """
        Cluster template revisions (list)
        """
        return pulumi.get(self, "template_revisions")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

