# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['MultiClusterApp']


class MultiClusterApp(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 answers: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['MultiClusterAppAnswerArgs']]]]] = None,
                 catalog_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 members: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['MultiClusterAppMemberArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 revision_history_limit: Optional[pulumi.Input[float]] = None,
                 revision_id: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 targets: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['MultiClusterAppTargetArgs']]]]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 template_version: Optional[pulumi.Input[str]] = None,
                 upgrade_strategy: Optional[pulumi.Input[pulumi.InputType['MultiClusterAppUpgradeStrategyArgs']]] = None,
                 wait: Optional[pulumi.Input[bool]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a MultiClusterApp resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] annotations: Annotations for multi cluster app object (map)
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['MultiClusterAppAnswerArgs']]]] answers: The multi cluster app answers (list)
        :param pulumi.Input[str] catalog_name: The multi cluster app catalog name (string)
        :param pulumi.Input[Mapping[str, Any]] labels: Labels for multi cluster app object (map)
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['MultiClusterAppMemberArgs']]]] members: The multi cluster app answers (list)
        :param pulumi.Input[str] name: The multi cluster app name (string)
        :param pulumi.Input[float] revision_history_limit: The multi cluster app revision history limit. Default `10` (int)
        :param pulumi.Input[str] revision_id: Current revision id for the multi cluster app (string)
        :param pulumi.Input[List[pulumi.Input[str]]] roles: The multi cluster app roles (list)
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['MultiClusterAppTargetArgs']]]] targets: The multi cluster app target projects (list)
        :param pulumi.Input[str] template_name: The multi cluster app template name (string)
        :param pulumi.Input[str] template_version: The multi cluster app template version. Default: `latest` (string)
        :param pulumi.Input[pulumi.InputType['MultiClusterAppUpgradeStrategyArgs']] upgrade_strategy: The multi cluster app upgrade strategy (list MaxItems:1)
        :param pulumi.Input[bool] wait: Wait until the multi cluster app is active. Default `true` (bool)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['annotations'] = annotations
            __props__['answers'] = answers
            if catalog_name is None:
                raise TypeError("Missing required property 'catalog_name'")
            __props__['catalog_name'] = catalog_name
            __props__['labels'] = labels
            __props__['members'] = members
            __props__['name'] = name
            __props__['revision_history_limit'] = revision_history_limit
            __props__['revision_id'] = revision_id
            if roles is None:
                raise TypeError("Missing required property 'roles'")
            __props__['roles'] = roles
            if targets is None:
                raise TypeError("Missing required property 'targets'")
            __props__['targets'] = targets
            if template_name is None:
                raise TypeError("Missing required property 'template_name'")
            __props__['template_name'] = template_name
            __props__['template_version'] = template_version
            __props__['upgrade_strategy'] = upgrade_strategy
            __props__['wait'] = wait
            __props__['template_version_id'] = None
        super(MultiClusterApp, __self__).__init__(
            'rancher2:index/multiClusterApp:MultiClusterApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            answers: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['MultiClusterAppAnswerArgs']]]]] = None,
            catalog_name: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            members: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['MultiClusterAppMemberArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            revision_history_limit: Optional[pulumi.Input[float]] = None,
            revision_id: Optional[pulumi.Input[str]] = None,
            roles: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
            targets: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['MultiClusterAppTargetArgs']]]]] = None,
            template_name: Optional[pulumi.Input[str]] = None,
            template_version: Optional[pulumi.Input[str]] = None,
            template_version_id: Optional[pulumi.Input[str]] = None,
            upgrade_strategy: Optional[pulumi.Input[pulumi.InputType['MultiClusterAppUpgradeStrategyArgs']]] = None,
            wait: Optional[pulumi.Input[bool]] = None) -> 'MultiClusterApp':
        """
        Get an existing MultiClusterApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] annotations: Annotations for multi cluster app object (map)
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['MultiClusterAppAnswerArgs']]]] answers: The multi cluster app answers (list)
        :param pulumi.Input[str] catalog_name: The multi cluster app catalog name (string)
        :param pulumi.Input[Mapping[str, Any]] labels: Labels for multi cluster app object (map)
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['MultiClusterAppMemberArgs']]]] members: The multi cluster app answers (list)
        :param pulumi.Input[str] name: The multi cluster app name (string)
        :param pulumi.Input[float] revision_history_limit: The multi cluster app revision history limit. Default `10` (int)
        :param pulumi.Input[str] revision_id: Current revision id for the multi cluster app (string)
        :param pulumi.Input[List[pulumi.Input[str]]] roles: The multi cluster app roles (list)
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['MultiClusterAppTargetArgs']]]] targets: The multi cluster app target projects (list)
        :param pulumi.Input[str] template_name: The multi cluster app template name (string)
        :param pulumi.Input[str] template_version: The multi cluster app template version. Default: `latest` (string)
        :param pulumi.Input[str] template_version_id: (Computed) The multi cluster app template version ID (string)
        :param pulumi.Input[pulumi.InputType['MultiClusterAppUpgradeStrategyArgs']] upgrade_strategy: The multi cluster app upgrade strategy (list MaxItems:1)
        :param pulumi.Input[bool] wait: Wait until the multi cluster app is active. Default `true` (bool)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["annotations"] = annotations
        __props__["answers"] = answers
        __props__["catalog_name"] = catalog_name
        __props__["labels"] = labels
        __props__["members"] = members
        __props__["name"] = name
        __props__["revision_history_limit"] = revision_history_limit
        __props__["revision_id"] = revision_id
        __props__["roles"] = roles
        __props__["targets"] = targets
        __props__["template_name"] = template_name
        __props__["template_version"] = template_version
        __props__["template_version_id"] = template_version_id
        __props__["upgrade_strategy"] = upgrade_strategy
        __props__["wait"] = wait
        return MultiClusterApp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Annotations for multi cluster app object (map)
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def answers(self) -> pulumi.Output[List['outputs.MultiClusterAppAnswer']]:
        """
        The multi cluster app answers (list)
        """
        return pulumi.get(self, "answers")

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> pulumi.Output[str]:
        """
        The multi cluster app catalog name (string)
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Labels for multi cluster app object (map)
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def members(self) -> pulumi.Output[Optional[List['outputs.MultiClusterAppMember']]]:
        """
        The multi cluster app answers (list)
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The multi cluster app name (string)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> pulumi.Output[Optional[float]]:
        """
        The multi cluster app revision history limit. Default `10` (int)
        """
        return pulumi.get(self, "revision_history_limit")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> pulumi.Output[str]:
        """
        Current revision id for the multi cluster app (string)
        """
        return pulumi.get(self, "revision_id")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[List[str]]:
        """
        The multi cluster app roles (list)
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def targets(self) -> pulumi.Output[List['outputs.MultiClusterAppTarget']]:
        """
        The multi cluster app target projects (list)
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Output[str]:
        """
        The multi cluster app template name (string)
        """
        return pulumi.get(self, "template_name")

    @property
    @pulumi.getter(name="templateVersion")
    def template_version(self) -> pulumi.Output[str]:
        """
        The multi cluster app template version. Default: `latest` (string)
        """
        return pulumi.get(self, "template_version")

    @property
    @pulumi.getter(name="templateVersionId")
    def template_version_id(self) -> pulumi.Output[str]:
        """
        (Computed) The multi cluster app template version ID (string)
        """
        return pulumi.get(self, "template_version_id")

    @property
    @pulumi.getter(name="upgradeStrategy")
    def upgrade_strategy(self) -> pulumi.Output['outputs.MultiClusterAppUpgradeStrategy']:
        """
        The multi cluster app upgrade strategy (list MaxItems:1)
        """
        return pulumi.get(self, "upgrade_strategy")

    @property
    @pulumi.getter
    def wait(self) -> pulumi.Output[Optional[bool]]:
        """
        Wait until the multi cluster app is active. Default `true` (bool)
        """
        return pulumi.get(self, "wait")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

