# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['NodePool']


class NodePool(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 control_plane: Optional[pulumi.Input[bool]] = None,
                 delete_not_ready_after_secs: Optional[pulumi.Input[float]] = None,
                 etcd: Optional[pulumi.Input[bool]] = None,
                 hostname_prefix: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_taints: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['NodePoolNodeTaintArgs']]]]] = None,
                 node_template_id: Optional[pulumi.Input[str]] = None,
                 quantity: Optional[pulumi.Input[float]] = None,
                 worker: Optional[pulumi.Input[bool]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a Rancher v2 Node Pool resource. This can be used to create Node Pool, using Node template for Rancher v2 RKE clusters and retrieve their information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] annotations: Annotations for Node Pool object (map)
        :param pulumi.Input[str] cluster_id: The RKE cluster id to use Node Pool (string)
        :param pulumi.Input[bool] control_plane: RKE control plane role for created nodes (bool)
        :param pulumi.Input[float] delete_not_ready_after_secs: Delete not ready node after secs. For Rancher v2.3.3 or above. Default `0` (int)
        :param pulumi.Input[bool] etcd: RKE etcd role for created nodes (bool)
        :param pulumi.Input[str] hostname_prefix: The prefix for created nodes of the Node Pool (string)
        :param pulumi.Input[Mapping[str, Any]] labels: Labels for Node Pool object (map)
        :param pulumi.Input[str] name: The name of the Node Pool (string)
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['NodePoolNodeTaintArgs']]]] node_taints: Node taints. For Rancher v2.3.3 or above (List)
        :param pulumi.Input[str] node_template_id: The Node Template ID to use for node creation (string)
        :param pulumi.Input[float] quantity: The number of nodes to create on Node Pool. Default `1`. Only values >= 1 allowed (int)
        :param pulumi.Input[bool] worker: RKE role role for created nodes (bool)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['annotations'] = annotations
            if cluster_id is None:
                raise TypeError("Missing required property 'cluster_id'")
            __props__['cluster_id'] = cluster_id
            __props__['control_plane'] = control_plane
            __props__['delete_not_ready_after_secs'] = delete_not_ready_after_secs
            __props__['etcd'] = etcd
            if hostname_prefix is None:
                raise TypeError("Missing required property 'hostname_prefix'")
            __props__['hostname_prefix'] = hostname_prefix
            __props__['labels'] = labels
            __props__['name'] = name
            __props__['node_taints'] = node_taints
            if node_template_id is None:
                raise TypeError("Missing required property 'node_template_id'")
            __props__['node_template_id'] = node_template_id
            __props__['quantity'] = quantity
            __props__['worker'] = worker
        super(NodePool, __self__).__init__(
            'rancher2:index/nodePool:NodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            control_plane: Optional[pulumi.Input[bool]] = None,
            delete_not_ready_after_secs: Optional[pulumi.Input[float]] = None,
            etcd: Optional[pulumi.Input[bool]] = None,
            hostname_prefix: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_taints: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['NodePoolNodeTaintArgs']]]]] = None,
            node_template_id: Optional[pulumi.Input[str]] = None,
            quantity: Optional[pulumi.Input[float]] = None,
            worker: Optional[pulumi.Input[bool]] = None) -> 'NodePool':
        """
        Get an existing NodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] annotations: Annotations for Node Pool object (map)
        :param pulumi.Input[str] cluster_id: The RKE cluster id to use Node Pool (string)
        :param pulumi.Input[bool] control_plane: RKE control plane role for created nodes (bool)
        :param pulumi.Input[float] delete_not_ready_after_secs: Delete not ready node after secs. For Rancher v2.3.3 or above. Default `0` (int)
        :param pulumi.Input[bool] etcd: RKE etcd role for created nodes (bool)
        :param pulumi.Input[str] hostname_prefix: The prefix for created nodes of the Node Pool (string)
        :param pulumi.Input[Mapping[str, Any]] labels: Labels for Node Pool object (map)
        :param pulumi.Input[str] name: The name of the Node Pool (string)
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['NodePoolNodeTaintArgs']]]] node_taints: Node taints. For Rancher v2.3.3 or above (List)
        :param pulumi.Input[str] node_template_id: The Node Template ID to use for node creation (string)
        :param pulumi.Input[float] quantity: The number of nodes to create on Node Pool. Default `1`. Only values >= 1 allowed (int)
        :param pulumi.Input[bool] worker: RKE role role for created nodes (bool)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["annotations"] = annotations
        __props__["cluster_id"] = cluster_id
        __props__["control_plane"] = control_plane
        __props__["delete_not_ready_after_secs"] = delete_not_ready_after_secs
        __props__["etcd"] = etcd
        __props__["hostname_prefix"] = hostname_prefix
        __props__["labels"] = labels
        __props__["name"] = name
        __props__["node_taints"] = node_taints
        __props__["node_template_id"] = node_template_id
        __props__["quantity"] = quantity
        __props__["worker"] = worker
        return NodePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Annotations for Node Pool object (map)
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The RKE cluster id to use Node Pool (string)
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="controlPlane")
    def control_plane(self) -> pulumi.Output[Optional[bool]]:
        """
        RKE control plane role for created nodes (bool)
        """
        return pulumi.get(self, "control_plane")

    @property
    @pulumi.getter(name="deleteNotReadyAfterSecs")
    def delete_not_ready_after_secs(self) -> pulumi.Output[Optional[float]]:
        """
        Delete not ready node after secs. For Rancher v2.3.3 or above. Default `0` (int)
        """
        return pulumi.get(self, "delete_not_ready_after_secs")

    @property
    @pulumi.getter
    def etcd(self) -> pulumi.Output[Optional[bool]]:
        """
        RKE etcd role for created nodes (bool)
        """
        return pulumi.get(self, "etcd")

    @property
    @pulumi.getter(name="hostnamePrefix")
    def hostname_prefix(self) -> pulumi.Output[str]:
        """
        The prefix for created nodes of the Node Pool (string)
        """
        return pulumi.get(self, "hostname_prefix")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Labels for Node Pool object (map)
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Node Pool (string)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeTaints")
    def node_taints(self) -> pulumi.Output[Optional[List['outputs.NodePoolNodeTaint']]]:
        """
        Node taints. For Rancher v2.3.3 or above (List)
        """
        return pulumi.get(self, "node_taints")

    @property
    @pulumi.getter(name="nodeTemplateId")
    def node_template_id(self) -> pulumi.Output[str]:
        """
        The Node Template ID to use for node creation (string)
        """
        return pulumi.get(self, "node_template_id")

    @property
    @pulumi.getter
    def quantity(self) -> pulumi.Output[Optional[float]]:
        """
        The number of nodes to create on Node Pool. Default `1`. Only values >= 1 allowed (int)
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter
    def worker(self) -> pulumi.Output[Optional[bool]]:
        """
        RKE role role for created nodes (bool)
        """
        return pulumi.get(self, "worker")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

