# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Notifier']


class Notifier(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pagerduty_config: Optional[pulumi.Input[pulumi.InputType['NotifierPagerdutyConfigArgs']]] = None,
                 send_resolved: Optional[pulumi.Input[bool]] = None,
                 slack_config: Optional[pulumi.Input[pulumi.InputType['NotifierSlackConfigArgs']]] = None,
                 smtp_config: Optional[pulumi.Input[pulumi.InputType['NotifierSmtpConfigArgs']]] = None,
                 webhook_config: Optional[pulumi.Input[pulumi.InputType['NotifierWebhookConfigArgs']]] = None,
                 wechat_config: Optional[pulumi.Input[pulumi.InputType['NotifierWechatConfigArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a Rancher v2 Notifier resource. This can be used to create notifiers for Rancher v2 environments and retrieve their information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Notifier
        foo = rancher2.Notifier("foo",
            cluster_id="<cluster_id>",
            description="Terraform notifier acceptance test",
            pagerduty_config=rancher2.NotifierPagerdutyConfigArgs(
                proxy_url="http://proxy.test.io",
                service_key="XXXXXXXX",
            ),
            send_resolved=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] annotations: Annotations for notifier object (map)
        :param pulumi.Input[str] cluster_id: The cluster id where create notifier (string)
        :param pulumi.Input[str] description: The notifier description (string)
        :param pulumi.Input[Mapping[str, Any]] labels: Labels for notifier object (map)
        :param pulumi.Input[str] name: The name of the notifier (string)
        :param pulumi.Input[pulumi.InputType['NotifierPagerdutyConfigArgs']] pagerduty_config: Pagerduty config for notifier (list maxitems:1)
        :param pulumi.Input[bool] send_resolved: = (Optional) Enable the notifier to send resolved notifications. Default `false` (bool)
        :param pulumi.Input[pulumi.InputType['NotifierSlackConfigArgs']] slack_config: Slack config for notifier (list maxitems:1)
        :param pulumi.Input[pulumi.InputType['NotifierSmtpConfigArgs']] smtp_config: SMTP config for notifier (list maxitems:1)
        :param pulumi.Input[pulumi.InputType['NotifierWebhookConfigArgs']] webhook_config: Webhook config for notifier (list maxitems:1)
        :param pulumi.Input[pulumi.InputType['NotifierWechatConfigArgs']] wechat_config: Wechat config for notifier (list maxitems:1)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['annotations'] = annotations
            if cluster_id is None:
                raise TypeError("Missing required property 'cluster_id'")
            __props__['cluster_id'] = cluster_id
            __props__['description'] = description
            __props__['labels'] = labels
            __props__['name'] = name
            __props__['pagerduty_config'] = pagerduty_config
            __props__['send_resolved'] = send_resolved
            __props__['slack_config'] = slack_config
            __props__['smtp_config'] = smtp_config
            __props__['webhook_config'] = webhook_config
            __props__['wechat_config'] = wechat_config
        super(Notifier, __self__).__init__(
            'rancher2:index/notifier:Notifier',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            pagerduty_config: Optional[pulumi.Input[pulumi.InputType['NotifierPagerdutyConfigArgs']]] = None,
            send_resolved: Optional[pulumi.Input[bool]] = None,
            slack_config: Optional[pulumi.Input[pulumi.InputType['NotifierSlackConfigArgs']]] = None,
            smtp_config: Optional[pulumi.Input[pulumi.InputType['NotifierSmtpConfigArgs']]] = None,
            webhook_config: Optional[pulumi.Input[pulumi.InputType['NotifierWebhookConfigArgs']]] = None,
            wechat_config: Optional[pulumi.Input[pulumi.InputType['NotifierWechatConfigArgs']]] = None) -> 'Notifier':
        """
        Get an existing Notifier resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] annotations: Annotations for notifier object (map)
        :param pulumi.Input[str] cluster_id: The cluster id where create notifier (string)
        :param pulumi.Input[str] description: The notifier description (string)
        :param pulumi.Input[Mapping[str, Any]] labels: Labels for notifier object (map)
        :param pulumi.Input[str] name: The name of the notifier (string)
        :param pulumi.Input[pulumi.InputType['NotifierPagerdutyConfigArgs']] pagerduty_config: Pagerduty config for notifier (list maxitems:1)
        :param pulumi.Input[bool] send_resolved: = (Optional) Enable the notifier to send resolved notifications. Default `false` (bool)
        :param pulumi.Input[pulumi.InputType['NotifierSlackConfigArgs']] slack_config: Slack config for notifier (list maxitems:1)
        :param pulumi.Input[pulumi.InputType['NotifierSmtpConfigArgs']] smtp_config: SMTP config for notifier (list maxitems:1)
        :param pulumi.Input[pulumi.InputType['NotifierWebhookConfigArgs']] webhook_config: Webhook config for notifier (list maxitems:1)
        :param pulumi.Input[pulumi.InputType['NotifierWechatConfigArgs']] wechat_config: Wechat config for notifier (list maxitems:1)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["annotations"] = annotations
        __props__["cluster_id"] = cluster_id
        __props__["description"] = description
        __props__["labels"] = labels
        __props__["name"] = name
        __props__["pagerduty_config"] = pagerduty_config
        __props__["send_resolved"] = send_resolved
        __props__["slack_config"] = slack_config
        __props__["smtp_config"] = smtp_config
        __props__["webhook_config"] = webhook_config
        __props__["wechat_config"] = wechat_config
        return Notifier(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Annotations for notifier object (map)
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The cluster id where create notifier (string)
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The notifier description (string)
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Labels for notifier object (map)
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the notifier (string)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pagerdutyConfig")
    def pagerduty_config(self) -> pulumi.Output[Optional['outputs.NotifierPagerdutyConfig']]:
        """
        Pagerduty config for notifier (list maxitems:1)
        """
        return pulumi.get(self, "pagerduty_config")

    @property
    @pulumi.getter(name="sendResolved")
    def send_resolved(self) -> pulumi.Output[Optional[bool]]:
        """
        = (Optional) Enable the notifier to send resolved notifications. Default `false` (bool)
        """
        return pulumi.get(self, "send_resolved")

    @property
    @pulumi.getter(name="slackConfig")
    def slack_config(self) -> pulumi.Output[Optional['outputs.NotifierSlackConfig']]:
        """
        Slack config for notifier (list maxitems:1)
        """
        return pulumi.get(self, "slack_config")

    @property
    @pulumi.getter(name="smtpConfig")
    def smtp_config(self) -> pulumi.Output[Optional['outputs.NotifierSmtpConfig']]:
        """
        SMTP config for notifier (list maxitems:1)
        """
        return pulumi.get(self, "smtp_config")

    @property
    @pulumi.getter(name="webhookConfig")
    def webhook_config(self) -> pulumi.Output[Optional['outputs.NotifierWebhookConfig']]:
        """
        Webhook config for notifier (list maxitems:1)
        """
        return pulumi.get(self, "webhook_config")

    @property
    @pulumi.getter(name="wechatConfig")
    def wechat_config(self) -> pulumi.Output[Optional['outputs.NotifierWechatConfig']]:
        """
        Wechat config for notifier (list maxitems:1)
        """
        return pulumi.get(self, "wechat_config")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

