# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['RoleTempalte']


class RoleTempalte(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrative: Optional[pulumi.Input[bool]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 context: Optional[pulumi.Input[str]] = None,
                 default_role: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 external: Optional[pulumi.Input[bool]] = None,
                 hidden: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 locked: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role_template_ids: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 rules: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['RoleTempalteRuleArgs']]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a Rancher v2 Role Template resource. This can be used to create Role Template for Rancher v2 and retrieve their information.

        `cluster` and `project` scopes are supported for role templates.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 cluster Role Template
        foo = rancher2.RoleTempalte("foo",
            context="cluster",
            default_role=True,
            description="Terraform role template acceptance test",
            rules=[rancher2.RoleTempalteRuleArgs(
                api_groups=["*"],
                resources=["secrets"],
                verbs=["create"],
            )])
        ```

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 project Role Template
        foo = rancher2.RoleTempalte("foo",
            context="project",
            default_role=True,
            description="Terraform role template acceptance test",
            rules=[rancher2.RoleTempalteRuleArgs(
                api_groups=["*"],
                resources=["secrets"],
                verbs=["create"],
            )])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] administrative: Administrative role template. Default `false` (bool)
        :param pulumi.Input[Mapping[str, Any]] annotations: Annotations for role template object (map)
        :param pulumi.Input[str] context: Role template context. `cluster` and `project` values are supported. Default: `cluster` (string)
        :param pulumi.Input[bool] default_role: Default role template for new created cluster or project. Default `false` (bool)
        :param pulumi.Input[str] description: Role template description (string)
        :param pulumi.Input[bool] external: External role template. Default `false` (bool)
        :param pulumi.Input[bool] hidden: Hidden role template. Default `false` (bool)
        :param pulumi.Input[Mapping[str, Any]] labels: Labels for role template object (map)
        :param pulumi.Input[bool] locked: Locked role template. Default `false` (bool)
        :param pulumi.Input[str] name: Role template name (string)
        :param pulumi.Input[List[pulumi.Input[str]]] role_template_ids: Inherit role template IDs (list)
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['RoleTempalteRuleArgs']]]] rules: Role template policy rules (list)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['administrative'] = administrative
            __props__['annotations'] = annotations
            __props__['context'] = context
            __props__['default_role'] = default_role
            __props__['description'] = description
            __props__['external'] = external
            __props__['hidden'] = hidden
            __props__['labels'] = labels
            __props__['locked'] = locked
            __props__['name'] = name
            __props__['role_template_ids'] = role_template_ids
            __props__['rules'] = rules
            __props__['builtin'] = None
        super(RoleTempalte, __self__).__init__(
            'rancher2:index/roleTempalte:RoleTempalte',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            administrative: Optional[pulumi.Input[bool]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            builtin: Optional[pulumi.Input[bool]] = None,
            context: Optional[pulumi.Input[str]] = None,
            default_role: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            external: Optional[pulumi.Input[bool]] = None,
            hidden: Optional[pulumi.Input[bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            locked: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            role_template_ids: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
            rules: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['RoleTempalteRuleArgs']]]]] = None) -> 'RoleTempalte':
        """
        Get an existing RoleTempalte resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] administrative: Administrative role template. Default `false` (bool)
        :param pulumi.Input[Mapping[str, Any]] annotations: Annotations for role template object (map)
        :param pulumi.Input[bool] builtin: (Computed) Builtin role template (string)
        :param pulumi.Input[str] context: Role template context. `cluster` and `project` values are supported. Default: `cluster` (string)
        :param pulumi.Input[bool] default_role: Default role template for new created cluster or project. Default `false` (bool)
        :param pulumi.Input[str] description: Role template description (string)
        :param pulumi.Input[bool] external: External role template. Default `false` (bool)
        :param pulumi.Input[bool] hidden: Hidden role template. Default `false` (bool)
        :param pulumi.Input[Mapping[str, Any]] labels: Labels for role template object (map)
        :param pulumi.Input[bool] locked: Locked role template. Default `false` (bool)
        :param pulumi.Input[str] name: Role template name (string)
        :param pulumi.Input[List[pulumi.Input[str]]] role_template_ids: Inherit role template IDs (list)
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['RoleTempalteRuleArgs']]]] rules: Role template policy rules (list)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["administrative"] = administrative
        __props__["annotations"] = annotations
        __props__["builtin"] = builtin
        __props__["context"] = context
        __props__["default_role"] = default_role
        __props__["description"] = description
        __props__["external"] = external
        __props__["hidden"] = hidden
        __props__["labels"] = labels
        __props__["locked"] = locked
        __props__["name"] = name
        __props__["role_template_ids"] = role_template_ids
        __props__["rules"] = rules
        return RoleTempalte(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def administrative(self) -> pulumi.Output[Optional[bool]]:
        """
        Administrative role template. Default `false` (bool)
        """
        return pulumi.get(self, "administrative")

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Annotations for role template object (map)
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def builtin(self) -> pulumi.Output[bool]:
        """
        (Computed) Builtin role template (string)
        """
        return pulumi.get(self, "builtin")

    @property
    @pulumi.getter
    def context(self) -> pulumi.Output[Optional[str]]:
        """
        Role template context. `cluster` and `project` values are supported. Default: `cluster` (string)
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="defaultRole")
    def default_role(self) -> pulumi.Output[Optional[bool]]:
        """
        Default role template for new created cluster or project. Default `false` (bool)
        """
        return pulumi.get(self, "default_role")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Role template description (string)
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def external(self) -> pulumi.Output[Optional[bool]]:
        """
        External role template. Default `false` (bool)
        """
        return pulumi.get(self, "external")

    @property
    @pulumi.getter
    def hidden(self) -> pulumi.Output[Optional[bool]]:
        """
        Hidden role template. Default `false` (bool)
        """
        return pulumi.get(self, "hidden")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Labels for role template object (map)
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def locked(self) -> pulumi.Output[Optional[bool]]:
        """
        Locked role template. Default `false` (bool)
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Role template name (string)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roleTemplateIds")
    def role_template_ids(self) -> pulumi.Output[List[str]]:
        """
        Inherit role template IDs (list)
        """
        return pulumi.get(self, "role_template_ids")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[List['outputs.RoleTempalteRule']]:
        """
        Role template policy rules (list)
        """
        return pulumi.get(self, "rules")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

