# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['Token']


class Token(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 renew: Optional[pulumi.Input[bool]] = None,
                 ttl: Optional[pulumi.Input[float]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a Rancher v2 Token resource. This can be used to create Tokens for Rancher v2 provider user and retrieve their information.

        There are 2 kind of tokens:
        - no scoped: valid for global system.
        - scoped: valid for just a specific cluster (`cluster_id` should be provided).

        Tokens can't be updated once created. Any diff in token data will recreate the token. If any token expire, Rancher2 provider will generate a diff to regenerate it.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 Token scoped
        foo = rancher2.Token("foo",
            cluster_id="<cluster-id>",
            description="foo token",
            ttl=1200)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] annotations: (Computed) Annotations of the token (map)
        :param pulumi.Input[str] cluster_id: Cluster ID for scoped token (string)
        :param pulumi.Input[str] description: Token description (string)
        :param pulumi.Input[Mapping[str, Any]] labels: (Computed) Labels of the token (map)
        :param pulumi.Input[bool] renew: Renew expired or disabled token
        :param pulumi.Input[float] ttl: Token time to live in seconds. Default `0` (int)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['annotations'] = annotations
            __props__['cluster_id'] = cluster_id
            __props__['description'] = description
            __props__['labels'] = labels
            __props__['renew'] = renew
            __props__['ttl'] = ttl
            __props__['access_key'] = None
            __props__['enabled'] = None
            __props__['expired'] = None
            __props__['name'] = None
            __props__['secret_key'] = None
            __props__['token'] = None
            __props__['user_id'] = None
        super(Token, __self__).__init__(
            'rancher2:index/token:Token',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[str]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            expired: Optional[pulumi.Input[bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            renew: Optional[pulumi.Input[bool]] = None,
            secret_key: Optional[pulumi.Input[str]] = None,
            token: Optional[pulumi.Input[str]] = None,
            ttl: Optional[pulumi.Input[float]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'Token':
        """
        Get an existing Token resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key: (Computed) Token access key part (string)
        :param pulumi.Input[Mapping[str, Any]] annotations: (Computed) Annotations of the token (map)
        :param pulumi.Input[str] cluster_id: Cluster ID for scoped token (string)
        :param pulumi.Input[str] description: Token description (string)
        :param pulumi.Input[bool] enabled: (Computed) Token is enabled (bool)
        :param pulumi.Input[bool] expired: (Computed) Token is expired (bool)
        :param pulumi.Input[Mapping[str, Any]] labels: (Computed) Labels of the token (map)
        :param pulumi.Input[str] name: (Computed) Token name (string)
        :param pulumi.Input[bool] renew: Renew expired or disabled token
        :param pulumi.Input[str] secret_key: (Computed/Sensitive) Token secret key part (string)
        :param pulumi.Input[str] token: (Computed/Sensitive) Token value (string)
        :param pulumi.Input[float] ttl: Token time to live in seconds. Default `0` (int)
        :param pulumi.Input[str] user_id: (Computed) Token user ID (string)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["access_key"] = access_key
        __props__["annotations"] = annotations
        __props__["cluster_id"] = cluster_id
        __props__["description"] = description
        __props__["enabled"] = enabled
        __props__["expired"] = expired
        __props__["labels"] = labels
        __props__["name"] = name
        __props__["renew"] = renew
        __props__["secret_key"] = secret_key
        __props__["token"] = token
        __props__["ttl"] = ttl
        __props__["user_id"] = user_id
        return Token(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[str]:
        """
        (Computed) Token access key part (string)
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Computed) Annotations of the token (map)
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[Optional[str]]:
        """
        Cluster ID for scoped token (string)
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Token description (string)
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        (Computed) Token is enabled (bool)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def expired(self) -> pulumi.Output[bool]:
        """
        (Computed) Token is expired (bool)
        """
        return pulumi.get(self, "expired")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Computed) Labels of the token (map)
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        (Computed) Token name (string)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def renew(self) -> pulumi.Output[Optional[bool]]:
        """
        Renew expired or disabled token
        """
        return pulumi.get(self, "renew")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[str]:
        """
        (Computed/Sensitive) Token secret key part (string)
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[str]:
        """
        (Computed/Sensitive) Token value (string)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[float]]:
        """
        Token time to live in seconds. Default `0` (int)
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        (Computed) Token user ID (string)
        """
        return pulumi.get(self, "user_id")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

