from .domain import (
    Size,
    Dimension,
    Video,
    VideoProperties,
    VideoSourceType,
    RgbColor,
    Color,
    ThemeColorType,
    SolidFill,
    ShapeBackgroundFill,
    OutlineFill,
    Weight,
    Outline,
    DashStyle,
    ShadowTransform,
    BlurRadius,
    Shadow,
    ShadowType,
    RectanglePosition,
    CropProperties,
    ColorStop,
    RecolorName,
    Recolor,
    ImageProperties,
    PropertyState,
    StretchedPictureFill,
    PageBackgroundFill,
    PredefinedLayout,
    ColorScheme,
    ThemeColorPair,
    Line,
    LineProperties,
    WordArt,
    SheetsChart,
    SheetsChartProperties,
    SpeakerSpotlight,
    SpeakerSpotlightProperties,
    Group,
)
from .text import AutoText, AutoTextType, ShapeProperties, TextElement
from .presentation import Presentation
from .page.page import (
    Layout,
    LayoutProperties,
    Master,
    MasterProperties,
    NotesMaster,
    Page,
)
from .page import Notes, NotesProperties, Slide, SlideProperties
from .page.base import BasePage, PageProperties, PageType
from .element.base import ElementKind
from .client import initialize_credentials, GoogleAPIClient
from .request.request import (
    CreateParagraphBulletsRequest,
    InsertTextRequest,
    UpdateTextStyleRequest,
    DeleteTextRequest,
    CreateShapeRequest,
    UpdateShapePropertiesRequest,
    UpdateImagePropertiesRequest,
    ReplaceImageRequest,
    CreateSlideRequest,
    UpdateSlidePropertiesRequest,
    UpdateSlidesPositionRequest,
    UpdatePagePropertiesRequest,
    DeleteObjectRequest,
    DuplicateObjectRequest,
)
from .request.domain import Range, RangeType, TableCellLocation, ElementProperties

from ._version import __version__, __version_info__

__all__ = [
    # Version info
    "__version__",
    "__version_info__",
    "GoogleAPIClient",
    # Domain objects
    "Size",
    "Dimension",
    "TextElement",
    "Video",
    "VideoProperties",
    "VideoSourceType",
    "RgbColor",
    "Color",
    "ThemeColorType",
    "SolidFill",
    "ShapeBackgroundFill",
    "OutlineFill",
    "Weight",
    "Outline",
    "DashStyle",
    "ShadowTransform",
    "BlurRadius",
    "Shadow",
    "ShadowType",
    "RectanglePosition",
    "ShapeProperties",
    "CropProperties",
    "ColorStop",
    "RecolorName",
    "Recolor",
    "ImageProperties",
    "PropertyState",
    "StretchedPictureFill",
    "PageBackgroundFill",
    "AutoText",
    "AutoTextType",
    "PredefinedLayout",
    "ColorScheme",
    "ThemeColorPair",
    "Line",
    "LineProperties",
    "WordArt",
    "SheetsChart",
    "SheetsChartProperties",
    "SpeakerSpotlight",
    "SpeakerSpotlightProperties",
    "Group",
    # Presentation
    "Presentation",
    # Pages
    "Layout",
    "LayoutProperties",
    "Master",
    "MasterProperties",
    "NotesMaster",
    "Page",
    "Notes",
    "NotesProperties",
    "Slide",
    "SlideProperties",
    "BasePage",
    "PageProperties",
    "PageType",
    # Elements
    "ElementKind",
    # Client
    "initialize_credentials",
    # Requests
    "CreateParagraphBulletsRequest",
    "InsertTextRequest",
    "UpdateTextStyleRequest",
    "DeleteTextRequest",
    "CreateShapeRequest",
    "UpdateShapePropertiesRequest",
    "UpdateImagePropertiesRequest",
    "ReplaceImageRequest",
    "CreateSlideRequest",
    "UpdateSlidePropertiesRequest",
    "UpdateSlidesPositionRequest",
    "UpdatePagePropertiesRequest",
    "DeleteObjectRequest",
    "DuplicateObjectRequest",
    "Range",
    "RangeType",
    "TableCellLocation",
    "ElementProperties",
]
