import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::MSK::Cluster`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export interface CfnClusterProps {
    /**
     * `AWS::MSK::Cluster.BrokerNodeGroupInfo`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-brokernodegroupinfo
     */
    readonly brokerNodeGroupInfo: CfnCluster.BrokerNodeGroupInfoProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.ClusterName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-clustername
     */
    readonly clusterName: string;
    /**
     * `AWS::MSK::Cluster.KafkaVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-kafkaversion
     */
    readonly kafkaVersion: string;
    /**
     * `AWS::MSK::Cluster.NumberOfBrokerNodes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-numberofbrokernodes
     */
    readonly numberOfBrokerNodes: number;
    /**
     * `AWS::MSK::Cluster.ClientAuthentication`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-clientauthentication
     */
    readonly clientAuthentication?: CfnCluster.ClientAuthenticationProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.ConfigurationInfo`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-configurationinfo
     */
    readonly configurationInfo?: CfnCluster.ConfigurationInfoProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.EncryptionInfo`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-encryptioninfo
     */
    readonly encryptionInfo?: CfnCluster.EncryptionInfoProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.EnhancedMonitoring`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-enhancedmonitoring
     */
    readonly enhancedMonitoring?: string;
    /**
     * `AWS::MSK::Cluster.LoggingInfo`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-logginginfo
     */
    readonly loggingInfo?: CfnCluster.LoggingInfoProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.OpenMonitoring`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-openmonitoring
     */
    readonly openMonitoring?: CfnCluster.OpenMonitoringProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::MSK::Cluster`
 *
 * @cloudformationResource AWS::MSK::Cluster
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html
 */
export declare class CfnCluster extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MSK::Cluster";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnCluster;
    /**
     * `AWS::MSK::Cluster.BrokerNodeGroupInfo`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-brokernodegroupinfo
     */
    brokerNodeGroupInfo: CfnCluster.BrokerNodeGroupInfoProperty | cdk.IResolvable;
    /**
     * `AWS::MSK::Cluster.ClusterName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-clustername
     */
    clusterName: string;
    /**
     * `AWS::MSK::Cluster.KafkaVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-kafkaversion
     */
    kafkaVersion: string;
    /**
     * `AWS::MSK::Cluster.NumberOfBrokerNodes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-numberofbrokernodes
     */
    numberOfBrokerNodes: number;
    /**
     * `AWS::MSK::Cluster.ClientAuthentication`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-clientauthentication
     */
    clientAuthentication: CfnCluster.ClientAuthenticationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MSK::Cluster.ConfigurationInfo`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-configurationinfo
     */
    configurationInfo: CfnCluster.ConfigurationInfoProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MSK::Cluster.EncryptionInfo`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-encryptioninfo
     */
    encryptionInfo: CfnCluster.EncryptionInfoProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MSK::Cluster.EnhancedMonitoring`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-enhancedmonitoring
     */
    enhancedMonitoring: string | undefined;
    /**
     * `AWS::MSK::Cluster.LoggingInfo`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-logginginfo
     */
    loggingInfo: CfnCluster.LoggingInfoProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MSK::Cluster.OpenMonitoring`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-openmonitoring
     */
    openMonitoring: CfnCluster.OpenMonitoringProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MSK::Cluster.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-msk-cluster.html#cfn-msk-cluster-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::MSK::Cluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClusterProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokerlogs.html
     */
    interface BrokerLogsProperty {
        /**
         * `CfnCluster.BrokerLogsProperty.CloudWatchLogs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokerlogs.html#cfn-msk-cluster-brokerlogs-cloudwatchlogs
         */
        readonly cloudWatchLogs?: CfnCluster.CloudWatchLogsProperty | cdk.IResolvable;
        /**
         * `CfnCluster.BrokerLogsProperty.Firehose`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokerlogs.html#cfn-msk-cluster-brokerlogs-firehose
         */
        readonly firehose?: CfnCluster.FirehoseProperty | cdk.IResolvable;
        /**
         * `CfnCluster.BrokerLogsProperty.S3`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokerlogs.html#cfn-msk-cluster-brokerlogs-s3
         */
        readonly s3?: CfnCluster.S3Property | cdk.IResolvable;
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokernodegroupinfo.html
     */
    interface BrokerNodeGroupInfoProperty {
        /**
         * `CfnCluster.BrokerNodeGroupInfoProperty.BrokerAZDistribution`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokernodegroupinfo.html#cfn-msk-cluster-brokernodegroupinfo-brokerazdistribution
         */
        readonly brokerAzDistribution?: string;
        /**
         * `CfnCluster.BrokerNodeGroupInfoProperty.ClientSubnets`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokernodegroupinfo.html#cfn-msk-cluster-brokernodegroupinfo-clientsubnets
         */
        readonly clientSubnets: string[];
        /**
         * `CfnCluster.BrokerNodeGroupInfoProperty.InstanceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokernodegroupinfo.html#cfn-msk-cluster-brokernodegroupinfo-instancetype
         */
        readonly instanceType: string;
        /**
         * `CfnCluster.BrokerNodeGroupInfoProperty.SecurityGroups`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokernodegroupinfo.html#cfn-msk-cluster-brokernodegroupinfo-securitygroups
         */
        readonly securityGroups?: string[];
        /**
         * `CfnCluster.BrokerNodeGroupInfoProperty.StorageInfo`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-brokernodegroupinfo.html#cfn-msk-cluster-brokernodegroupinfo-storageinfo
         */
        readonly storageInfo?: CfnCluster.StorageInfoProperty | cdk.IResolvable;
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-clientauthentication.html
     */
    interface ClientAuthenticationProperty {
        /**
         * `CfnCluster.ClientAuthenticationProperty.Tls`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-clientauthentication.html#cfn-msk-cluster-clientauthentication-tls
         */
        readonly tls?: CfnCluster.TlsProperty | cdk.IResolvable;
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-cloudwatchlogs.html
     */
    interface CloudWatchLogsProperty {
        /**
         * `CfnCluster.CloudWatchLogsProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-cloudwatchlogs.html#cfn-msk-cluster-cloudwatchlogs-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnCluster.CloudWatchLogsProperty.LogGroup`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-cloudwatchlogs.html#cfn-msk-cluster-cloudwatchlogs-loggroup
         */
        readonly logGroup?: string;
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-configurationinfo.html
     */
    interface ConfigurationInfoProperty {
        /**
         * `CfnCluster.ConfigurationInfoProperty.Arn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-configurationinfo.html#cfn-msk-cluster-configurationinfo-arn
         */
        readonly arn: string;
        /**
         * `CfnCluster.ConfigurationInfoProperty.Revision`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-configurationinfo.html#cfn-msk-cluster-configurationinfo-revision
         */
        readonly revision: number;
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-ebsstorageinfo.html
     */
    interface EBSStorageInfoProperty {
        /**
         * `CfnCluster.EBSStorageInfoProperty.VolumeSize`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-ebsstorageinfo.html#cfn-msk-cluster-ebsstorageinfo-volumesize
         */
        readonly volumeSize?: number;
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptionatrest.html
     */
    interface EncryptionAtRestProperty {
        /**
         * `CfnCluster.EncryptionAtRestProperty.DataVolumeKMSKeyId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptionatrest.html#cfn-msk-cluster-encryptionatrest-datavolumekmskeyid
         */
        readonly dataVolumeKmsKeyId: string;
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptionintransit.html
     */
    interface EncryptionInTransitProperty {
        /**
         * `CfnCluster.EncryptionInTransitProperty.ClientBroker`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptionintransit.html#cfn-msk-cluster-encryptionintransit-clientbroker
         */
        readonly clientBroker?: string;
        /**
         * `CfnCluster.EncryptionInTransitProperty.InCluster`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptionintransit.html#cfn-msk-cluster-encryptionintransit-incluster
         */
        readonly inCluster?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptioninfo.html
     */
    interface EncryptionInfoProperty {
        /**
         * `CfnCluster.EncryptionInfoProperty.EncryptionAtRest`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptioninfo.html#cfn-msk-cluster-encryptioninfo-encryptionatrest
         */
        readonly encryptionAtRest?: CfnCluster.EncryptionAtRestProperty | cdk.IResolvable;
        /**
         * `CfnCluster.EncryptionInfoProperty.EncryptionInTransit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-encryptioninfo.html#cfn-msk-cluster-encryptioninfo-encryptionintransit
         */
        readonly encryptionInTransit?: CfnCluster.EncryptionInTransitProperty | cdk.IResolvable;
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-firehose.html
     */
    interface FirehoseProperty {
        /**
         * `CfnCluster.FirehoseProperty.DeliveryStream`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-firehose.html#cfn-msk-cluster-firehose-deliverystream
         */
        readonly deliveryStream?: string;
        /**
         * `CfnCluster.FirehoseProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-firehose.html#cfn-msk-cluster-firehose-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-jmxexporter.html
     */
    interface JmxExporterProperty {
        /**
         * `CfnCluster.JmxExporterProperty.EnabledInBroker`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-jmxexporter.html#cfn-msk-cluster-jmxexporter-enabledinbroker
         */
        readonly enabledInBroker: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-logginginfo.html
     */
    interface LoggingInfoProperty {
        /**
         * `CfnCluster.LoggingInfoProperty.BrokerLogs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-logginginfo.html#cfn-msk-cluster-logginginfo-brokerlogs
         */
        readonly brokerLogs: CfnCluster.BrokerLogsProperty | cdk.IResolvable;
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-nodeexporter.html
     */
    interface NodeExporterProperty {
        /**
         * `CfnCluster.NodeExporterProperty.EnabledInBroker`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-nodeexporter.html#cfn-msk-cluster-nodeexporter-enabledinbroker
         */
        readonly enabledInBroker: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-openmonitoring.html
     */
    interface OpenMonitoringProperty {
        /**
         * `CfnCluster.OpenMonitoringProperty.Prometheus`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-openmonitoring.html#cfn-msk-cluster-openmonitoring-prometheus
         */
        readonly prometheus: CfnCluster.PrometheusProperty | cdk.IResolvable;
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-prometheus.html
     */
    interface PrometheusProperty {
        /**
         * `CfnCluster.PrometheusProperty.JmxExporter`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-prometheus.html#cfn-msk-cluster-prometheus-jmxexporter
         */
        readonly jmxExporter?: CfnCluster.JmxExporterProperty | cdk.IResolvable;
        /**
         * `CfnCluster.PrometheusProperty.NodeExporter`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-prometheus.html#cfn-msk-cluster-prometheus-nodeexporter
         */
        readonly nodeExporter?: CfnCluster.NodeExporterProperty | cdk.IResolvable;
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-s3.html
     */
    interface S3Property {
        /**
         * `CfnCluster.S3Property.Bucket`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-s3.html#cfn-msk-cluster-s3-bucket
         */
        readonly bucket?: string;
        /**
         * `CfnCluster.S3Property.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-s3.html#cfn-msk-cluster-s3-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnCluster.S3Property.Prefix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-s3.html#cfn-msk-cluster-s3-prefix
         */
        readonly prefix?: string;
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-storageinfo.html
     */
    interface StorageInfoProperty {
        /**
         * `CfnCluster.StorageInfoProperty.EBSStorageInfo`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-storageinfo.html#cfn-msk-cluster-storageinfo-ebsstorageinfo
         */
        readonly ebsStorageInfo?: CfnCluster.EBSStorageInfoProperty | cdk.IResolvable;
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-tls.html
     */
    interface TlsProperty {
        /**
         * `CfnCluster.TlsProperty.CertificateAuthorityArnList`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-msk-cluster-tls.html#cfn-msk-cluster-tls-certificateauthorityarnlist
         */
        readonly certificateAuthorityArnList?: string[];
    }
}
