"""The module that defines the ``TenantCoupon`` model.

SPDX-License-Identifier: AGPL-3.0-only OR BSD-3-Clause-Clear
"""

from __future__ import annotations

import typing as t
from dataclasses import dataclass, field

import cg_request_args as rqa

from ..parsers import ParserFor, make_union
from ..utils import to_dict
from .tenant_coupon_with_code import TenantCouponWithCode
from .tenant_coupon_without_code import TenantCouponWithoutCode

TenantCoupon = t.Union[
    TenantCouponWithCode,
    TenantCouponWithoutCode,
]
TenantCouponParser = rqa.Lazy(
    lambda: make_union(
        ParserFor.make(TenantCouponWithCode),
        ParserFor.make(TenantCouponWithoutCode),
    ),
)
