from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="TrieFastRegex",
    version="0.1.1a",
    author="Brandon Callahan",
    author_email="brandoncallah@gmail.com",
    description="A compact regular expression builder from string lists using Trie data structure",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/brandoncallah/pyTriEX",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
    ],
    python_requires=">=3.8",
)