"""initial

Revision ID: 0210948a8147
Revises: 
Create Date: 2021-10-29 11:51:19.265141

"""

import sqlalchemy as sa
import sqlalchemy_utils
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "0210948a8147"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "client",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("hashed_secret", sa.String(), nullable=False),
        sa.Column("salt", sa.String(), nullable=False),
        sa.Column("scopes", sa.ARRAY(sa.String()), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_client_id"), "client", ["id"], unique=False)
    op.create_table(
        "connectionconfig",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("key", sa.String(), nullable=False),
        sa.Column(
            "connection_type",
            sa.Enum("postgres", "mongodb", "mysql", "https", name="connectiontype"),
            nullable=False,
        ),
        sa.Column(
            "access", sa.Enum("read", "write", name="accesslevel"), nullable=False
        ),
        sa.Column(
            "secrets",
            sqlalchemy_utils.types.encrypted.encrypted_type.StringEncryptedType(),
            nullable=True,
        ),
        sa.Column("last_test_timestamp", sa.DateTime(timezone=True), nullable=True),
        sa.Column("last_test_succeeded", sa.Boolean(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_connectionconfig_id"), "connectionconfig", ["id"], unique=False
    )
    op.create_index(
        op.f("ix_connectionconfig_key"), "connectionconfig", ["key"], unique=True
    )
    op.create_index(
        op.f("ix_connectionconfig_name"), "connectionconfig", ["name"], unique=True
    )
    op.create_table(
        "executionlog",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("dataset_name", sa.String(), nullable=True),
        sa.Column("collection_name", sa.String(), nullable=True),
        sa.Column(
            "fields_affected", postgresql.JSONB(astext_type=sa.Text()), nullable=True
        ),
        sa.Column("message", sa.String(), nullable=True),
        sa.Column(
            "action_type",
            sa.Enum("access", "consent", "erasure", "update", name="actiontype"),
            nullable=False,
        ),
        sa.Column(
            "status",
            sa.Enum(
                "in_processing",
                "pending",
                "complete",
                "error",
                "retrying",
                name="executionlogstatus",
            ),
            nullable=False,
        ),
        sa.Column("privacy_request_id", sa.String(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_executionlog_action_type"),
        "executionlog",
        ["action_type"],
        unique=False,
    )
    op.create_index(
        op.f("ix_executionlog_collection_name"),
        "executionlog",
        ["collection_name"],
        unique=False,
    )
    op.create_index(
        op.f("ix_executionlog_dataset_name"),
        "executionlog",
        ["dataset_name"],
        unique=False,
    )
    op.create_index(op.f("ix_executionlog_id"), "executionlog", ["id"], unique=False)
    op.create_index(
        op.f("ix_executionlog_privacy_request_id"),
        "executionlog",
        ["privacy_request_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_executionlog_status"), "executionlog", ["status"], unique=False
    )
    op.create_table(
        "storageconfig",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("name", sa.String(), nullable=True),
        sa.Column(
            "type",
            sa.Enum(
                "s3",
                "gcs",
                "transcend",
                "onetrust",
                "ethyca",
                "local",
                name="storagetype",
            ),
            nullable=False,
        ),
        sa.Column("details", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.Column("key", sa.String(), nullable=False),
        sa.Column(
            "secrets",
            sqlalchemy_utils.types.encrypted.encrypted_type.StringEncryptedType(),
            nullable=True,
        ),
        sa.Column(
            "format",
            sa.Enum("json", "csv", name="responseformat"),
            server_default="json",
            nullable=False,
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_storageconfig_id"), "storageconfig", ["id"], unique=False)
    op.create_index(op.f("ix_storageconfig_key"), "storageconfig", ["key"], unique=True)
    op.create_index(
        op.f("ix_storageconfig_name"), "storageconfig", ["name"], unique=True
    )
    op.create_index(
        op.f("ix_storageconfig_type"), "storageconfig", ["type"], unique=False
    )
    op.create_table(
        "datasetconfig",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("connection_config_id", sa.String(), nullable=False),
        sa.Column("fides_key", sa.String(), nullable=False),
        sa.Column("dataset", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.ForeignKeyConstraint(
            ["connection_config_id"],
            ["connectionconfig.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_datasetconfig_fides_key"), "datasetconfig", ["fides_key"], unique=True
    )
    op.create_index(op.f("ix_datasetconfig_id"), "datasetconfig", ["id"], unique=False)
    op.create_table(
        "policy",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("key", sa.String(), nullable=False),
        sa.Column("client_id", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["client_id"],
            ["client.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name"),
    )
    op.create_index(op.f("ix_policy_id"), "policy", ["id"], unique=False)
    op.create_index(op.f("ix_policy_key"), "policy", ["key"], unique=True)
    op.create_table(
        "privacyrequest",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("external_id", sa.String(), nullable=True),
        sa.Column("started_processing_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column("finished_processing_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column("requested_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column(
            "status",
            sa.Enum(
                "in_processing",
                "pending",
                "complete",
                "error",
                name="privacyrequeststatus",
            ),
            nullable=False,
        ),
        sa.Column("client_id", sa.String(), nullable=True),
        sa.Column("origin", sa.String(), nullable=True),
        sa.Column("policy_id", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["client_id"],
            ["client.id"],
        ),
        sa.ForeignKeyConstraint(
            ["policy_id"],
            ["policy.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_privacyrequest_external_id"),
        "privacyrequest",
        ["external_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_privacyrequest_id"), "privacyrequest", ["id"], unique=False
    )
    op.create_index(
        op.f("ix_privacyrequest_status"), "privacyrequest", ["status"], unique=False
    )
    op.create_table(
        "rule",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("key", sa.String(), nullable=False),
        sa.Column("policy_id", sa.String(), nullable=False),
        sa.Column(
            "action_type",
            sa.Enum("access", "consent", "erasure", "update", name="actiontype"),
            nullable=False,
        ),
        sa.Column(
            "masking_strategy",
            sqlalchemy_utils.types.encrypted.encrypted_type.StringEncryptedType(),
            nullable=True,
        ),
        sa.Column("storage_destination_id", sa.String(), nullable=True),
        sa.Column("client_id", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["client_id"],
            ["client.id"],
        ),
        sa.ForeignKeyConstraint(
            ["policy_id"],
            ["policy.id"],
        ),
        sa.ForeignKeyConstraint(
            ["storage_destination_id"],
            ["storageconfig.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name"),
    )
    op.create_index(op.f("ix_rule_id"), "rule", ["id"], unique=False)
    op.create_index(op.f("ix_rule_key"), "rule", ["key"], unique=True)
    op.create_table(
        "ruletarget",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("key", sa.String(), nullable=False),
        sa.Column("data_category", sa.String(), nullable=False),
        sa.Column("rule_id", sa.String(), nullable=False),
        sa.Column("client_id", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["client_id"],
            ["client.id"],
        ),
        sa.ForeignKeyConstraint(
            ["rule_id"],
            ["rule.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name"),
        sa.UniqueConstraint(
            "rule_id", "data_category", name="_rule_id_data_category_uc"
        ),
    )
    op.create_index(op.f("ix_ruletarget_id"), "ruletarget", ["id"], unique=False)
    op.create_index(op.f("ix_ruletarget_key"), "ruletarget", ["key"], unique=True)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_ruletarget_key"), table_name="ruletarget")
    op.drop_index(op.f("ix_ruletarget_id"), table_name="ruletarget")
    op.drop_table("ruletarget")
    op.drop_index(op.f("ix_rule_key"), table_name="rule")
    op.drop_index(op.f("ix_rule_id"), table_name="rule")
    op.drop_table("rule")
    op.drop_index(op.f("ix_privacyrequest_status"), table_name="privacyrequest")
    op.drop_index(op.f("ix_privacyrequest_id"), table_name="privacyrequest")
    op.drop_index(op.f("ix_privacyrequest_external_id"), table_name="privacyrequest")
    op.drop_table("privacyrequest")
    op.drop_index(op.f("ix_policy_key"), table_name="policy")
    op.drop_index(op.f("ix_policy_id"), table_name="policy")
    op.drop_table("policy")
    op.drop_index(op.f("ix_datasetconfig_id"), table_name="datasetconfig")
    op.drop_index(op.f("ix_datasetconfig_fides_key"), table_name="datasetconfig")
    op.drop_table("datasetconfig")
    op.drop_index(op.f("ix_storageconfig_type"), table_name="storageconfig")
    op.drop_index(op.f("ix_storageconfig_name"), table_name="storageconfig")
    op.drop_index(op.f("ix_storageconfig_key"), table_name="storageconfig")
    op.drop_index(op.f("ix_storageconfig_id"), table_name="storageconfig")
    op.drop_table("storageconfig")
    op.drop_index(op.f("ix_executionlog_status"), table_name="executionlog")
    op.drop_index(op.f("ix_executionlog_privacy_request_id"), table_name="executionlog")
    op.drop_index(op.f("ix_executionlog_id"), table_name="executionlog")
    op.drop_index(op.f("ix_executionlog_dataset_name"), table_name="executionlog")
    op.drop_index(op.f("ix_executionlog_collection_name"), table_name="executionlog")
    op.drop_index(op.f("ix_executionlog_action_type"), table_name="executionlog")
    op.drop_table("executionlog")
    op.drop_index(op.f("ix_connectionconfig_name"), table_name="connectionconfig")
    op.drop_index(op.f("ix_connectionconfig_key"), table_name="connectionconfig")
    op.drop_index(op.f("ix_connectionconfig_id"), table_name="connectionconfig")
    op.drop_table("connectionconfig")
    op.drop_index(op.f("ix_client_id"), table_name="client")
    op.drop_table("client")
    # ### end Alembic commands ###
