"""add user assigned data_uses and system_id columns to stagedresource

Revision ID: 7c3fbee90c78
Revises: 9a1eacd2666b
Create Date: 2025-03-04 15:00:23.874270

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "7c3fbee90c78"
down_revision = "9a1eacd2666b"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "stagedresource",
        sa.Column(
            "user_assigned_system_id", sa.VARCHAR(), autoincrement=False, nullable=True
        ),
    )
    op.add_column(
        "stagedresource",
        sa.Column(
            "user_assigned_data_uses",
            postgresql.ARRAY(sa.VARCHAR()),
            server_default=sa.text("'{}'::character varying[]"),
            autoincrement=False,
            nullable=False,
        ),
    )
    # ### end Alembic commands ###
    op.create_index(
        "ix_stagedresource_user_assigned_system_id",
        "stagedresource",
        ["user_assigned_system_id"],
        unique=False,
    )


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("stagedresource", "user_assigned_data_uses")
    op.drop_column("stagedresource", "user_assigned_system_id")
    # ### end Alembic commands ###
    op.drop_index(
        "ix_stagedresource_user_assigned_system_id", table_name="stagedresource"
    )
