# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetZoneResult',
    'AwaitableGetZoneResult',
    'get_zone',
    'get_zone_output',
]

@pulumi.output_type
class GetZoneResult:
    """
    A collection of values returned by getZone.
    """
    def __init__(__self__, authoritative_nameservers=None, delete_protection=None, id=None, labels=None, mode=None, name=None, primary_nameservers=None, registrar=None, ttl=None, with_selector=None):
        if authoritative_nameservers and not isinstance(authoritative_nameservers, dict):
            raise TypeError("Expected argument 'authoritative_nameservers' to be a dict")
        pulumi.set(__self__, "authoritative_nameservers", authoritative_nameservers)
        if delete_protection and not isinstance(delete_protection, bool):
            raise TypeError("Expected argument 'delete_protection' to be a bool")
        pulumi.set(__self__, "delete_protection", delete_protection)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if mode and not isinstance(mode, str):
            raise TypeError("Expected argument 'mode' to be a str")
        pulumi.set(__self__, "mode", mode)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if primary_nameservers and not isinstance(primary_nameservers, list):
            raise TypeError("Expected argument 'primary_nameservers' to be a list")
        pulumi.set(__self__, "primary_nameservers", primary_nameservers)
        if registrar and not isinstance(registrar, str):
            raise TypeError("Expected argument 'registrar' to be a str")
        pulumi.set(__self__, "registrar", registrar)
        if ttl and not isinstance(ttl, int):
            raise TypeError("Expected argument 'ttl' to be a int")
        pulumi.set(__self__, "ttl", ttl)
        if with_selector and not isinstance(with_selector, str):
            raise TypeError("Expected argument 'with_selector' to be a str")
        pulumi.set(__self__, "with_selector", with_selector)

    @_builtins.property
    @pulumi.getter(name="authoritativeNameservers")
    def authoritative_nameservers(self) -> 'outputs.GetZoneAuthoritativeNameserversResult':
        """
        Authoritative nameservers of the Zone.
        """
        return pulumi.get(self, "authoritative_nameservers")

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> _builtins.bool:
        """
        Whether delete protection is enabled.
        """
        return pulumi.get(self, "delete_protection")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.int]:
        """
        ID of the Zone.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        Mode of the Zone.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the Zone.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primaryNameservers")
    def primary_nameservers(self) -> Sequence['outputs.GetZonePrimaryNameserverResult']:
        """
        Primary nameservers of the Zone.
        """
        return pulumi.get(self, "primary_nameservers")

    @_builtins.property
    @pulumi.getter
    def registrar(self) -> _builtins.str:
        """
        Registrar of the Zone.
        """
        return pulumi.get(self, "registrar")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> _builtins.int:
        """
        Default Time To Live (TTL) of the Zone.
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter(name="withSelector")
    def with_selector(self) -> Optional[_builtins.str]:
        """
        Filter results using a [Label Selector](https://docs.hetzner.cloud/reference/cloud#label-selector).
        """
        return pulumi.get(self, "with_selector")


class AwaitableGetZoneResult(GetZoneResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneResult(
            authoritative_nameservers=self.authoritative_nameservers,
            delete_protection=self.delete_protection,
            id=self.id,
            labels=self.labels,
            mode=self.mode,
            name=self.name,
            primary_nameservers=self.primary_nameservers,
            registrar=self.registrar,
            ttl=self.ttl,
            with_selector=self.with_selector)


def get_zone(id: Optional[_builtins.int] = None,
             name: Optional[_builtins.str] = None,
             with_selector: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneResult:
    """
    Provides details about a Hetzner Cloud Zone.

    For Internationalized domain names (IDN), see the `provider::hcloud::idna` function.

    See the [Zones API documentation](https://docs.hetzner.cloud/reference/cloud#zones) for more details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    by_id = hcloud.get_zone(id=1234)
    by_name = hcloud.get_zone(name="example.com")
    by_label = hcloud.get_zone(with_selector="key=value")
    ```


    :param _builtins.int id: ID of the Zone.
    :param _builtins.str name: Name of the Zone.
    :param _builtins.str with_selector: Filter results using a [Label Selector](https://docs.hetzner.cloud/reference/cloud#label-selector).
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['withSelector'] = with_selector
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('hcloud:index/getZone:getZone', __args__, opts=opts, typ=GetZoneResult).value

    return AwaitableGetZoneResult(
        authoritative_nameservers=pulumi.get(__ret__, 'authoritative_nameservers'),
        delete_protection=pulumi.get(__ret__, 'delete_protection'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        mode=pulumi.get(__ret__, 'mode'),
        name=pulumi.get(__ret__, 'name'),
        primary_nameservers=pulumi.get(__ret__, 'primary_nameservers'),
        registrar=pulumi.get(__ret__, 'registrar'),
        ttl=pulumi.get(__ret__, 'ttl'),
        with_selector=pulumi.get(__ret__, 'with_selector'))
def get_zone_output(id: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                    name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    with_selector: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZoneResult]:
    """
    Provides details about a Hetzner Cloud Zone.

    For Internationalized domain names (IDN), see the `provider::hcloud::idna` function.

    See the [Zones API documentation](https://docs.hetzner.cloud/reference/cloud#zones) for more details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    by_id = hcloud.get_zone(id=1234)
    by_name = hcloud.get_zone(name="example.com")
    by_label = hcloud.get_zone(with_selector="key=value")
    ```


    :param _builtins.int id: ID of the Zone.
    :param _builtins.str name: Name of the Zone.
    :param _builtins.str with_selector: Filter results using a [Label Selector](https://docs.hetzner.cloud/reference/cloud#label-selector).
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['withSelector'] = with_selector
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('hcloud:index/getZone:getZone', __args__, opts=opts, typ=GetZoneResult)
    return __ret__.apply(lambda __response__: GetZoneResult(
        authoritative_nameservers=pulumi.get(__response__, 'authoritative_nameservers'),
        delete_protection=pulumi.get(__response__, 'delete_protection'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        mode=pulumi.get(__response__, 'mode'),
        name=pulumi.get(__response__, 'name'),
        primary_nameservers=pulumi.get(__response__, 'primary_nameservers'),
        registrar=pulumi.get(__response__, 'registrar'),
        ttl=pulumi.get(__response__, 'ttl'),
        with_selector=pulumi.get(__response__, 'with_selector')))
