# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LoadBalancerNetworkArgs', 'LoadBalancerNetwork']

@pulumi.input_type
class LoadBalancerNetworkArgs:
    def __init__(__self__, *,
                 load_balancer_id: pulumi.Input[_builtins.int],
                 enable_public_interface: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LoadBalancerNetwork resource.
        :param pulumi.Input[_builtins.int] load_balancer_id: ID of the Load Balancer.
        :param pulumi.Input[_builtins.bool] enable_public_interface: Wether the Load Balancer public interface is enabled. Default is `true`.
        :param pulumi.Input[_builtins.str] ip: IP to assign to the Load Balancer.
        :param pulumi.Input[_builtins.int] network_id: ID of the Network to attach the Load Balancer to. Using `subnet_id` is preferred. Required if `subnet_id` is not set. If `subnet_id` or `ip` are not set, the Load Balancer will be attached to the last subnet (ordered by `ip_range`).
        :param pulumi.Input[_builtins.str] subnet_id: ID of the Subnet to attach the Load Balancer to. Required if `network_id` is not set.
        """
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if enable_public_interface is not None:
            pulumi.set(__self__, "enable_public_interface", enable_public_interface)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[_builtins.int]:
        """
        ID of the Load Balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "load_balancer_id", value)

    @_builtins.property
    @pulumi.getter(name="enablePublicInterface")
    def enable_public_interface(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Wether the Load Balancer public interface is enabled. Default is `true`.
        """
        return pulumi.get(self, "enable_public_interface")

    @enable_public_interface.setter
    def enable_public_interface(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_public_interface", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP to assign to the Load Balancer.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        ID of the Network to attach the Load Balancer to. Using `subnet_id` is preferred. Required if `subnet_id` is not set. If `subnet_id` or `ip` are not set, the Load Balancer will be attached to the last subnet (ordered by `ip_range`).
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Subnet to attach the Load Balancer to. Required if `network_id` is not set.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class _LoadBalancerNetworkState:
    def __init__(__self__, *,
                 enable_public_interface: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.int]] = None,
                 network_id: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoadBalancerNetwork resources.
        :param pulumi.Input[_builtins.bool] enable_public_interface: Wether the Load Balancer public interface is enabled. Default is `true`.
        :param pulumi.Input[_builtins.str] ip: IP to assign to the Load Balancer.
        :param pulumi.Input[_builtins.int] load_balancer_id: ID of the Load Balancer.
        :param pulumi.Input[_builtins.int] network_id: ID of the Network to attach the Load Balancer to. Using `subnet_id` is preferred. Required if `subnet_id` is not set. If `subnet_id` or `ip` are not set, the Load Balancer will be attached to the last subnet (ordered by `ip_range`).
        :param pulumi.Input[_builtins.str] subnet_id: ID of the Subnet to attach the Load Balancer to. Required if `network_id` is not set.
        """
        if enable_public_interface is not None:
            pulumi.set(__self__, "enable_public_interface", enable_public_interface)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="enablePublicInterface")
    def enable_public_interface(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Wether the Load Balancer public interface is enabled. Default is `true`.
        """
        return pulumi.get(self, "enable_public_interface")

    @enable_public_interface.setter
    def enable_public_interface(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_public_interface", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP to assign to the Load Balancer.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        ID of the Load Balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "load_balancer_id", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        ID of the Network to attach the Load Balancer to. Using `subnet_id` is preferred. Required if `subnet_id` is not set. If `subnet_id` or `ip` are not set, the Load Balancer will be attached to the last subnet (ordered by `ip_range`).
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Subnet to attach the Load Balancer to. Required if `network_id` is not set.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.type_token("hcloud:index/loadBalancerNetwork:LoadBalancerNetwork")
class LoadBalancerNetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_public_interface: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.int]] = None,
                 network_id: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manage the attachment of a Load Balancer in a Network in the Hetzner Cloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        main = hcloud.LoadBalancer("main",
            name="main",
            load_balancer_type="lb11",
            network_zone="eu-central")
        network = hcloud.Network("network",
            name="network",
            ip_range="10.0.0.0/16")
        subnet = hcloud.NetworkSubnet("subnet",
            network_id=network.id,
            type="cloud",
            network_zone="eu-central",
            ip_range="10.0.1.0/24")
        attachment = hcloud.LoadBalancerNetwork("attachment",
            load_balancer_id=main.id,
            subnet_id=subnet.id,
            ip="10.0.1.5")
        ```

        ## Import

        In Terraform v1.5.0 and later, the `import` block can be used with the `id` attribute, for example:

        terraform

        import {

          id = "${hcloud_load_balancer.example.id}-${hcloud_network.example.id}"

          to = hcloud_load_balancer_network.attachment

        }

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import hcloud:index/loadBalancerNetwork:LoadBalancerNetwork example "$LOAD_BALANCER_ID-$NETWORK_ID"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enable_public_interface: Wether the Load Balancer public interface is enabled. Default is `true`.
        :param pulumi.Input[_builtins.str] ip: IP to assign to the Load Balancer.
        :param pulumi.Input[_builtins.int] load_balancer_id: ID of the Load Balancer.
        :param pulumi.Input[_builtins.int] network_id: ID of the Network to attach the Load Balancer to. Using `subnet_id` is preferred. Required if `subnet_id` is not set. If `subnet_id` or `ip` are not set, the Load Balancer will be attached to the last subnet (ordered by `ip_range`).
        :param pulumi.Input[_builtins.str] subnet_id: ID of the Subnet to attach the Load Balancer to. Required if `network_id` is not set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage the attachment of a Load Balancer in a Network in the Hetzner Cloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        main = hcloud.LoadBalancer("main",
            name="main",
            load_balancer_type="lb11",
            network_zone="eu-central")
        network = hcloud.Network("network",
            name="network",
            ip_range="10.0.0.0/16")
        subnet = hcloud.NetworkSubnet("subnet",
            network_id=network.id,
            type="cloud",
            network_zone="eu-central",
            ip_range="10.0.1.0/24")
        attachment = hcloud.LoadBalancerNetwork("attachment",
            load_balancer_id=main.id,
            subnet_id=subnet.id,
            ip="10.0.1.5")
        ```

        ## Import

        In Terraform v1.5.0 and later, the `import` block can be used with the `id` attribute, for example:

        terraform

        import {

          id = "${hcloud_load_balancer.example.id}-${hcloud_network.example.id}"

          to = hcloud_load_balancer_network.attachment

        }

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import hcloud:index/loadBalancerNetwork:LoadBalancerNetwork example "$LOAD_BALANCER_ID-$NETWORK_ID"
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_public_interface: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.int]] = None,
                 network_id: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerNetworkArgs.__new__(LoadBalancerNetworkArgs)

            __props__.__dict__["enable_public_interface"] = enable_public_interface
            __props__.__dict__["ip"] = ip
            if load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_id'")
            __props__.__dict__["load_balancer_id"] = load_balancer_id
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["subnet_id"] = subnet_id
        super(LoadBalancerNetwork, __self__).__init__(
            'hcloud:index/loadBalancerNetwork:LoadBalancerNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_public_interface: Optional[pulumi.Input[_builtins.bool]] = None,
            ip: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancer_id: Optional[pulumi.Input[_builtins.int]] = None,
            network_id: Optional[pulumi.Input[_builtins.int]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'LoadBalancerNetwork':
        """
        Get an existing LoadBalancerNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enable_public_interface: Wether the Load Balancer public interface is enabled. Default is `true`.
        :param pulumi.Input[_builtins.str] ip: IP to assign to the Load Balancer.
        :param pulumi.Input[_builtins.int] load_balancer_id: ID of the Load Balancer.
        :param pulumi.Input[_builtins.int] network_id: ID of the Network to attach the Load Balancer to. Using `subnet_id` is preferred. Required if `subnet_id` is not set. If `subnet_id` or `ip` are not set, the Load Balancer will be attached to the last subnet (ordered by `ip_range`).
        :param pulumi.Input[_builtins.str] subnet_id: ID of the Subnet to attach the Load Balancer to. Required if `network_id` is not set.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerNetworkState.__new__(_LoadBalancerNetworkState)

        __props__.__dict__["enable_public_interface"] = enable_public_interface
        __props__.__dict__["ip"] = ip
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["subnet_id"] = subnet_id
        return LoadBalancerNetwork(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="enablePublicInterface")
    def enable_public_interface(self) -> pulumi.Output[_builtins.bool]:
        """
        Wether the Load Balancer public interface is enabled. Default is `true`.
        """
        return pulumi.get(self, "enable_public_interface")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Output[_builtins.str]:
        """
        IP to assign to the Load Balancer.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[_builtins.int]:
        """
        ID of the Load Balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.int]:
        """
        ID of the Network to attach the Load Balancer to. Using `subnet_id` is preferred. Required if `subnet_id` is not set. If `subnet_id` or `ip` are not set, the Load Balancer will be attached to the last subnet (ordered by `ip_range`).
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the Subnet to attach the Load Balancer to. Required if `network_id` is not set.
        """
        return pulumi.get(self, "subnet_id")

