# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ManagedCertificateArgs', 'ManagedCertificate']

@pulumi.input_type
class ManagedCertificateArgs:
    def __init__(__self__, *,
                 domain_names: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedCertificate resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domain_names: Domain names for which a certificate
               should be obtained.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels (key-value pairs) the
               certificate should be created with.
        :param pulumi.Input[_builtins.str] name: Name of the Certificate.
        """
        pulumi.set(__self__, "domain_names", domain_names)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Domain names for which a certificate
        should be obtained.
        """
        return pulumi.get(self, "domain_names")

    @domain_names.setter
    def domain_names(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "domain_names", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-defined labels (key-value pairs) the
        certificate should be created with.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Certificate.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ManagedCertificateState:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 not_valid_after: Optional[pulumi.Input[_builtins.str]] = None,
                 not_valid_before: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedCertificate resources.
        :param pulumi.Input[_builtins.str] certificate: (string) PEM encoded TLS certificate.
        :param pulumi.Input[_builtins.str] created: (string) Point in time when the Certificate was created at Hetzner Cloud (in ISO-8601 format).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domain_names: Domain names for which a certificate
               should be obtained.
        :param pulumi.Input[_builtins.str] fingerprint: (string) Fingerprint of the certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels (key-value pairs) the
               certificate should be created with.
        :param pulumi.Input[_builtins.str] name: Name of the Certificate.
        :param pulumi.Input[_builtins.str] not_valid_after: (string) Point in time when the Certificate stops being valid (in ISO-8601 format).
        :param pulumi.Input[_builtins.str] not_valid_before: (string) Point in time when the Certificate becomes valid (in ISO-8601 format).
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if domain_names is not None:
            pulumi.set(__self__, "domain_names", domain_names)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if not_valid_after is not None:
            pulumi.set(__self__, "not_valid_after", not_valid_after)
        if not_valid_before is not None:
            pulumi.set(__self__, "not_valid_before", not_valid_before)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) PEM encoded TLS certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) Point in time when the Certificate was created at Hetzner Cloud (in ISO-8601 format).
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Domain names for which a certificate
        should be obtained.
        """
        return pulumi.get(self, "domain_names")

    @domain_names.setter
    def domain_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "domain_names", value)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) Fingerprint of the certificate.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-defined labels (key-value pairs) the
        certificate should be created with.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Certificate.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notValidAfter")
    def not_valid_after(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) Point in time when the Certificate stops being valid (in ISO-8601 format).
        """
        return pulumi.get(self, "not_valid_after")

    @not_valid_after.setter
    def not_valid_after(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_valid_after", value)

    @_builtins.property
    @pulumi.getter(name="notValidBefore")
    def not_valid_before(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) Point in time when the Certificate becomes valid (in ISO-8601 format).
        """
        return pulumi.get(self, "not_valid_before")

    @not_valid_before.setter
    def not_valid_before(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_valid_before", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("hcloud:index/managedCertificate:ManagedCertificate")
class ManagedCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Obtain a Hetzner Cloud managed TLS certificate.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        managed_cert = hcloud.ManagedCertificate("managed_cert",
            name="managed_cert",
            domain_names=[
                "*.example.com",
                "example.com",
            ],
            labels={
                "label_1": "value_1",
                "label_2": "value_2",
            })
        ```

        ## Import

        Managed certificates can be imported using their `id`:

        ```sh
        $ pulumi import hcloud:index/managedCertificate:ManagedCertificate example "$CERTIFICATE_ID"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domain_names: Domain names for which a certificate
               should be obtained.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels (key-value pairs) the
               certificate should be created with.
        :param pulumi.Input[_builtins.str] name: Name of the Certificate.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Obtain a Hetzner Cloud managed TLS certificate.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        managed_cert = hcloud.ManagedCertificate("managed_cert",
            name="managed_cert",
            domain_names=[
                "*.example.com",
                "example.com",
            ],
            labels={
                "label_1": "value_1",
                "label_2": "value_2",
            })
        ```

        ## Import

        Managed certificates can be imported using their `id`:

        ```sh
        $ pulumi import hcloud:index/managedCertificate:ManagedCertificate example "$CERTIFICATE_ID"
        ```

        :param str resource_name: The name of the resource.
        :param ManagedCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedCertificateArgs.__new__(ManagedCertificateArgs)

            if domain_names is None and not opts.urn:
                raise TypeError("Missing required property 'domain_names'")
            __props__.__dict__["domain_names"] = domain_names
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["certificate"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["not_valid_after"] = None
            __props__.__dict__["not_valid_before"] = None
            __props__.__dict__["type"] = None
        super(ManagedCertificate, __self__).__init__(
            'hcloud:index/managedCertificate:ManagedCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            not_valid_after: Optional[pulumi.Input[_builtins.str]] = None,
            not_valid_before: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagedCertificate':
        """
        Get an existing ManagedCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate: (string) PEM encoded TLS certificate.
        :param pulumi.Input[_builtins.str] created: (string) Point in time when the Certificate was created at Hetzner Cloud (in ISO-8601 format).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domain_names: Domain names for which a certificate
               should be obtained.
        :param pulumi.Input[_builtins.str] fingerprint: (string) Fingerprint of the certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels (key-value pairs) the
               certificate should be created with.
        :param pulumi.Input[_builtins.str] name: Name of the Certificate.
        :param pulumi.Input[_builtins.str] not_valid_after: (string) Point in time when the Certificate stops being valid (in ISO-8601 format).
        :param pulumi.Input[_builtins.str] not_valid_before: (string) Point in time when the Certificate becomes valid (in ISO-8601 format).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedCertificateState.__new__(_ManagedCertificateState)

        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["created"] = created
        __props__.__dict__["domain_names"] = domain_names
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["not_valid_after"] = not_valid_after
        __props__.__dict__["not_valid_before"] = not_valid_before
        __props__.__dict__["type"] = type
        return ManagedCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[_builtins.str]:
        """
        (string) PEM encoded TLS certificate.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        (string) Point in time when the Certificate was created at Hetzner Cloud (in ISO-8601 format).
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Domain names for which a certificate
        should be obtained.
        """
        return pulumi.get(self, "domain_names")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        (string) Fingerprint of the certificate.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        User-defined labels (key-value pairs) the
        certificate should be created with.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Certificate.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notValidAfter")
    def not_valid_after(self) -> pulumi.Output[_builtins.str]:
        """
        (string) Point in time when the Certificate stops being valid (in ISO-8601 format).
        """
        return pulumi.get(self, "not_valid_after")

    @_builtins.property
    @pulumi.getter(name="notValidBefore")
    def not_valid_before(self) -> pulumi.Output[_builtins.str]:
        """
        (string) Point in time when the Certificate becomes valid (in ISO-8601 format).
        """
        return pulumi.get(self, "not_valid_before")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "type")

