# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetResourceGroupsResult',
    'AwaitableGetResourceGroupsResult',
    'get_resource_groups',
    'get_resource_groups_output',
]

@pulumi.output_type
class GetResourceGroupsResult:
    """
    A collection of values returned by getResourceGroups.
    """
    def __init__(__self__, db_cluster_id=None, group_name=None, groups=None, id=None, ids=None, output_file=None):
        if db_cluster_id and not isinstance(db_cluster_id, str):
            raise TypeError("Expected argument 'db_cluster_id' to be a str")
        pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        if group_name and not isinstance(group_name, str):
            raise TypeError("Expected argument 'group_name' to be a str")
        pulumi.set(__self__, "group_name", group_name)
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> _builtins.str:
        """
        DB cluster id.
        """
        return pulumi.get(self, "db_cluster_id")

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[_builtins.str]:
        """
        The name of the resource pool.
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetResourceGroupsGroupResult']:
        """
        A list of Resource Group Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetResourceGroupsResult(GetResourceGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceGroupsResult(
            db_cluster_id=self.db_cluster_id,
            group_name=self.group_name,
            groups=self.groups,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file)


def get_resource_groups(db_cluster_id: Optional[_builtins.str] = None,
                        group_name: Optional[_builtins.str] = None,
                        ids: Optional[Sequence[_builtins.str]] = None,
                        output_file: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceGroupsResult:
    """
    This data source provides Adb Resource Group available to the user.[What is Resource Group](https://www.alibabacloud.com/help/en/analyticdb-for-mysql/developer-reference/api-adb-2019-03-15-describedbresourcegroup)

    > **NOTE:** Available since v1.195.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.adb.get_resource_groups(db_cluster_id="am-bp1a16357gty69185",
        group_name="TESTOPENAPI")
    pulumi.export("alicloudAdbResourceGroupExampleId", default.groups[0].id)
    ```


    :param _builtins.str db_cluster_id: DBClusterId
    :param _builtins.str group_name: The name of the resource pool, which cannot exceed 64 bytes in length.
    :param Sequence[_builtins.str] ids: A list of AnalyticDB for MySQL (ADB) Resource Group IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['dbClusterId'] = db_cluster_id
    __args__['groupName'] = group_name
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:adb/getResourceGroups:getResourceGroups', __args__, opts=opts, typ=GetResourceGroupsResult).value

    return AwaitableGetResourceGroupsResult(
        db_cluster_id=pulumi.get(__ret__, 'db_cluster_id'),
        group_name=pulumi.get(__ret__, 'group_name'),
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_resource_groups_output(db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                               group_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                               output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceGroupsResult]:
    """
    This data source provides Adb Resource Group available to the user.[What is Resource Group](https://www.alibabacloud.com/help/en/analyticdb-for-mysql/developer-reference/api-adb-2019-03-15-describedbresourcegroup)

    > **NOTE:** Available since v1.195.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.adb.get_resource_groups(db_cluster_id="am-bp1a16357gty69185",
        group_name="TESTOPENAPI")
    pulumi.export("alicloudAdbResourceGroupExampleId", default.groups[0].id)
    ```


    :param _builtins.str db_cluster_id: DBClusterId
    :param _builtins.str group_name: The name of the resource pool, which cannot exceed 64 bytes in length.
    :param Sequence[_builtins.str] ids: A list of AnalyticDB for MySQL (ADB) Resource Group IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['dbClusterId'] = db_cluster_id
    __args__['groupName'] = group_name
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:adb/getResourceGroups:getResourceGroups', __args__, opts=opts, typ=GetResourceGroupsResult)
    return __ret__.apply(lambda __response__: GetResourceGroupsResult(
        db_cluster_id=pulumi.get(__response__, 'db_cluster_id'),
        group_name=pulumi.get(__response__, 'group_name'),
        groups=pulumi.get(__response__, 'groups'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file')))
