# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ListenerArgs', 'Listener']

@pulumi.input_type
class ListenerArgs:
    def __init__(__self__, *,
                 default_actions: pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]],
                 listener_port: pulumi.Input[_builtins.int],
                 listener_protocol: pulumi.Input[_builtins.str],
                 load_balancer_id: pulumi.Input[_builtins.str],
                 access_log_record_customized_headers_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 access_log_tracing_config: Optional[pulumi.Input['ListenerAccessLogTracingConfigArgs']] = None,
                 acl_config: Optional[pulumi.Input['ListenerAclConfigArgs']] = None,
                 ca_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerCaCertificateArgs']]]] = None,
                 ca_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificates: Optional[pulumi.Input['ListenerCertificatesArgs']] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 gzip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 http2_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_description: Optional[pulumi.Input[_builtins.str]] = None,
                 quic_config: Optional[pulumi.Input['ListenerQuicConfigArgs']] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 x_forwarded_for_config: Optional[pulumi.Input['ListenerXForwardedForConfigArgs']] = None):
        """
        The set of arguments for constructing a Listener resource.
        :param pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]] default_actions: The Default Rule Action List See `default_actions` below.
        :param pulumi.Input[_builtins.int] listener_port: The SLB Instance Front-End, and Those of the Ports Used. Value: 1~65535.
        :param pulumi.Input[_builtins.str] listener_protocol: Snooping Protocols. Valid Values: HTTP, HTTPS Or QuIC.
        :param pulumi.Input[_builtins.str] load_balancer_id: The SLB Instance Id.
        :param pulumi.Input[_builtins.bool] access_log_record_customized_headers_enabled: Access Log Whether to Enable Carry Custom Header Field. Valid values: `true`, `false`. Default Value: `false`.
               
               > **NOTE:**  Only Instances outside the Security Group to Access the Log Switch `accesslogenabled` Open, in Order to Set This Parameter to the `true`.
        :param pulumi.Input['ListenerAccessLogTracingConfigArgs'] access_log_tracing_config: Xtrace Configuration Information. See `access_log_tracing_config` below.
        :param pulumi.Input['ListenerAclConfigArgs'] acl_config: The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alb.ListenerAclAttachment`.,
        :param pulumi.Input[Sequence[pulumi.Input['ListenerCaCertificateArgs']]] ca_certificates: The list of certificates. See `ca_certificates` below.
        :param pulumi.Input[_builtins.bool] ca_enabled: Whether to turn on two-way authentication. Value:
        :param pulumi.Input['ListenerCertificatesArgs'] certificates: The list of certificates. See `certificates` below.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
        :param pulumi.Input[_builtins.bool] gzip_enabled: Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid Values: True Or False. Default Value: TRUE.
        :param pulumi.Input[_builtins.bool] http2_enabled: Whether to Enable HTTP/2 Features. Valid Values: True Or False. Default Value: TRUE.
        :param pulumi.Input[_builtins.int] idle_timeout: Specify the Connection Idle Timeout Value: 1 to 60 seconds.
        :param pulumi.Input[_builtins.str] listener_description: Set the IP Address of the Listened Description. Length Is from 2 to 256 Characters.
        :param pulumi.Input['ListenerQuicConfigArgs'] quic_config: Configuration Associated with the QuIC Listening See `quic_config` below.
        :param pulumi.Input[_builtins.int] request_timeout: The Specified Request Timeout Time. Value: 1~180 Seconds. Default Value: 60 seconds. If the Timeout Time Within the Back-End Server Has Not Answered the SLB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
        :param pulumi.Input[_builtins.str] security_policy_id: Security Policy
        :param pulumi.Input[_builtins.str] status: The Current IP Address of the Listened State
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input['ListenerXForwardedForConfigArgs'] x_forwarded_for_config: xforwardfor Related Attribute Configuration See `x_forwarded_for_config` below.
        """
        pulumi.set(__self__, "default_actions", default_actions)
        pulumi.set(__self__, "listener_port", listener_port)
        pulumi.set(__self__, "listener_protocol", listener_protocol)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if access_log_record_customized_headers_enabled is not None:
            pulumi.set(__self__, "access_log_record_customized_headers_enabled", access_log_record_customized_headers_enabled)
        if access_log_tracing_config is not None:
            pulumi.set(__self__, "access_log_tracing_config", access_log_tracing_config)
        if acl_config is not None:
            warnings.warn("""Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.""", DeprecationWarning)
            pulumi.log.warn("""acl_config is deprecated: Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.""")
        if acl_config is not None:
            pulumi.set(__self__, "acl_config", acl_config)
        if ca_certificates is not None:
            pulumi.set(__self__, "ca_certificates", ca_certificates)
        if ca_enabled is not None:
            pulumi.set(__self__, "ca_enabled", ca_enabled)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if gzip_enabled is not None:
            pulumi.set(__self__, "gzip_enabled", gzip_enabled)
        if http2_enabled is not None:
            pulumi.set(__self__, "http2_enabled", http2_enabled)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if listener_description is not None:
            pulumi.set(__self__, "listener_description", listener_description)
        if quic_config is not None:
            pulumi.set(__self__, "quic_config", quic_config)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if x_forwarded_for_config is not None:
            pulumi.set(__self__, "x_forwarded_for_config", x_forwarded_for_config)

    @_builtins.property
    @pulumi.getter(name="defaultActions")
    def default_actions(self) -> pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]]:
        """
        The Default Rule Action List See `default_actions` below.
        """
        return pulumi.get(self, "default_actions")

    @default_actions.setter
    def default_actions(self, value: pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]]):
        pulumi.set(self, "default_actions", value)

    @_builtins.property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> pulumi.Input[_builtins.int]:
        """
        The SLB Instance Front-End, and Those of the Ports Used. Value: 1~65535.
        """
        return pulumi.get(self, "listener_port")

    @listener_port.setter
    def listener_port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "listener_port", value)

    @_builtins.property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> pulumi.Input[_builtins.str]:
        """
        Snooping Protocols. Valid Values: HTTP, HTTPS Or QuIC.
        """
        return pulumi.get(self, "listener_protocol")

    @listener_protocol.setter
    def listener_protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "listener_protocol", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[_builtins.str]:
        """
        The SLB Instance Id.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "load_balancer_id", value)

    @_builtins.property
    @pulumi.getter(name="accessLogRecordCustomizedHeadersEnabled")
    def access_log_record_customized_headers_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Access Log Whether to Enable Carry Custom Header Field. Valid values: `true`, `false`. Default Value: `false`.

        > **NOTE:**  Only Instances outside the Security Group to Access the Log Switch `accesslogenabled` Open, in Order to Set This Parameter to the `true`.
        """
        return pulumi.get(self, "access_log_record_customized_headers_enabled")

    @access_log_record_customized_headers_enabled.setter
    def access_log_record_customized_headers_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "access_log_record_customized_headers_enabled", value)

    @_builtins.property
    @pulumi.getter(name="accessLogTracingConfig")
    def access_log_tracing_config(self) -> Optional[pulumi.Input['ListenerAccessLogTracingConfigArgs']]:
        """
        Xtrace Configuration Information. See `access_log_tracing_config` below.
        """
        return pulumi.get(self, "access_log_tracing_config")

    @access_log_tracing_config.setter
    def access_log_tracing_config(self, value: Optional[pulumi.Input['ListenerAccessLogTracingConfigArgs']]):
        pulumi.set(self, "access_log_tracing_config", value)

    @_builtins.property
    @pulumi.getter(name="aclConfig")
    @_utilities.deprecated("""Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.""")
    def acl_config(self) -> Optional[pulumi.Input['ListenerAclConfigArgs']]:
        """
        The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alb.ListenerAclAttachment`.,
        """
        return pulumi.get(self, "acl_config")

    @acl_config.setter
    def acl_config(self, value: Optional[pulumi.Input['ListenerAclConfigArgs']]):
        pulumi.set(self, "acl_config", value)

    @_builtins.property
    @pulumi.getter(name="caCertificates")
    def ca_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListenerCaCertificateArgs']]]]:
        """
        The list of certificates. See `ca_certificates` below.
        """
        return pulumi.get(self, "ca_certificates")

    @ca_certificates.setter
    def ca_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerCaCertificateArgs']]]]):
        pulumi.set(self, "ca_certificates", value)

    @_builtins.property
    @pulumi.getter(name="caEnabled")
    def ca_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to turn on two-way authentication. Value:
        """
        return pulumi.get(self, "ca_enabled")

    @ca_enabled.setter
    def ca_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ca_enabled", value)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input['ListenerCertificatesArgs']]:
        """
        The list of certificates. See `certificates` below.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input['ListenerCertificatesArgs']]):
        pulumi.set(self, "certificates", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to PreCheck only this request. Value:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="gzipEnabled")
    def gzip_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid Values: True Or False. Default Value: TRUE.
        """
        return pulumi.get(self, "gzip_enabled")

    @gzip_enabled.setter
    def gzip_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "gzip_enabled", value)

    @_builtins.property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to Enable HTTP/2 Features. Valid Values: True Or False. Default Value: TRUE.
        """
        return pulumi.get(self, "http2_enabled")

    @http2_enabled.setter
    def http2_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "http2_enabled", value)

    @_builtins.property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specify the Connection Idle Timeout Value: 1 to 60 seconds.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_timeout", value)

    @_builtins.property
    @pulumi.getter(name="listenerDescription")
    def listener_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the IP Address of the Listened Description. Length Is from 2 to 256 Characters.
        """
        return pulumi.get(self, "listener_description")

    @listener_description.setter
    def listener_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_description", value)

    @_builtins.property
    @pulumi.getter(name="quicConfig")
    def quic_config(self) -> Optional[pulumi.Input['ListenerQuicConfigArgs']]:
        """
        Configuration Associated with the QuIC Listening See `quic_config` below.
        """
        return pulumi.get(self, "quic_config")

    @quic_config.setter
    def quic_config(self, value: Optional[pulumi.Input['ListenerQuicConfigArgs']]):
        pulumi.set(self, "quic_config", value)

    @_builtins.property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Specified Request Timeout Time. Value: 1~180 Seconds. Default Value: 60 seconds. If the Timeout Time Within the Back-End Server Has Not Answered the SLB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
        """
        return pulumi.get(self, "request_timeout")

    @request_timeout.setter
    def request_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "request_timeout", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Security Policy
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Current IP Address of the Listened State
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="xForwardedForConfig")
    def x_forwarded_for_config(self) -> Optional[pulumi.Input['ListenerXForwardedForConfigArgs']]:
        """
        xforwardfor Related Attribute Configuration See `x_forwarded_for_config` below.
        """
        return pulumi.get(self, "x_forwarded_for_config")

    @x_forwarded_for_config.setter
    def x_forwarded_for_config(self, value: Optional[pulumi.Input['ListenerXForwardedForConfigArgs']]):
        pulumi.set(self, "x_forwarded_for_config", value)


@pulumi.input_type
class _ListenerState:
    def __init__(__self__, *,
                 access_log_record_customized_headers_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 access_log_tracing_config: Optional[pulumi.Input['ListenerAccessLogTracingConfigArgs']] = None,
                 acl_config: Optional[pulumi.Input['ListenerAclConfigArgs']] = None,
                 ca_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerCaCertificateArgs']]]] = None,
                 ca_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificates: Optional[pulumi.Input['ListenerCertificatesArgs']] = None,
                 default_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 gzip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 http2_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_description: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_port: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 quic_config: Optional[pulumi.Input['ListenerQuicConfigArgs']] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 x_forwarded_for_config: Optional[pulumi.Input['ListenerXForwardedForConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Listener resources.
        :param pulumi.Input[_builtins.bool] access_log_record_customized_headers_enabled: Access Log Whether to Enable Carry Custom Header Field. Valid values: `true`, `false`. Default Value: `false`.
               
               > **NOTE:**  Only Instances outside the Security Group to Access the Log Switch `accesslogenabled` Open, in Order to Set This Parameter to the `true`.
        :param pulumi.Input['ListenerAccessLogTracingConfigArgs'] access_log_tracing_config: Xtrace Configuration Information. See `access_log_tracing_config` below.
        :param pulumi.Input['ListenerAclConfigArgs'] acl_config: The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alb.ListenerAclAttachment`.,
        :param pulumi.Input[Sequence[pulumi.Input['ListenerCaCertificateArgs']]] ca_certificates: The list of certificates. See `ca_certificates` below.
        :param pulumi.Input[_builtins.bool] ca_enabled: Whether to turn on two-way authentication. Value:
        :param pulumi.Input['ListenerCertificatesArgs'] certificates: The list of certificates. See `certificates` below.
        :param pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]] default_actions: The Default Rule Action List See `default_actions` below.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
        :param pulumi.Input[_builtins.bool] gzip_enabled: Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid Values: True Or False. Default Value: TRUE.
        :param pulumi.Input[_builtins.bool] http2_enabled: Whether to Enable HTTP/2 Features. Valid Values: True Or False. Default Value: TRUE.
        :param pulumi.Input[_builtins.int] idle_timeout: Specify the Connection Idle Timeout Value: 1 to 60 seconds.
        :param pulumi.Input[_builtins.str] listener_description: Set the IP Address of the Listened Description. Length Is from 2 to 256 Characters.
        :param pulumi.Input[_builtins.int] listener_port: The SLB Instance Front-End, and Those of the Ports Used. Value: 1~65535.
        :param pulumi.Input[_builtins.str] listener_protocol: Snooping Protocols. Valid Values: HTTP, HTTPS Or QuIC.
        :param pulumi.Input[_builtins.str] load_balancer_id: The SLB Instance Id.
        :param pulumi.Input['ListenerQuicConfigArgs'] quic_config: Configuration Associated with the QuIC Listening See `quic_config` below.
        :param pulumi.Input[_builtins.int] request_timeout: The Specified Request Timeout Time. Value: 1~180 Seconds. Default Value: 60 seconds. If the Timeout Time Within the Back-End Server Has Not Answered the SLB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
        :param pulumi.Input[_builtins.str] security_policy_id: Security Policy
        :param pulumi.Input[_builtins.str] status: The Current IP Address of the Listened State
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input['ListenerXForwardedForConfigArgs'] x_forwarded_for_config: xforwardfor Related Attribute Configuration See `x_forwarded_for_config` below.
        """
        if access_log_record_customized_headers_enabled is not None:
            pulumi.set(__self__, "access_log_record_customized_headers_enabled", access_log_record_customized_headers_enabled)
        if access_log_tracing_config is not None:
            pulumi.set(__self__, "access_log_tracing_config", access_log_tracing_config)
        if acl_config is not None:
            warnings.warn("""Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.""", DeprecationWarning)
            pulumi.log.warn("""acl_config is deprecated: Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.""")
        if acl_config is not None:
            pulumi.set(__self__, "acl_config", acl_config)
        if ca_certificates is not None:
            pulumi.set(__self__, "ca_certificates", ca_certificates)
        if ca_enabled is not None:
            pulumi.set(__self__, "ca_enabled", ca_enabled)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if default_actions is not None:
            pulumi.set(__self__, "default_actions", default_actions)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if gzip_enabled is not None:
            pulumi.set(__self__, "gzip_enabled", gzip_enabled)
        if http2_enabled is not None:
            pulumi.set(__self__, "http2_enabled", http2_enabled)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if listener_description is not None:
            pulumi.set(__self__, "listener_description", listener_description)
        if listener_port is not None:
            pulumi.set(__self__, "listener_port", listener_port)
        if listener_protocol is not None:
            pulumi.set(__self__, "listener_protocol", listener_protocol)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if quic_config is not None:
            pulumi.set(__self__, "quic_config", quic_config)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if x_forwarded_for_config is not None:
            pulumi.set(__self__, "x_forwarded_for_config", x_forwarded_for_config)

    @_builtins.property
    @pulumi.getter(name="accessLogRecordCustomizedHeadersEnabled")
    def access_log_record_customized_headers_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Access Log Whether to Enable Carry Custom Header Field. Valid values: `true`, `false`. Default Value: `false`.

        > **NOTE:**  Only Instances outside the Security Group to Access the Log Switch `accesslogenabled` Open, in Order to Set This Parameter to the `true`.
        """
        return pulumi.get(self, "access_log_record_customized_headers_enabled")

    @access_log_record_customized_headers_enabled.setter
    def access_log_record_customized_headers_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "access_log_record_customized_headers_enabled", value)

    @_builtins.property
    @pulumi.getter(name="accessLogTracingConfig")
    def access_log_tracing_config(self) -> Optional[pulumi.Input['ListenerAccessLogTracingConfigArgs']]:
        """
        Xtrace Configuration Information. See `access_log_tracing_config` below.
        """
        return pulumi.get(self, "access_log_tracing_config")

    @access_log_tracing_config.setter
    def access_log_tracing_config(self, value: Optional[pulumi.Input['ListenerAccessLogTracingConfigArgs']]):
        pulumi.set(self, "access_log_tracing_config", value)

    @_builtins.property
    @pulumi.getter(name="aclConfig")
    @_utilities.deprecated("""Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.""")
    def acl_config(self) -> Optional[pulumi.Input['ListenerAclConfigArgs']]:
        """
        The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alb.ListenerAclAttachment`.,
        """
        return pulumi.get(self, "acl_config")

    @acl_config.setter
    def acl_config(self, value: Optional[pulumi.Input['ListenerAclConfigArgs']]):
        pulumi.set(self, "acl_config", value)

    @_builtins.property
    @pulumi.getter(name="caCertificates")
    def ca_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListenerCaCertificateArgs']]]]:
        """
        The list of certificates. See `ca_certificates` below.
        """
        return pulumi.get(self, "ca_certificates")

    @ca_certificates.setter
    def ca_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerCaCertificateArgs']]]]):
        pulumi.set(self, "ca_certificates", value)

    @_builtins.property
    @pulumi.getter(name="caEnabled")
    def ca_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to turn on two-way authentication. Value:
        """
        return pulumi.get(self, "ca_enabled")

    @ca_enabled.setter
    def ca_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ca_enabled", value)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input['ListenerCertificatesArgs']]:
        """
        The list of certificates. See `certificates` below.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input['ListenerCertificatesArgs']]):
        pulumi.set(self, "certificates", value)

    @_builtins.property
    @pulumi.getter(name="defaultActions")
    def default_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]]]:
        """
        The Default Rule Action List See `default_actions` below.
        """
        return pulumi.get(self, "default_actions")

    @default_actions.setter
    def default_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]]]):
        pulumi.set(self, "default_actions", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to PreCheck only this request. Value:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="gzipEnabled")
    def gzip_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid Values: True Or False. Default Value: TRUE.
        """
        return pulumi.get(self, "gzip_enabled")

    @gzip_enabled.setter
    def gzip_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "gzip_enabled", value)

    @_builtins.property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to Enable HTTP/2 Features. Valid Values: True Or False. Default Value: TRUE.
        """
        return pulumi.get(self, "http2_enabled")

    @http2_enabled.setter
    def http2_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "http2_enabled", value)

    @_builtins.property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specify the Connection Idle Timeout Value: 1 to 60 seconds.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_timeout", value)

    @_builtins.property
    @pulumi.getter(name="listenerDescription")
    def listener_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the IP Address of the Listened Description. Length Is from 2 to 256 Characters.
        """
        return pulumi.get(self, "listener_description")

    @listener_description.setter
    def listener_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_description", value)

    @_builtins.property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The SLB Instance Front-End, and Those of the Ports Used. Value: 1~65535.
        """
        return pulumi.get(self, "listener_port")

    @listener_port.setter
    def listener_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "listener_port", value)

    @_builtins.property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Snooping Protocols. Valid Values: HTTP, HTTPS Or QuIC.
        """
        return pulumi.get(self, "listener_protocol")

    @listener_protocol.setter
    def listener_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_protocol", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SLB Instance Id.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_id", value)

    @_builtins.property
    @pulumi.getter(name="quicConfig")
    def quic_config(self) -> Optional[pulumi.Input['ListenerQuicConfigArgs']]:
        """
        Configuration Associated with the QuIC Listening See `quic_config` below.
        """
        return pulumi.get(self, "quic_config")

    @quic_config.setter
    def quic_config(self, value: Optional[pulumi.Input['ListenerQuicConfigArgs']]):
        pulumi.set(self, "quic_config", value)

    @_builtins.property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Specified Request Timeout Time. Value: 1~180 Seconds. Default Value: 60 seconds. If the Timeout Time Within the Back-End Server Has Not Answered the SLB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
        """
        return pulumi.get(self, "request_timeout")

    @request_timeout.setter
    def request_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "request_timeout", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Security Policy
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Current IP Address of the Listened State
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="xForwardedForConfig")
    def x_forwarded_for_config(self) -> Optional[pulumi.Input['ListenerXForwardedForConfigArgs']]:
        """
        xforwardfor Related Attribute Configuration See `x_forwarded_for_config` below.
        """
        return pulumi.get(self, "x_forwarded_for_config")

    @x_forwarded_for_config.setter
    def x_forwarded_for_config(self, value: Optional[pulumi.Input['ListenerXForwardedForConfigArgs']]):
        pulumi.set(self, "x_forwarded_for_config", value)


@pulumi.type_token("alicloud:alb/listener:Listener")
class Listener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_log_record_customized_headers_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 access_log_tracing_config: Optional[pulumi.Input[Union['ListenerAccessLogTracingConfigArgs', 'ListenerAccessLogTracingConfigArgsDict']]] = None,
                 acl_config: Optional[pulumi.Input[Union['ListenerAclConfigArgs', 'ListenerAclConfigArgsDict']]] = None,
                 ca_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerCaCertificateArgs', 'ListenerCaCertificateArgsDict']]]]] = None,
                 ca_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificates: Optional[pulumi.Input[Union['ListenerCertificatesArgs', 'ListenerCertificatesArgsDict']]] = None,
                 default_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerDefaultActionArgs', 'ListenerDefaultActionArgsDict']]]]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 gzip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 http2_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_description: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_port: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 quic_config: Optional[pulumi.Input[Union['ListenerQuicConfigArgs', 'ListenerQuicConfigArgsDict']]] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 x_forwarded_for_config: Optional[pulumi.Input[Union['ListenerXForwardedForConfigArgs', 'ListenerXForwardedForConfigArgsDict']]] = None,
                 __props__=None):
        """
        Provides a Application Load Balancer (ALB) Listener resource.

        For information about Application Load Balancer (ALB) Listener and how to use it, see [What is Listener](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createlistener).

        > **NOTE:** Available since v1.133.0.

        ## Import

        Application Load Balancer (ALB) Listener can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alb/listener:Listener example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] access_log_record_customized_headers_enabled: Access Log Whether to Enable Carry Custom Header Field. Valid values: `true`, `false`. Default Value: `false`.
               
               > **NOTE:**  Only Instances outside the Security Group to Access the Log Switch `accesslogenabled` Open, in Order to Set This Parameter to the `true`.
        :param pulumi.Input[Union['ListenerAccessLogTracingConfigArgs', 'ListenerAccessLogTracingConfigArgsDict']] access_log_tracing_config: Xtrace Configuration Information. See `access_log_tracing_config` below.
        :param pulumi.Input[Union['ListenerAclConfigArgs', 'ListenerAclConfigArgsDict']] acl_config: The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alb.ListenerAclAttachment`.,
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListenerCaCertificateArgs', 'ListenerCaCertificateArgsDict']]]] ca_certificates: The list of certificates. See `ca_certificates` below.
        :param pulumi.Input[_builtins.bool] ca_enabled: Whether to turn on two-way authentication. Value:
        :param pulumi.Input[Union['ListenerCertificatesArgs', 'ListenerCertificatesArgsDict']] certificates: The list of certificates. See `certificates` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListenerDefaultActionArgs', 'ListenerDefaultActionArgsDict']]]] default_actions: The Default Rule Action List See `default_actions` below.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
        :param pulumi.Input[_builtins.bool] gzip_enabled: Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid Values: True Or False. Default Value: TRUE.
        :param pulumi.Input[_builtins.bool] http2_enabled: Whether to Enable HTTP/2 Features. Valid Values: True Or False. Default Value: TRUE.
        :param pulumi.Input[_builtins.int] idle_timeout: Specify the Connection Idle Timeout Value: 1 to 60 seconds.
        :param pulumi.Input[_builtins.str] listener_description: Set the IP Address of the Listened Description. Length Is from 2 to 256 Characters.
        :param pulumi.Input[_builtins.int] listener_port: The SLB Instance Front-End, and Those of the Ports Used. Value: 1~65535.
        :param pulumi.Input[_builtins.str] listener_protocol: Snooping Protocols. Valid Values: HTTP, HTTPS Or QuIC.
        :param pulumi.Input[_builtins.str] load_balancer_id: The SLB Instance Id.
        :param pulumi.Input[Union['ListenerQuicConfigArgs', 'ListenerQuicConfigArgsDict']] quic_config: Configuration Associated with the QuIC Listening See `quic_config` below.
        :param pulumi.Input[_builtins.int] request_timeout: The Specified Request Timeout Time. Value: 1~180 Seconds. Default Value: 60 seconds. If the Timeout Time Within the Back-End Server Has Not Answered the SLB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
        :param pulumi.Input[_builtins.str] security_policy_id: Security Policy
        :param pulumi.Input[_builtins.str] status: The Current IP Address of the Listened State
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[Union['ListenerXForwardedForConfigArgs', 'ListenerXForwardedForConfigArgsDict']] x_forwarded_for_config: xforwardfor Related Attribute Configuration See `x_forwarded_for_config` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Application Load Balancer (ALB) Listener resource.

        For information about Application Load Balancer (ALB) Listener and how to use it, see [What is Listener](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createlistener).

        > **NOTE:** Available since v1.133.0.

        ## Import

        Application Load Balancer (ALB) Listener can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alb/listener:Listener example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_log_record_customized_headers_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 access_log_tracing_config: Optional[pulumi.Input[Union['ListenerAccessLogTracingConfigArgs', 'ListenerAccessLogTracingConfigArgsDict']]] = None,
                 acl_config: Optional[pulumi.Input[Union['ListenerAclConfigArgs', 'ListenerAclConfigArgsDict']]] = None,
                 ca_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerCaCertificateArgs', 'ListenerCaCertificateArgsDict']]]]] = None,
                 ca_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificates: Optional[pulumi.Input[Union['ListenerCertificatesArgs', 'ListenerCertificatesArgsDict']]] = None,
                 default_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerDefaultActionArgs', 'ListenerDefaultActionArgsDict']]]]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 gzip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 http2_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_description: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_port: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 quic_config: Optional[pulumi.Input[Union['ListenerQuicConfigArgs', 'ListenerQuicConfigArgsDict']]] = None,
                 request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 x_forwarded_for_config: Optional[pulumi.Input[Union['ListenerXForwardedForConfigArgs', 'ListenerXForwardedForConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerArgs.__new__(ListenerArgs)

            __props__.__dict__["access_log_record_customized_headers_enabled"] = access_log_record_customized_headers_enabled
            __props__.__dict__["access_log_tracing_config"] = access_log_tracing_config
            __props__.__dict__["acl_config"] = acl_config
            __props__.__dict__["ca_certificates"] = ca_certificates
            __props__.__dict__["ca_enabled"] = ca_enabled
            __props__.__dict__["certificates"] = certificates
            if default_actions is None and not opts.urn:
                raise TypeError("Missing required property 'default_actions'")
            __props__.__dict__["default_actions"] = default_actions
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["gzip_enabled"] = gzip_enabled
            __props__.__dict__["http2_enabled"] = http2_enabled
            __props__.__dict__["idle_timeout"] = idle_timeout
            __props__.__dict__["listener_description"] = listener_description
            if listener_port is None and not opts.urn:
                raise TypeError("Missing required property 'listener_port'")
            __props__.__dict__["listener_port"] = listener_port
            if listener_protocol is None and not opts.urn:
                raise TypeError("Missing required property 'listener_protocol'")
            __props__.__dict__["listener_protocol"] = listener_protocol
            if load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_id'")
            __props__.__dict__["load_balancer_id"] = load_balancer_id
            __props__.__dict__["quic_config"] = quic_config
            __props__.__dict__["request_timeout"] = request_timeout
            __props__.__dict__["security_policy_id"] = security_policy_id
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["x_forwarded_for_config"] = x_forwarded_for_config
        super(Listener, __self__).__init__(
            'alicloud:alb/listener:Listener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_log_record_customized_headers_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            access_log_tracing_config: Optional[pulumi.Input[Union['ListenerAccessLogTracingConfigArgs', 'ListenerAccessLogTracingConfigArgsDict']]] = None,
            acl_config: Optional[pulumi.Input[Union['ListenerAclConfigArgs', 'ListenerAclConfigArgsDict']]] = None,
            ca_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerCaCertificateArgs', 'ListenerCaCertificateArgsDict']]]]] = None,
            ca_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            certificates: Optional[pulumi.Input[Union['ListenerCertificatesArgs', 'ListenerCertificatesArgsDict']]] = None,
            default_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerDefaultActionArgs', 'ListenerDefaultActionArgsDict']]]]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            gzip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            http2_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            listener_description: Optional[pulumi.Input[_builtins.str]] = None,
            listener_port: Optional[pulumi.Input[_builtins.int]] = None,
            listener_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
            quic_config: Optional[pulumi.Input[Union['ListenerQuicConfigArgs', 'ListenerQuicConfigArgsDict']]] = None,
            request_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            x_forwarded_for_config: Optional[pulumi.Input[Union['ListenerXForwardedForConfigArgs', 'ListenerXForwardedForConfigArgsDict']]] = None) -> 'Listener':
        """
        Get an existing Listener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] access_log_record_customized_headers_enabled: Access Log Whether to Enable Carry Custom Header Field. Valid values: `true`, `false`. Default Value: `false`.
               
               > **NOTE:**  Only Instances outside the Security Group to Access the Log Switch `accesslogenabled` Open, in Order to Set This Parameter to the `true`.
        :param pulumi.Input[Union['ListenerAccessLogTracingConfigArgs', 'ListenerAccessLogTracingConfigArgsDict']] access_log_tracing_config: Xtrace Configuration Information. See `access_log_tracing_config` below.
        :param pulumi.Input[Union['ListenerAclConfigArgs', 'ListenerAclConfigArgsDict']] acl_config: The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alb.ListenerAclAttachment`.,
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListenerCaCertificateArgs', 'ListenerCaCertificateArgsDict']]]] ca_certificates: The list of certificates. See `ca_certificates` below.
        :param pulumi.Input[_builtins.bool] ca_enabled: Whether to turn on two-way authentication. Value:
        :param pulumi.Input[Union['ListenerCertificatesArgs', 'ListenerCertificatesArgsDict']] certificates: The list of certificates. See `certificates` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListenerDefaultActionArgs', 'ListenerDefaultActionArgsDict']]]] default_actions: The Default Rule Action List See `default_actions` below.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
        :param pulumi.Input[_builtins.bool] gzip_enabled: Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid Values: True Or False. Default Value: TRUE.
        :param pulumi.Input[_builtins.bool] http2_enabled: Whether to Enable HTTP/2 Features. Valid Values: True Or False. Default Value: TRUE.
        :param pulumi.Input[_builtins.int] idle_timeout: Specify the Connection Idle Timeout Value: 1 to 60 seconds.
        :param pulumi.Input[_builtins.str] listener_description: Set the IP Address of the Listened Description. Length Is from 2 to 256 Characters.
        :param pulumi.Input[_builtins.int] listener_port: The SLB Instance Front-End, and Those of the Ports Used. Value: 1~65535.
        :param pulumi.Input[_builtins.str] listener_protocol: Snooping Protocols. Valid Values: HTTP, HTTPS Or QuIC.
        :param pulumi.Input[_builtins.str] load_balancer_id: The SLB Instance Id.
        :param pulumi.Input[Union['ListenerQuicConfigArgs', 'ListenerQuicConfigArgsDict']] quic_config: Configuration Associated with the QuIC Listening See `quic_config` below.
        :param pulumi.Input[_builtins.int] request_timeout: The Specified Request Timeout Time. Value: 1~180 Seconds. Default Value: 60 seconds. If the Timeout Time Within the Back-End Server Has Not Answered the SLB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
        :param pulumi.Input[_builtins.str] security_policy_id: Security Policy
        :param pulumi.Input[_builtins.str] status: The Current IP Address of the Listened State
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[Union['ListenerXForwardedForConfigArgs', 'ListenerXForwardedForConfigArgsDict']] x_forwarded_for_config: xforwardfor Related Attribute Configuration See `x_forwarded_for_config` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerState.__new__(_ListenerState)

        __props__.__dict__["access_log_record_customized_headers_enabled"] = access_log_record_customized_headers_enabled
        __props__.__dict__["access_log_tracing_config"] = access_log_tracing_config
        __props__.__dict__["acl_config"] = acl_config
        __props__.__dict__["ca_certificates"] = ca_certificates
        __props__.__dict__["ca_enabled"] = ca_enabled
        __props__.__dict__["certificates"] = certificates
        __props__.__dict__["default_actions"] = default_actions
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["gzip_enabled"] = gzip_enabled
        __props__.__dict__["http2_enabled"] = http2_enabled
        __props__.__dict__["idle_timeout"] = idle_timeout
        __props__.__dict__["listener_description"] = listener_description
        __props__.__dict__["listener_port"] = listener_port
        __props__.__dict__["listener_protocol"] = listener_protocol
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["quic_config"] = quic_config
        __props__.__dict__["request_timeout"] = request_timeout
        __props__.__dict__["security_policy_id"] = security_policy_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["x_forwarded_for_config"] = x_forwarded_for_config
        return Listener(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessLogRecordCustomizedHeadersEnabled")
    def access_log_record_customized_headers_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Access Log Whether to Enable Carry Custom Header Field. Valid values: `true`, `false`. Default Value: `false`.

        > **NOTE:**  Only Instances outside the Security Group to Access the Log Switch `accesslogenabled` Open, in Order to Set This Parameter to the `true`.
        """
        return pulumi.get(self, "access_log_record_customized_headers_enabled")

    @_builtins.property
    @pulumi.getter(name="accessLogTracingConfig")
    def access_log_tracing_config(self) -> pulumi.Output[Optional['outputs.ListenerAccessLogTracingConfig']]:
        """
        Xtrace Configuration Information. See `access_log_tracing_config` below.
        """
        return pulumi.get(self, "access_log_tracing_config")

    @_builtins.property
    @pulumi.getter(name="aclConfig")
    @_utilities.deprecated("""Field 'acl_config' has been deprecated from provider version 1.163.0 and it will be removed in the future version. Please use the new resource 'alicloud_alb_listener_acl_attachment'.""")
    def acl_config(self) -> pulumi.Output['outputs.ListenerAclConfig']:
        """
        The configurations of the access control lists (ACLs). See `acl_config` below for details. **NOTE:** Field `acl_config` has been deprecated from provider version 1.163.0, and it will be removed in the future version. Please use the new resource `alb.ListenerAclAttachment`.,
        """
        return pulumi.get(self, "acl_config")

    @_builtins.property
    @pulumi.getter(name="caCertificates")
    def ca_certificates(self) -> pulumi.Output[Optional[Sequence['outputs.ListenerCaCertificate']]]:
        """
        The list of certificates. See `ca_certificates` below.
        """
        return pulumi.get(self, "ca_certificates")

    @_builtins.property
    @pulumi.getter(name="caEnabled")
    def ca_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to turn on two-way authentication. Value:
        """
        return pulumi.get(self, "ca_enabled")

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> pulumi.Output[Optional['outputs.ListenerCertificates']]:
        """
        The list of certificates. See `certificates` below.
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter(name="defaultActions")
    def default_actions(self) -> pulumi.Output[Sequence['outputs.ListenerDefaultAction']]:
        """
        The Default Rule Action List See `default_actions` below.
        """
        return pulumi.get(self, "default_actions")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to PreCheck only this request. Value:
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="gzipEnabled")
    def gzip_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to Enable Gzip Compression, as a Specific File Type on a Compression. Valid Values: True Or False. Default Value: TRUE.
        """
        return pulumi.get(self, "gzip_enabled")

    @_builtins.property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to Enable HTTP/2 Features. Valid Values: True Or False. Default Value: TRUE.
        """
        return pulumi.get(self, "http2_enabled")

    @_builtins.property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Specify the Connection Idle Timeout Value: 1 to 60 seconds.
        """
        return pulumi.get(self, "idle_timeout")

    @_builtins.property
    @pulumi.getter(name="listenerDescription")
    def listener_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set the IP Address of the Listened Description. Length Is from 2 to 256 Characters.
        """
        return pulumi.get(self, "listener_description")

    @_builtins.property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> pulumi.Output[_builtins.int]:
        """
        The SLB Instance Front-End, and Those of the Ports Used. Value: 1~65535.
        """
        return pulumi.get(self, "listener_port")

    @_builtins.property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> pulumi.Output[_builtins.str]:
        """
        Snooping Protocols. Valid Values: HTTP, HTTPS Or QuIC.
        """
        return pulumi.get(self, "listener_protocol")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The SLB Instance Id.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter(name="quicConfig")
    def quic_config(self) -> pulumi.Output['outputs.ListenerQuicConfig']:
        """
        Configuration Associated with the QuIC Listening See `quic_config` below.
        """
        return pulumi.get(self, "quic_config")

    @_builtins.property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The Specified Request Timeout Time. Value: 1~180 Seconds. Default Value: 60 seconds. If the Timeout Time Within the Back-End Server Has Not Answered the SLB Will Give up Waiting, the Client Returns the HTTP 504 Error Code.
        """
        return pulumi.get(self, "request_timeout")

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        Security Policy
        """
        return pulumi.get(self, "security_policy_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The Current IP Address of the Listened State
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="xForwardedForConfig")
    def x_forwarded_for_config(self) -> pulumi.Output['outputs.ListenerXForwardedForConfig']:
        """
        xforwardfor Related Attribute Configuration See `x_forwarded_for_config` below.
        """
        return pulumi.get(self, "x_forwarded_for_config")

