# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 deploy_type: pulumi.Input[_builtins.int],
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 confluent_config: Optional[pulumi.Input['InstanceConfluentConfigArgs']] = None,
                 default_topic_partition_num: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.int]] = None,
                 eip_max: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_auto_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_auto_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 io_max: Optional[pulumi.Input[_builtins.int]] = None,
                 io_max_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 paid_type: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_num: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group: Optional[pulumi.Input[_builtins.str]] = None,
                 selected_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 serverless_config: Optional[pulumi.Input['InstanceServerlessConfigArgs']] = None,
                 service_version: Optional[pulumi.Input[_builtins.str]] = None,
                 spec_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topic_quota: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.int] deploy_type: The deployment type of the instance. **NOTE:** From version 1.161.0, this attribute supports to be updated. Valid values:
        :param pulumi.Input[_builtins.str] config: The initial configurations of the ApsaraMQ for Kafka instance. The values must be valid JSON strings. The `config` supports the following parameters:
               * `enable.vpc_sasl_ssl`: Specifies whether to enable VPC transmission encryption. Default value: `false`. Valid values:
        :param pulumi.Input['InstanceConfluentConfigArgs'] confluent_config: The configurations of Confluent. See `confluent_config` below.
               > **NOTE:** If `instance_type` is set to `alikafka_confluent`, `confluent_config` is required.
        :param pulumi.Input[_builtins.int] default_topic_partition_num: The number of partitions in a topic that is automatically created.
        :param pulumi.Input[_builtins.int] disk_size: The disk size of the instance. When modify this value, it only supports adjust to a greater value.
               > **NOTE:** If `instance_type` is set to `alikafka`, `disk_size` is required.
        :param pulumi.Input[_builtins.int] disk_type: The disk type of the instance. Valid values:
        :param pulumi.Input[_builtins.int] eip_max: The max bandwidth of the instance. It will be ignored when `deploy_type = 5`. When modify this value, it only supports adjust to a greater value.
        :param pulumi.Input[_builtins.bool] enable_auto_group: Specify whether to enable the flexible group creation feature. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] enable_auto_topic: Specify whether to enable the automatic topic creation feature. Default value: `disable`. Valid values:
        :param pulumi.Input[_builtins.str] instance_type: The type of the Instance. Default value: `alikafka`. Valid values:
        :param pulumi.Input[_builtins.int] io_max: The max value of io of the instance. When modify this value, it only support adjust to a greater value.
        :param pulumi.Input[_builtins.str] io_max_spec: The traffic specification of the instance. We recommend that you configure this parameter.
               - You should specify one of the `io_max` and `io_max_spec` parameters, and `io_max_spec` is recommended.
               - For more information about the valid values, see [Billing](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/billing-overview).
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the key that is used to encrypt data on standard SSDs in the region of the instance.
        :param pulumi.Input[_builtins.str] name: Name of your Kafka instance. The length should between 3 and 64 characters. If not set, will use instance id as instance name.
        :param pulumi.Input[_builtins.str] paid_type: The billing method of the instance. Default value: `PostPaid`. Valid values: `PostPaid`, `PrePaid`. When modify this value, it only support adjust from `PostPaid` to `PrePaid`.
        :param pulumi.Input[_builtins.int] partition_num: The number of partitions.
        :param pulumi.Input[_builtins.str] password: The instance password. **NOTE:** If `instance_type` is set to `alikafka_confluent`, `password` is required.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param pulumi.Input[_builtins.str] security_group: The ID of security group for this instance. If the security group is empty, system will create a default one.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] selected_zones: The zones among which you want to deploy the instance.
        :param pulumi.Input['InstanceServerlessConfigArgs'] serverless_config: The parameters configured for the serverless ApsaraMQ for Kafka instance. See `serverless_config` below.
               > **NOTE:** If `instance_type` is set to `alikafka_serverless`, `serverless_config` is required.
        :param pulumi.Input[_builtins.str] service_version: The version of the Instance. Valid values:
               - If `instance_type` is set to `alikafka`. Default value: `2.2.0`. Valid values: `2.2.0`, `2.6.2`.
               - If `instance_type` is set to `alikafka_serverless`. Default value: `3.3.1`. Valid values: `3.3.1`.
               - If `instance_type` is set to `alikafka_confluent`. Default value: `7.4.0`. Valid values: `7.4.0`.
        :param pulumi.Input[_builtins.str] spec_type: The instance edition. Default value: `normal`. Valid values:
               - If `instance_type` is set to `alikafka`. Valid values: `normal`, `professional`, `professionalForHighRead`.
               - If `instance_type` is set to `alikafka_serverless`. Valid values: `normal`.
               - If `instance_type` is set to `alikafka_confluent`. Valid values: `professional`, `enterprise`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] topic_quota: The max num of topic can be creation of the instance.
               It has been deprecated since version 1.194.0 and using `partition_num` instead.
               Currently, its value only can be set to 50 when creating it, and finally depends on `partition_num` value: <`topic_quota`> = 1000 + <`partition_num`>.
               Therefore, you can update it by updating the `partition_num`, and it is the only updating path.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID of the instance.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of attaching vswitch to instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: The IDs of the vSwitches with which the instance is associated.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the instance. The value can be in zone x or region id-x format. **NOTE**: When the available zone is insufficient, another availability zone may be deployed.
        """
        pulumi.set(__self__, "deploy_type", deploy_type)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if confluent_config is not None:
            pulumi.set(__self__, "confluent_config", confluent_config)
        if default_topic_partition_num is not None:
            pulumi.set(__self__, "default_topic_partition_num", default_topic_partition_num)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if eip_max is not None:
            pulumi.set(__self__, "eip_max", eip_max)
        if enable_auto_group is not None:
            pulumi.set(__self__, "enable_auto_group", enable_auto_group)
        if enable_auto_topic is not None:
            pulumi.set(__self__, "enable_auto_topic", enable_auto_topic)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if io_max is not None:
            pulumi.set(__self__, "io_max", io_max)
        if io_max_spec is not None:
            pulumi.set(__self__, "io_max_spec", io_max_spec)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if paid_type is not None:
            pulumi.set(__self__, "paid_type", paid_type)
        if partition_num is not None:
            pulumi.set(__self__, "partition_num", partition_num)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_group is not None:
            pulumi.set(__self__, "security_group", security_group)
        if selected_zones is not None:
            pulumi.set(__self__, "selected_zones", selected_zones)
        if serverless_config is not None:
            pulumi.set(__self__, "serverless_config", serverless_config)
        if service_version is not None:
            pulumi.set(__self__, "service_version", service_version)
        if spec_type is not None:
            pulumi.set(__self__, "spec_type", spec_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if topic_quota is not None:
            warnings.warn("""Attribute `topic_quota` has been deprecated since 1.194.0 and it will be removed in the next future. Using new attribute `partition_num` instead.""", DeprecationWarning)
            pulumi.log.warn("""topic_quota is deprecated: Attribute `topic_quota` has been deprecated since 1.194.0 and it will be removed in the next future. Using new attribute `partition_num` instead.""")
        if topic_quota is not None:
            pulumi.set(__self__, "topic_quota", topic_quota)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="deployType")
    def deploy_type(self) -> pulumi.Input[_builtins.int]:
        """
        The deployment type of the instance. **NOTE:** From version 1.161.0, this attribute supports to be updated. Valid values:
        """
        return pulumi.get(self, "deploy_type")

    @deploy_type.setter
    def deploy_type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "deploy_type", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The initial configurations of the ApsaraMQ for Kafka instance. The values must be valid JSON strings. The `config` supports the following parameters:
        * `enable.vpc_sasl_ssl`: Specifies whether to enable VPC transmission encryption. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="confluentConfig")
    def confluent_config(self) -> Optional[pulumi.Input['InstanceConfluentConfigArgs']]:
        """
        The configurations of Confluent. See `confluent_config` below.
        > **NOTE:** If `instance_type` is set to `alikafka_confluent`, `confluent_config` is required.
        """
        return pulumi.get(self, "confluent_config")

    @confluent_config.setter
    def confluent_config(self, value: Optional[pulumi.Input['InstanceConfluentConfigArgs']]):
        pulumi.set(self, "confluent_config", value)

    @_builtins.property
    @pulumi.getter(name="defaultTopicPartitionNum")
    def default_topic_partition_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of partitions in a topic that is automatically created.
        """
        return pulumi.get(self, "default_topic_partition_num")

    @default_topic_partition_num.setter
    def default_topic_partition_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_topic_partition_num", value)

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The disk size of the instance. When modify this value, it only supports adjust to a greater value.
        > **NOTE:** If `instance_type` is set to `alikafka`, `disk_size` is required.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_size", value)

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The disk type of the instance. Valid values:
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_type", value)

    @_builtins.property
    @pulumi.getter(name="eipMax")
    def eip_max(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The max bandwidth of the instance. It will be ignored when `deploy_type = 5`. When modify this value, it only supports adjust to a greater value.
        """
        return pulumi.get(self, "eip_max")

    @eip_max.setter
    def eip_max(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "eip_max", value)

    @_builtins.property
    @pulumi.getter(name="enableAutoGroup")
    def enable_auto_group(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specify whether to enable the flexible group creation feature. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_auto_group")

    @enable_auto_group.setter
    def enable_auto_group(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_auto_group", value)

    @_builtins.property
    @pulumi.getter(name="enableAutoTopic")
    def enable_auto_topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify whether to enable the automatic topic creation feature. Default value: `disable`. Valid values:
        """
        return pulumi.get(self, "enable_auto_topic")

    @enable_auto_topic.setter
    def enable_auto_topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_auto_topic", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Instance. Default value: `alikafka`. Valid values:
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="ioMax")
    def io_max(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The max value of io of the instance. When modify this value, it only support adjust to a greater value.
        """
        return pulumi.get(self, "io_max")

    @io_max.setter
    def io_max(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "io_max", value)

    @_builtins.property
    @pulumi.getter(name="ioMaxSpec")
    def io_max_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The traffic specification of the instance. We recommend that you configure this parameter.
        - You should specify one of the `io_max` and `io_max_spec` parameters, and `io_max_spec` is recommended.
        - For more information about the valid values, see [Billing](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/billing-overview).
        """
        return pulumi.get(self, "io_max_spec")

    @io_max_spec.setter
    def io_max_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "io_max_spec", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the key that is used to encrypt data on standard SSDs in the region of the instance.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of your Kafka instance. The length should between 3 and 64 characters. If not set, will use instance id as instance name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="paidType")
    def paid_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the instance. Default value: `PostPaid`. Valid values: `PostPaid`, `PrePaid`. When modify this value, it only support adjust from `PostPaid` to `PrePaid`.
        """
        return pulumi.get(self, "paid_type")

    @paid_type.setter
    def paid_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "paid_type", value)

    @_builtins.property
    @pulumi.getter(name="partitionNum")
    def partition_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of partitions.
        """
        return pulumi.get(self, "partition_num")

    @partition_num.setter
    def partition_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "partition_num", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance password. **NOTE:** If `instance_type` is set to `alikafka_confluent`, `password` is required.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of security group for this instance. If the security group is empty, system will create a default one.
        """
        return pulumi.get(self, "security_group")

    @security_group.setter
    def security_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group", value)

    @_builtins.property
    @pulumi.getter(name="selectedZones")
    def selected_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The zones among which you want to deploy the instance.
        """
        return pulumi.get(self, "selected_zones")

    @selected_zones.setter
    def selected_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "selected_zones", value)

    @_builtins.property
    @pulumi.getter(name="serverlessConfig")
    def serverless_config(self) -> Optional[pulumi.Input['InstanceServerlessConfigArgs']]:
        """
        The parameters configured for the serverless ApsaraMQ for Kafka instance. See `serverless_config` below.
        > **NOTE:** If `instance_type` is set to `alikafka_serverless`, `serverless_config` is required.
        """
        return pulumi.get(self, "serverless_config")

    @serverless_config.setter
    def serverless_config(self, value: Optional[pulumi.Input['InstanceServerlessConfigArgs']]):
        pulumi.set(self, "serverless_config", value)

    @_builtins.property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the Instance. Valid values:
        - If `instance_type` is set to `alikafka`. Default value: `2.2.0`. Valid values: `2.2.0`, `2.6.2`.
        - If `instance_type` is set to `alikafka_serverless`. Default value: `3.3.1`. Valid values: `3.3.1`.
        - If `instance_type` is set to `alikafka_confluent`. Default value: `7.4.0`. Valid values: `7.4.0`.
        """
        return pulumi.get(self, "service_version")

    @service_version.setter
    def service_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_version", value)

    @_builtins.property
    @pulumi.getter(name="specType")
    def spec_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance edition. Default value: `normal`. Valid values:
        - If `instance_type` is set to `alikafka`. Valid values: `normal`, `professional`, `professionalForHighRead`.
        - If `instance_type` is set to `alikafka_serverless`. Valid values: `normal`.
        - If `instance_type` is set to `alikafka_confluent`. Valid values: `professional`, `enterprise`.
        """
        return pulumi.get(self, "spec_type")

    @spec_type.setter
    def spec_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spec_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="topicQuota")
    @_utilities.deprecated("""Attribute `topic_quota` has been deprecated since 1.194.0 and it will be removed in the next future. Using new attribute `partition_num` instead.""")
    def topic_quota(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The max num of topic can be creation of the instance.
        It has been deprecated since version 1.194.0 and using `partition_num` instead.
        Currently, its value only can be set to 50 when creating it, and finally depends on `partition_num` value: <`topic_quota`> = 1000 + <`partition_num`>.
        Therefore, you can update it by updating the `partition_num`, and it is the only updating path.
        """
        return pulumi.get(self, "topic_quota")

    @topic_quota.setter
    def topic_quota(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "topic_quota", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID of the instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of attaching vswitch to instance.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs of the vSwitches with which the instance is associated.
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vswitch_ids", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID of the instance. The value can be in zone x or region id-x format. **NOTE**: When the available zone is insufficient, another availability zone may be deployed.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 confluent_config: Optional[pulumi.Input['InstanceConfluentConfigArgs']] = None,
                 default_topic_partition_num: Optional[pulumi.Input[_builtins.int]] = None,
                 deploy_type: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.int]] = None,
                 domain_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_max: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_auto_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_auto_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 end_point: Optional[pulumi.Input[_builtins.str]] = None,
                 group_left: Optional[pulumi.Input[_builtins.int]] = None,
                 group_used: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 io_max: Optional[pulumi.Input[_builtins.int]] = None,
                 io_max_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 is_partition_buy: Optional[pulumi.Input[_builtins.int]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 paid_type: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_left: Optional[pulumi.Input[_builtins.int]] = None,
                 partition_num: Optional[pulumi.Input[_builtins.int]] = None,
                 partition_used: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sasl_domain_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group: Optional[pulumi.Input[_builtins.str]] = None,
                 selected_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 serverless_config: Optional[pulumi.Input['InstanceServerlessConfigArgs']] = None,
                 service_version: Optional[pulumi.Input[_builtins.str]] = None,
                 spec_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_domain_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topic_left: Optional[pulumi.Input[_builtins.int]] = None,
                 topic_num_of_buy: Optional[pulumi.Input[_builtins.int]] = None,
                 topic_quota: Optional[pulumi.Input[_builtins.int]] = None,
                 topic_used: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] config: The initial configurations of the ApsaraMQ for Kafka instance. The values must be valid JSON strings. The `config` supports the following parameters:
               * `enable.vpc_sasl_ssl`: Specifies whether to enable VPC transmission encryption. Default value: `false`. Valid values:
        :param pulumi.Input['InstanceConfluentConfigArgs'] confluent_config: The configurations of Confluent. See `confluent_config` below.
               > **NOTE:** If `instance_type` is set to `alikafka_confluent`, `confluent_config` is required.
        :param pulumi.Input[_builtins.int] default_topic_partition_num: The number of partitions in a topic that is automatically created.
        :param pulumi.Input[_builtins.int] deploy_type: The deployment type of the instance. **NOTE:** From version 1.161.0, this attribute supports to be updated. Valid values:
        :param pulumi.Input[_builtins.int] disk_size: The disk size of the instance. When modify this value, it only supports adjust to a greater value.
               > **NOTE:** If `instance_type` is set to `alikafka`, `disk_size` is required.
        :param pulumi.Input[_builtins.int] disk_type: The disk type of the instance. Valid values:
        :param pulumi.Input[_builtins.str] domain_endpoint: (Available since v1.234.0) The default endpoint of the instance in domain name mode.
        :param pulumi.Input[_builtins.int] eip_max: The max bandwidth of the instance. It will be ignored when `deploy_type = 5`. When modify this value, it only supports adjust to a greater value.
        :param pulumi.Input[_builtins.bool] enable_auto_group: Specify whether to enable the flexible group creation feature. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] enable_auto_topic: Specify whether to enable the automatic topic creation feature. Default value: `disable`. Valid values:
        :param pulumi.Input[_builtins.str] end_point: The EndPoint to access the kafka instance.
        :param pulumi.Input[_builtins.int] group_left: (Available since v1.214.1) The number of available groups.
        :param pulumi.Input[_builtins.int] group_used: (Available since v1.214.1) The number of used groups.
        :param pulumi.Input[_builtins.str] instance_type: The type of the Instance. Default value: `alikafka`. Valid values:
        :param pulumi.Input[_builtins.int] io_max: The max value of io of the instance. When modify this value, it only support adjust to a greater value.
        :param pulumi.Input[_builtins.str] io_max_spec: The traffic specification of the instance. We recommend that you configure this parameter.
               - You should specify one of the `io_max` and `io_max_spec` parameters, and `io_max_spec` is recommended.
               - For more information about the valid values, see [Billing](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/billing-overview).
        :param pulumi.Input[_builtins.int] is_partition_buy: (Available since v1.214.1) The method that you use to purchase partitions.
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the key that is used to encrypt data on standard SSDs in the region of the instance.
        :param pulumi.Input[_builtins.str] name: Name of your Kafka instance. The length should between 3 and 64 characters. If not set, will use instance id as instance name.
        :param pulumi.Input[_builtins.str] paid_type: The billing method of the instance. Default value: `PostPaid`. Valid values: `PostPaid`, `PrePaid`. When modify this value, it only support adjust from `PostPaid` to `PrePaid`.
        :param pulumi.Input[_builtins.int] partition_left: (Available since v1.214.1) The number of available partitions.
        :param pulumi.Input[_builtins.int] partition_num: The number of partitions.
        :param pulumi.Input[_builtins.int] partition_used: (Available since v1.214.1) The number of used partitions.
        :param pulumi.Input[_builtins.str] password: The instance password. **NOTE:** If `instance_type` is set to `alikafka_confluent`, `password` is required.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param pulumi.Input[_builtins.str] sasl_domain_endpoint: (Available since v1.234.0) The Simple Authentication and Security Layer (SASL) endpoint of the instance in domain name mode.
        :param pulumi.Input[_builtins.str] security_group: The ID of security group for this instance. If the security group is empty, system will create a default one.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] selected_zones: The zones among which you want to deploy the instance.
        :param pulumi.Input['InstanceServerlessConfigArgs'] serverless_config: The parameters configured for the serverless ApsaraMQ for Kafka instance. See `serverless_config` below.
               > **NOTE:** If `instance_type` is set to `alikafka_serverless`, `serverless_config` is required.
        :param pulumi.Input[_builtins.str] service_version: The version of the Instance. Valid values:
               - If `instance_type` is set to `alikafka`. Default value: `2.2.0`. Valid values: `2.2.0`, `2.6.2`.
               - If `instance_type` is set to `alikafka_serverless`. Default value: `3.3.1`. Valid values: `3.3.1`.
               - If `instance_type` is set to `alikafka_confluent`. Default value: `7.4.0`. Valid values: `7.4.0`.
        :param pulumi.Input[_builtins.str] spec_type: The instance edition. Default value: `normal`. Valid values:
               - If `instance_type` is set to `alikafka`. Valid values: `normal`, `professional`, `professionalForHighRead`.
               - If `instance_type` is set to `alikafka_serverless`. Valid values: `normal`.
               - If `instance_type` is set to `alikafka_confluent`. Valid values: `professional`, `enterprise`.
        :param pulumi.Input[_builtins.str] ssl_domain_endpoint: (Available since v1.234.0) The SSL endpoint of the instance in domain name mode.
        :param pulumi.Input[_builtins.str] ssl_endpoint: (Available since v1.234.0) The Secure Sockets Layer (SSL) endpoint of the instance in IP address mode.
        :param pulumi.Input[_builtins.int] status: The status of the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] topic_left: (Available since v1.214.1) The number of available topics.
        :param pulumi.Input[_builtins.int] topic_num_of_buy: (Available since v1.214.1) The number of purchased topics.
        :param pulumi.Input[_builtins.int] topic_quota: The max num of topic can be creation of the instance.
               It has been deprecated since version 1.194.0 and using `partition_num` instead.
               Currently, its value only can be set to 50 when creating it, and finally depends on `partition_num` value: <`topic_quota`> = 1000 + <`partition_num`>.
               Therefore, you can update it by updating the `partition_num`, and it is the only updating path.
        :param pulumi.Input[_builtins.int] topic_used: (Available since v1.214.1) The number of used topics.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID of the instance.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of attaching vswitch to instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: The IDs of the vSwitches with which the instance is associated.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the instance. The value can be in zone x or region id-x format. **NOTE**: When the available zone is insufficient, another availability zone may be deployed.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if confluent_config is not None:
            pulumi.set(__self__, "confluent_config", confluent_config)
        if default_topic_partition_num is not None:
            pulumi.set(__self__, "default_topic_partition_num", default_topic_partition_num)
        if deploy_type is not None:
            pulumi.set(__self__, "deploy_type", deploy_type)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if domain_endpoint is not None:
            pulumi.set(__self__, "domain_endpoint", domain_endpoint)
        if eip_max is not None:
            pulumi.set(__self__, "eip_max", eip_max)
        if enable_auto_group is not None:
            pulumi.set(__self__, "enable_auto_group", enable_auto_group)
        if enable_auto_topic is not None:
            pulumi.set(__self__, "enable_auto_topic", enable_auto_topic)
        if end_point is not None:
            pulumi.set(__self__, "end_point", end_point)
        if group_left is not None:
            pulumi.set(__self__, "group_left", group_left)
        if group_used is not None:
            pulumi.set(__self__, "group_used", group_used)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if io_max is not None:
            pulumi.set(__self__, "io_max", io_max)
        if io_max_spec is not None:
            pulumi.set(__self__, "io_max_spec", io_max_spec)
        if is_partition_buy is not None:
            pulumi.set(__self__, "is_partition_buy", is_partition_buy)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if paid_type is not None:
            pulumi.set(__self__, "paid_type", paid_type)
        if partition_left is not None:
            pulumi.set(__self__, "partition_left", partition_left)
        if partition_num is not None:
            pulumi.set(__self__, "partition_num", partition_num)
        if partition_used is not None:
            pulumi.set(__self__, "partition_used", partition_used)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if sasl_domain_endpoint is not None:
            pulumi.set(__self__, "sasl_domain_endpoint", sasl_domain_endpoint)
        if security_group is not None:
            pulumi.set(__self__, "security_group", security_group)
        if selected_zones is not None:
            pulumi.set(__self__, "selected_zones", selected_zones)
        if serverless_config is not None:
            pulumi.set(__self__, "serverless_config", serverless_config)
        if service_version is not None:
            pulumi.set(__self__, "service_version", service_version)
        if spec_type is not None:
            pulumi.set(__self__, "spec_type", spec_type)
        if ssl_domain_endpoint is not None:
            pulumi.set(__self__, "ssl_domain_endpoint", ssl_domain_endpoint)
        if ssl_endpoint is not None:
            pulumi.set(__self__, "ssl_endpoint", ssl_endpoint)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if topic_left is not None:
            pulumi.set(__self__, "topic_left", topic_left)
        if topic_num_of_buy is not None:
            pulumi.set(__self__, "topic_num_of_buy", topic_num_of_buy)
        if topic_quota is not None:
            warnings.warn("""Attribute `topic_quota` has been deprecated since 1.194.0 and it will be removed in the next future. Using new attribute `partition_num` instead.""", DeprecationWarning)
            pulumi.log.warn("""topic_quota is deprecated: Attribute `topic_quota` has been deprecated since 1.194.0 and it will be removed in the next future. Using new attribute `partition_num` instead.""")
        if topic_quota is not None:
            pulumi.set(__self__, "topic_quota", topic_quota)
        if topic_used is not None:
            pulumi.set(__self__, "topic_used", topic_used)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The initial configurations of the ApsaraMQ for Kafka instance. The values must be valid JSON strings. The `config` supports the following parameters:
        * `enable.vpc_sasl_ssl`: Specifies whether to enable VPC transmission encryption. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="confluentConfig")
    def confluent_config(self) -> Optional[pulumi.Input['InstanceConfluentConfigArgs']]:
        """
        The configurations of Confluent. See `confluent_config` below.
        > **NOTE:** If `instance_type` is set to `alikafka_confluent`, `confluent_config` is required.
        """
        return pulumi.get(self, "confluent_config")

    @confluent_config.setter
    def confluent_config(self, value: Optional[pulumi.Input['InstanceConfluentConfigArgs']]):
        pulumi.set(self, "confluent_config", value)

    @_builtins.property
    @pulumi.getter(name="defaultTopicPartitionNum")
    def default_topic_partition_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of partitions in a topic that is automatically created.
        """
        return pulumi.get(self, "default_topic_partition_num")

    @default_topic_partition_num.setter
    def default_topic_partition_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_topic_partition_num", value)

    @_builtins.property
    @pulumi.getter(name="deployType")
    def deploy_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The deployment type of the instance. **NOTE:** From version 1.161.0, this attribute supports to be updated. Valid values:
        """
        return pulumi.get(self, "deploy_type")

    @deploy_type.setter
    def deploy_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deploy_type", value)

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The disk size of the instance. When modify this value, it only supports adjust to a greater value.
        > **NOTE:** If `instance_type` is set to `alikafka`, `disk_size` is required.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_size", value)

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The disk type of the instance. Valid values:
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_type", value)

    @_builtins.property
    @pulumi.getter(name="domainEndpoint")
    def domain_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.234.0) The default endpoint of the instance in domain name mode.
        """
        return pulumi.get(self, "domain_endpoint")

    @domain_endpoint.setter
    def domain_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="eipMax")
    def eip_max(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The max bandwidth of the instance. It will be ignored when `deploy_type = 5`. When modify this value, it only supports adjust to a greater value.
        """
        return pulumi.get(self, "eip_max")

    @eip_max.setter
    def eip_max(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "eip_max", value)

    @_builtins.property
    @pulumi.getter(name="enableAutoGroup")
    def enable_auto_group(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specify whether to enable the flexible group creation feature. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_auto_group")

    @enable_auto_group.setter
    def enable_auto_group(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_auto_group", value)

    @_builtins.property
    @pulumi.getter(name="enableAutoTopic")
    def enable_auto_topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify whether to enable the automatic topic creation feature. Default value: `disable`. Valid values:
        """
        return pulumi.get(self, "enable_auto_topic")

    @enable_auto_topic.setter
    def enable_auto_topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_auto_topic", value)

    @_builtins.property
    @pulumi.getter(name="endPoint")
    def end_point(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EndPoint to access the kafka instance.
        """
        return pulumi.get(self, "end_point")

    @end_point.setter
    def end_point(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_point", value)

    @_builtins.property
    @pulumi.getter(name="groupLeft")
    def group_left(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Available since v1.214.1) The number of available groups.
        """
        return pulumi.get(self, "group_left")

    @group_left.setter
    def group_left(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "group_left", value)

    @_builtins.property
    @pulumi.getter(name="groupUsed")
    def group_used(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Available since v1.214.1) The number of used groups.
        """
        return pulumi.get(self, "group_used")

    @group_used.setter
    def group_used(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "group_used", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Instance. Default value: `alikafka`. Valid values:
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="ioMax")
    def io_max(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The max value of io of the instance. When modify this value, it only support adjust to a greater value.
        """
        return pulumi.get(self, "io_max")

    @io_max.setter
    def io_max(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "io_max", value)

    @_builtins.property
    @pulumi.getter(name="ioMaxSpec")
    def io_max_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The traffic specification of the instance. We recommend that you configure this parameter.
        - You should specify one of the `io_max` and `io_max_spec` parameters, and `io_max_spec` is recommended.
        - For more information about the valid values, see [Billing](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/billing-overview).
        """
        return pulumi.get(self, "io_max_spec")

    @io_max_spec.setter
    def io_max_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "io_max_spec", value)

    @_builtins.property
    @pulumi.getter(name="isPartitionBuy")
    def is_partition_buy(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Available since v1.214.1) The method that you use to purchase partitions.
        """
        return pulumi.get(self, "is_partition_buy")

    @is_partition_buy.setter
    def is_partition_buy(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "is_partition_buy", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the key that is used to encrypt data on standard SSDs in the region of the instance.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of your Kafka instance. The length should between 3 and 64 characters. If not set, will use instance id as instance name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="paidType")
    def paid_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the instance. Default value: `PostPaid`. Valid values: `PostPaid`, `PrePaid`. When modify this value, it only support adjust from `PostPaid` to `PrePaid`.
        """
        return pulumi.get(self, "paid_type")

    @paid_type.setter
    def paid_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "paid_type", value)

    @_builtins.property
    @pulumi.getter(name="partitionLeft")
    def partition_left(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Available since v1.214.1) The number of available partitions.
        """
        return pulumi.get(self, "partition_left")

    @partition_left.setter
    def partition_left(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "partition_left", value)

    @_builtins.property
    @pulumi.getter(name="partitionNum")
    def partition_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of partitions.
        """
        return pulumi.get(self, "partition_num")

    @partition_num.setter
    def partition_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "partition_num", value)

    @_builtins.property
    @pulumi.getter(name="partitionUsed")
    def partition_used(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Available since v1.214.1) The number of used partitions.
        """
        return pulumi.get(self, "partition_used")

    @partition_used.setter
    def partition_used(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "partition_used", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance password. **NOTE:** If `instance_type` is set to `alikafka_confluent`, `password` is required.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="saslDomainEndpoint")
    def sasl_domain_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.234.0) The Simple Authentication and Security Layer (SASL) endpoint of the instance in domain name mode.
        """
        return pulumi.get(self, "sasl_domain_endpoint")

    @sasl_domain_endpoint.setter
    def sasl_domain_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sasl_domain_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of security group for this instance. If the security group is empty, system will create a default one.
        """
        return pulumi.get(self, "security_group")

    @security_group.setter
    def security_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group", value)

    @_builtins.property
    @pulumi.getter(name="selectedZones")
    def selected_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The zones among which you want to deploy the instance.
        """
        return pulumi.get(self, "selected_zones")

    @selected_zones.setter
    def selected_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "selected_zones", value)

    @_builtins.property
    @pulumi.getter(name="serverlessConfig")
    def serverless_config(self) -> Optional[pulumi.Input['InstanceServerlessConfigArgs']]:
        """
        The parameters configured for the serverless ApsaraMQ for Kafka instance. See `serverless_config` below.
        > **NOTE:** If `instance_type` is set to `alikafka_serverless`, `serverless_config` is required.
        """
        return pulumi.get(self, "serverless_config")

    @serverless_config.setter
    def serverless_config(self, value: Optional[pulumi.Input['InstanceServerlessConfigArgs']]):
        pulumi.set(self, "serverless_config", value)

    @_builtins.property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the Instance. Valid values:
        - If `instance_type` is set to `alikafka`. Default value: `2.2.0`. Valid values: `2.2.0`, `2.6.2`.
        - If `instance_type` is set to `alikafka_serverless`. Default value: `3.3.1`. Valid values: `3.3.1`.
        - If `instance_type` is set to `alikafka_confluent`. Default value: `7.4.0`. Valid values: `7.4.0`.
        """
        return pulumi.get(self, "service_version")

    @service_version.setter
    def service_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_version", value)

    @_builtins.property
    @pulumi.getter(name="specType")
    def spec_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance edition. Default value: `normal`. Valid values:
        - If `instance_type` is set to `alikafka`. Valid values: `normal`, `professional`, `professionalForHighRead`.
        - If `instance_type` is set to `alikafka_serverless`. Valid values: `normal`.
        - If `instance_type` is set to `alikafka_confluent`. Valid values: `professional`, `enterprise`.
        """
        return pulumi.get(self, "spec_type")

    @spec_type.setter
    def spec_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spec_type", value)

    @_builtins.property
    @pulumi.getter(name="sslDomainEndpoint")
    def ssl_domain_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.234.0) The SSL endpoint of the instance in domain name mode.
        """
        return pulumi.get(self, "ssl_domain_endpoint")

    @ssl_domain_endpoint.setter
    def ssl_domain_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_domain_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="sslEndpoint")
    def ssl_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.234.0) The Secure Sockets Layer (SSL) endpoint of the instance in IP address mode.
        """
        return pulumi.get(self, "ssl_endpoint")

    @ssl_endpoint.setter
    def ssl_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The status of the instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="topicLeft")
    def topic_left(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Available since v1.214.1) The number of available topics.
        """
        return pulumi.get(self, "topic_left")

    @topic_left.setter
    def topic_left(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "topic_left", value)

    @_builtins.property
    @pulumi.getter(name="topicNumOfBuy")
    def topic_num_of_buy(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Available since v1.214.1) The number of purchased topics.
        """
        return pulumi.get(self, "topic_num_of_buy")

    @topic_num_of_buy.setter
    def topic_num_of_buy(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "topic_num_of_buy", value)

    @_builtins.property
    @pulumi.getter(name="topicQuota")
    @_utilities.deprecated("""Attribute `topic_quota` has been deprecated since 1.194.0 and it will be removed in the next future. Using new attribute `partition_num` instead.""")
    def topic_quota(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The max num of topic can be creation of the instance.
        It has been deprecated since version 1.194.0 and using `partition_num` instead.
        Currently, its value only can be set to 50 when creating it, and finally depends on `partition_num` value: <`topic_quota`> = 1000 + <`partition_num`>.
        Therefore, you can update it by updating the `partition_num`, and it is the only updating path.
        """
        return pulumi.get(self, "topic_quota")

    @topic_quota.setter
    def topic_quota(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "topic_quota", value)

    @_builtins.property
    @pulumi.getter(name="topicUsed")
    def topic_used(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Available since v1.214.1) The number of used topics.
        """
        return pulumi.get(self, "topic_used")

    @topic_used.setter
    def topic_used(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "topic_used", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID of the instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of attaching vswitch to instance.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs of the vSwitches with which the instance is associated.
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vswitch_ids", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID of the instance. The value can be in zone x or region id-x format. **NOTE**: When the available zone is insufficient, another availability zone may be deployed.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:alikafka/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 confluent_config: Optional[pulumi.Input[Union['InstanceConfluentConfigArgs', 'InstanceConfluentConfigArgsDict']]] = None,
                 default_topic_partition_num: Optional[pulumi.Input[_builtins.int]] = None,
                 deploy_type: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.int]] = None,
                 eip_max: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_auto_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_auto_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 io_max: Optional[pulumi.Input[_builtins.int]] = None,
                 io_max_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 paid_type: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_num: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group: Optional[pulumi.Input[_builtins.str]] = None,
                 selected_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 serverless_config: Optional[pulumi.Input[Union['InstanceServerlessConfigArgs', 'InstanceServerlessConfigArgsDict']]] = None,
                 service_version: Optional[pulumi.Input[_builtins.str]] = None,
                 spec_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topic_quota: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        AliKafka instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alikafka/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] config: The initial configurations of the ApsaraMQ for Kafka instance. The values must be valid JSON strings. The `config` supports the following parameters:
               * `enable.vpc_sasl_ssl`: Specifies whether to enable VPC transmission encryption. Default value: `false`. Valid values:
        :param pulumi.Input[Union['InstanceConfluentConfigArgs', 'InstanceConfluentConfigArgsDict']] confluent_config: The configurations of Confluent. See `confluent_config` below.
               > **NOTE:** If `instance_type` is set to `alikafka_confluent`, `confluent_config` is required.
        :param pulumi.Input[_builtins.int] default_topic_partition_num: The number of partitions in a topic that is automatically created.
        :param pulumi.Input[_builtins.int] deploy_type: The deployment type of the instance. **NOTE:** From version 1.161.0, this attribute supports to be updated. Valid values:
        :param pulumi.Input[_builtins.int] disk_size: The disk size of the instance. When modify this value, it only supports adjust to a greater value.
               > **NOTE:** If `instance_type` is set to `alikafka`, `disk_size` is required.
        :param pulumi.Input[_builtins.int] disk_type: The disk type of the instance. Valid values:
        :param pulumi.Input[_builtins.int] eip_max: The max bandwidth of the instance. It will be ignored when `deploy_type = 5`. When modify this value, it only supports adjust to a greater value.
        :param pulumi.Input[_builtins.bool] enable_auto_group: Specify whether to enable the flexible group creation feature. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] enable_auto_topic: Specify whether to enable the automatic topic creation feature. Default value: `disable`. Valid values:
        :param pulumi.Input[_builtins.str] instance_type: The type of the Instance. Default value: `alikafka`. Valid values:
        :param pulumi.Input[_builtins.int] io_max: The max value of io of the instance. When modify this value, it only support adjust to a greater value.
        :param pulumi.Input[_builtins.str] io_max_spec: The traffic specification of the instance. We recommend that you configure this parameter.
               - You should specify one of the `io_max` and `io_max_spec` parameters, and `io_max_spec` is recommended.
               - For more information about the valid values, see [Billing](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/billing-overview).
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the key that is used to encrypt data on standard SSDs in the region of the instance.
        :param pulumi.Input[_builtins.str] name: Name of your Kafka instance. The length should between 3 and 64 characters. If not set, will use instance id as instance name.
        :param pulumi.Input[_builtins.str] paid_type: The billing method of the instance. Default value: `PostPaid`. Valid values: `PostPaid`, `PrePaid`. When modify this value, it only support adjust from `PostPaid` to `PrePaid`.
        :param pulumi.Input[_builtins.int] partition_num: The number of partitions.
        :param pulumi.Input[_builtins.str] password: The instance password. **NOTE:** If `instance_type` is set to `alikafka_confluent`, `password` is required.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param pulumi.Input[_builtins.str] security_group: The ID of security group for this instance. If the security group is empty, system will create a default one.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] selected_zones: The zones among which you want to deploy the instance.
        :param pulumi.Input[Union['InstanceServerlessConfigArgs', 'InstanceServerlessConfigArgsDict']] serverless_config: The parameters configured for the serverless ApsaraMQ for Kafka instance. See `serverless_config` below.
               > **NOTE:** If `instance_type` is set to `alikafka_serverless`, `serverless_config` is required.
        :param pulumi.Input[_builtins.str] service_version: The version of the Instance. Valid values:
               - If `instance_type` is set to `alikafka`. Default value: `2.2.0`. Valid values: `2.2.0`, `2.6.2`.
               - If `instance_type` is set to `alikafka_serverless`. Default value: `3.3.1`. Valid values: `3.3.1`.
               - If `instance_type` is set to `alikafka_confluent`. Default value: `7.4.0`. Valid values: `7.4.0`.
        :param pulumi.Input[_builtins.str] spec_type: The instance edition. Default value: `normal`. Valid values:
               - If `instance_type` is set to `alikafka`. Valid values: `normal`, `professional`, `professionalForHighRead`.
               - If `instance_type` is set to `alikafka_serverless`. Valid values: `normal`.
               - If `instance_type` is set to `alikafka_confluent`. Valid values: `professional`, `enterprise`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] topic_quota: The max num of topic can be creation of the instance.
               It has been deprecated since version 1.194.0 and using `partition_num` instead.
               Currently, its value only can be set to 50 when creating it, and finally depends on `partition_num` value: <`topic_quota`> = 1000 + <`partition_num`>.
               Therefore, you can update it by updating the `partition_num`, and it is the only updating path.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID of the instance.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of attaching vswitch to instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: The IDs of the vSwitches with which the instance is associated.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the instance. The value can be in zone x or region id-x format. **NOTE**: When the available zone is insufficient, another availability zone may be deployed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        AliKafka instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alikafka/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 confluent_config: Optional[pulumi.Input[Union['InstanceConfluentConfigArgs', 'InstanceConfluentConfigArgsDict']]] = None,
                 default_topic_partition_num: Optional[pulumi.Input[_builtins.int]] = None,
                 deploy_type: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.int]] = None,
                 eip_max: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_auto_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_auto_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 io_max: Optional[pulumi.Input[_builtins.int]] = None,
                 io_max_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 paid_type: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_num: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group: Optional[pulumi.Input[_builtins.str]] = None,
                 selected_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 serverless_config: Optional[pulumi.Input[Union['InstanceServerlessConfigArgs', 'InstanceServerlessConfigArgsDict']]] = None,
                 service_version: Optional[pulumi.Input[_builtins.str]] = None,
                 spec_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topic_quota: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["config"] = config
            __props__.__dict__["confluent_config"] = confluent_config
            __props__.__dict__["default_topic_partition_num"] = default_topic_partition_num
            if deploy_type is None and not opts.urn:
                raise TypeError("Missing required property 'deploy_type'")
            __props__.__dict__["deploy_type"] = deploy_type
            __props__.__dict__["disk_size"] = disk_size
            __props__.__dict__["disk_type"] = disk_type
            __props__.__dict__["eip_max"] = eip_max
            __props__.__dict__["enable_auto_group"] = enable_auto_group
            __props__.__dict__["enable_auto_topic"] = enable_auto_topic
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["io_max"] = io_max
            __props__.__dict__["io_max_spec"] = io_max_spec
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["name"] = name
            __props__.__dict__["paid_type"] = paid_type
            __props__.__dict__["partition_num"] = partition_num
            __props__.__dict__["password"] = password
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["security_group"] = security_group
            __props__.__dict__["selected_zones"] = selected_zones
            __props__.__dict__["serverless_config"] = serverless_config
            __props__.__dict__["service_version"] = service_version
            __props__.__dict__["spec_type"] = spec_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["topic_quota"] = topic_quota
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["vswitch_ids"] = vswitch_ids
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["domain_endpoint"] = None
            __props__.__dict__["end_point"] = None
            __props__.__dict__["group_left"] = None
            __props__.__dict__["group_used"] = None
            __props__.__dict__["is_partition_buy"] = None
            __props__.__dict__["partition_left"] = None
            __props__.__dict__["partition_used"] = None
            __props__.__dict__["sasl_domain_endpoint"] = None
            __props__.__dict__["ssl_domain_endpoint"] = None
            __props__.__dict__["ssl_endpoint"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["topic_left"] = None
            __props__.__dict__["topic_num_of_buy"] = None
            __props__.__dict__["topic_used"] = None
        super(Instance, __self__).__init__(
            'alicloud:alikafka/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[_builtins.str]] = None,
            confluent_config: Optional[pulumi.Input[Union['InstanceConfluentConfigArgs', 'InstanceConfluentConfigArgsDict']]] = None,
            default_topic_partition_num: Optional[pulumi.Input[_builtins.int]] = None,
            deploy_type: Optional[pulumi.Input[_builtins.int]] = None,
            disk_size: Optional[pulumi.Input[_builtins.int]] = None,
            disk_type: Optional[pulumi.Input[_builtins.int]] = None,
            domain_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            eip_max: Optional[pulumi.Input[_builtins.int]] = None,
            enable_auto_group: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_auto_topic: Optional[pulumi.Input[_builtins.str]] = None,
            end_point: Optional[pulumi.Input[_builtins.str]] = None,
            group_left: Optional[pulumi.Input[_builtins.int]] = None,
            group_used: Optional[pulumi.Input[_builtins.int]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            io_max: Optional[pulumi.Input[_builtins.int]] = None,
            io_max_spec: Optional[pulumi.Input[_builtins.str]] = None,
            is_partition_buy: Optional[pulumi.Input[_builtins.int]] = None,
            kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            paid_type: Optional[pulumi.Input[_builtins.str]] = None,
            partition_left: Optional[pulumi.Input[_builtins.int]] = None,
            partition_num: Optional[pulumi.Input[_builtins.int]] = None,
            partition_used: Optional[pulumi.Input[_builtins.int]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            sasl_domain_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            security_group: Optional[pulumi.Input[_builtins.str]] = None,
            selected_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            serverless_config: Optional[pulumi.Input[Union['InstanceServerlessConfigArgs', 'InstanceServerlessConfigArgsDict']]] = None,
            service_version: Optional[pulumi.Input[_builtins.str]] = None,
            spec_type: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_domain_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            topic_left: Optional[pulumi.Input[_builtins.int]] = None,
            topic_num_of_buy: Optional[pulumi.Input[_builtins.int]] = None,
            topic_quota: Optional[pulumi.Input[_builtins.int]] = None,
            topic_used: Optional[pulumi.Input[_builtins.int]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] config: The initial configurations of the ApsaraMQ for Kafka instance. The values must be valid JSON strings. The `config` supports the following parameters:
               * `enable.vpc_sasl_ssl`: Specifies whether to enable VPC transmission encryption. Default value: `false`. Valid values:
        :param pulumi.Input[Union['InstanceConfluentConfigArgs', 'InstanceConfluentConfigArgsDict']] confluent_config: The configurations of Confluent. See `confluent_config` below.
               > **NOTE:** If `instance_type` is set to `alikafka_confluent`, `confluent_config` is required.
        :param pulumi.Input[_builtins.int] default_topic_partition_num: The number of partitions in a topic that is automatically created.
        :param pulumi.Input[_builtins.int] deploy_type: The deployment type of the instance. **NOTE:** From version 1.161.0, this attribute supports to be updated. Valid values:
        :param pulumi.Input[_builtins.int] disk_size: The disk size of the instance. When modify this value, it only supports adjust to a greater value.
               > **NOTE:** If `instance_type` is set to `alikafka`, `disk_size` is required.
        :param pulumi.Input[_builtins.int] disk_type: The disk type of the instance. Valid values:
        :param pulumi.Input[_builtins.str] domain_endpoint: (Available since v1.234.0) The default endpoint of the instance in domain name mode.
        :param pulumi.Input[_builtins.int] eip_max: The max bandwidth of the instance. It will be ignored when `deploy_type = 5`. When modify this value, it only supports adjust to a greater value.
        :param pulumi.Input[_builtins.bool] enable_auto_group: Specify whether to enable the flexible group creation feature. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] enable_auto_topic: Specify whether to enable the automatic topic creation feature. Default value: `disable`. Valid values:
        :param pulumi.Input[_builtins.str] end_point: The EndPoint to access the kafka instance.
        :param pulumi.Input[_builtins.int] group_left: (Available since v1.214.1) The number of available groups.
        :param pulumi.Input[_builtins.int] group_used: (Available since v1.214.1) The number of used groups.
        :param pulumi.Input[_builtins.str] instance_type: The type of the Instance. Default value: `alikafka`. Valid values:
        :param pulumi.Input[_builtins.int] io_max: The max value of io of the instance. When modify this value, it only support adjust to a greater value.
        :param pulumi.Input[_builtins.str] io_max_spec: The traffic specification of the instance. We recommend that you configure this parameter.
               - You should specify one of the `io_max` and `io_max_spec` parameters, and `io_max_spec` is recommended.
               - For more information about the valid values, see [Billing](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/billing-overview).
        :param pulumi.Input[_builtins.int] is_partition_buy: (Available since v1.214.1) The method that you use to purchase partitions.
        :param pulumi.Input[_builtins.str] kms_key_id: The ID of the key that is used to encrypt data on standard SSDs in the region of the instance.
        :param pulumi.Input[_builtins.str] name: Name of your Kafka instance. The length should between 3 and 64 characters. If not set, will use instance id as instance name.
        :param pulumi.Input[_builtins.str] paid_type: The billing method of the instance. Default value: `PostPaid`. Valid values: `PostPaid`, `PrePaid`. When modify this value, it only support adjust from `PostPaid` to `PrePaid`.
        :param pulumi.Input[_builtins.int] partition_left: (Available since v1.214.1) The number of available partitions.
        :param pulumi.Input[_builtins.int] partition_num: The number of partitions.
        :param pulumi.Input[_builtins.int] partition_used: (Available since v1.214.1) The number of used partitions.
        :param pulumi.Input[_builtins.str] password: The instance password. **NOTE:** If `instance_type` is set to `alikafka_confluent`, `password` is required.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param pulumi.Input[_builtins.str] sasl_domain_endpoint: (Available since v1.234.0) The Simple Authentication and Security Layer (SASL) endpoint of the instance in domain name mode.
        :param pulumi.Input[_builtins.str] security_group: The ID of security group for this instance. If the security group is empty, system will create a default one.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] selected_zones: The zones among which you want to deploy the instance.
        :param pulumi.Input[Union['InstanceServerlessConfigArgs', 'InstanceServerlessConfigArgsDict']] serverless_config: The parameters configured for the serverless ApsaraMQ for Kafka instance. See `serverless_config` below.
               > **NOTE:** If `instance_type` is set to `alikafka_serverless`, `serverless_config` is required.
        :param pulumi.Input[_builtins.str] service_version: The version of the Instance. Valid values:
               - If `instance_type` is set to `alikafka`. Default value: `2.2.0`. Valid values: `2.2.0`, `2.6.2`.
               - If `instance_type` is set to `alikafka_serverless`. Default value: `3.3.1`. Valid values: `3.3.1`.
               - If `instance_type` is set to `alikafka_confluent`. Default value: `7.4.0`. Valid values: `7.4.0`.
        :param pulumi.Input[_builtins.str] spec_type: The instance edition. Default value: `normal`. Valid values:
               - If `instance_type` is set to `alikafka`. Valid values: `normal`, `professional`, `professionalForHighRead`.
               - If `instance_type` is set to `alikafka_serverless`. Valid values: `normal`.
               - If `instance_type` is set to `alikafka_confluent`. Valid values: `professional`, `enterprise`.
        :param pulumi.Input[_builtins.str] ssl_domain_endpoint: (Available since v1.234.0) The SSL endpoint of the instance in domain name mode.
        :param pulumi.Input[_builtins.str] ssl_endpoint: (Available since v1.234.0) The Secure Sockets Layer (SSL) endpoint of the instance in IP address mode.
        :param pulumi.Input[_builtins.int] status: The status of the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.int] topic_left: (Available since v1.214.1) The number of available topics.
        :param pulumi.Input[_builtins.int] topic_num_of_buy: (Available since v1.214.1) The number of purchased topics.
        :param pulumi.Input[_builtins.int] topic_quota: The max num of topic can be creation of the instance.
               It has been deprecated since version 1.194.0 and using `partition_num` instead.
               Currently, its value only can be set to 50 when creating it, and finally depends on `partition_num` value: <`topic_quota`> = 1000 + <`partition_num`>.
               Therefore, you can update it by updating the `partition_num`, and it is the only updating path.
        :param pulumi.Input[_builtins.int] topic_used: (Available since v1.214.1) The number of used topics.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID of the instance.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of attaching vswitch to instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: The IDs of the vSwitches with which the instance is associated.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the instance. The value can be in zone x or region id-x format. **NOTE**: When the available zone is insufficient, another availability zone may be deployed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["config"] = config
        __props__.__dict__["confluent_config"] = confluent_config
        __props__.__dict__["default_topic_partition_num"] = default_topic_partition_num
        __props__.__dict__["deploy_type"] = deploy_type
        __props__.__dict__["disk_size"] = disk_size
        __props__.__dict__["disk_type"] = disk_type
        __props__.__dict__["domain_endpoint"] = domain_endpoint
        __props__.__dict__["eip_max"] = eip_max
        __props__.__dict__["enable_auto_group"] = enable_auto_group
        __props__.__dict__["enable_auto_topic"] = enable_auto_topic
        __props__.__dict__["end_point"] = end_point
        __props__.__dict__["group_left"] = group_left
        __props__.__dict__["group_used"] = group_used
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["io_max"] = io_max
        __props__.__dict__["io_max_spec"] = io_max_spec
        __props__.__dict__["is_partition_buy"] = is_partition_buy
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["name"] = name
        __props__.__dict__["paid_type"] = paid_type
        __props__.__dict__["partition_left"] = partition_left
        __props__.__dict__["partition_num"] = partition_num
        __props__.__dict__["partition_used"] = partition_used
        __props__.__dict__["password"] = password
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["sasl_domain_endpoint"] = sasl_domain_endpoint
        __props__.__dict__["security_group"] = security_group
        __props__.__dict__["selected_zones"] = selected_zones
        __props__.__dict__["serverless_config"] = serverless_config
        __props__.__dict__["service_version"] = service_version
        __props__.__dict__["spec_type"] = spec_type
        __props__.__dict__["ssl_domain_endpoint"] = ssl_domain_endpoint
        __props__.__dict__["ssl_endpoint"] = ssl_endpoint
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["topic_left"] = topic_left
        __props__.__dict__["topic_num_of_buy"] = topic_num_of_buy
        __props__.__dict__["topic_quota"] = topic_quota
        __props__.__dict__["topic_used"] = topic_used
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["vswitch_ids"] = vswitch_ids
        __props__.__dict__["zone_id"] = zone_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output[_builtins.str]:
        """
        The initial configurations of the ApsaraMQ for Kafka instance. The values must be valid JSON strings. The `config` supports the following parameters:
        * `enable.vpc_sasl_ssl`: Specifies whether to enable VPC transmission encryption. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="confluentConfig")
    def confluent_config(self) -> pulumi.Output['outputs.InstanceConfluentConfig']:
        """
        The configurations of Confluent. See `confluent_config` below.
        > **NOTE:** If `instance_type` is set to `alikafka_confluent`, `confluent_config` is required.
        """
        return pulumi.get(self, "confluent_config")

    @_builtins.property
    @pulumi.getter(name="defaultTopicPartitionNum")
    def default_topic_partition_num(self) -> pulumi.Output[_builtins.int]:
        """
        The number of partitions in a topic that is automatically created.
        """
        return pulumi.get(self, "default_topic_partition_num")

    @_builtins.property
    @pulumi.getter(name="deployType")
    def deploy_type(self) -> pulumi.Output[_builtins.int]:
        """
        The deployment type of the instance. **NOTE:** From version 1.161.0, this attribute supports to be updated. Valid values:
        """
        return pulumi.get(self, "deploy_type")

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The disk size of the instance. When modify this value, it only supports adjust to a greater value.
        > **NOTE:** If `instance_type` is set to `alikafka`, `disk_size` is required.
        """
        return pulumi.get(self, "disk_size")

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The disk type of the instance. Valid values:
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter(name="domainEndpoint")
    def domain_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.234.0) The default endpoint of the instance in domain name mode.
        """
        return pulumi.get(self, "domain_endpoint")

    @_builtins.property
    @pulumi.getter(name="eipMax")
    def eip_max(self) -> pulumi.Output[_builtins.int]:
        """
        The max bandwidth of the instance. It will be ignored when `deploy_type = 5`. When modify this value, it only supports adjust to a greater value.
        """
        return pulumi.get(self, "eip_max")

    @_builtins.property
    @pulumi.getter(name="enableAutoGroup")
    def enable_auto_group(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specify whether to enable the flexible group creation feature. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_auto_group")

    @_builtins.property
    @pulumi.getter(name="enableAutoTopic")
    def enable_auto_topic(self) -> pulumi.Output[_builtins.str]:
        """
        Specify whether to enable the automatic topic creation feature. Default value: `disable`. Valid values:
        """
        return pulumi.get(self, "enable_auto_topic")

    @_builtins.property
    @pulumi.getter(name="endPoint")
    def end_point(self) -> pulumi.Output[_builtins.str]:
        """
        The EndPoint to access the kafka instance.
        """
        return pulumi.get(self, "end_point")

    @_builtins.property
    @pulumi.getter(name="groupLeft")
    def group_left(self) -> pulumi.Output[_builtins.int]:
        """
        (Available since v1.214.1) The number of available groups.
        """
        return pulumi.get(self, "group_left")

    @_builtins.property
    @pulumi.getter(name="groupUsed")
    def group_used(self) -> pulumi.Output[_builtins.int]:
        """
        (Available since v1.214.1) The number of used groups.
        """
        return pulumi.get(self, "group_used")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the Instance. Default value: `alikafka`. Valid values:
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="ioMax")
    def io_max(self) -> pulumi.Output[_builtins.int]:
        """
        The max value of io of the instance. When modify this value, it only support adjust to a greater value.
        """
        return pulumi.get(self, "io_max")

    @_builtins.property
    @pulumi.getter(name="ioMaxSpec")
    def io_max_spec(self) -> pulumi.Output[_builtins.str]:
        """
        The traffic specification of the instance. We recommend that you configure this parameter.
        - You should specify one of the `io_max` and `io_max_spec` parameters, and `io_max_spec` is recommended.
        - For more information about the valid values, see [Billing](https://www.alibabacloud.com/help/en/message-queue-for-apache-kafka/latest/billing-overview).
        """
        return pulumi.get(self, "io_max_spec")

    @_builtins.property
    @pulumi.getter(name="isPartitionBuy")
    def is_partition_buy(self) -> pulumi.Output[_builtins.int]:
        """
        (Available since v1.214.1) The method that you use to purchase partitions.
        """
        return pulumi.get(self, "is_partition_buy")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the key that is used to encrypt data on standard SSDs in the region of the instance.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of your Kafka instance. The length should between 3 and 64 characters. If not set, will use instance id as instance name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="paidType")
    def paid_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The billing method of the instance. Default value: `PostPaid`. Valid values: `PostPaid`, `PrePaid`. When modify this value, it only support adjust from `PostPaid` to `PrePaid`.
        """
        return pulumi.get(self, "paid_type")

    @_builtins.property
    @pulumi.getter(name="partitionLeft")
    def partition_left(self) -> pulumi.Output[_builtins.int]:
        """
        (Available since v1.214.1) The number of available partitions.
        """
        return pulumi.get(self, "partition_left")

    @_builtins.property
    @pulumi.getter(name="partitionNum")
    def partition_num(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of partitions.
        """
        return pulumi.get(self, "partition_num")

    @_builtins.property
    @pulumi.getter(name="partitionUsed")
    def partition_used(self) -> pulumi.Output[_builtins.int]:
        """
        (Available since v1.214.1) The number of used partitions.
        """
        return pulumi.get(self, "partition_used")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The instance password. **NOTE:** If `instance_type` is set to `alikafka_confluent`, `password` is required.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="saslDomainEndpoint")
    def sasl_domain_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.234.0) The Simple Authentication and Security Layer (SASL) endpoint of the instance in domain name mode.
        """
        return pulumi.get(self, "sasl_domain_endpoint")

    @_builtins.property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of security group for this instance. If the security group is empty, system will create a default one.
        """
        return pulumi.get(self, "security_group")

    @_builtins.property
    @pulumi.getter(name="selectedZones")
    def selected_zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The zones among which you want to deploy the instance.
        """
        return pulumi.get(self, "selected_zones")

    @_builtins.property
    @pulumi.getter(name="serverlessConfig")
    def serverless_config(self) -> pulumi.Output['outputs.InstanceServerlessConfig']:
        """
        The parameters configured for the serverless ApsaraMQ for Kafka instance. See `serverless_config` below.
        > **NOTE:** If `instance_type` is set to `alikafka_serverless`, `serverless_config` is required.
        """
        return pulumi.get(self, "serverless_config")

    @_builtins.property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the Instance. Valid values:
        - If `instance_type` is set to `alikafka`. Default value: `2.2.0`. Valid values: `2.2.0`, `2.6.2`.
        - If `instance_type` is set to `alikafka_serverless`. Default value: `3.3.1`. Valid values: `3.3.1`.
        - If `instance_type` is set to `alikafka_confluent`. Default value: `7.4.0`. Valid values: `7.4.0`.
        """
        return pulumi.get(self, "service_version")

    @_builtins.property
    @pulumi.getter(name="specType")
    def spec_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The instance edition. Default value: `normal`. Valid values:
        - If `instance_type` is set to `alikafka`. Valid values: `normal`, `professional`, `professionalForHighRead`.
        - If `instance_type` is set to `alikafka_serverless`. Valid values: `normal`.
        - If `instance_type` is set to `alikafka_confluent`. Valid values: `professional`, `enterprise`.
        """
        return pulumi.get(self, "spec_type")

    @_builtins.property
    @pulumi.getter(name="sslDomainEndpoint")
    def ssl_domain_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.234.0) The SSL endpoint of the instance in domain name mode.
        """
        return pulumi.get(self, "ssl_domain_endpoint")

    @_builtins.property
    @pulumi.getter(name="sslEndpoint")
    def ssl_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.234.0) The Secure Sockets Layer (SSL) endpoint of the instance in IP address mode.
        """
        return pulumi.get(self, "ssl_endpoint")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.int]:
        """
        The status of the instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="topicLeft")
    def topic_left(self) -> pulumi.Output[_builtins.int]:
        """
        (Available since v1.214.1) The number of available topics.
        """
        return pulumi.get(self, "topic_left")

    @_builtins.property
    @pulumi.getter(name="topicNumOfBuy")
    def topic_num_of_buy(self) -> pulumi.Output[_builtins.int]:
        """
        (Available since v1.214.1) The number of purchased topics.
        """
        return pulumi.get(self, "topic_num_of_buy")

    @_builtins.property
    @pulumi.getter(name="topicQuota")
    @_utilities.deprecated("""Attribute `topic_quota` has been deprecated since 1.194.0 and it will be removed in the next future. Using new attribute `partition_num` instead.""")
    def topic_quota(self) -> pulumi.Output[_builtins.int]:
        """
        The max num of topic can be creation of the instance.
        It has been deprecated since version 1.194.0 and using `partition_num` instead.
        Currently, its value only can be set to 50 when creating it, and finally depends on `partition_num` value: <`topic_quota`> = 1000 + <`partition_num`>.
        Therefore, you can update it by updating the `partition_num`, and it is the only updating path.
        """
        return pulumi.get(self, "topic_quota")

    @_builtins.property
    @pulumi.getter(name="topicUsed")
    def topic_used(self) -> pulumi.Output[_builtins.int]:
        """
        (Available since v1.214.1) The number of used topics.
        """
        return pulumi.get(self, "topic_used")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC ID of the instance.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of attaching vswitch to instance.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The IDs of the vSwitches with which the instance is associated.
        """
        return pulumi.get(self, "vswitch_ids")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The zone ID of the instance. The value can be in zone x or region id-x format. **NOTE**: When the available zone is insufficient, another availability zone may be deployed.
        """
        return pulumi.get(self, "zone_id")

