# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HttpApiArgs', 'HttpApi']

@pulumi.input_type
class HttpApiArgs:
    def __init__(__self__, *,
                 http_api_name: pulumi.Input[_builtins.str],
                 protocols: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 base_path: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a HttpApi resource.
        :param pulumi.Input[_builtins.str] http_api_name: The name of the resource
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocols: API protocol
        :param pulumi.Input[_builtins.str] base_path: API path
        :param pulumi.Input[_builtins.str] description: Description of API
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] type: API type
        """
        pulumi.set(__self__, "http_api_name", http_api_name)
        pulumi.set(__self__, "protocols", protocols)
        if base_path is not None:
            pulumi.set(__self__, "base_path", base_path)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="httpApiName")
    def http_api_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "http_api_name")

    @http_api_name.setter
    def http_api_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "http_api_name", value)

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        API protocol
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "protocols", value)

    @_builtins.property
    @pulumi.getter(name="basePath")
    def base_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API path
        """
        return pulumi.get(self, "base_path")

    @base_path.setter
    def base_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_path", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of API
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _HttpApiState:
    def __init__(__self__, *,
                 base_path: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 http_api_name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HttpApi resources.
        :param pulumi.Input[_builtins.str] base_path: API path
        :param pulumi.Input[_builtins.str] description: Description of API
        :param pulumi.Input[_builtins.str] http_api_name: The name of the resource
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocols: API protocol
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] type: API type
        """
        if base_path is not None:
            pulumi.set(__self__, "base_path", base_path)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if http_api_name is not None:
            pulumi.set(__self__, "http_api_name", http_api_name)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="basePath")
    def base_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API path
        """
        return pulumi.get(self, "base_path")

    @base_path.setter
    def base_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_path", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of API
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="httpApiName")
    def http_api_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "http_api_name")

    @http_api_name.setter
    def http_api_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_api_name", value)

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        API protocol
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "protocols", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("alicloud:apig/httpApi:HttpApi")
class HttpApi(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_path: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 http_api_name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a APIG Http Api resource.

        For information about APIG Http Api and how to use it, see [What is Http Api](https://next.api.aliyun.com/api/APIG/2024-03-27/CreateHttpApi).

        > **NOTE:** Available since v1.240.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        protocol = config.get("protocol")
        if protocol is None:
            protocol = "HTTP"
        protocol_https = config.get("protocolHttps")
        if protocol_https is None:
            protocol_https = "HTTPS"
        default = alicloud.resourcemanager.get_resource_groups()
        default_http_api = alicloud.apig.HttpApi("default",
            http_api_name=name,
            protocols=[protocol],
            base_path="/v1",
            description="zhiwei_pop_examplecase",
            type="Rest")
        ```

        ## Import

        APIG Http Api can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:apig/httpApi:HttpApi example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] base_path: API path
        :param pulumi.Input[_builtins.str] description: Description of API
        :param pulumi.Input[_builtins.str] http_api_name: The name of the resource
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocols: API protocol
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] type: API type
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HttpApiArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a APIG Http Api resource.

        For information about APIG Http Api and how to use it, see [What is Http Api](https://next.api.aliyun.com/api/APIG/2024-03-27/CreateHttpApi).

        > **NOTE:** Available since v1.240.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        protocol = config.get("protocol")
        if protocol is None:
            protocol = "HTTP"
        protocol_https = config.get("protocolHttps")
        if protocol_https is None:
            protocol_https = "HTTPS"
        default = alicloud.resourcemanager.get_resource_groups()
        default_http_api = alicloud.apig.HttpApi("default",
            http_api_name=name,
            protocols=[protocol],
            base_path="/v1",
            description="zhiwei_pop_examplecase",
            type="Rest")
        ```

        ## Import

        APIG Http Api can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:apig/httpApi:HttpApi example <id>
        ```

        :param str resource_name: The name of the resource.
        :param HttpApiArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HttpApiArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_path: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 http_api_name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HttpApiArgs.__new__(HttpApiArgs)

            __props__.__dict__["base_path"] = base_path
            __props__.__dict__["description"] = description
            if http_api_name is None and not opts.urn:
                raise TypeError("Missing required property 'http_api_name'")
            __props__.__dict__["http_api_name"] = http_api_name
            if protocols is None and not opts.urn:
                raise TypeError("Missing required property 'protocols'")
            __props__.__dict__["protocols"] = protocols
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["type"] = type
        super(HttpApi, __self__).__init__(
            'alicloud:apig/httpApi:HttpApi',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            base_path: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            http_api_name: Optional[pulumi.Input[_builtins.str]] = None,
            protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'HttpApi':
        """
        Get an existing HttpApi resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] base_path: API path
        :param pulumi.Input[_builtins.str] description: Description of API
        :param pulumi.Input[_builtins.str] http_api_name: The name of the resource
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocols: API protocol
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] type: API type
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HttpApiState.__new__(_HttpApiState)

        __props__.__dict__["base_path"] = base_path
        __props__.__dict__["description"] = description
        __props__.__dict__["http_api_name"] = http_api_name
        __props__.__dict__["protocols"] = protocols
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["type"] = type
        return HttpApi(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="basePath")
    def base_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        API path
        """
        return pulumi.get(self, "base_path")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of API
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="httpApiName")
    def http_api_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "http_api_name")

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        API protocol
        """
        return pulumi.get(self, "protocols")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        API type
        """
        return pulumi.get(self, "type")

