# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BackendArgs', 'Backend']

@pulumi.input_type
class BackendArgs:
    def __init__(__self__, *,
                 backend_name: pulumi.Input[_builtins.str],
                 backend_type: pulumi.Input[_builtins.str],
                 create_event_bridge_service_linked_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Backend resource.
        :param pulumi.Input[_builtins.str] backend_name: The name of the Backend.
        :param pulumi.Input[_builtins.str] backend_type: The type of the Backend. Valid values: `HTTP`, `VPC`, `FC_EVENT`, `FC_EVENT_V3`, `FC_HTTP`, `FC_HTTP_V3`, `OSS`, `MOCK`.
        :param pulumi.Input[_builtins.bool] create_event_bridge_service_linked_role: Whether to create an Event bus service association role.
        :param pulumi.Input[_builtins.str] description: The description of the Backend.
        """
        pulumi.set(__self__, "backend_name", backend_name)
        pulumi.set(__self__, "backend_type", backend_type)
        if create_event_bridge_service_linked_role is not None:
            pulumi.set(__self__, "create_event_bridge_service_linked_role", create_event_bridge_service_linked_role)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="backendName")
    def backend_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Backend.
        """
        return pulumi.get(self, "backend_name")

    @backend_name.setter
    def backend_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend_name", value)

    @_builtins.property
    @pulumi.getter(name="backendType")
    def backend_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the Backend. Valid values: `HTTP`, `VPC`, `FC_EVENT`, `FC_EVENT_V3`, `FC_HTTP`, `FC_HTTP_V3`, `OSS`, `MOCK`.
        """
        return pulumi.get(self, "backend_type")

    @backend_type.setter
    def backend_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend_type", value)

    @_builtins.property
    @pulumi.getter(name="createEventBridgeServiceLinkedRole")
    def create_event_bridge_service_linked_role(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create an Event bus service association role.
        """
        return pulumi.get(self, "create_event_bridge_service_linked_role")

    @create_event_bridge_service_linked_role.setter
    def create_event_bridge_service_linked_role(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "create_event_bridge_service_linked_role", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Backend.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _BackendState:
    def __init__(__self__, *,
                 backend_name: Optional[pulumi.Input[_builtins.str]] = None,
                 backend_type: Optional[pulumi.Input[_builtins.str]] = None,
                 create_event_bridge_service_linked_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Backend resources.
        :param pulumi.Input[_builtins.str] backend_name: The name of the Backend.
        :param pulumi.Input[_builtins.str] backend_type: The type of the Backend. Valid values: `HTTP`, `VPC`, `FC_EVENT`, `FC_EVENT_V3`, `FC_HTTP`, `FC_HTTP_V3`, `OSS`, `MOCK`.
        :param pulumi.Input[_builtins.bool] create_event_bridge_service_linked_role: Whether to create an Event bus service association role.
        :param pulumi.Input[_builtins.str] description: The description of the Backend.
        """
        if backend_name is not None:
            pulumi.set(__self__, "backend_name", backend_name)
        if backend_type is not None:
            pulumi.set(__self__, "backend_type", backend_type)
        if create_event_bridge_service_linked_role is not None:
            pulumi.set(__self__, "create_event_bridge_service_linked_role", create_event_bridge_service_linked_role)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="backendName")
    def backend_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Backend.
        """
        return pulumi.get(self, "backend_name")

    @backend_name.setter
    def backend_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend_name", value)

    @_builtins.property
    @pulumi.getter(name="backendType")
    def backend_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Backend. Valid values: `HTTP`, `VPC`, `FC_EVENT`, `FC_EVENT_V3`, `FC_HTTP`, `FC_HTTP_V3`, `OSS`, `MOCK`.
        """
        return pulumi.get(self, "backend_type")

    @backend_type.setter
    def backend_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend_type", value)

    @_builtins.property
    @pulumi.getter(name="createEventBridgeServiceLinkedRole")
    def create_event_bridge_service_linked_role(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create an Event bus service association role.
        """
        return pulumi.get(self, "create_event_bridge_service_linked_role")

    @create_event_bridge_service_linked_role.setter
    def create_event_bridge_service_linked_role(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "create_event_bridge_service_linked_role", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Backend.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.type_token("alicloud:apigateway/backend:Backend")
class Backend(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_name: Optional[pulumi.Input[_builtins.str]] = None,
                 backend_type: Optional[pulumi.Input[_builtins.str]] = None,
                 create_event_bridge_service_linked_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Api Gateway Backend resource.

        For information about Api Gateway Backend and how to use it, see [What is Backend](https://www.alibabacloud.com/help/en/api-gateway/developer-reference/api-cloudapi-2016-07-14-createbackend).

        > **NOTE:** Available since v1.181.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.apigateway.Backend("default",
            backend_name=name,
            description=name,
            backend_type="HTTP")
        ```

        ## Import

        Api Gateway Backend can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:apigateway/backend:Backend example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend_name: The name of the Backend.
        :param pulumi.Input[_builtins.str] backend_type: The type of the Backend. Valid values: `HTTP`, `VPC`, `FC_EVENT`, `FC_EVENT_V3`, `FC_HTTP`, `FC_HTTP_V3`, `OSS`, `MOCK`.
        :param pulumi.Input[_builtins.bool] create_event_bridge_service_linked_role: Whether to create an Event bus service association role.
        :param pulumi.Input[_builtins.str] description: The description of the Backend.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackendArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Api Gateway Backend resource.

        For information about Api Gateway Backend and how to use it, see [What is Backend](https://www.alibabacloud.com/help/en/api-gateway/developer-reference/api-cloudapi-2016-07-14-createbackend).

        > **NOTE:** Available since v1.181.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.apigateway.Backend("default",
            backend_name=name,
            description=name,
            backend_type="HTTP")
        ```

        ## Import

        Api Gateway Backend can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:apigateway/backend:Backend example <id>
        ```

        :param str resource_name: The name of the resource.
        :param BackendArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackendArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_name: Optional[pulumi.Input[_builtins.str]] = None,
                 backend_type: Optional[pulumi.Input[_builtins.str]] = None,
                 create_event_bridge_service_linked_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackendArgs.__new__(BackendArgs)

            if backend_name is None and not opts.urn:
                raise TypeError("Missing required property 'backend_name'")
            __props__.__dict__["backend_name"] = backend_name
            if backend_type is None and not opts.urn:
                raise TypeError("Missing required property 'backend_type'")
            __props__.__dict__["backend_type"] = backend_type
            __props__.__dict__["create_event_bridge_service_linked_role"] = create_event_bridge_service_linked_role
            __props__.__dict__["description"] = description
        super(Backend, __self__).__init__(
            'alicloud:apigateway/backend:Backend',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend_name: Optional[pulumi.Input[_builtins.str]] = None,
            backend_type: Optional[pulumi.Input[_builtins.str]] = None,
            create_event_bridge_service_linked_role: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None) -> 'Backend':
        """
        Get an existing Backend resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend_name: The name of the Backend.
        :param pulumi.Input[_builtins.str] backend_type: The type of the Backend. Valid values: `HTTP`, `VPC`, `FC_EVENT`, `FC_EVENT_V3`, `FC_HTTP`, `FC_HTTP_V3`, `OSS`, `MOCK`.
        :param pulumi.Input[_builtins.bool] create_event_bridge_service_linked_role: Whether to create an Event bus service association role.
        :param pulumi.Input[_builtins.str] description: The description of the Backend.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackendState.__new__(_BackendState)

        __props__.__dict__["backend_name"] = backend_name
        __props__.__dict__["backend_type"] = backend_type
        __props__.__dict__["create_event_bridge_service_linked_role"] = create_event_bridge_service_linked_role
        __props__.__dict__["description"] = description
        return Backend(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backendName")
    def backend_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Backend.
        """
        return pulumi.get(self, "backend_name")

    @_builtins.property
    @pulumi.getter(name="backendType")
    def backend_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the Backend. Valid values: `HTTP`, `VPC`, `FC_EVENT`, `FC_EVENT_V3`, `FC_HTTP`, `FC_HTTP_V3`, `OSS`, `MOCK`.
        """
        return pulumi.get(self, "backend_type")

    @_builtins.property
    @pulumi.getter(name="createEventBridgeServiceLinkedRole")
    def create_event_bridge_service_linked_role(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to create an Event bus service association role.
        """
        return pulumi.get(self, "create_event_bridge_service_linked_role")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Backend.
        """
        return pulumi.get(self, "description")

