# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GroupArgs', 'Group']

@pulumi.input_type
class GroupArgs:
    def __init__(__self__, *,
                 base_path: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_log_config: Optional[pulumi.Input['GroupUserLogConfigArgs']] = None,
                 vpc_intranet_enable: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Group resource.
        :param pulumi.Input[_builtins.str] base_path: The base path of the api gateway group. Defaults to `/`.
        :param pulumi.Input[_builtins.str] description: The description of the api gateway group. Defaults to null.
        :param pulumi.Input[_builtins.str] instance_id: The id of the api gateway.
        :param pulumi.Input[_builtins.str] name: The name of the api gateway group. Defaults to null.
        :param pulumi.Input['GroupUserLogConfigArgs'] user_log_config: user_log_config defines the config of user log of the group. See `user_log_config` below.
        :param pulumi.Input[_builtins.bool] vpc_intranet_enable: Whether to enable `vpc_domain`. Defaults to `false`.
        """
        if base_path is not None:
            pulumi.set(__self__, "base_path", base_path)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if user_log_config is not None:
            pulumi.set(__self__, "user_log_config", user_log_config)
        if vpc_intranet_enable is not None:
            pulumi.set(__self__, "vpc_intranet_enable", vpc_intranet_enable)

    @_builtins.property
    @pulumi.getter(name="basePath")
    def base_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base path of the api gateway group. Defaults to `/`.
        """
        return pulumi.get(self, "base_path")

    @base_path.setter
    def base_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_path", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the api gateway group. Defaults to null.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the api gateway.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the api gateway group. Defaults to null.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="userLogConfig")
    def user_log_config(self) -> Optional[pulumi.Input['GroupUserLogConfigArgs']]:
        """
        user_log_config defines the config of user log of the group. See `user_log_config` below.
        """
        return pulumi.get(self, "user_log_config")

    @user_log_config.setter
    def user_log_config(self, value: Optional[pulumi.Input['GroupUserLogConfigArgs']]):
        pulumi.set(self, "user_log_config", value)

    @_builtins.property
    @pulumi.getter(name="vpcIntranetEnable")
    def vpc_intranet_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable `vpc_domain`. Defaults to `false`.
        """
        return pulumi.get(self, "vpc_intranet_enable")

    @vpc_intranet_enable.setter
    def vpc_intranet_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vpc_intranet_enable", value)


@pulumi.input_type
class _GroupState:
    def __init__(__self__, *,
                 base_path: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 user_log_config: Optional[pulumi.Input['GroupUserLogConfigArgs']] = None,
                 vpc_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_intranet_enable: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Group resources.
        :param pulumi.Input[_builtins.str] base_path: The base path of the api gateway group. Defaults to `/`.
        :param pulumi.Input[_builtins.str] description: The description of the api gateway group. Defaults to null.
        :param pulumi.Input[_builtins.str] instance_id: The id of the api gateway.
        :param pulumi.Input[_builtins.str] name: The name of the api gateway group. Defaults to null.
        :param pulumi.Input[_builtins.str] sub_domain: (Available in 1.69.0+)	Second-level domain name automatically assigned to the API group.
        :param pulumi.Input['GroupUserLogConfigArgs'] user_log_config: user_log_config defines the config of user log of the group. See `user_log_config` below.
        :param pulumi.Input[_builtins.str] vpc_domain: (Available in 1.69.0+)	Second-level VPC domain name automatically assigned to the API group.
        :param pulumi.Input[_builtins.bool] vpc_intranet_enable: Whether to enable `vpc_domain`. Defaults to `false`.
        """
        if base_path is not None:
            pulumi.set(__self__, "base_path", base_path)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sub_domain is not None:
            pulumi.set(__self__, "sub_domain", sub_domain)
        if user_log_config is not None:
            pulumi.set(__self__, "user_log_config", user_log_config)
        if vpc_domain is not None:
            pulumi.set(__self__, "vpc_domain", vpc_domain)
        if vpc_intranet_enable is not None:
            pulumi.set(__self__, "vpc_intranet_enable", vpc_intranet_enable)

    @_builtins.property
    @pulumi.getter(name="basePath")
    def base_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base path of the api gateway group. Defaults to `/`.
        """
        return pulumi.get(self, "base_path")

    @base_path.setter
    def base_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_path", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the api gateway group. Defaults to null.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the api gateway.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the api gateway group. Defaults to null.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="subDomain")
    def sub_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available in 1.69.0+)	Second-level domain name automatically assigned to the API group.
        """
        return pulumi.get(self, "sub_domain")

    @sub_domain.setter
    def sub_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_domain", value)

    @_builtins.property
    @pulumi.getter(name="userLogConfig")
    def user_log_config(self) -> Optional[pulumi.Input['GroupUserLogConfigArgs']]:
        """
        user_log_config defines the config of user log of the group. See `user_log_config` below.
        """
        return pulumi.get(self, "user_log_config")

    @user_log_config.setter
    def user_log_config(self, value: Optional[pulumi.Input['GroupUserLogConfigArgs']]):
        pulumi.set(self, "user_log_config", value)

    @_builtins.property
    @pulumi.getter(name="vpcDomain")
    def vpc_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available in 1.69.0+)	Second-level VPC domain name automatically assigned to the API group.
        """
        return pulumi.get(self, "vpc_domain")

    @vpc_domain.setter
    def vpc_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_domain", value)

    @_builtins.property
    @pulumi.getter(name="vpcIntranetEnable")
    def vpc_intranet_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable `vpc_domain`. Defaults to `false`.
        """
        return pulumi.get(self, "vpc_intranet_enable")

    @vpc_intranet_enable.setter
    def vpc_intranet_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vpc_intranet_enable", value)


@pulumi.type_token("alicloud:apigateway/group:Group")
class Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_path: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_log_config: Optional[pulumi.Input[Union['GroupUserLogConfigArgs', 'GroupUserLogConfigArgsDict']]] = None,
                 vpc_intranet_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.apigateway.Group("default",
            name="tf_example",
            description="tf_example",
            base_path="/",
            user_log_config={
                "request_body": True,
                "response_body": True,
                "query_string": "*",
                "request_headers": "*",
                "response_headers": "*",
                "jwt_claims": "*",
            })
        ```

        ## Import

        Api gateway group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:apigateway/group:Group example "ab2351f2ce904edaa8d92a0510832b91"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] base_path: The base path of the api gateway group. Defaults to `/`.
        :param pulumi.Input[_builtins.str] description: The description of the api gateway group. Defaults to null.
        :param pulumi.Input[_builtins.str] instance_id: The id of the api gateway.
        :param pulumi.Input[_builtins.str] name: The name of the api gateway group. Defaults to null.
        :param pulumi.Input[Union['GroupUserLogConfigArgs', 'GroupUserLogConfigArgsDict']] user_log_config: user_log_config defines the config of user log of the group. See `user_log_config` below.
        :param pulumi.Input[_builtins.bool] vpc_intranet_enable: Whether to enable `vpc_domain`. Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[GroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.apigateway.Group("default",
            name="tf_example",
            description="tf_example",
            base_path="/",
            user_log_config={
                "request_body": True,
                "response_body": True,
                "query_string": "*",
                "request_headers": "*",
                "response_headers": "*",
                "jwt_claims": "*",
            })
        ```

        ## Import

        Api gateway group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:apigateway/group:Group example "ab2351f2ce904edaa8d92a0510832b91"
        ```

        :param str resource_name: The name of the resource.
        :param GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_path: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_log_config: Optional[pulumi.Input[Union['GroupUserLogConfigArgs', 'GroupUserLogConfigArgsDict']]] = None,
                 vpc_intranet_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupArgs.__new__(GroupArgs)

            __props__.__dict__["base_path"] = base_path
            __props__.__dict__["description"] = description
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["user_log_config"] = user_log_config
            __props__.__dict__["vpc_intranet_enable"] = vpc_intranet_enable
            __props__.__dict__["sub_domain"] = None
            __props__.__dict__["vpc_domain"] = None
        super(Group, __self__).__init__(
            'alicloud:apigateway/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            base_path: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            sub_domain: Optional[pulumi.Input[_builtins.str]] = None,
            user_log_config: Optional[pulumi.Input[Union['GroupUserLogConfigArgs', 'GroupUserLogConfigArgsDict']]] = None,
            vpc_domain: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_intranet_enable: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Group':
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] base_path: The base path of the api gateway group. Defaults to `/`.
        :param pulumi.Input[_builtins.str] description: The description of the api gateway group. Defaults to null.
        :param pulumi.Input[_builtins.str] instance_id: The id of the api gateway.
        :param pulumi.Input[_builtins.str] name: The name of the api gateway group. Defaults to null.
        :param pulumi.Input[_builtins.str] sub_domain: (Available in 1.69.0+)	Second-level domain name automatically assigned to the API group.
        :param pulumi.Input[Union['GroupUserLogConfigArgs', 'GroupUserLogConfigArgsDict']] user_log_config: user_log_config defines the config of user log of the group. See `user_log_config` below.
        :param pulumi.Input[_builtins.str] vpc_domain: (Available in 1.69.0+)	Second-level VPC domain name automatically assigned to the API group.
        :param pulumi.Input[_builtins.bool] vpc_intranet_enable: Whether to enable `vpc_domain`. Defaults to `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupState.__new__(_GroupState)

        __props__.__dict__["base_path"] = base_path
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["sub_domain"] = sub_domain
        __props__.__dict__["user_log_config"] = user_log_config
        __props__.__dict__["vpc_domain"] = vpc_domain
        __props__.__dict__["vpc_intranet_enable"] = vpc_intranet_enable
        return Group(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="basePath")
    def base_path(self) -> pulumi.Output[_builtins.str]:
        """
        The base path of the api gateway group. Defaults to `/`.
        """
        return pulumi.get(self, "base_path")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the api gateway group. Defaults to null.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the api gateway.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the api gateway group. Defaults to null.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="subDomain")
    def sub_domain(self) -> pulumi.Output[_builtins.str]:
        """
        (Available in 1.69.0+)	Second-level domain name automatically assigned to the API group.
        """
        return pulumi.get(self, "sub_domain")

    @_builtins.property
    @pulumi.getter(name="userLogConfig")
    def user_log_config(self) -> pulumi.Output[Optional['outputs.GroupUserLogConfig']]:
        """
        user_log_config defines the config of user log of the group. See `user_log_config` below.
        """
        return pulumi.get(self, "user_log_config")

    @_builtins.property
    @pulumi.getter(name="vpcDomain")
    def vpc_domain(self) -> pulumi.Output[_builtins.str]:
        """
        (Available in 1.69.0+)	Second-level VPC domain name automatically assigned to the API group.
        """
        return pulumi.get(self, "vpc_domain")

    @_builtins.property
    @pulumi.getter(name="vpcIntranetEnable")
    def vpc_intranet_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable `vpc_domain`. Defaults to `false`.
        """
        return pulumi.get(self, "vpc_intranet_enable")

