# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 bandwidth: pulumi.Input[_builtins.str],
                 description: pulumi.Input[_builtins.str],
                 license_code: pulumi.Input[_builtins.str],
                 plan_code: pulumi.Input[_builtins.str],
                 security_group_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 storage: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 ad_auth_servers: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAdAuthServerArgs']]]] = None,
                 enable_public_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 ldap_auth_servers: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLdapAuthServerArgs']]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 public_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] bandwidth: The bandwidth of Cloud Bastionhost instance.
               If China-Site Account, its valid values: 0 to 150. Unit: Mbit/s. The value must be a multiple of 5.
               If International-Site Account, its valid values: 0 to 200. Unit: Mbit/s. The value must be a multiple of 10.
        :param pulumi.Input[_builtins.str] description: Description of the instance. This name can have a string of 1 to 63 characters.
        :param pulumi.Input[_builtins.str] license_code: The package type of Cloud Bastionhost instance. You can query more supported types through the [DescribePricingModule](https://help.aliyun.com/document_detail/96469.html).
        :param pulumi.Input[_builtins.str] plan_code: The plan code of Cloud Bastionhost instance. Valid values:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: security group IDs configured to Bastionhost. 
               **NOTE:** There is a potential diff error because of the order of `security_group_ids` values indefinite.
               So, from version 1.160.0, `security_group_ids` type has been updated as `set` from `list`,
               and you can use tolist to convert it to a list.
        :param pulumi.Input[_builtins.str] storage: The storage of Cloud Bastionhost instance. Valid values: `0` to `500`. Unit: TB. **NOTE:** From version 1.251.0, `storage` can be modified.
        :param pulumi.Input[_builtins.str] vswitch_id: VSwitch ID configured to Bastionhost.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceAdAuthServerArgs']]] ad_auth_servers: The AD auth server of the Instance. See `ad_auth_server` below.
        :param pulumi.Input[_builtins.bool] enable_public_access: Whether to Enable the public internet access to a specified Bastionhost instance. The valid values: `true`, `false`.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceLdapAuthServerArgs']]] ldap_auth_servers: The LDAP auth server of the Instance. See `ldap_auth_server` below.
        :param pulumi.Input[_builtins.int] period: Duration for initially producing the instance. Valid values: [1~9], 12, 24, 36. At present, the provider does not support modify "period".
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period. Valid values: `1` to `9`, `12`, `24`, `36`. **NOTE:** The `renew_period` is required under the condition that `renewal_status` is `AutoRenewal`. From version 1.193.0, `renew_period` can be modified.
        :param pulumi.Input[_builtins.str] renewal_period_unit: The unit of the auto-renewal period. Valid values:  **NOTE:** The `renewal_period_unit` is required under the condition that `renewal_status` is `AutoRenewal`.
               - `M`: months.
               - `Y`: years.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`. From version 1.193.0, `renewal_status` can be modified.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the Bastionhost Instance belongs. If not set, the resource is created in the default resource group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "license_code", license_code)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "storage", storage)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if ad_auth_servers is not None:
            pulumi.set(__self__, "ad_auth_servers", ad_auth_servers)
        if enable_public_access is not None:
            pulumi.set(__self__, "enable_public_access", enable_public_access)
        if ldap_auth_servers is not None:
            pulumi.set(__self__, "ldap_auth_servers", ldap_auth_servers)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_white_lists is not None:
            pulumi.set(__self__, "public_white_lists", public_white_lists)
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renewal_period_unit is not None:
            pulumi.set(__self__, "renewal_period_unit", renewal_period_unit)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Input[_builtins.str]:
        """
        The bandwidth of Cloud Bastionhost instance.
        If China-Site Account, its valid values: 0 to 150. Unit: Mbit/s. The value must be a multiple of 5.
        If International-Site Account, its valid values: 0 to 200. Unit: Mbit/s. The value must be a multiple of 10.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        Description of the instance. This name can have a string of 1 to 63 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="licenseCode")
    def license_code(self) -> pulumi.Input[_builtins.str]:
        """
        The package type of Cloud Bastionhost instance. You can query more supported types through the [DescribePricingModule](https://help.aliyun.com/document_detail/96469.html).
        """
        return pulumi.get(self, "license_code")

    @license_code.setter
    def license_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "license_code", value)

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> pulumi.Input[_builtins.str]:
        """
        The plan code of Cloud Bastionhost instance. Valid values:
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plan_code", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        security group IDs configured to Bastionhost. 
        **NOTE:** There is a potential diff error because of the order of `security_group_ids` values indefinite.
        So, from version 1.160.0, `security_group_ids` type has been updated as `set` from `list`,
        and you can use tolist to convert it to a list.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def storage(self) -> pulumi.Input[_builtins.str]:
        """
        The storage of Cloud Bastionhost instance. Valid values: `0` to `500`. Unit: TB. **NOTE:** From version 1.251.0, `storage` can be modified.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        VSwitch ID configured to Bastionhost.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="adAuthServers")
    def ad_auth_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAdAuthServerArgs']]]]:
        """
        The AD auth server of the Instance. See `ad_auth_server` below.
        """
        return pulumi.get(self, "ad_auth_servers")

    @ad_auth_servers.setter
    def ad_auth_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAdAuthServerArgs']]]]):
        pulumi.set(self, "ad_auth_servers", value)

    @_builtins.property
    @pulumi.getter(name="enablePublicAccess")
    def enable_public_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to Enable the public internet access to a specified Bastionhost instance. The valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_public_access")

    @enable_public_access.setter
    def enable_public_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_public_access", value)

    @_builtins.property
    @pulumi.getter(name="ldapAuthServers")
    def ldap_auth_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLdapAuthServerArgs']]]]:
        """
        The LDAP auth server of the Instance. See `ldap_auth_server` below.
        """
        return pulumi.get(self, "ldap_auth_servers")

    @ldap_auth_servers.setter
    def ldap_auth_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLdapAuthServerArgs']]]]):
        pulumi.set(self, "ldap_auth_servers", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration for initially producing the instance. Valid values: [1~9], 12, 24, 36. At present, the provider does not support modify "period".
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="publicWhiteLists")
    def public_white_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "public_white_lists")

    @public_white_lists.setter
    def public_white_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "public_white_lists", value)

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Automatic renewal period. Valid values: `1` to `9`, `12`, `24`, `36`. **NOTE:** The `renew_period` is required under the condition that `renewal_status` is `AutoRenewal`. From version 1.193.0, `renew_period` can be modified.
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_period", value)

    @_builtins.property
    @pulumi.getter(name="renewalPeriodUnit")
    def renewal_period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of the auto-renewal period. Valid values:  **NOTE:** The `renewal_period_unit` is required under the condition that `renewal_status` is `AutoRenewal`.
        - `M`: months.
        - `Y`: years.
        """
        return pulumi.get(self, "renewal_period_unit")

    @renewal_period_unit.setter
    def renewal_period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_period_unit", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`. From version 1.193.0, `renewal_status` can be modified.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of resource group which the Bastionhost Instance belongs. If not set, the resource is created in the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 ad_auth_servers: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAdAuthServerArgs']]]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_public_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 ldap_auth_servers: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLdapAuthServerArgs']]]] = None,
                 license_code: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_code: Optional[pulumi.Input[_builtins.str]] = None,
                 public_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 storage: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceAdAuthServerArgs']]] ad_auth_servers: The AD auth server of the Instance. See `ad_auth_server` below.
        :param pulumi.Input[_builtins.str] bandwidth: The bandwidth of Cloud Bastionhost instance.
               If China-Site Account, its valid values: 0 to 150. Unit: Mbit/s. The value must be a multiple of 5.
               If International-Site Account, its valid values: 0 to 200. Unit: Mbit/s. The value must be a multiple of 10.
        :param pulumi.Input[_builtins.str] description: Description of the instance. This name can have a string of 1 to 63 characters.
        :param pulumi.Input[_builtins.bool] enable_public_access: Whether to Enable the public internet access to a specified Bastionhost instance. The valid values: `true`, `false`.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceLdapAuthServerArgs']]] ldap_auth_servers: The LDAP auth server of the Instance. See `ldap_auth_server` below.
        :param pulumi.Input[_builtins.str] license_code: The package type of Cloud Bastionhost instance. You can query more supported types through the [DescribePricingModule](https://help.aliyun.com/document_detail/96469.html).
        :param pulumi.Input[_builtins.int] period: Duration for initially producing the instance. Valid values: [1~9], 12, 24, 36. At present, the provider does not support modify "period".
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] plan_code: The plan code of Cloud Bastionhost instance. Valid values:
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period. Valid values: `1` to `9`, `12`, `24`, `36`. **NOTE:** The `renew_period` is required under the condition that `renewal_status` is `AutoRenewal`. From version 1.193.0, `renew_period` can be modified.
        :param pulumi.Input[_builtins.str] renewal_period_unit: The unit of the auto-renewal period. Valid values:  **NOTE:** The `renewal_period_unit` is required under the condition that `renewal_status` is `AutoRenewal`.
               - `M`: months.
               - `Y`: years.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`. From version 1.193.0, `renewal_status` can be modified.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the Bastionhost Instance belongs. If not set, the resource is created in the default resource group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: security group IDs configured to Bastionhost. 
               **NOTE:** There is a potential diff error because of the order of `security_group_ids` values indefinite.
               So, from version 1.160.0, `security_group_ids` type has been updated as `set` from `list`,
               and you can use tolist to convert it to a list.
        :param pulumi.Input[_builtins.str] storage: The storage of Cloud Bastionhost instance. Valid values: `0` to `500`. Unit: TB. **NOTE:** From version 1.251.0, `storage` can be modified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: VSwitch ID configured to Bastionhost.
        """
        if ad_auth_servers is not None:
            pulumi.set(__self__, "ad_auth_servers", ad_auth_servers)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_public_access is not None:
            pulumi.set(__self__, "enable_public_access", enable_public_access)
        if ldap_auth_servers is not None:
            pulumi.set(__self__, "ldap_auth_servers", ldap_auth_servers)
        if license_code is not None:
            pulumi.set(__self__, "license_code", license_code)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if plan_code is not None:
            pulumi.set(__self__, "plan_code", plan_code)
        if public_white_lists is not None:
            pulumi.set(__self__, "public_white_lists", public_white_lists)
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renewal_period_unit is not None:
            pulumi.set(__self__, "renewal_period_unit", renewal_period_unit)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="adAuthServers")
    def ad_auth_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAdAuthServerArgs']]]]:
        """
        The AD auth server of the Instance. See `ad_auth_server` below.
        """
        return pulumi.get(self, "ad_auth_servers")

    @ad_auth_servers.setter
    def ad_auth_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAdAuthServerArgs']]]]):
        pulumi.set(self, "ad_auth_servers", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bandwidth of Cloud Bastionhost instance.
        If China-Site Account, its valid values: 0 to 150. Unit: Mbit/s. The value must be a multiple of 5.
        If International-Site Account, its valid values: 0 to 200. Unit: Mbit/s. The value must be a multiple of 10.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the instance. This name can have a string of 1 to 63 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enablePublicAccess")
    def enable_public_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to Enable the public internet access to a specified Bastionhost instance. The valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_public_access")

    @enable_public_access.setter
    def enable_public_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_public_access", value)

    @_builtins.property
    @pulumi.getter(name="ldapAuthServers")
    def ldap_auth_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLdapAuthServerArgs']]]]:
        """
        The LDAP auth server of the Instance. See `ldap_auth_server` below.
        """
        return pulumi.get(self, "ldap_auth_servers")

    @ldap_auth_servers.setter
    def ldap_auth_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLdapAuthServerArgs']]]]):
        pulumi.set(self, "ldap_auth_servers", value)

    @_builtins.property
    @pulumi.getter(name="licenseCode")
    def license_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The package type of Cloud Bastionhost instance. You can query more supported types through the [DescribePricingModule](https://help.aliyun.com/document_detail/96469.html).
        """
        return pulumi.get(self, "license_code")

    @license_code.setter
    def license_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_code", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Duration for initially producing the instance. Valid values: [1~9], 12, 24, 36. At present, the provider does not support modify "period".
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The plan code of Cloud Bastionhost instance. Valid values:
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_code", value)

    @_builtins.property
    @pulumi.getter(name="publicWhiteLists")
    def public_white_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "public_white_lists")

    @public_white_lists.setter
    def public_white_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "public_white_lists", value)

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Automatic renewal period. Valid values: `1` to `9`, `12`, `24`, `36`. **NOTE:** The `renew_period` is required under the condition that `renewal_status` is `AutoRenewal`. From version 1.193.0, `renew_period` can be modified.
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_period", value)

    @_builtins.property
    @pulumi.getter(name="renewalPeriodUnit")
    def renewal_period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of the auto-renewal period. Valid values:  **NOTE:** The `renewal_period_unit` is required under the condition that `renewal_status` is `AutoRenewal`.
        - `M`: months.
        - `Y`: years.
        """
        return pulumi.get(self, "renewal_period_unit")

    @renewal_period_unit.setter
    def renewal_period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_period_unit", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`. From version 1.193.0, `renewal_status` can be modified.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of resource group which the Bastionhost Instance belongs. If not set, the resource is created in the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        security group IDs configured to Bastionhost. 
        **NOTE:** There is a potential diff error because of the order of `security_group_ids` values indefinite.
        So, from version 1.160.0, `security_group_ids` type has been updated as `set` from `list`,
        and you can use tolist to convert it to a list.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage of Cloud Bastionhost instance. Valid values: `0` to `500`. Unit: TB. **NOTE:** From version 1.251.0, `storage` can be modified.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VSwitch ID configured to Bastionhost.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:bastionhost/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ad_auth_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceAdAuthServerArgs', 'InstanceAdAuthServerArgsDict']]]]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_public_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 ldap_auth_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceLdapAuthServerArgs', 'InstanceLdapAuthServerArgsDict']]]]] = None,
                 license_code: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_code: Optional[pulumi.Input[_builtins.str]] = None,
                 public_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 storage: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Yundun_bastionhost instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:bastionhost/instance:Instance example bastionhost-exampe123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceAdAuthServerArgs', 'InstanceAdAuthServerArgsDict']]]] ad_auth_servers: The AD auth server of the Instance. See `ad_auth_server` below.
        :param pulumi.Input[_builtins.str] bandwidth: The bandwidth of Cloud Bastionhost instance.
               If China-Site Account, its valid values: 0 to 150. Unit: Mbit/s. The value must be a multiple of 5.
               If International-Site Account, its valid values: 0 to 200. Unit: Mbit/s. The value must be a multiple of 10.
        :param pulumi.Input[_builtins.str] description: Description of the instance. This name can have a string of 1 to 63 characters.
        :param pulumi.Input[_builtins.bool] enable_public_access: Whether to Enable the public internet access to a specified Bastionhost instance. The valid values: `true`, `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceLdapAuthServerArgs', 'InstanceLdapAuthServerArgsDict']]]] ldap_auth_servers: The LDAP auth server of the Instance. See `ldap_auth_server` below.
        :param pulumi.Input[_builtins.str] license_code: The package type of Cloud Bastionhost instance. You can query more supported types through the [DescribePricingModule](https://help.aliyun.com/document_detail/96469.html).
        :param pulumi.Input[_builtins.int] period: Duration for initially producing the instance. Valid values: [1~9], 12, 24, 36. At present, the provider does not support modify "period".
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] plan_code: The plan code of Cloud Bastionhost instance. Valid values:
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period. Valid values: `1` to `9`, `12`, `24`, `36`. **NOTE:** The `renew_period` is required under the condition that `renewal_status` is `AutoRenewal`. From version 1.193.0, `renew_period` can be modified.
        :param pulumi.Input[_builtins.str] renewal_period_unit: The unit of the auto-renewal period. Valid values:  **NOTE:** The `renewal_period_unit` is required under the condition that `renewal_status` is `AutoRenewal`.
               - `M`: months.
               - `Y`: years.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`. From version 1.193.0, `renewal_status` can be modified.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the Bastionhost Instance belongs. If not set, the resource is created in the default resource group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: security group IDs configured to Bastionhost. 
               **NOTE:** There is a potential diff error because of the order of `security_group_ids` values indefinite.
               So, from version 1.160.0, `security_group_ids` type has been updated as `set` from `list`,
               and you can use tolist to convert it to a list.
        :param pulumi.Input[_builtins.str] storage: The storage of Cloud Bastionhost instance. Valid values: `0` to `500`. Unit: TB. **NOTE:** From version 1.251.0, `storage` can be modified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: VSwitch ID configured to Bastionhost.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Yundun_bastionhost instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:bastionhost/instance:Instance example bastionhost-exampe123456
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ad_auth_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceAdAuthServerArgs', 'InstanceAdAuthServerArgsDict']]]]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_public_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 ldap_auth_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceLdapAuthServerArgs', 'InstanceLdapAuthServerArgsDict']]]]] = None,
                 license_code: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 plan_code: Optional[pulumi.Input[_builtins.str]] = None,
                 public_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 storage: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["ad_auth_servers"] = ad_auth_servers
            if bandwidth is None and not opts.urn:
                raise TypeError("Missing required property 'bandwidth'")
            __props__.__dict__["bandwidth"] = bandwidth
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_public_access"] = enable_public_access
            __props__.__dict__["ldap_auth_servers"] = ldap_auth_servers
            if license_code is None and not opts.urn:
                raise TypeError("Missing required property 'license_code'")
            __props__.__dict__["license_code"] = license_code
            __props__.__dict__["period"] = period
            if plan_code is None and not opts.urn:
                raise TypeError("Missing required property 'plan_code'")
            __props__.__dict__["plan_code"] = plan_code
            __props__.__dict__["public_white_lists"] = public_white_lists
            __props__.__dict__["renew_period"] = renew_period
            __props__.__dict__["renewal_period_unit"] = renewal_period_unit
            __props__.__dict__["renewal_status"] = renewal_status
            __props__.__dict__["resource_group_id"] = resource_group_id
            if security_group_ids is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_ids'")
            __props__.__dict__["security_group_ids"] = security_group_ids
            if storage is None and not opts.urn:
                raise TypeError("Missing required property 'storage'")
            __props__.__dict__["storage"] = storage
            __props__.__dict__["tags"] = tags
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
        super(Instance, __self__).__init__(
            'alicloud:bastionhost/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ad_auth_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceAdAuthServerArgs', 'InstanceAdAuthServerArgsDict']]]]] = None,
            bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enable_public_access: Optional[pulumi.Input[_builtins.bool]] = None,
            ldap_auth_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceLdapAuthServerArgs', 'InstanceLdapAuthServerArgsDict']]]]] = None,
            license_code: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            plan_code: Optional[pulumi.Input[_builtins.str]] = None,
            public_white_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            renew_period: Optional[pulumi.Input[_builtins.int]] = None,
            renewal_period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            storage: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceAdAuthServerArgs', 'InstanceAdAuthServerArgsDict']]]] ad_auth_servers: The AD auth server of the Instance. See `ad_auth_server` below.
        :param pulumi.Input[_builtins.str] bandwidth: The bandwidth of Cloud Bastionhost instance.
               If China-Site Account, its valid values: 0 to 150. Unit: Mbit/s. The value must be a multiple of 5.
               If International-Site Account, its valid values: 0 to 200. Unit: Mbit/s. The value must be a multiple of 10.
        :param pulumi.Input[_builtins.str] description: Description of the instance. This name can have a string of 1 to 63 characters.
        :param pulumi.Input[_builtins.bool] enable_public_access: Whether to Enable the public internet access to a specified Bastionhost instance. The valid values: `true`, `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceLdapAuthServerArgs', 'InstanceLdapAuthServerArgsDict']]]] ldap_auth_servers: The LDAP auth server of the Instance. See `ldap_auth_server` below.
        :param pulumi.Input[_builtins.str] license_code: The package type of Cloud Bastionhost instance. You can query more supported types through the [DescribePricingModule](https://help.aliyun.com/document_detail/96469.html).
        :param pulumi.Input[_builtins.int] period: Duration for initially producing the instance. Valid values: [1~9], 12, 24, 36. At present, the provider does not support modify "period".
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] plan_code: The plan code of Cloud Bastionhost instance. Valid values:
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period. Valid values: `1` to `9`, `12`, `24`, `36`. **NOTE:** The `renew_period` is required under the condition that `renewal_status` is `AutoRenewal`. From version 1.193.0, `renew_period` can be modified.
        :param pulumi.Input[_builtins.str] renewal_period_unit: The unit of the auto-renewal period. Valid values:  **NOTE:** The `renewal_period_unit` is required under the condition that `renewal_status` is `AutoRenewal`.
               - `M`: months.
               - `Y`: years.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`. From version 1.193.0, `renewal_status` can be modified.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the Bastionhost Instance belongs. If not set, the resource is created in the default resource group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: security group IDs configured to Bastionhost. 
               **NOTE:** There is a potential diff error because of the order of `security_group_ids` values indefinite.
               So, from version 1.160.0, `security_group_ids` type has been updated as `set` from `list`,
               and you can use tolist to convert it to a list.
        :param pulumi.Input[_builtins.str] storage: The storage of Cloud Bastionhost instance. Valid values: `0` to `500`. Unit: TB. **NOTE:** From version 1.251.0, `storage` can be modified.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: VSwitch ID configured to Bastionhost.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["ad_auth_servers"] = ad_auth_servers
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_public_access"] = enable_public_access
        __props__.__dict__["ldap_auth_servers"] = ldap_auth_servers
        __props__.__dict__["license_code"] = license_code
        __props__.__dict__["period"] = period
        __props__.__dict__["plan_code"] = plan_code
        __props__.__dict__["public_white_lists"] = public_white_lists
        __props__.__dict__["renew_period"] = renew_period
        __props__.__dict__["renewal_period_unit"] = renewal_period_unit
        __props__.__dict__["renewal_status"] = renewal_status
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["storage"] = storage
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vswitch_id"] = vswitch_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adAuthServers")
    def ad_auth_servers(self) -> pulumi.Output[Sequence['outputs.InstanceAdAuthServer']]:
        """
        The AD auth server of the Instance. See `ad_auth_server` below.
        """
        return pulumi.get(self, "ad_auth_servers")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[_builtins.str]:
        """
        The bandwidth of Cloud Bastionhost instance.
        If China-Site Account, its valid values: 0 to 150. Unit: Mbit/s. The value must be a multiple of 5.
        If International-Site Account, its valid values: 0 to 200. Unit: Mbit/s. The value must be a multiple of 10.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the instance. This name can have a string of 1 to 63 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enablePublicAccess")
    def enable_public_access(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to Enable the public internet access to a specified Bastionhost instance. The valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_public_access")

    @_builtins.property
    @pulumi.getter(name="ldapAuthServers")
    def ldap_auth_servers(self) -> pulumi.Output[Sequence['outputs.InstanceLdapAuthServer']]:
        """
        The LDAP auth server of the Instance. See `ldap_auth_server` below.
        """
        return pulumi.get(self, "ldap_auth_servers")

    @_builtins.property
    @pulumi.getter(name="licenseCode")
    def license_code(self) -> pulumi.Output[_builtins.str]:
        """
        The package type of Cloud Bastionhost instance. You can query more supported types through the [DescribePricingModule](https://help.aliyun.com/document_detail/96469.html).
        """
        return pulumi.get(self, "license_code")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Duration for initially producing the instance. Valid values: [1~9], 12, 24, 36. At present, the provider does not support modify "period".
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> pulumi.Output[_builtins.str]:
        """
        The plan code of Cloud Bastionhost instance. Valid values:
        """
        return pulumi.get(self, "plan_code")

    @_builtins.property
    @pulumi.getter(name="publicWhiteLists")
    def public_white_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "public_white_lists")

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Automatic renewal period. Valid values: `1` to `9`, `12`, `24`, `36`. **NOTE:** The `renew_period` is required under the condition that `renewal_status` is `AutoRenewal`. From version 1.193.0, `renew_period` can be modified.
        """
        return pulumi.get(self, "renew_period")

    @_builtins.property
    @pulumi.getter(name="renewalPeriodUnit")
    def renewal_period_unit(self) -> pulumi.Output[_builtins.str]:
        """
        The unit of the auto-renewal period. Valid values:  **NOTE:** The `renewal_period_unit` is required under the condition that `renewal_status` is `AutoRenewal`.
        - `M`: months.
        - `Y`: years.
        """
        return pulumi.get(self, "renewal_period_unit")

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> pulumi.Output[_builtins.str]:
        """
        Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`. From version 1.193.0, `renewal_status` can be modified.
        """
        return pulumi.get(self, "renewal_status")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Id of resource group which the Bastionhost Instance belongs. If not set, the resource is created in the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        security group IDs configured to Bastionhost. 
        **NOTE:** There is a potential diff error because of the order of `security_group_ids` values indefinite.
        So, from version 1.160.0, `security_group_ids` type has been updated as `set` from `list`,
        and you can use tolist to convert it to a list.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> pulumi.Output[_builtins.str]:
        """
        The storage of Cloud Bastionhost instance. Valid values: `0` to `500`. Unit: TB. **NOTE:** From version 1.251.0, `storage` can be modified.
        """
        return pulumi.get(self, "storage")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        VSwitch ID configured to Bastionhost.
        """
        return pulumi.get(self, "vswitch_id")

