# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOpenApiPricingModulesResult',
    'AwaitableGetOpenApiPricingModulesResult',
    'get_open_api_pricing_modules',
    'get_open_api_pricing_modules_output',
]

@pulumi.output_type
class GetOpenApiPricingModulesResult:
    """
    A collection of values returned by getOpenApiPricingModules.
    """
    def __init__(__self__, id=None, ids=None, modules=None, name_regex=None, names=None, output_file=None, product_code=None, product_type=None, subscription_type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if modules and not isinstance(modules, list):
            raise TypeError("Expected argument 'modules' to be a list")
        pulumi.set(__self__, "modules", modules)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if product_code and not isinstance(product_code, str):
            raise TypeError("Expected argument 'product_code' to be a str")
        pulumi.set(__self__, "product_code", product_code)
        if product_type and not isinstance(product_type, str):
            raise TypeError("Expected argument 'product_type' to be a str")
        pulumi.set(__self__, "product_type", product_type)
        if subscription_type and not isinstance(subscription_type, str):
            raise TypeError("Expected argument 'subscription_type' to be a str")
        pulumi.set(__self__, "subscription_type", subscription_type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def modules(self) -> Sequence['outputs.GetOpenApiPricingModulesModuleResult']:
        """
        A list of Pricing Module Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "modules")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of name of Pricing Modules.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="productCode")
    def product_code(self) -> _builtins.str:
        return pulumi.get(self, "product_code")

    @_builtins.property
    @pulumi.getter(name="productType")
    def product_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "product_type")

    @_builtins.property
    @pulumi.getter(name="subscriptionType")
    def subscription_type(self) -> _builtins.str:
        return pulumi.get(self, "subscription_type")


class AwaitableGetOpenApiPricingModulesResult(GetOpenApiPricingModulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOpenApiPricingModulesResult(
            id=self.id,
            ids=self.ids,
            modules=self.modules,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            product_code=self.product_code,
            product_type=self.product_type,
            subscription_type=self.subscription_type)


def get_open_api_pricing_modules(ids: Optional[Sequence[_builtins.str]] = None,
                                 name_regex: Optional[_builtins.str] = None,
                                 output_file: Optional[_builtins.str] = None,
                                 product_code: Optional[_builtins.str] = None,
                                 product_type: Optional[_builtins.str] = None,
                                 subscription_type: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOpenApiPricingModulesResult:
    """
    This data source provides Bss Open Api Pricing Module available to the user.[What is Pricing Module](https://www.alibabacloud.com/help/en/boa/latest/api-bssopenapi-2017-12-14-describepricingmodule)

    > **NOTE:** Available since v1.195.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.bss.get_open_api_pricing_modules(name_regex="国内月均日峰值带宽",
        product_code="cdn",
        product_type="CDN",
        subscription_type="PayAsYouGo")
    pulumi.export("alicloudBssOpenapiPricingModuleExampleId", default.modules[0].code)
    ```


    :param _builtins.str name_regex: A regex string to filter results by Property name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str product_code: The product code.
    :param _builtins.str product_type: The product type.
    :param _builtins.str subscription_type: Subscription type. Value:
           * Subscription: Prepaid.
           * PayAsYouGo: postpaid.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['productCode'] = product_code
    __args__['productType'] = product_type
    __args__['subscriptionType'] = subscription_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:bss/getOpenApiPricingModules:getOpenApiPricingModules', __args__, opts=opts, typ=GetOpenApiPricingModulesResult).value

    return AwaitableGetOpenApiPricingModulesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        modules=pulumi.get(__ret__, 'modules'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        product_code=pulumi.get(__ret__, 'product_code'),
        product_type=pulumi.get(__ret__, 'product_type'),
        subscription_type=pulumi.get(__ret__, 'subscription_type'))
def get_open_api_pricing_modules_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                        name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        product_code: Optional[pulumi.Input[_builtins.str]] = None,
                                        product_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        subscription_type: Optional[pulumi.Input[_builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOpenApiPricingModulesResult]:
    """
    This data source provides Bss Open Api Pricing Module available to the user.[What is Pricing Module](https://www.alibabacloud.com/help/en/boa/latest/api-bssopenapi-2017-12-14-describepricingmodule)

    > **NOTE:** Available since v1.195.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.bss.get_open_api_pricing_modules(name_regex="国内月均日峰值带宽",
        product_code="cdn",
        product_type="CDN",
        subscription_type="PayAsYouGo")
    pulumi.export("alicloudBssOpenapiPricingModuleExampleId", default.modules[0].code)
    ```


    :param _builtins.str name_regex: A regex string to filter results by Property name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str product_code: The product code.
    :param _builtins.str product_type: The product type.
    :param _builtins.str subscription_type: Subscription type. Value:
           * Subscription: Prepaid.
           * PayAsYouGo: postpaid.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['productCode'] = product_code
    __args__['productType'] = product_type
    __args__['subscriptionType'] = subscription_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:bss/getOpenApiPricingModules:getOpenApiPricingModules', __args__, opts=opts, typ=GetOpenApiPricingModulesResult)
    return __ret__.apply(lambda __response__: GetOpenApiPricingModulesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        modules=pulumi.get(__response__, 'modules'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        product_code=pulumi.get(__response__, 'product_code'),
        product_type=pulumi.get(__response__, 'product_type'),
        subscription_type=pulumi.get(__response__, 'subscription_type')))
