# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBandwidthLimitsResult',
    'AwaitableGetBandwidthLimitsResult',
    'get_bandwidth_limits',
    'get_bandwidth_limits_output',
]

@pulumi.output_type
class GetBandwidthLimitsResult:
    """
    A collection of values returned by getBandwidthLimits.
    """
    def __init__(__self__, id=None, instance_ids=None, limits=None, output_file=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_ids and not isinstance(instance_ids, list):
            raise TypeError("Expected argument 'instance_ids' to be a list")
        pulumi.set(__self__, "instance_ids", instance_ids)
        if limits and not isinstance(limits, list):
            raise TypeError("Expected argument 'limits' to be a list")
        pulumi.set(__self__, "limits", limits)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "instance_ids")

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Sequence['outputs.GetBandwidthLimitsLimitResult']:
        """
        A list of CEN Bandwidth Limits. Each element contains the following attributes:
        """
        return pulumi.get(self, "limits")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetBandwidthLimitsResult(GetBandwidthLimitsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBandwidthLimitsResult(
            id=self.id,
            instance_ids=self.instance_ids,
            limits=self.limits,
            output_file=self.output_file)


def get_bandwidth_limits(instance_ids: Optional[Sequence[_builtins.str]] = None,
                         output_file: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBandwidthLimitsResult:
    """
    This data source provides CEN Bandwidth Limits available to the user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    bwl = alicloud.cen.get_bandwidth_limits(instance_ids=["cen-id1"])
    pulumi.export("firstCenBandwidthLimitsLocalRegionId", bwl.limits[0].local_region_id)
    ```


    :param Sequence[_builtins.str] instance_ids: A list of CEN instances IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['instanceIds'] = instance_ids
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cen/getBandwidthLimits:getBandwidthLimits', __args__, opts=opts, typ=GetBandwidthLimitsResult).value

    return AwaitableGetBandwidthLimitsResult(
        id=pulumi.get(__ret__, 'id'),
        instance_ids=pulumi.get(__ret__, 'instance_ids'),
        limits=pulumi.get(__ret__, 'limits'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_bandwidth_limits_output(instance_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBandwidthLimitsResult]:
    """
    This data source provides CEN Bandwidth Limits available to the user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    bwl = alicloud.cen.get_bandwidth_limits(instance_ids=["cen-id1"])
    pulumi.export("firstCenBandwidthLimitsLocalRegionId", bwl.limits[0].local_region_id)
    ```


    :param Sequence[_builtins.str] instance_ids: A list of CEN instances IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['instanceIds'] = instance_ids
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cen/getBandwidthLimits:getBandwidthLimits', __args__, opts=opts, typ=GetBandwidthLimitsResult)
    return __ret__.apply(lambda __response__: GetBandwidthLimitsResult(
        id=pulumi.get(__response__, 'id'),
        instance_ids=pulumi.get(__response__, 'instance_ids'),
        limits=pulumi.get(__response__, 'limits'),
        output_file=pulumi.get(__response__, 'output_file')))
