# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TransitRouterPeerAttachmentArgs', 'TransitRouterPeerAttachment']

@pulumi.input_type
class TransitRouterPeerAttachmentArgs:
    def __init__(__self__, *,
                 peer_transit_router_id: pulumi.Input[_builtins.str],
                 auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 bandwidth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 peer_transit_router_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_association_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_peer_attachment_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TransitRouterPeerAttachment resource.
        :param pulumi.Input[_builtins.str] peer_transit_router_id: The ID of the peer transit router.
        :param pulumi.Input[_builtins.bool] auto_publish_route_enabled: Specifies whether to enable the local Enterprise Edition transit router to automatically advertise the routes of the inter-region connection to the peer transit router. Valid values:
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth value of the inter-region connection. Unit: Mbit/s.
               
               - This parameter specifies the maximum bandwidth value for the inter-region connection if you set `BandwidthType` to `BandwidthPackage`.
               - This parameter specifies the bandwidth throttling threshold for the inter-region connection if you set `BandwidthType` to `DataTransfer`.
        :param pulumi.Input[_builtins.str] bandwidth_type: The method that is used to allocate bandwidth to the inter-region connection. Valid values:
               
               - `BandwidthPackage`: allocates bandwidth from a bandwidth plan.
               - `DataTransfer`: bandwidth is billed based on the pay-by-data-transfer metering method.
        :param pulumi.Input[_builtins.str] cen_bandwidth_package_id: The ID of the bandwidth plan that is used to allocate bandwidth to the inter-region connection.
               
               > **NOTE:**   If you set `BandwidthType` to `DataTransfer`, you do not need to set this parameter.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param pulumi.Input[_builtins.str] default_link_type: The default line type.
               Valid values: Platinum and Gold.
               Platinum is supported only when BandwidthType is set to DataTransfer.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        :param pulumi.Input[_builtins.str] peer_transit_router_region_id: The ID of the region where the peer transit router is deployed.
        :param pulumi.Input[_builtins.str] resource_type: The resource type to attachment. Only support `VR` and default value is `VR`.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.bool] route_table_association_enabled: Field `route_table_association_enabled` has been deprecated from provider version 1.230.0.
        :param pulumi.Input[_builtins.bool] route_table_propagation_enabled: Field `route_table_propagation_enabled` has been deprecated from provider version 1.230.0.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transit_router_attachment_description: The new description of the inter-region connection.
               This parameter is optional. If you enter a description, it must be 1 to 256 characters in length, and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] transit_router_attachment_name: . Field 'transit_router_attachment_name' has been deprecated from provider version 1.247.0. New field 'transit_router_peer_attachment_name' instead.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the local Enterprise Edition transit router.
        :param pulumi.Input[_builtins.str] transit_router_peer_attachment_name: The new name of the inter-region connection.
               The name can be empty or 1 to 128 characters in length, and cannot start with http:// or https://.
        """
        pulumi.set(__self__, "peer_transit_router_id", peer_transit_router_id)
        if auto_publish_route_enabled is not None:
            pulumi.set(__self__, "auto_publish_route_enabled", auto_publish_route_enabled)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if bandwidth_type is not None:
            pulumi.set(__self__, "bandwidth_type", bandwidth_type)
        if cen_bandwidth_package_id is not None:
            pulumi.set(__self__, "cen_bandwidth_package_id", cen_bandwidth_package_id)
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if default_link_type is not None:
            pulumi.set(__self__, "default_link_type", default_link_type)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if peer_transit_router_region_id is not None:
            pulumi.set(__self__, "peer_transit_router_region_id", peer_transit_router_region_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if route_table_association_enabled is not None:
            warnings.warn("""Field `route_table_association_enabled` has been deprecated from provider version 1.230.0.""", DeprecationWarning)
            pulumi.log.warn("""route_table_association_enabled is deprecated: Field `route_table_association_enabled` has been deprecated from provider version 1.230.0.""")
        if route_table_association_enabled is not None:
            pulumi.set(__self__, "route_table_association_enabled", route_table_association_enabled)
        if route_table_propagation_enabled is not None:
            warnings.warn("""Field `route_table_propagation_enabled` has been deprecated from provider version 1.230.0.""", DeprecationWarning)
            pulumi.log.warn("""route_table_propagation_enabled is deprecated: Field `route_table_propagation_enabled` has been deprecated from provider version 1.230.0.""")
        if route_table_propagation_enabled is not None:
            pulumi.set(__self__, "route_table_propagation_enabled", route_table_propagation_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_router_attachment_description is not None:
            pulumi.set(__self__, "transit_router_attachment_description", transit_router_attachment_description)
        if transit_router_attachment_name is not None:
            warnings.warn("""Field 'transit_router_attachment_name' has been deprecated since provider version 1.247.0. New field 'transit_router_peer_attachment_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""transit_router_attachment_name is deprecated: Field 'transit_router_attachment_name' has been deprecated since provider version 1.247.0. New field 'transit_router_peer_attachment_name' instead.""")
        if transit_router_attachment_name is not None:
            pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)
        if transit_router_peer_attachment_name is not None:
            pulumi.set(__self__, "transit_router_peer_attachment_name", transit_router_peer_attachment_name)

    @_builtins.property
    @pulumi.getter(name="peerTransitRouterId")
    def peer_transit_router_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_id")

    @peer_transit_router_id.setter
    def peer_transit_router_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "peer_transit_router_id", value)

    @_builtins.property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the local Enterprise Edition transit router to automatically advertise the routes of the inter-region connection to the peer transit router. Valid values:
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @auto_publish_route_enabled.setter
    def auto_publish_route_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_publish_route_enabled", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth value of the inter-region connection. Unit: Mbit/s.

        - This parameter specifies the maximum bandwidth value for the inter-region connection if you set `BandwidthType` to `BandwidthPackage`.
        - This parameter specifies the bandwidth throttling threshold for the inter-region connection if you set `BandwidthType` to `DataTransfer`.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthType")
    def bandwidth_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method that is used to allocate bandwidth to the inter-region connection. Valid values:

        - `BandwidthPackage`: allocates bandwidth from a bandwidth plan.
        - `DataTransfer`: bandwidth is billed based on the pay-by-data-transfer metering method.
        """
        return pulumi.get(self, "bandwidth_type")

    @bandwidth_type.setter
    def bandwidth_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_type", value)

    @_builtins.property
    @pulumi.getter(name="cenBandwidthPackageId")
    def cen_bandwidth_package_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the bandwidth plan that is used to allocate bandwidth to the inter-region connection.

        > **NOTE:**   If you set `BandwidthType` to `DataTransfer`, you do not need to set this parameter.
        """
        return pulumi.get(self, "cen_bandwidth_package_id")

    @cen_bandwidth_package_id.setter
    def cen_bandwidth_package_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_bandwidth_package_id", value)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Cloud Enterprise Network (CEN) instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultLinkType")
    def default_link_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default line type.
        Valid values: Platinum and Gold.
        Platinum is supported only when BandwidthType is set to DataTransfer.
        """
        return pulumi.get(self, "default_link_type")

    @default_link_type.setter
    def default_link_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_link_type", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="peerTransitRouterRegionId")
    def peer_transit_router_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region where the peer transit router is deployed.
        """
        return pulumi.get(self, "peer_transit_router_region_id")

    @peer_transit_router_region_id.setter
    def peer_transit_router_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_transit_router_region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource type to attachment. Only support `VR` and default value is `VR`.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter(name="routeTableAssociationEnabled")
    @_utilities.deprecated("""Field `route_table_association_enabled` has been deprecated from provider version 1.230.0.""")
    def route_table_association_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Field `route_table_association_enabled` has been deprecated from provider version 1.230.0.
        """
        return pulumi.get(self, "route_table_association_enabled")

    @route_table_association_enabled.setter
    def route_table_association_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "route_table_association_enabled", value)

    @_builtins.property
    @pulumi.getter(name="routeTablePropagationEnabled")
    @_utilities.deprecated("""Field `route_table_propagation_enabled` has been deprecated from provider version 1.230.0.""")
    def route_table_propagation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Field `route_table_propagation_enabled` has been deprecated from provider version 1.230.0.
        """
        return pulumi.get(self, "route_table_propagation_enabled")

    @route_table_propagation_enabled.setter
    def route_table_propagation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "route_table_propagation_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new description of the inter-region connection.
        This parameter is optional. If you enter a description, it must be 1 to 256 characters in length, and cannot start with http:// or https://.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @transit_router_attachment_description.setter
    def transit_router_attachment_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_description", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentName")
    @_utilities.deprecated("""Field 'transit_router_attachment_name' has been deprecated since provider version 1.247.0. New field 'transit_router_peer_attachment_name' instead.""")
    def transit_router_attachment_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'transit_router_attachment_name' has been deprecated from provider version 1.247.0. New field 'transit_router_peer_attachment_name' instead.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @transit_router_attachment_name.setter
    def transit_router_attachment_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_name", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the local Enterprise Edition transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_id", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterPeerAttachmentName")
    def transit_router_peer_attachment_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new name of the inter-region connection.
        The name can be empty or 1 to 128 characters in length, and cannot start with http:// or https://.
        """
        return pulumi.get(self, "transit_router_peer_attachment_name")

    @transit_router_peer_attachment_name.setter
    def transit_router_peer_attachment_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_peer_attachment_name", value)


@pulumi.input_type
class _TransitRouterPeerAttachmentState:
    def __init__(__self__, *,
                 auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 bandwidth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 default_link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 peer_transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_transit_router_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_association_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_peer_attachment_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TransitRouterPeerAttachment resources.
        :param pulumi.Input[_builtins.bool] auto_publish_route_enabled: Specifies whether to enable the local Enterprise Edition transit router to automatically advertise the routes of the inter-region connection to the peer transit router. Valid values:
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth value of the inter-region connection. Unit: Mbit/s.
               
               - This parameter specifies the maximum bandwidth value for the inter-region connection if you set `BandwidthType` to `BandwidthPackage`.
               - This parameter specifies the bandwidth throttling threshold for the inter-region connection if you set `BandwidthType` to `DataTransfer`.
        :param pulumi.Input[_builtins.str] bandwidth_type: The method that is used to allocate bandwidth to the inter-region connection. Valid values:
               
               - `BandwidthPackage`: allocates bandwidth from a bandwidth plan.
               - `DataTransfer`: bandwidth is billed based on the pay-by-data-transfer metering method.
        :param pulumi.Input[_builtins.str] cen_bandwidth_package_id: The ID of the bandwidth plan that is used to allocate bandwidth to the inter-region connection.
               
               > **NOTE:**   If you set `BandwidthType` to `DataTransfer`, you do not need to set this parameter.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] default_link_type: The default line type.
               Valid values: Platinum and Gold.
               Platinum is supported only when BandwidthType is set to DataTransfer.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        :param pulumi.Input[_builtins.str] peer_transit_router_id: The ID of the peer transit router.
        :param pulumi.Input[_builtins.str] peer_transit_router_region_id: The ID of the region where the peer transit router is deployed.
        :param pulumi.Input[_builtins.str] region_id: The ID of the region where the local Enterprise Edition transit router is deployed.
        :param pulumi.Input[_builtins.str] resource_type: The resource type to attachment. Only support `VR` and default value is `VR`.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.bool] route_table_association_enabled: Field `route_table_association_enabled` has been deprecated from provider version 1.230.0.
        :param pulumi.Input[_builtins.bool] route_table_propagation_enabled: Field `route_table_propagation_enabled` has been deprecated from provider version 1.230.0.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transit_router_attachment_description: The new description of the inter-region connection.
               This parameter is optional. If you enter a description, it must be 1 to 256 characters in length, and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] transit_router_attachment_id: The ID of the inter-region connection.
        :param pulumi.Input[_builtins.str] transit_router_attachment_name: . Field 'transit_router_attachment_name' has been deprecated from provider version 1.247.0. New field 'transit_router_peer_attachment_name' instead.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the local Enterprise Edition transit router.
        :param pulumi.Input[_builtins.str] transit_router_peer_attachment_name: The new name of the inter-region connection.
               The name can be empty or 1 to 128 characters in length, and cannot start with http:// or https://.
        """
        if auto_publish_route_enabled is not None:
            pulumi.set(__self__, "auto_publish_route_enabled", auto_publish_route_enabled)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if bandwidth_type is not None:
            pulumi.set(__self__, "bandwidth_type", bandwidth_type)
        if cen_bandwidth_package_id is not None:
            pulumi.set(__self__, "cen_bandwidth_package_id", cen_bandwidth_package_id)
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if default_link_type is not None:
            pulumi.set(__self__, "default_link_type", default_link_type)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if peer_transit_router_id is not None:
            pulumi.set(__self__, "peer_transit_router_id", peer_transit_router_id)
        if peer_transit_router_region_id is not None:
            pulumi.set(__self__, "peer_transit_router_region_id", peer_transit_router_region_id)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if route_table_association_enabled is not None:
            warnings.warn("""Field `route_table_association_enabled` has been deprecated from provider version 1.230.0.""", DeprecationWarning)
            pulumi.log.warn("""route_table_association_enabled is deprecated: Field `route_table_association_enabled` has been deprecated from provider version 1.230.0.""")
        if route_table_association_enabled is not None:
            pulumi.set(__self__, "route_table_association_enabled", route_table_association_enabled)
        if route_table_propagation_enabled is not None:
            warnings.warn("""Field `route_table_propagation_enabled` has been deprecated from provider version 1.230.0.""", DeprecationWarning)
            pulumi.log.warn("""route_table_propagation_enabled is deprecated: Field `route_table_propagation_enabled` has been deprecated from provider version 1.230.0.""")
        if route_table_propagation_enabled is not None:
            pulumi.set(__self__, "route_table_propagation_enabled", route_table_propagation_enabled)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_router_attachment_description is not None:
            pulumi.set(__self__, "transit_router_attachment_description", transit_router_attachment_description)
        if transit_router_attachment_id is not None:
            pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        if transit_router_attachment_name is not None:
            warnings.warn("""Field 'transit_router_attachment_name' has been deprecated since provider version 1.247.0. New field 'transit_router_peer_attachment_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""transit_router_attachment_name is deprecated: Field 'transit_router_attachment_name' has been deprecated since provider version 1.247.0. New field 'transit_router_peer_attachment_name' instead.""")
        if transit_router_attachment_name is not None:
            pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)
        if transit_router_peer_attachment_name is not None:
            pulumi.set(__self__, "transit_router_peer_attachment_name", transit_router_peer_attachment_name)

    @_builtins.property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the local Enterprise Edition transit router to automatically advertise the routes of the inter-region connection to the peer transit router. Valid values:
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @auto_publish_route_enabled.setter
    def auto_publish_route_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_publish_route_enabled", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth value of the inter-region connection. Unit: Mbit/s.

        - This parameter specifies the maximum bandwidth value for the inter-region connection if you set `BandwidthType` to `BandwidthPackage`.
        - This parameter specifies the bandwidth throttling threshold for the inter-region connection if you set `BandwidthType` to `DataTransfer`.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthType")
    def bandwidth_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method that is used to allocate bandwidth to the inter-region connection. Valid values:

        - `BandwidthPackage`: allocates bandwidth from a bandwidth plan.
        - `DataTransfer`: bandwidth is billed based on the pay-by-data-transfer metering method.
        """
        return pulumi.get(self, "bandwidth_type")

    @bandwidth_type.setter
    def bandwidth_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_type", value)

    @_builtins.property
    @pulumi.getter(name="cenBandwidthPackageId")
    def cen_bandwidth_package_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the bandwidth plan that is used to allocate bandwidth to the inter-region connection.

        > **NOTE:**   If you set `BandwidthType` to `DataTransfer`, you do not need to set this parameter.
        """
        return pulumi.get(self, "cen_bandwidth_package_id")

    @cen_bandwidth_package_id.setter
    def cen_bandwidth_package_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_bandwidth_package_id", value)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Cloud Enterprise Network (CEN) instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="defaultLinkType")
    def default_link_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default line type.
        Valid values: Platinum and Gold.
        Platinum is supported only when BandwidthType is set to DataTransfer.
        """
        return pulumi.get(self, "default_link_type")

    @default_link_type.setter
    def default_link_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_link_type", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="peerTransitRouterId")
    def peer_transit_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_id")

    @peer_transit_router_id.setter
    def peer_transit_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_transit_router_id", value)

    @_builtins.property
    @pulumi.getter(name="peerTransitRouterRegionId")
    def peer_transit_router_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region where the peer transit router is deployed.
        """
        return pulumi.get(self, "peer_transit_router_region_id")

    @peer_transit_router_region_id.setter
    def peer_transit_router_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_transit_router_region_id", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region where the local Enterprise Edition transit router is deployed.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource type to attachment. Only support `VR` and default value is `VR`.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter(name="routeTableAssociationEnabled")
    @_utilities.deprecated("""Field `route_table_association_enabled` has been deprecated from provider version 1.230.0.""")
    def route_table_association_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Field `route_table_association_enabled` has been deprecated from provider version 1.230.0.
        """
        return pulumi.get(self, "route_table_association_enabled")

    @route_table_association_enabled.setter
    def route_table_association_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "route_table_association_enabled", value)

    @_builtins.property
    @pulumi.getter(name="routeTablePropagationEnabled")
    @_utilities.deprecated("""Field `route_table_propagation_enabled` has been deprecated from provider version 1.230.0.""")
    def route_table_propagation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Field `route_table_propagation_enabled` has been deprecated from provider version 1.230.0.
        """
        return pulumi.get(self, "route_table_propagation_enabled")

    @route_table_propagation_enabled.setter
    def route_table_propagation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "route_table_propagation_enabled", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new description of the inter-region connection.
        This parameter is optional. If you enter a description, it must be 1 to 256 characters in length, and cannot start with http:// or https://.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @transit_router_attachment_description.setter
    def transit_router_attachment_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_description", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the inter-region connection.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @transit_router_attachment_id.setter
    def transit_router_attachment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_id", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentName")
    @_utilities.deprecated("""Field 'transit_router_attachment_name' has been deprecated since provider version 1.247.0. New field 'transit_router_peer_attachment_name' instead.""")
    def transit_router_attachment_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'transit_router_attachment_name' has been deprecated from provider version 1.247.0. New field 'transit_router_peer_attachment_name' instead.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @transit_router_attachment_name.setter
    def transit_router_attachment_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_name", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the local Enterprise Edition transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_id", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterPeerAttachmentName")
    def transit_router_peer_attachment_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new name of the inter-region connection.
        The name can be empty or 1 to 128 characters in length, and cannot start with http:// or https://.
        """
        return pulumi.get(self, "transit_router_peer_attachment_name")

    @transit_router_peer_attachment_name.setter
    def transit_router_peer_attachment_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_peer_attachment_name", value)


@pulumi.type_token("alicloud:cen/transitRouterPeerAttachment:TransitRouterPeerAttachment")
class TransitRouterPeerAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 bandwidth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 peer_transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_transit_router_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_association_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_peer_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Enterprise Network (CEN) Transit Router Peer Attachment resource.

        For information about Cloud Enterprise Network (CEN) Transit Router Peer Attachment and how to use it, see [What is Transit Router Peer Attachment](https://next.api.alibabacloud.com/document/Cbn/2017-09-12/CreateTransitRouterPeerAttachment).

        > **NOTE:** Available since v1.128.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        peer_region = config.get("peerRegion")
        if peer_region is None:
            peer_region = "cn-beijing"
        example = alicloud.cen.Instance("example",
            cen_instance_name=name,
            protection_level="REDUCED")
        example_bandwidth_package = alicloud.cen.BandwidthPackage("example",
            bandwidth=5,
            cen_bandwidth_package_name="tf_example",
            geographic_region_a_id="China",
            geographic_region_b_id="China")
        example_bandwidth_package_attachment = alicloud.cen.BandwidthPackageAttachment("example",
            instance_id=example.id,
            bandwidth_package_id=example_bandwidth_package.id)
        example_transit_router = alicloud.cen.TransitRouter("example", cen_id=example_bandwidth_package_attachment.instance_id)
        peer = alicloud.cen.TransitRouter("peer", cen_id=example_transit_router.cen_id)
        example_transit_router_peer_attachment = alicloud.cen.TransitRouterPeerAttachment("example",
            cen_id=example.id,
            transit_router_id=example_transit_router.transit_router_id,
            peer_transit_router_region_id=peer_region,
            peer_transit_router_id=peer.transit_router_id,
            cen_bandwidth_package_id=example_bandwidth_package_attachment.bandwidth_package_id,
            bandwidth=5,
            transit_router_attachment_description=name,
            transit_router_attachment_name=name)
        ```

        ## Import

        Cloud Enterprise Network (CEN) Transit Router Peer Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/transitRouterPeerAttachment:TransitRouterPeerAttachment example <cen_id>:<transit_router_attachment_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_publish_route_enabled: Specifies whether to enable the local Enterprise Edition transit router to automatically advertise the routes of the inter-region connection to the peer transit router. Valid values:
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth value of the inter-region connection. Unit: Mbit/s.
               
               - This parameter specifies the maximum bandwidth value for the inter-region connection if you set `BandwidthType` to `BandwidthPackage`.
               - This parameter specifies the bandwidth throttling threshold for the inter-region connection if you set `BandwidthType` to `DataTransfer`.
        :param pulumi.Input[_builtins.str] bandwidth_type: The method that is used to allocate bandwidth to the inter-region connection. Valid values:
               
               - `BandwidthPackage`: allocates bandwidth from a bandwidth plan.
               - `DataTransfer`: bandwidth is billed based on the pay-by-data-transfer metering method.
        :param pulumi.Input[_builtins.str] cen_bandwidth_package_id: The ID of the bandwidth plan that is used to allocate bandwidth to the inter-region connection.
               
               > **NOTE:**   If you set `BandwidthType` to `DataTransfer`, you do not need to set this parameter.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param pulumi.Input[_builtins.str] default_link_type: The default line type.
               Valid values: Platinum and Gold.
               Platinum is supported only when BandwidthType is set to DataTransfer.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        :param pulumi.Input[_builtins.str] peer_transit_router_id: The ID of the peer transit router.
        :param pulumi.Input[_builtins.str] peer_transit_router_region_id: The ID of the region where the peer transit router is deployed.
        :param pulumi.Input[_builtins.str] resource_type: The resource type to attachment. Only support `VR` and default value is `VR`.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.bool] route_table_association_enabled: Field `route_table_association_enabled` has been deprecated from provider version 1.230.0.
        :param pulumi.Input[_builtins.bool] route_table_propagation_enabled: Field `route_table_propagation_enabled` has been deprecated from provider version 1.230.0.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transit_router_attachment_description: The new description of the inter-region connection.
               This parameter is optional. If you enter a description, it must be 1 to 256 characters in length, and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] transit_router_attachment_name: . Field 'transit_router_attachment_name' has been deprecated from provider version 1.247.0. New field 'transit_router_peer_attachment_name' instead.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the local Enterprise Edition transit router.
        :param pulumi.Input[_builtins.str] transit_router_peer_attachment_name: The new name of the inter-region connection.
               The name can be empty or 1 to 128 characters in length, and cannot start with http:// or https://.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransitRouterPeerAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Enterprise Network (CEN) Transit Router Peer Attachment resource.

        For information about Cloud Enterprise Network (CEN) Transit Router Peer Attachment and how to use it, see [What is Transit Router Peer Attachment](https://next.api.alibabacloud.com/document/Cbn/2017-09-12/CreateTransitRouterPeerAttachment).

        > **NOTE:** Available since v1.128.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        peer_region = config.get("peerRegion")
        if peer_region is None:
            peer_region = "cn-beijing"
        example = alicloud.cen.Instance("example",
            cen_instance_name=name,
            protection_level="REDUCED")
        example_bandwidth_package = alicloud.cen.BandwidthPackage("example",
            bandwidth=5,
            cen_bandwidth_package_name="tf_example",
            geographic_region_a_id="China",
            geographic_region_b_id="China")
        example_bandwidth_package_attachment = alicloud.cen.BandwidthPackageAttachment("example",
            instance_id=example.id,
            bandwidth_package_id=example_bandwidth_package.id)
        example_transit_router = alicloud.cen.TransitRouter("example", cen_id=example_bandwidth_package_attachment.instance_id)
        peer = alicloud.cen.TransitRouter("peer", cen_id=example_transit_router.cen_id)
        example_transit_router_peer_attachment = alicloud.cen.TransitRouterPeerAttachment("example",
            cen_id=example.id,
            transit_router_id=example_transit_router.transit_router_id,
            peer_transit_router_region_id=peer_region,
            peer_transit_router_id=peer.transit_router_id,
            cen_bandwidth_package_id=example_bandwidth_package_attachment.bandwidth_package_id,
            bandwidth=5,
            transit_router_attachment_description=name,
            transit_router_attachment_name=name)
        ```

        ## Import

        Cloud Enterprise Network (CEN) Transit Router Peer Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/transitRouterPeerAttachment:TransitRouterPeerAttachment example <cen_id>:<transit_router_attachment_id>
        ```

        :param str resource_name: The name of the resource.
        :param TransitRouterPeerAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransitRouterPeerAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 bandwidth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_link_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 peer_transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_transit_router_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_association_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_peer_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransitRouterPeerAttachmentArgs.__new__(TransitRouterPeerAttachmentArgs)

            __props__.__dict__["auto_publish_route_enabled"] = auto_publish_route_enabled
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["bandwidth_type"] = bandwidth_type
            __props__.__dict__["cen_bandwidth_package_id"] = cen_bandwidth_package_id
            __props__.__dict__["cen_id"] = cen_id
            __props__.__dict__["default_link_type"] = default_link_type
            __props__.__dict__["dry_run"] = dry_run
            if peer_transit_router_id is None and not opts.urn:
                raise TypeError("Missing required property 'peer_transit_router_id'")
            __props__.__dict__["peer_transit_router_id"] = peer_transit_router_id
            __props__.__dict__["peer_transit_router_region_id"] = peer_transit_router_region_id
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["route_table_association_enabled"] = route_table_association_enabled
            __props__.__dict__["route_table_propagation_enabled"] = route_table_propagation_enabled
            __props__.__dict__["tags"] = tags
            __props__.__dict__["transit_router_attachment_description"] = transit_router_attachment_description
            __props__.__dict__["transit_router_attachment_name"] = transit_router_attachment_name
            __props__.__dict__["transit_router_id"] = transit_router_id
            __props__.__dict__["transit_router_peer_attachment_name"] = transit_router_peer_attachment_name
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["transit_router_attachment_id"] = None
        super(TransitRouterPeerAttachment, __self__).__init__(
            'alicloud:cen/transitRouterPeerAttachment:TransitRouterPeerAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            bandwidth_type: Optional[pulumi.Input[_builtins.str]] = None,
            cen_bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
            cen_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            default_link_type: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            peer_transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
            peer_transit_router_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            route_table_association_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            route_table_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_peer_attachment_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'TransitRouterPeerAttachment':
        """
        Get an existing TransitRouterPeerAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_publish_route_enabled: Specifies whether to enable the local Enterprise Edition transit router to automatically advertise the routes of the inter-region connection to the peer transit router. Valid values:
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth value of the inter-region connection. Unit: Mbit/s.
               
               - This parameter specifies the maximum bandwidth value for the inter-region connection if you set `BandwidthType` to `BandwidthPackage`.
               - This parameter specifies the bandwidth throttling threshold for the inter-region connection if you set `BandwidthType` to `DataTransfer`.
        :param pulumi.Input[_builtins.str] bandwidth_type: The method that is used to allocate bandwidth to the inter-region connection. Valid values:
               
               - `BandwidthPackage`: allocates bandwidth from a bandwidth plan.
               - `DataTransfer`: bandwidth is billed based on the pay-by-data-transfer metering method.
        :param pulumi.Input[_builtins.str] cen_bandwidth_package_id: The ID of the bandwidth plan that is used to allocate bandwidth to the inter-region connection.
               
               > **NOTE:**   If you set `BandwidthType` to `DataTransfer`, you do not need to set this parameter.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] default_link_type: The default line type.
               Valid values: Platinum and Gold.
               Platinum is supported only when BandwidthType is set to DataTransfer.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        :param pulumi.Input[_builtins.str] peer_transit_router_id: The ID of the peer transit router.
        :param pulumi.Input[_builtins.str] peer_transit_router_region_id: The ID of the region where the peer transit router is deployed.
        :param pulumi.Input[_builtins.str] region_id: The ID of the region where the local Enterprise Edition transit router is deployed.
        :param pulumi.Input[_builtins.str] resource_type: The resource type to attachment. Only support `VR` and default value is `VR`.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.bool] route_table_association_enabled: Field `route_table_association_enabled` has been deprecated from provider version 1.230.0.
        :param pulumi.Input[_builtins.bool] route_table_propagation_enabled: Field `route_table_propagation_enabled` has been deprecated from provider version 1.230.0.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] transit_router_attachment_description: The new description of the inter-region connection.
               This parameter is optional. If you enter a description, it must be 1 to 256 characters in length, and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] transit_router_attachment_id: The ID of the inter-region connection.
        :param pulumi.Input[_builtins.str] transit_router_attachment_name: . Field 'transit_router_attachment_name' has been deprecated from provider version 1.247.0. New field 'transit_router_peer_attachment_name' instead.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the local Enterprise Edition transit router.
        :param pulumi.Input[_builtins.str] transit_router_peer_attachment_name: The new name of the inter-region connection.
               The name can be empty or 1 to 128 characters in length, and cannot start with http:// or https://.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransitRouterPeerAttachmentState.__new__(_TransitRouterPeerAttachmentState)

        __props__.__dict__["auto_publish_route_enabled"] = auto_publish_route_enabled
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["bandwidth_type"] = bandwidth_type
        __props__.__dict__["cen_bandwidth_package_id"] = cen_bandwidth_package_id
        __props__.__dict__["cen_id"] = cen_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["default_link_type"] = default_link_type
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["peer_transit_router_id"] = peer_transit_router_id
        __props__.__dict__["peer_transit_router_region_id"] = peer_transit_router_region_id
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["route_table_association_enabled"] = route_table_association_enabled
        __props__.__dict__["route_table_propagation_enabled"] = route_table_propagation_enabled
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["transit_router_attachment_description"] = transit_router_attachment_description
        __props__.__dict__["transit_router_attachment_id"] = transit_router_attachment_id
        __props__.__dict__["transit_router_attachment_name"] = transit_router_attachment_name
        __props__.__dict__["transit_router_id"] = transit_router_id
        __props__.__dict__["transit_router_peer_attachment_name"] = transit_router_peer_attachment_name
        return TransitRouterPeerAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the local Enterprise Edition transit router to automatically advertise the routes of the inter-region connection to the peer transit router. Valid values:
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The bandwidth value of the inter-region connection. Unit: Mbit/s.

        - This parameter specifies the maximum bandwidth value for the inter-region connection if you set `BandwidthType` to `BandwidthPackage`.
        - This parameter specifies the bandwidth throttling threshold for the inter-region connection if you set `BandwidthType` to `DataTransfer`.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="bandwidthType")
    def bandwidth_type(self) -> pulumi.Output[_builtins.str]:
        """
        The method that is used to allocate bandwidth to the inter-region connection. Valid values:

        - `BandwidthPackage`: allocates bandwidth from a bandwidth plan.
        - `DataTransfer`: bandwidth is billed based on the pay-by-data-transfer metering method.
        """
        return pulumi.get(self, "bandwidth_type")

    @_builtins.property
    @pulumi.getter(name="cenBandwidthPackageId")
    def cen_bandwidth_package_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the bandwidth plan that is used to allocate bandwidth to the inter-region connection.

        > **NOTE:**   If you set `BandwidthType` to `DataTransfer`, you do not need to set this parameter.
        """
        return pulumi.get(self, "cen_bandwidth_package_id")

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Cloud Enterprise Network (CEN) instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="defaultLinkType")
    def default_link_type(self) -> pulumi.Output[_builtins.str]:
        """
        The default line type.
        Valid values: Platinum and Gold.
        Platinum is supported only when BandwidthType is set to DataTransfer.
        """
        return pulumi.get(self, "default_link_type")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to perform PreCheck on this request, including permissions and instance status verification. Value:
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="peerTransitRouterId")
    def peer_transit_router_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_id")

    @_builtins.property
    @pulumi.getter(name="peerTransitRouterRegionId")
    def peer_transit_router_region_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the region where the peer transit router is deployed.
        """
        return pulumi.get(self, "peer_transit_router_region_id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region where the local Enterprise Edition transit router is deployed.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource type to attachment. Only support `VR` and default value is `VR`.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter(name="routeTableAssociationEnabled")
    @_utilities.deprecated("""Field `route_table_association_enabled` has been deprecated from provider version 1.230.0.""")
    def route_table_association_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Field `route_table_association_enabled` has been deprecated from provider version 1.230.0.
        """
        return pulumi.get(self, "route_table_association_enabled")

    @_builtins.property
    @pulumi.getter(name="routeTablePropagationEnabled")
    @_utilities.deprecated("""Field `route_table_propagation_enabled` has been deprecated from provider version 1.230.0.""")
    def route_table_propagation_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Field `route_table_propagation_enabled` has been deprecated from provider version 1.230.0.
        """
        return pulumi.get(self, "route_table_propagation_enabled")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The new description of the inter-region connection.
        This parameter is optional. If you enter a description, it must be 1 to 256 characters in length, and cannot start with http:// or https://.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the inter-region connection.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentName")
    @_utilities.deprecated("""Field 'transit_router_attachment_name' has been deprecated since provider version 1.247.0. New field 'transit_router_peer_attachment_name' instead.""")
    def transit_router_attachment_name(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'transit_router_attachment_name' has been deprecated from provider version 1.247.0. New field 'transit_router_peer_attachment_name' instead.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the local Enterprise Edition transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterPeerAttachmentName")
    def transit_router_peer_attachment_name(self) -> pulumi.Output[_builtins.str]:
        """
        The new name of the inter-region connection.
        The name can be empty or 1 to 128 characters in length, and cannot start with http:// or https://.
        """
        return pulumi.get(self, "transit_router_peer_attachment_name")

