# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AggregateDeliveryArgs', 'AggregateDelivery']

@pulumi.input_type
class AggregateDeliveryArgs:
    def __init__(__self__, *,
                 aggregator_id: pulumi.Input[_builtins.str],
                 delivery_channel_target_arn: pulumi.Input[_builtins.str],
                 delivery_channel_type: pulumi.Input[_builtins.str],
                 configuration_item_change_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 configuration_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 delivery_channel_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 non_compliant_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 oversized_data_oss_target_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a AggregateDelivery resource.
        :param pulumi.Input[_builtins.str] aggregator_id: Aggregator ID.
        :param pulumi.Input[_builtins.str] delivery_channel_target_arn: The ARN of the delivery destination.  
               - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
               - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
               - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
        :param pulumi.Input[_builtins.str] delivery_channel_type: The type of the delivery channel. Valid values:
               - OSS: Object Storage Service (OSS)
               - MNS: Message Service (MNS)
               - SLS: Log Service
        :param pulumi.Input[_builtins.bool] configuration_item_change_notification: Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:  
               - true: The specified destination receives resource change logs.
               - false: The specified destination does not receive resource change logs.
        :param pulumi.Input[_builtins.bool] configuration_snapshot: Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:  
               - true: The specified destination receives scheduled resource snapshots.
               - false: The specified destination does not receive scheduled resource snapshots.
        :param pulumi.Input[_builtins.str] delivery_channel_condition: The rule that is attached to the delivery channel.   
               
               This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.
               
               If you specify the risk level or resource types for subscription events, this is as follows:
               
               The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
               
               The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.
               
               Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
        :param pulumi.Input[_builtins.str] delivery_channel_name: The name of the delivery channel.
        :param pulumi.Input[_builtins.str] description: The description of the delivery method.
        :param pulumi.Input[_builtins.bool] non_compliant_notification: Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:  
               - true: The specified destination receives resource non-compliance events.
               - false: The specified destination does not receive resource non-compliance events.
        :param pulumi.Input[_builtins.str] oversized_data_oss_target_arn: The ARN of the OSS bucket to which the delivered data is transferred when the size of the data exceeds the specified upper limit of the delivery channel.
        :param pulumi.Input[_builtins.int] status: The status of the delivery method. Valid values:   
               - 0: The delivery method is disabled.
               - 1: The delivery destination is enabled. This is the default value.
        """
        pulumi.set(__self__, "aggregator_id", aggregator_id)
        pulumi.set(__self__, "delivery_channel_target_arn", delivery_channel_target_arn)
        pulumi.set(__self__, "delivery_channel_type", delivery_channel_type)
        if configuration_item_change_notification is not None:
            pulumi.set(__self__, "configuration_item_change_notification", configuration_item_change_notification)
        if configuration_snapshot is not None:
            pulumi.set(__self__, "configuration_snapshot", configuration_snapshot)
        if delivery_channel_condition is not None:
            pulumi.set(__self__, "delivery_channel_condition", delivery_channel_condition)
        if delivery_channel_name is not None:
            pulumi.set(__self__, "delivery_channel_name", delivery_channel_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if non_compliant_notification is not None:
            pulumi.set(__self__, "non_compliant_notification", non_compliant_notification)
        if oversized_data_oss_target_arn is not None:
            pulumi.set(__self__, "oversized_data_oss_target_arn", oversized_data_oss_target_arn)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="aggregatorId")
    def aggregator_id(self) -> pulumi.Input[_builtins.str]:
        """
        Aggregator ID.
        """
        return pulumi.get(self, "aggregator_id")

    @aggregator_id.setter
    def aggregator_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "aggregator_id", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelTargetArn")
    def delivery_channel_target_arn(self) -> pulumi.Input[_builtins.str]:
        """
        The ARN of the delivery destination.  
        - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
        - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
        - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
        """
        return pulumi.get(self, "delivery_channel_target_arn")

    @delivery_channel_target_arn.setter
    def delivery_channel_target_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "delivery_channel_target_arn", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelType")
    def delivery_channel_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the delivery channel. Valid values:
        - OSS: Object Storage Service (OSS)
        - MNS: Message Service (MNS)
        - SLS: Log Service
        """
        return pulumi.get(self, "delivery_channel_type")

    @delivery_channel_type.setter
    def delivery_channel_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "delivery_channel_type", value)

    @_builtins.property
    @pulumi.getter(name="configurationItemChangeNotification")
    def configuration_item_change_notification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:  
        - true: The specified destination receives resource change logs.
        - false: The specified destination does not receive resource change logs.
        """
        return pulumi.get(self, "configuration_item_change_notification")

    @configuration_item_change_notification.setter
    def configuration_item_change_notification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "configuration_item_change_notification", value)

    @_builtins.property
    @pulumi.getter(name="configurationSnapshot")
    def configuration_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:  
        - true: The specified destination receives scheduled resource snapshots.
        - false: The specified destination does not receive scheduled resource snapshots.
        """
        return pulumi.get(self, "configuration_snapshot")

    @configuration_snapshot.setter
    def configuration_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "configuration_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelCondition")
    def delivery_channel_condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule that is attached to the delivery channel.   

        This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.

        If you specify the risk level or resource types for subscription events, this is as follows:

        The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.

        The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.

        Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
        """
        return pulumi.get(self, "delivery_channel_condition")

    @delivery_channel_condition.setter
    def delivery_channel_condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_channel_condition", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelName")
    def delivery_channel_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the delivery channel.
        """
        return pulumi.get(self, "delivery_channel_name")

    @delivery_channel_name.setter
    def delivery_channel_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_channel_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the delivery method.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="nonCompliantNotification")
    def non_compliant_notification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:  
        - true: The specified destination receives resource non-compliance events.
        - false: The specified destination does not receive resource non-compliance events.
        """
        return pulumi.get(self, "non_compliant_notification")

    @non_compliant_notification.setter
    def non_compliant_notification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "non_compliant_notification", value)

    @_builtins.property
    @pulumi.getter(name="oversizedDataOssTargetArn")
    def oversized_data_oss_target_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the OSS bucket to which the delivered data is transferred when the size of the data exceeds the specified upper limit of the delivery channel.
        """
        return pulumi.get(self, "oversized_data_oss_target_arn")

    @oversized_data_oss_target_arn.setter
    def oversized_data_oss_target_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oversized_data_oss_target_arn", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The status of the delivery method. Valid values:   
        - 0: The delivery method is disabled.
        - 1: The delivery destination is enabled. This is the default value.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _AggregateDeliveryState:
    def __init__(__self__, *,
                 aggregator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_item_change_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 configuration_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 delivery_channel_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_target_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 non_compliant_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 oversized_data_oss_target_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering AggregateDelivery resources.
        :param pulumi.Input[_builtins.str] aggregator_id: Aggregator ID.
        :param pulumi.Input[_builtins.bool] configuration_item_change_notification: Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:  
               - true: The specified destination receives resource change logs.
               - false: The specified destination does not receive resource change logs.
        :param pulumi.Input[_builtins.bool] configuration_snapshot: Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:  
               - true: The specified destination receives scheduled resource snapshots.
               - false: The specified destination does not receive scheduled resource snapshots.
        :param pulumi.Input[_builtins.str] delivery_channel_condition: The rule that is attached to the delivery channel.   
               
               This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.
               
               If you specify the risk level or resource types for subscription events, this is as follows:
               
               The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
               
               The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.
               
               Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
        :param pulumi.Input[_builtins.str] delivery_channel_id: The ID of the delivery method. This parameter is required when you modify a delivery method.
        :param pulumi.Input[_builtins.str] delivery_channel_name: The name of the delivery channel.
        :param pulumi.Input[_builtins.str] delivery_channel_target_arn: The ARN of the delivery destination.  
               - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
               - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
               - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
        :param pulumi.Input[_builtins.str] delivery_channel_type: The type of the delivery channel. Valid values:
               - OSS: Object Storage Service (OSS)
               - MNS: Message Service (MNS)
               - SLS: Log Service
        :param pulumi.Input[_builtins.str] description: The description of the delivery method.
        :param pulumi.Input[_builtins.bool] non_compliant_notification: Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:  
               - true: The specified destination receives resource non-compliance events.
               - false: The specified destination does not receive resource non-compliance events.
        :param pulumi.Input[_builtins.str] oversized_data_oss_target_arn: The ARN of the OSS bucket to which the delivered data is transferred when the size of the data exceeds the specified upper limit of the delivery channel.
        :param pulumi.Input[_builtins.int] status: The status of the delivery method. Valid values:   
               - 0: The delivery method is disabled.
               - 1: The delivery destination is enabled. This is the default value.
        """
        if aggregator_id is not None:
            pulumi.set(__self__, "aggregator_id", aggregator_id)
        if configuration_item_change_notification is not None:
            pulumi.set(__self__, "configuration_item_change_notification", configuration_item_change_notification)
        if configuration_snapshot is not None:
            pulumi.set(__self__, "configuration_snapshot", configuration_snapshot)
        if delivery_channel_condition is not None:
            pulumi.set(__self__, "delivery_channel_condition", delivery_channel_condition)
        if delivery_channel_id is not None:
            pulumi.set(__self__, "delivery_channel_id", delivery_channel_id)
        if delivery_channel_name is not None:
            pulumi.set(__self__, "delivery_channel_name", delivery_channel_name)
        if delivery_channel_target_arn is not None:
            pulumi.set(__self__, "delivery_channel_target_arn", delivery_channel_target_arn)
        if delivery_channel_type is not None:
            pulumi.set(__self__, "delivery_channel_type", delivery_channel_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if non_compliant_notification is not None:
            pulumi.set(__self__, "non_compliant_notification", non_compliant_notification)
        if oversized_data_oss_target_arn is not None:
            pulumi.set(__self__, "oversized_data_oss_target_arn", oversized_data_oss_target_arn)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="aggregatorId")
    def aggregator_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Aggregator ID.
        """
        return pulumi.get(self, "aggregator_id")

    @aggregator_id.setter
    def aggregator_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aggregator_id", value)

    @_builtins.property
    @pulumi.getter(name="configurationItemChangeNotification")
    def configuration_item_change_notification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:  
        - true: The specified destination receives resource change logs.
        - false: The specified destination does not receive resource change logs.
        """
        return pulumi.get(self, "configuration_item_change_notification")

    @configuration_item_change_notification.setter
    def configuration_item_change_notification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "configuration_item_change_notification", value)

    @_builtins.property
    @pulumi.getter(name="configurationSnapshot")
    def configuration_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:  
        - true: The specified destination receives scheduled resource snapshots.
        - false: The specified destination does not receive scheduled resource snapshots.
        """
        return pulumi.get(self, "configuration_snapshot")

    @configuration_snapshot.setter
    def configuration_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "configuration_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelCondition")
    def delivery_channel_condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule that is attached to the delivery channel.   

        This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.

        If you specify the risk level or resource types for subscription events, this is as follows:

        The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.

        The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.

        Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
        """
        return pulumi.get(self, "delivery_channel_condition")

    @delivery_channel_condition.setter
    def delivery_channel_condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_channel_condition", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelId")
    def delivery_channel_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the delivery method. This parameter is required when you modify a delivery method.
        """
        return pulumi.get(self, "delivery_channel_id")

    @delivery_channel_id.setter
    def delivery_channel_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_channel_id", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelName")
    def delivery_channel_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the delivery channel.
        """
        return pulumi.get(self, "delivery_channel_name")

    @delivery_channel_name.setter
    def delivery_channel_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_channel_name", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelTargetArn")
    def delivery_channel_target_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the delivery destination.  
        - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
        - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
        - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
        """
        return pulumi.get(self, "delivery_channel_target_arn")

    @delivery_channel_target_arn.setter
    def delivery_channel_target_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_channel_target_arn", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelType")
    def delivery_channel_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the delivery channel. Valid values:
        - OSS: Object Storage Service (OSS)
        - MNS: Message Service (MNS)
        - SLS: Log Service
        """
        return pulumi.get(self, "delivery_channel_type")

    @delivery_channel_type.setter
    def delivery_channel_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_channel_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the delivery method.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="nonCompliantNotification")
    def non_compliant_notification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:  
        - true: The specified destination receives resource non-compliance events.
        - false: The specified destination does not receive resource non-compliance events.
        """
        return pulumi.get(self, "non_compliant_notification")

    @non_compliant_notification.setter
    def non_compliant_notification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "non_compliant_notification", value)

    @_builtins.property
    @pulumi.getter(name="oversizedDataOssTargetArn")
    def oversized_data_oss_target_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the OSS bucket to which the delivered data is transferred when the size of the data exceeds the specified upper limit of the delivery channel.
        """
        return pulumi.get(self, "oversized_data_oss_target_arn")

    @oversized_data_oss_target_arn.setter
    def oversized_data_oss_target_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oversized_data_oss_target_arn", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The status of the delivery method. Valid values:   
        - 0: The delivery method is disabled.
        - 1: The delivery destination is enabled. This is the default value.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:cfg/aggregateDelivery:AggregateDelivery")
class AggregateDelivery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_item_change_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 configuration_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 delivery_channel_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_target_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 non_compliant_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 oversized_data_oss_target_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Config Aggregate Delivery resource.

        Delivery channel of aggregator.

        For information about Config Aggregate Delivery and how to use it, see [What is Aggregate Delivery](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createaggregateconfigdeliverychannel).

        > **NOTE:** Available since v1.172.0.

        ## Import

        Config Aggregate Delivery can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cfg/aggregateDelivery:AggregateDelivery example <aggregator_id>:<delivery_channel_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aggregator_id: Aggregator ID.
        :param pulumi.Input[_builtins.bool] configuration_item_change_notification: Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:  
               - true: The specified destination receives resource change logs.
               - false: The specified destination does not receive resource change logs.
        :param pulumi.Input[_builtins.bool] configuration_snapshot: Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:  
               - true: The specified destination receives scheduled resource snapshots.
               - false: The specified destination does not receive scheduled resource snapshots.
        :param pulumi.Input[_builtins.str] delivery_channel_condition: The rule that is attached to the delivery channel.   
               
               This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.
               
               If you specify the risk level or resource types for subscription events, this is as follows:
               
               The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
               
               The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.
               
               Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
        :param pulumi.Input[_builtins.str] delivery_channel_name: The name of the delivery channel.
        :param pulumi.Input[_builtins.str] delivery_channel_target_arn: The ARN of the delivery destination.  
               - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
               - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
               - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
        :param pulumi.Input[_builtins.str] delivery_channel_type: The type of the delivery channel. Valid values:
               - OSS: Object Storage Service (OSS)
               - MNS: Message Service (MNS)
               - SLS: Log Service
        :param pulumi.Input[_builtins.str] description: The description of the delivery method.
        :param pulumi.Input[_builtins.bool] non_compliant_notification: Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:  
               - true: The specified destination receives resource non-compliance events.
               - false: The specified destination does not receive resource non-compliance events.
        :param pulumi.Input[_builtins.str] oversized_data_oss_target_arn: The ARN of the OSS bucket to which the delivered data is transferred when the size of the data exceeds the specified upper limit of the delivery channel.
        :param pulumi.Input[_builtins.int] status: The status of the delivery method. Valid values:   
               - 0: The delivery method is disabled.
               - 1: The delivery destination is enabled. This is the default value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AggregateDeliveryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Config Aggregate Delivery resource.

        Delivery channel of aggregator.

        For information about Config Aggregate Delivery and how to use it, see [What is Aggregate Delivery](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createaggregateconfigdeliverychannel).

        > **NOTE:** Available since v1.172.0.

        ## Import

        Config Aggregate Delivery can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cfg/aggregateDelivery:AggregateDelivery example <aggregator_id>:<delivery_channel_id>
        ```

        :param str resource_name: The name of the resource.
        :param AggregateDeliveryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AggregateDeliveryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration_item_change_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 configuration_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 delivery_channel_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_target_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 non_compliant_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 oversized_data_oss_target_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AggregateDeliveryArgs.__new__(AggregateDeliveryArgs)

            if aggregator_id is None and not opts.urn:
                raise TypeError("Missing required property 'aggregator_id'")
            __props__.__dict__["aggregator_id"] = aggregator_id
            __props__.__dict__["configuration_item_change_notification"] = configuration_item_change_notification
            __props__.__dict__["configuration_snapshot"] = configuration_snapshot
            __props__.__dict__["delivery_channel_condition"] = delivery_channel_condition
            __props__.__dict__["delivery_channel_name"] = delivery_channel_name
            if delivery_channel_target_arn is None and not opts.urn:
                raise TypeError("Missing required property 'delivery_channel_target_arn'")
            __props__.__dict__["delivery_channel_target_arn"] = delivery_channel_target_arn
            if delivery_channel_type is None and not opts.urn:
                raise TypeError("Missing required property 'delivery_channel_type'")
            __props__.__dict__["delivery_channel_type"] = delivery_channel_type
            __props__.__dict__["description"] = description
            __props__.__dict__["non_compliant_notification"] = non_compliant_notification
            __props__.__dict__["oversized_data_oss_target_arn"] = oversized_data_oss_target_arn
            __props__.__dict__["status"] = status
            __props__.__dict__["delivery_channel_id"] = None
        super(AggregateDelivery, __self__).__init__(
            'alicloud:cfg/aggregateDelivery:AggregateDelivery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aggregator_id: Optional[pulumi.Input[_builtins.str]] = None,
            configuration_item_change_notification: Optional[pulumi.Input[_builtins.bool]] = None,
            configuration_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
            delivery_channel_condition: Optional[pulumi.Input[_builtins.str]] = None,
            delivery_channel_id: Optional[pulumi.Input[_builtins.str]] = None,
            delivery_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
            delivery_channel_target_arn: Optional[pulumi.Input[_builtins.str]] = None,
            delivery_channel_type: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            non_compliant_notification: Optional[pulumi.Input[_builtins.bool]] = None,
            oversized_data_oss_target_arn: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.int]] = None) -> 'AggregateDelivery':
        """
        Get an existing AggregateDelivery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aggregator_id: Aggregator ID.
        :param pulumi.Input[_builtins.bool] configuration_item_change_notification: Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:  
               - true: The specified destination receives resource change logs.
               - false: The specified destination does not receive resource change logs.
        :param pulumi.Input[_builtins.bool] configuration_snapshot: Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:  
               - true: The specified destination receives scheduled resource snapshots.
               - false: The specified destination does not receive scheduled resource snapshots.
        :param pulumi.Input[_builtins.str] delivery_channel_condition: The rule that is attached to the delivery channel.   
               
               This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.
               
               If you specify the risk level or resource types for subscription events, this is as follows:
               
               The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
               
               The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.
               
               Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
        :param pulumi.Input[_builtins.str] delivery_channel_id: The ID of the delivery method. This parameter is required when you modify a delivery method.
        :param pulumi.Input[_builtins.str] delivery_channel_name: The name of the delivery channel.
        :param pulumi.Input[_builtins.str] delivery_channel_target_arn: The ARN of the delivery destination.  
               - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
               - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
               - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
        :param pulumi.Input[_builtins.str] delivery_channel_type: The type of the delivery channel. Valid values:
               - OSS: Object Storage Service (OSS)
               - MNS: Message Service (MNS)
               - SLS: Log Service
        :param pulumi.Input[_builtins.str] description: The description of the delivery method.
        :param pulumi.Input[_builtins.bool] non_compliant_notification: Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:  
               - true: The specified destination receives resource non-compliance events.
               - false: The specified destination does not receive resource non-compliance events.
        :param pulumi.Input[_builtins.str] oversized_data_oss_target_arn: The ARN of the OSS bucket to which the delivered data is transferred when the size of the data exceeds the specified upper limit of the delivery channel.
        :param pulumi.Input[_builtins.int] status: The status of the delivery method. Valid values:   
               - 0: The delivery method is disabled.
               - 1: The delivery destination is enabled. This is the default value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AggregateDeliveryState.__new__(_AggregateDeliveryState)

        __props__.__dict__["aggregator_id"] = aggregator_id
        __props__.__dict__["configuration_item_change_notification"] = configuration_item_change_notification
        __props__.__dict__["configuration_snapshot"] = configuration_snapshot
        __props__.__dict__["delivery_channel_condition"] = delivery_channel_condition
        __props__.__dict__["delivery_channel_id"] = delivery_channel_id
        __props__.__dict__["delivery_channel_name"] = delivery_channel_name
        __props__.__dict__["delivery_channel_target_arn"] = delivery_channel_target_arn
        __props__.__dict__["delivery_channel_type"] = delivery_channel_type
        __props__.__dict__["description"] = description
        __props__.__dict__["non_compliant_notification"] = non_compliant_notification
        __props__.__dict__["oversized_data_oss_target_arn"] = oversized_data_oss_target_arn
        __props__.__dict__["status"] = status
        return AggregateDelivery(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aggregatorId")
    def aggregator_id(self) -> pulumi.Output[_builtins.str]:
        """
        Aggregator ID.
        """
        return pulumi.get(self, "aggregator_id")

    @_builtins.property
    @pulumi.getter(name="configurationItemChangeNotification")
    def configuration_item_change_notification(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:  
        - true: The specified destination receives resource change logs.
        - false: The specified destination does not receive resource change logs.
        """
        return pulumi.get(self, "configuration_item_change_notification")

    @_builtins.property
    @pulumi.getter(name="configurationSnapshot")
    def configuration_snapshot(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:  
        - true: The specified destination receives scheduled resource snapshots.
        - false: The specified destination does not receive scheduled resource snapshots.
        """
        return pulumi.get(self, "configuration_snapshot")

    @_builtins.property
    @pulumi.getter(name="deliveryChannelCondition")
    def delivery_channel_condition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The rule that is attached to the delivery channel.   

        This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.

        If you specify the risk level or resource types for subscription events, this is as follows:

        The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.

        The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.

        Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
        """
        return pulumi.get(self, "delivery_channel_condition")

    @_builtins.property
    @pulumi.getter(name="deliveryChannelId")
    def delivery_channel_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the delivery method. This parameter is required when you modify a delivery method.
        """
        return pulumi.get(self, "delivery_channel_id")

    @_builtins.property
    @pulumi.getter(name="deliveryChannelName")
    def delivery_channel_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the delivery channel.
        """
        return pulumi.get(self, "delivery_channel_name")

    @_builtins.property
    @pulumi.getter(name="deliveryChannelTargetArn")
    def delivery_channel_target_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the delivery destination.  
        - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
        - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
        - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
        """
        return pulumi.get(self, "delivery_channel_target_arn")

    @_builtins.property
    @pulumi.getter(name="deliveryChannelType")
    def delivery_channel_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the delivery channel. Valid values:
        - OSS: Object Storage Service (OSS)
        - MNS: Message Service (MNS)
        - SLS: Log Service
        """
        return pulumi.get(self, "delivery_channel_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the delivery method.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="nonCompliantNotification")
    def non_compliant_notification(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:  
        - true: The specified destination receives resource non-compliance events.
        - false: The specified destination does not receive resource non-compliance events.
        """
        return pulumi.get(self, "non_compliant_notification")

    @_builtins.property
    @pulumi.getter(name="oversizedDataOssTargetArn")
    def oversized_data_oss_target_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ARN of the OSS bucket to which the delivered data is transferred when the size of the data exceeds the specified upper limit of the delivery channel.
        """
        return pulumi.get(self, "oversized_data_oss_target_arn")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.int]:
        """
        The status of the delivery method. Valid values:   
        - 0: The delivery method is disabled.
        - 1: The delivery destination is enabled. This is the default value.
        """
        return pulumi.get(self, "status")

