# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecurityIpArgs', 'SecurityIp']

@pulumi.input_type
class SecurityIpArgs:
    def __init__(__self__, *,
                 db_instance_id: pulumi.Input[_builtins.str],
                 group_name: pulumi.Input[_builtins.str],
                 security_ip_list: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a SecurityIp resource.
        :param pulumi.Input[_builtins.str] db_instance_id: The cluster ID.
        :param pulumi.Input[_builtins.str] group_name: The whitelist name.
        :param pulumi.Input[_builtins.str] security_ip_list: The IP address list under the whitelist group.
        """
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "security_ip_list", security_ip_list)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The cluster ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The whitelist name.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter(name="securityIpList")
    def security_ip_list(self) -> pulumi.Input[_builtins.str]:
        """
        The IP address list under the whitelist group.
        """
        return pulumi.get(self, "security_ip_list")

    @security_ip_list.setter
    def security_ip_list(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_ip_list", value)


@pulumi.input_type
class _SecurityIpState:
    def __init__(__self__, *,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_list: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecurityIp resources.
        :param pulumi.Input[_builtins.str] db_instance_id: The cluster ID.
        :param pulumi.Input[_builtins.str] group_name: The whitelist name.
        :param pulumi.Input[_builtins.str] security_ip_list: The IP address list under the whitelist group.
        """
        if db_instance_id is not None:
            pulumi.set(__self__, "db_instance_id", db_instance_id)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if security_ip_list is not None:
            pulumi.set(__self__, "security_ip_list", security_ip_list)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The whitelist name.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter(name="securityIpList")
    def security_ip_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address list under the whitelist group.
        """
        return pulumi.get(self, "security_ip_list")

    @security_ip_list.setter
    def security_ip_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_ip_list", value)


@pulumi.type_token("alicloud:clickhouseenterprisedbcluster/securityIp:SecurityIp")
class SecurityIp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_list: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Click House Enterprise Db Cluster Security I P resource.

        Enterprise Clickhouse instance Security IP.

        For information about Click House Enterprise Db Cluster Security I P and how to use it, see [What is Enterprise Db Cluster Security I P](https://next.api.alibabacloud.com/document/clickhouse/2023-05-22/ModifySecurityIPList).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-beijing"
        vsw_ip_range_i = config.get("vswIpRangeI")
        if vsw_ip_range_i is None:
            vsw_ip_range_i = "172.16.1.0/24"
        vpc_ip_range = config.get("vpcIpRange")
        if vpc_ip_range is None:
            vpc_ip_range = "172.16.0.0/12"
        zone_id_i = config.get("zoneIdI")
        if zone_id_i is None:
            zone_id_i = "cn-beijing-i"
        defaultkt_k_lu_m = alicloud.vpc.Network("defaultktKLuM", cidr_block=vpc_ip_range)
        default_tqwn3k = alicloud.vpc.Switch("defaultTQWN3k",
            vpc_id=defaultkt_k_lu_m.id,
            zone_id=zone_id_i,
            cidr_block=vsw_ip_range_i)
        defaultn0n_vr_n = alicloud.clickhouseenterprisedbcluster.ClickHouseEnterpriseDbCluster("defaultn0nVrN",
            zone_id=zone_id_i,
            vpc_id=defaultkt_k_lu_m.id,
            scale_min="8",
            scale_max="16",
            vswitch_id=default_tqwn3k.id)
        default = alicloud.clickhouseenterprisedbcluster.SecurityIp("default",
            group_name="example_group",
            security_ip_list="127.0.0.2",
            db_instance_id=defaultn0n_vr_n.id)
        ```

        ## Import

        Click House Enterprise Db Cluster Security I P can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:clickhouseenterprisedbcluster/securityIp:SecurityIp example <db_instance_id>:<group_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] db_instance_id: The cluster ID.
        :param pulumi.Input[_builtins.str] group_name: The whitelist name.
        :param pulumi.Input[_builtins.str] security_ip_list: The IP address list under the whitelist group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityIpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Click House Enterprise Db Cluster Security I P resource.

        Enterprise Clickhouse instance Security IP.

        For information about Click House Enterprise Db Cluster Security I P and how to use it, see [What is Enterprise Db Cluster Security I P](https://next.api.alibabacloud.com/document/clickhouse/2023-05-22/ModifySecurityIPList).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-beijing"
        vsw_ip_range_i = config.get("vswIpRangeI")
        if vsw_ip_range_i is None:
            vsw_ip_range_i = "172.16.1.0/24"
        vpc_ip_range = config.get("vpcIpRange")
        if vpc_ip_range is None:
            vpc_ip_range = "172.16.0.0/12"
        zone_id_i = config.get("zoneIdI")
        if zone_id_i is None:
            zone_id_i = "cn-beijing-i"
        defaultkt_k_lu_m = alicloud.vpc.Network("defaultktKLuM", cidr_block=vpc_ip_range)
        default_tqwn3k = alicloud.vpc.Switch("defaultTQWN3k",
            vpc_id=defaultkt_k_lu_m.id,
            zone_id=zone_id_i,
            cidr_block=vsw_ip_range_i)
        defaultn0n_vr_n = alicloud.clickhouseenterprisedbcluster.ClickHouseEnterpriseDbCluster("defaultn0nVrN",
            zone_id=zone_id_i,
            vpc_id=defaultkt_k_lu_m.id,
            scale_min="8",
            scale_max="16",
            vswitch_id=default_tqwn3k.id)
        default = alicloud.clickhouseenterprisedbcluster.SecurityIp("default",
            group_name="example_group",
            security_ip_list="127.0.0.2",
            db_instance_id=defaultn0n_vr_n.id)
        ```

        ## Import

        Click House Enterprise Db Cluster Security I P can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:clickhouseenterprisedbcluster/securityIp:SecurityIp example <db_instance_id>:<group_name>
        ```

        :param str resource_name: The name of the resource.
        :param SecurityIpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityIpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_list: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityIpArgs.__new__(SecurityIpArgs)

            if db_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_id'")
            __props__.__dict__["db_instance_id"] = db_instance_id
            if group_name is None and not opts.urn:
                raise TypeError("Missing required property 'group_name'")
            __props__.__dict__["group_name"] = group_name
            if security_ip_list is None and not opts.urn:
                raise TypeError("Missing required property 'security_ip_list'")
            __props__.__dict__["security_ip_list"] = security_ip_list
        super(SecurityIp, __self__).__init__(
            'alicloud:clickhouseenterprisedbcluster/securityIp:SecurityIp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            group_name: Optional[pulumi.Input[_builtins.str]] = None,
            security_ip_list: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecurityIp':
        """
        Get an existing SecurityIp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] db_instance_id: The cluster ID.
        :param pulumi.Input[_builtins.str] group_name: The whitelist name.
        :param pulumi.Input[_builtins.str] security_ip_list: The IP address list under the whitelist group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityIpState.__new__(_SecurityIpState)

        __props__.__dict__["db_instance_id"] = db_instance_id
        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["security_ip_list"] = security_ip_list
        return SecurityIp(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster ID.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The whitelist name.
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter(name="securityIpList")
    def security_ip_list(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address list under the whitelist group.
        """
        return pulumi.get(self, "security_ip_list")

