# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPricesResult',
    'AwaitableGetPricesResult',
    'get_prices',
    'get_prices_output',
]

@pulumi.output_type
class GetPricesResult:
    """
    A collection of values returned by getPrices.
    """
    def __init__(__self__, desire_attributes=None, id=None, output_file=None, prices=None, product=None, resource_code=None):
        if desire_attributes and not isinstance(desire_attributes, dict):
            raise TypeError("Expected argument 'desire_attributes' to be a dict")
        pulumi.set(__self__, "desire_attributes", desire_attributes)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if prices and not isinstance(prices, list):
            raise TypeError("Expected argument 'prices' to be a list")
        pulumi.set(__self__, "prices", prices)
        if product and not isinstance(product, str):
            raise TypeError("Expected argument 'product' to be a str")
        pulumi.set(__self__, "product", product)
        if resource_code and not isinstance(resource_code, str):
            raise TypeError("Expected argument 'resource_code' to be a str")
        pulumi.set(__self__, "resource_code", resource_code)

    @_builtins.property
    @pulumi.getter(name="desireAttributes")
    def desire_attributes(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "desire_attributes")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def prices(self) -> Sequence['outputs.GetPricesPriceResult']:
        """
        A list of Price Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "prices")

    @_builtins.property
    @pulumi.getter
    def product(self) -> _builtins.str:
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter(name="resourceCode")
    def resource_code(self) -> _builtins.str:
        return pulumi.get(self, "resource_code")


class AwaitableGetPricesResult(GetPricesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPricesResult(
            desire_attributes=self.desire_attributes,
            id=self.id,
            output_file=self.output_file,
            prices=self.prices,
            product=self.product,
            resource_code=self.resource_code)


def get_prices(desire_attributes: Optional[Mapping[str, _builtins.str]] = None,
               output_file: Optional[_builtins.str] = None,
               product: Optional[_builtins.str] = None,
               resource_code: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPricesResult:
    """
    This data source provides Cloud Control Price available to the user.[What is Price](https://next.api.aliyun.com/document/cloudcontrol/2022-08-30/GetPrice)

    > **NOTE:** Available since v1.241.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.cloudcontrol.get_prices(desire_attributes={
            "AddressType": "internet",
            "PaymentType": "PayAsYouGo",
        },
        product="SLB",
        resource_code="LoadBalancer")
    pulumi.export("alicloudCloudControlPriceExampleId", default.prices[0].discount_price)
    ```


    :param Mapping[str, _builtins.str] desire_attributes: This property represent the detailed configuration of the Resource which you are going to get price.  Give same content as DesireAttributes of the 'Resource' Resource when start Create operation. 'PaymentType' is necessary when in DesireAttributes.  Here is a probably example when you get the price of SLB LoadBalancer:```json{"LoadBalancerName": "cc-test","Bandwidth": 6,"PaymentType": "PayAsYouGo","AddressType": "internet","LoadBalancerSpec": "slb.s3.small","InternetChargeType": "paybybandwidth"} See `DesireAttributes` below.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str product: The product Code represents the product to be operated. Currently supported products and resources can be queried at the following link: [supported-services-and-resource-types](https://help.aliyun.com/zh/cloud-control-api/product-overview/supported-services-and-resource-types).
    :param _builtins.str resource_code: Resource Code, if there is a parent resource, split with `::`, such as VPC::VSwitch. The supported resource Code can be obtained from the following link: [supported-services-and-resource-types](https://help.aliyun.com/zh/cloud-control-api/product-overview/supported-services-and-resource-types).
    """
    __args__ = dict()
    __args__['desireAttributes'] = desire_attributes
    __args__['outputFile'] = output_file
    __args__['product'] = product
    __args__['resourceCode'] = resource_code
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cloudcontrol/getPrices:getPrices', __args__, opts=opts, typ=GetPricesResult).value

    return AwaitableGetPricesResult(
        desire_attributes=pulumi.get(__ret__, 'desire_attributes'),
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        prices=pulumi.get(__ret__, 'prices'),
        product=pulumi.get(__ret__, 'product'),
        resource_code=pulumi.get(__ret__, 'resource_code'))
def get_prices_output(desire_attributes: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                      output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      product: Optional[pulumi.Input[_builtins.str]] = None,
                      resource_code: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPricesResult]:
    """
    This data source provides Cloud Control Price available to the user.[What is Price](https://next.api.aliyun.com/document/cloudcontrol/2022-08-30/GetPrice)

    > **NOTE:** Available since v1.241.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.cloudcontrol.get_prices(desire_attributes={
            "AddressType": "internet",
            "PaymentType": "PayAsYouGo",
        },
        product="SLB",
        resource_code="LoadBalancer")
    pulumi.export("alicloudCloudControlPriceExampleId", default.prices[0].discount_price)
    ```


    :param Mapping[str, _builtins.str] desire_attributes: This property represent the detailed configuration of the Resource which you are going to get price.  Give same content as DesireAttributes of the 'Resource' Resource when start Create operation. 'PaymentType' is necessary when in DesireAttributes.  Here is a probably example when you get the price of SLB LoadBalancer:```json{"LoadBalancerName": "cc-test","Bandwidth": 6,"PaymentType": "PayAsYouGo","AddressType": "internet","LoadBalancerSpec": "slb.s3.small","InternetChargeType": "paybybandwidth"} See `DesireAttributes` below.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str product: The product Code represents the product to be operated. Currently supported products and resources can be queried at the following link: [supported-services-and-resource-types](https://help.aliyun.com/zh/cloud-control-api/product-overview/supported-services-and-resource-types).
    :param _builtins.str resource_code: Resource Code, if there is a parent resource, split with `::`, such as VPC::VSwitch. The supported resource Code can be obtained from the following link: [supported-services-and-resource-types](https://help.aliyun.com/zh/cloud-control-api/product-overview/supported-services-and-resource-types).
    """
    __args__ = dict()
    __args__['desireAttributes'] = desire_attributes
    __args__['outputFile'] = output_file
    __args__['product'] = product
    __args__['resourceCode'] = resource_code
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cloudcontrol/getPrices:getPrices', __args__, opts=opts, typ=GetPricesResult)
    return __ret__.apply(lambda __response__: GetPricesResult(
        desire_attributes=pulumi.get(__response__, 'desire_attributes'),
        id=pulumi.get(__response__, 'id'),
        output_file=pulumi.get(__response__, 'output_file'),
        prices=pulumi.get(__response__, 'prices'),
        product=pulumi.get(__response__, 'product'),
        resource_code=pulumi.get(__response__, 'resource_code')))
