# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAddressBooksResult',
    'AwaitableGetAddressBooksResult',
    'get_address_books',
    'get_address_books_output',
]

@pulumi.output_type
class GetAddressBooksResult:
    """
    A collection of values returned by getAddressBooks.
    """
    def __init__(__self__, books=None, group_type=None, id=None, ids=None, name_regex=None, names=None, output_file=None):
        if books and not isinstance(books, list):
            raise TypeError("Expected argument 'books' to be a list")
        pulumi.set(__self__, "books", books)
        if group_type and not isinstance(group_type, str):
            raise TypeError("Expected argument 'group_type' to be a str")
        pulumi.set(__self__, "group_type", group_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter
    def books(self) -> Sequence['outputs.GetAddressBooksBookResult']:
        """
        A list of Cloud Firewall Address Books. Each element contains the following attributes:
        """
        return pulumi.get(self, "books")

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> Optional[_builtins.str]:
        """
        The type of the Address Book.
        """
        return pulumi.get(self, "group_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Address Book names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetAddressBooksResult(GetAddressBooksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddressBooksResult(
            books=self.books,
            group_type=self.group_type,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file)


def get_address_books(group_type: Optional[_builtins.str] = None,
                      ids: Optional[Sequence[_builtins.str]] = None,
                      name_regex: Optional[_builtins.str] = None,
                      output_file: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddressBooksResult:
    """
    This data source provides the Cloud Firewall Address Books of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.178.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "tf-example"
    default = alicloud.cloudfirewall.AddressBook("default",
        group_name=name,
        group_type="ip",
        description="tf-description",
        auto_add_tag_ecs=0,
        address_lists=[
            "10.21.0.0/16",
            "10.168.0.0/16",
        ])
    ids = alicloud.cloudfirewall.get_address_books_output(ids=[default.id])
    pulumi.export("cloudFirewallAddressBookId1", ids.books[0].id)
    ```


    :param _builtins.str group_type: The type of the Address Book. Valid values: `ip`, `ipv6`, `domain`, `port`, `tag`.
           **NOTE:** From version 1.213.1, `group_type` can be set to `ipv6`, `domain`, `port`.
    :param Sequence[_builtins.str] ids: A list of Address Book IDs.
    :param _builtins.str name_regex: A regex string to filter results Address Book name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['groupType'] = group_type
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cloudfirewall/getAddressBooks:getAddressBooks', __args__, opts=opts, typ=GetAddressBooksResult).value

    return AwaitableGetAddressBooksResult(
        books=pulumi.get(__ret__, 'books'),
        group_type=pulumi.get(__ret__, 'group_type'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_address_books_output(group_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                             name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAddressBooksResult]:
    """
    This data source provides the Cloud Firewall Address Books of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.178.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "tf-example"
    default = alicloud.cloudfirewall.AddressBook("default",
        group_name=name,
        group_type="ip",
        description="tf-description",
        auto_add_tag_ecs=0,
        address_lists=[
            "10.21.0.0/16",
            "10.168.0.0/16",
        ])
    ids = alicloud.cloudfirewall.get_address_books_output(ids=[default.id])
    pulumi.export("cloudFirewallAddressBookId1", ids.books[0].id)
    ```


    :param _builtins.str group_type: The type of the Address Book. Valid values: `ip`, `ipv6`, `domain`, `port`, `tag`.
           **NOTE:** From version 1.213.1, `group_type` can be set to `ipv6`, `domain`, `port`.
    :param Sequence[_builtins.str] ids: A list of Address Book IDs.
    :param _builtins.str name_regex: A regex string to filter results Address Book name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['groupType'] = group_type
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cloudfirewall/getAddressBooks:getAddressBooks', __args__, opts=opts, typ=GetAddressBooksResult)
    return __ret__.apply(lambda __response__: GetAddressBooksResult(
        books=pulumi.get(__response__, 'books'),
        group_type=pulumi.get(__response__, 'group_type'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file')))
